import pprint
import re  # noqa: F401
from enum import Enum

import six


class IdempotencyStrategy(str, Enum):
    FAIL = "FAIL",
    RETURN_EXISTING = "RETURN_EXISTING"

    def __str__(self) -> str:
        return self.name.__str__()


class StartWorkflowRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'version': 'int',
        'correlation_id': 'str',
        'input': 'dict(str, object)',
        'task_to_domain': 'dict(str, str)',
        'workflow_def': 'WorkflowDef',
        'external_input_payload_storage_path': 'str',
        'priority': 'int',
        'created_by': 'str',
        'idempotency_key': 'str',
        'idempotency_strategy':'str'
    }

    attribute_map = {
        'name': 'name',
        'version': 'version',
        'correlation_id': 'correlationId',
        'input': 'input',
        'task_to_domain': 'taskToDomain',
        'workflow_def': 'workflowDef',
        'external_input_payload_storage_path': 'externalInputPayloadStoragePath',
        'priority': 'priority',
        'created_by': 'createdBy',
        'idempotency_key': 'idempotencyKey',
        'idempotency_strategy': 'idempotencyStrategy'
    }

    def __init__(self, name=None, version=None, correlation_id=None, input=None, task_to_domain=None, workflow_def=None,
                 external_input_payload_storage_path=None, priority=None, created_by=None,
                 idempotency_key: str = None, idempotency_strategy: IdempotencyStrategy = IdempotencyStrategy.FAIL):  # noqa: E501
        """StartWorkflowRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._version = None
        self._correlation_id = None
        self._input = None
        self._task_to_domain = None
        self._workflow_def = None
        self._external_input_payload_storage_path = None
        self._priority = None
        self._created_by = None
        self.discriminator = None
        self.name = name
        if version is not None:
            self.version = version
        if correlation_id is not None:
            self.correlation_id = correlation_id
        if input is not None:
            self.input = input
        if task_to_domain is not None:
            self.task_to_domain = task_to_domain
        if workflow_def is not None:
            self.workflow_def = workflow_def
        if external_input_payload_storage_path is not None:
            self.external_input_payload_storage_path = external_input_payload_storage_path
        if priority is not None:
            self.priority = priority
        if created_by is not None:
            self.created_by = created_by
        if idempotency_key is not None:
            self._idempotency_key = idempotency_key
            self._idempotency_strategy = idempotency_strategy
        else:
            self._idempotency_key = None
            self._idempotency_strategy = IdempotencyStrategy.FAIL

    @property
    def name(self):
        """Gets the name of this StartWorkflowRequest.  # noqa: E501


        :return: The name of this StartWorkflowRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this StartWorkflowRequest.


        :param name: The name of this StartWorkflowRequest.  # noqa: E501
        :type: str
        """
        self._name = name

    @property
    def version(self):
        """Gets the version of this StartWorkflowRequest.  # noqa: E501


        :return: The version of this StartWorkflowRequest.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this StartWorkflowRequest.


        :param version: The version of this StartWorkflowRequest.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def correlation_id(self):
        """Gets the correlation_id of this StartWorkflowRequest.  # noqa: E501


        :return: The correlation_id of this StartWorkflowRequest.  # noqa: E501
        :rtype: str
        """
        return self._correlation_id

    @correlation_id.setter
    def correlation_id(self, correlation_id):
        """Sets the correlation_id of this StartWorkflowRequest.


        :param correlation_id: The correlation_id of this StartWorkflowRequest.  # noqa: E501
        :type: str
        """

        self._correlation_id = correlation_id

    @property
    def input(self):
        """Gets the input of this StartWorkflowRequest.  # noqa: E501


        :return: The input of this StartWorkflowRequest.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._input

    @input.setter
    def input(self, input):
        """Sets the input of this StartWorkflowRequest.


        :param input: The input of this StartWorkflowRequest.  # noqa: E501
        :type: dict(str, object)
        """

        self._input = input

    @property
    def task_to_domain(self):
        """Gets the task_to_domain of this StartWorkflowRequest.  # noqa: E501


        :return: The task_to_domain of this StartWorkflowRequest.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._task_to_domain

    @task_to_domain.setter
    def task_to_domain(self, task_to_domain):
        """Sets the task_to_domain of this StartWorkflowRequest.


        :param task_to_domain: The task_to_domain of this StartWorkflowRequest.  # noqa: E501
        :type: dict(str, str)
        """

        self._task_to_domain = task_to_domain

    @property
    def workflow_def(self):
        """Gets the workflow_def of this StartWorkflowRequest.  # noqa: E501


        :return: The workflow_def of this StartWorkflowRequest.  # noqa: E501
        :rtype: WorkflowDef
        """
        return self._workflow_def

    @workflow_def.setter
    def workflow_def(self, workflow_def):
        """Sets the workflow_def of this StartWorkflowRequest.


        :param workflow_def: The workflow_def of this StartWorkflowRequest.  # noqa: E501
        :type: WorkflowDef
        """

        self._workflow_def = workflow_def

    @property
    def external_input_payload_storage_path(self):
        """Gets the external_input_payload_storage_path of this StartWorkflowRequest.  # noqa: E501


        :return: The external_input_payload_storage_path of this StartWorkflowRequest.  # noqa: E501
        :rtype: str
        """
        return self._external_input_payload_storage_path

    @external_input_payload_storage_path.setter
    def external_input_payload_storage_path(self, external_input_payload_storage_path):
        """Sets the external_input_payload_storage_path of this StartWorkflowRequest.


        :param external_input_payload_storage_path: The external_input_payload_storage_path of this StartWorkflowRequest.  # noqa: E501
        :type: str
        """

        self._external_input_payload_storage_path = external_input_payload_storage_path

    @property
    def priority(self):
        """Gets the priority of this StartWorkflowRequest.  # noqa: E501


        :return: The priority of this StartWorkflowRequest.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this StartWorkflowRequest.


        :param priority: The priority of this StartWorkflowRequest.  # noqa: E501
        :type: int
        """

        self._priority = priority

    @property
    def created_by(self):
        """Gets the created_by of this StartWorkflowRequest.  # noqa: E501


        :return: The created_by of this StartWorkflowRequest.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this StartWorkflowRequest.


        :param created_by: The created_by of this StartWorkflowRequest.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def idempotency_key(self):
        return self._idempotency_key

    @idempotency_key.setter
    def idempotency_key(self, idempotency_key: str):
        self._idempotency_key = idempotency_key

    @property
    def idempotency_strategy(self) -> IdempotencyStrategy:
        return self._idempotency_strategy

    @idempotency_strategy.setter
    def idempotency_strategy(self, idempotency_strategy : IdempotencyStrategy):
        self._idempotency_strategy = idempotency_strategy

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StartWorkflowRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StartWorkflowRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
