# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.group import Group
from conductor.asyncio_client.http.models.role import Role
from typing import Optional, Set
from typing_extensions import Self

class ConductorUser(BaseModel):
    """
    ConductorUser
    """ # noqa: E501
    application_user: Optional[StrictBool] = Field(default=None, alias="applicationUser")
    encrypted_id: Optional[StrictBool] = Field(default=None, alias="encryptedId")
    encrypted_id_display_value: Optional[StrictStr] = Field(default=None, alias="encryptedIdDisplayValue")
    groups: Optional[List[Group]] = None
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    orkes_workers_app: Optional[StrictBool] = Field(default=None, alias="orkesWorkersApp")
    roles: Optional[List[Role]] = None
    uuid: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["applicationUser", "encryptedId", "encryptedIdDisplayValue", "groups", "id", "name", "orkesWorkersApp", "roles", "uuid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConductorUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in roles (list)
        _items = []
        if self.roles:
            for _item_roles in self.roles:
                if _item_roles:
                    _items.append(_item_roles.to_dict())
            _dict['roles'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConductorUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applicationUser": obj.get("applicationUser"),
            "encryptedId": obj.get("encryptedId"),
            "encryptedIdDisplayValue": obj.get("encryptedIdDisplayValue"),
            "groups": [Group.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "id": obj.get("id"),
            "name": obj.get("name"),
            "orkesWorkersApp": obj.get("orkesWorkersApp"),
            "roles": [Role.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "uuid": obj.get("uuid")
        })
        return _obj


