# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.integration_api import IntegrationApi
from conductor.asyncio_client.http.models.tag import Tag
from typing import Optional, Set
from typing_extensions import Self

class Integration(BaseModel):
    """
    Integration
    """ # noqa: E501
    apis: Optional[List[IntegrationApi]] = None
    category: Optional[StrictStr] = None
    configuration: Optional[Dict[str, Dict[str, Any]]] = None
    create_time: Optional[StrictInt] = Field(default=None, alias="createTime")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    description: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    models_count: Optional[StrictInt] = Field(default=None, alias="modelsCount")
    name: Optional[StrictStr] = None
    owner_app: Optional[StrictStr] = Field(default=None, alias="ownerApp")
    tags: Optional[List[Tag]] = None
    type: Optional[StrictStr] = None
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    __properties: ClassVar[List[str]] = ["apis", "category", "configuration", "createTime", "createdBy", "description", "enabled", "modelsCount", "name", "ownerApp", "tags", "type", "updateTime", "updatedBy"]

    @field_validator('category')
    def category_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['API', 'AI_MODEL', 'VECTOR_DB', 'RELATIONAL_DB', 'MESSAGE_BROKER']):
            raise ValueError("must be one of enum values ('API', 'AI_MODEL', 'VECTOR_DB', 'RELATIONAL_DB', 'MESSAGE_BROKER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Integration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in apis (list)
        _items = []
        if self.apis:
            for _item_apis in self.apis:
                if _item_apis:
                    _items.append(_item_apis.to_dict())
            _dict['apis'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Integration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apis": [IntegrationApi.from_dict(_item) for _item in obj["apis"]] if obj.get("apis") is not None else None,
            "category": obj.get("category"),
            "configuration": obj.get("configuration"),
            "createTime": obj.get("createTime"),
            "createdBy": obj.get("createdBy"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled"),
            "modelsCount": obj.get("modelsCount"),
            "name": obj.get("name"),
            "ownerApp": obj.get("ownerApp"),
            "tags": [Tag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "type": obj.get("type"),
            "updateTime": obj.get("updateTime"),
            "updatedBy": obj.get("updatedBy")
        })
        return _obj


