# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.integration_def_form_field import IntegrationDefFormField
from typing import Optional, Set
from typing_extensions import Self

class IntegrationDef(BaseModel):
    """
    IntegrationDef
    """ # noqa: E501
    category: Optional[StrictStr] = None
    category_label: Optional[StrictStr] = Field(default=None, alias="categoryLabel")
    configuration: Optional[List[IntegrationDefFormField]] = None
    description: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    icon_name: Optional[StrictStr] = Field(default=None, alias="iconName")
    name: Optional[StrictStr] = None
    tags: Optional[List[StrictStr]] = None
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["category", "categoryLabel", "configuration", "description", "enabled", "iconName", "name", "tags", "type"]

    @field_validator('category')
    def category_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['API', 'AI_MODEL', 'VECTOR_DB', 'RELATIONAL_DB', 'MESSAGE_BROKER']):
            raise ValueError("must be one of enum values ('API', 'AI_MODEL', 'VECTOR_DB', 'RELATIONAL_DB', 'MESSAGE_BROKER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IntegrationDef from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in configuration (list)
        _items = []
        if self.configuration:
            for _item_configuration in self.configuration:
                if _item_configuration:
                    _items.append(_item_configuration.to_dict())
            _dict['configuration'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IntegrationDef from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "category": obj.get("category"),
            "categoryLabel": obj.get("categoryLabel"),
            "configuration": [IntegrationDefFormField.from_dict(_item) for _item in obj["configuration"]] if obj.get("configuration") is not None else None,
            "description": obj.get("description"),
            "enabled": obj.get("enabled"),
            "iconName": obj.get("iconName"),
            "name": obj.get("name"),
            "tags": obj.get("tags"),
            "type": obj.get("type")
        })
        return _obj


