# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from conductor.asyncio_client.http.models.start_workflow_request import StartWorkflowRequest
from typing import Optional, Set
from typing_extensions import Self

class SaveScheduleRequest(BaseModel):
    """
    SaveScheduleRequest
    """ # noqa: E501
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    cron_expression: StrictStr = Field(alias="cronExpression")
    description: Optional[StrictStr] = None
    name: Annotated[str, Field(strict=True)]
    paused: Optional[StrictBool] = None
    run_catchup_schedule_instances: Optional[StrictBool] = Field(default=None, alias="runCatchupScheduleInstances")
    schedule_end_time: Optional[StrictInt] = Field(default=None, alias="scheduleEndTime")
    schedule_start_time: Optional[StrictInt] = Field(default=None, alias="scheduleStartTime")
    start_workflow_request: StartWorkflowRequest = Field(alias="startWorkflowRequest")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    zone_id: Optional[StrictStr] = Field(default=None, alias="zoneId")
    __properties: ClassVar[List[str]] = ["createdBy", "cronExpression", "description", "name", "paused", "runCatchupScheduleInstances", "scheduleEndTime", "scheduleStartTime", "startWorkflowRequest", "updatedBy", "zoneId"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\w*$", value):
            raise ValueError(r"must validate the regular expression /^\w*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SaveScheduleRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of start_workflow_request
        if self.start_workflow_request:
            _dict['startWorkflowRequest'] = self.start_workflow_request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SaveScheduleRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdBy": obj.get("createdBy"),
            "cronExpression": obj.get("cronExpression"),
            "description": obj.get("description"),
            "name": obj.get("name"),
            "paused": obj.get("paused"),
            "runCatchupScheduleInstances": obj.get("runCatchupScheduleInstances"),
            "scheduleEndTime": obj.get("scheduleEndTime"),
            "scheduleStartTime": obj.get("scheduleStartTime"),
            "startWorkflowRequest": StartWorkflowRequest.from_dict(obj["startWorkflowRequest"]) if obj.get("startWorkflowRequest") is not None else None,
            "updatedBy": obj.get("updatedBy"),
            "zoneId": obj.get("zoneId")
        })
        return _obj


