# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WorkflowSummary(BaseModel):
    """
    WorkflowSummary
    """ # noqa: E501
    correlation_id: Optional[StrictStr] = Field(default=None, alias="correlationId")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    end_time: Optional[StrictStr] = Field(default=None, alias="endTime")
    event: Optional[StrictStr] = None
    execution_time: Optional[StrictInt] = Field(default=None, alias="executionTime")
    external_input_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalInputPayloadStoragePath")
    external_output_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalOutputPayloadStoragePath")
    failed_reference_task_names: Optional[StrictStr] = Field(default=None, alias="failedReferenceTaskNames")
    failed_task_names: Optional[List[StrictStr]] = Field(default=None, alias="failedTaskNames")
    input: Optional[StrictStr] = None
    input_size: Optional[StrictInt] = Field(default=None, alias="inputSize")
    output: Optional[StrictStr] = None
    output_size: Optional[StrictInt] = Field(default=None, alias="outputSize")
    priority: Optional[StrictInt] = None
    reason_for_incompletion: Optional[StrictStr] = Field(default=None, alias="reasonForIncompletion")
    start_time: Optional[StrictStr] = Field(default=None, alias="startTime")
    status: Optional[StrictStr] = None
    update_time: Optional[StrictStr] = Field(default=None, alias="updateTime")
    version: Optional[StrictInt] = None
    workflow_id: Optional[StrictStr] = Field(default=None, alias="workflowId")
    workflow_type: Optional[StrictStr] = Field(default=None, alias="workflowType")
    __properties: ClassVar[List[str]] = ["correlationId", "createdBy", "endTime", "event", "executionTime", "externalInputPayloadStoragePath", "externalOutputPayloadStoragePath", "failedReferenceTaskNames", "failedTaskNames", "input", "inputSize", "output", "outputSize", "priority", "reasonForIncompletion", "startTime", "status", "updateTime", "version", "workflowId", "workflowType"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RUNNING', 'COMPLETED', 'FAILED', 'TIMED_OUT', 'TERMINATED', 'PAUSED']):
            raise ValueError("must be one of enum values ('RUNNING', 'COMPLETED', 'FAILED', 'TIMED_OUT', 'TERMINATED', 'PAUSED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "correlationId": obj.get("correlationId"),
            "createdBy": obj.get("createdBy"),
            "endTime": obj.get("endTime"),
            "event": obj.get("event"),
            "executionTime": obj.get("executionTime"),
            "externalInputPayloadStoragePath": obj.get("externalInputPayloadStoragePath"),
            "externalOutputPayloadStoragePath": obj.get("externalOutputPayloadStoragePath"),
            "failedReferenceTaskNames": obj.get("failedReferenceTaskNames"),
            "failedTaskNames": obj.get("failedTaskNames"),
            "input": obj.get("input"),
            "inputSize": obj.get("inputSize"),
            "output": obj.get("output"),
            "outputSize": obj.get("outputSize"),
            "priority": obj.get("priority"),
            "reasonForIncompletion": obj.get("reasonForIncompletion"),
            "startTime": obj.get("startTime"),
            "status": obj.get("status"),
            "updateTime": obj.get("updateTime"),
            "version": obj.get("version"),
            "workflowId": obj.get("workflowId"),
            "workflowType": obj.get("workflowType")
        })
        return _obj


