# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.byte_string import ByteString
from conductor.asyncio_client.http.models.unknown_field_set import UnknownFieldSet
from typing import Optional, Set
from typing_extensions import Self

class EnumDescriptorProto(BaseModel):
    """
    EnumDescriptorProto
    """ # noqa: E501
    all_fields: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="allFields")
    default_instance_for_type: Optional[EnumDescriptorProto] = Field(default=None, alias="defaultInstanceForType")
    descriptor_for_type: Optional[Descriptor] = Field(default=None, alias="descriptorForType")
    initialization_error_string: Optional[StrictStr] = Field(default=None, alias="initializationErrorString")
    initialized: Optional[StrictBool] = None
    memoized_serialized_size: Optional[StrictInt] = Field(default=None, alias="memoizedSerializedSize")
    name: Optional[StrictStr] = None
    name_bytes: Optional[ByteString] = Field(default=None, alias="nameBytes")
    options: Optional[EnumOptions] = None
    options_or_builder: Optional[EnumOptionsOrBuilder] = Field(default=None, alias="optionsOrBuilder")
    parser_for_type: Optional[Dict[str, Any]] = Field(default=None, alias="parserForType")
    reserved_name_count: Optional[StrictInt] = Field(default=None, alias="reservedNameCount")
    reserved_name_list: Optional[List[str]] = Field(default=None, alias="reservedNameList")
    reserved_range_count: Optional[StrictInt] = Field(default=None, alias="reservedRangeCount")
    reserved_range_list: Optional[List[EnumReservedRange]] = Field(default=None, alias="reservedRangeList")
    reserved_range_or_builder_list: Optional[List[EnumReservedRangeOrBuilder]] = Field(default=None, alias="reservedRangeOrBuilderList")
    serialized_size: Optional[StrictInt] = Field(default=None, alias="serializedSize")
    unknown_fields: Optional[UnknownFieldSet] = Field(default=None, alias="unknownFields")
    value_count: Optional[StrictInt] = Field(default=None, alias="valueCount")
    value_list: Optional[List[EnumValueDescriptorProto]] = Field(default=None, alias="valueList")
    value_or_builder_list: Optional[List[EnumValueDescriptorProtoOrBuilder]] = Field(default=None, alias="valueOrBuilderList")
    __properties: ClassVar[List[str]] = ["allFields", "defaultInstanceForType", "descriptorForType", "initializationErrorString", "initialized", "memoizedSerializedSize", "name", "nameBytes", "options", "optionsOrBuilder", "parserForType", "reservedNameCount", "reservedNameList", "reservedRangeCount", "reservedRangeList", "reservedRangeOrBuilderList", "serializedSize", "unknownFields", "valueCount", "valueList", "valueOrBuilderList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EnumDescriptorProto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_instance_for_type
        if self.default_instance_for_type:
            _dict['defaultInstanceForType'] = self.default_instance_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of descriptor_for_type
        if self.descriptor_for_type:
            _dict['descriptorForType'] = self.descriptor_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of name_bytes
        if self.name_bytes:
            _dict['nameBytes'] = self.name_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of options_or_builder
        if self.options_or_builder:
            _dict['optionsOrBuilder'] = self.options_or_builder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in reserved_range_list (list)
        _items = []
        if self.reserved_range_list:
            for _item_reserved_range_list in self.reserved_range_list:
                if _item_reserved_range_list:
                    _items.append(_item_reserved_range_list.to_dict())
            _dict['reservedRangeList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in reserved_range_or_builder_list (list)
        _items = []
        if self.reserved_range_or_builder_list:
            for _item_reserved_range_or_builder_list in self.reserved_range_or_builder_list:
                if _item_reserved_range_or_builder_list:
                    _items.append(_item_reserved_range_or_builder_list.to_dict())
            _dict['reservedRangeOrBuilderList'] = _items
        # override the default output from pydantic by calling `to_dict()` of unknown_fields
        if self.unknown_fields:
            _dict['unknownFields'] = self.unknown_fields.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in value_list (list)
        _items = []
        if self.value_list:
            for _item_value_list in self.value_list:
                if _item_value_list:
                    _items.append(_item_value_list.to_dict())
            _dict['valueList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in value_or_builder_list (list)
        _items = []
        if self.value_or_builder_list:
            for _item_value_or_builder_list in self.value_or_builder_list:
                if _item_value_or_builder_list:
                    _items.append(_item_value_or_builder_list.to_dict())
            _dict['valueOrBuilderList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EnumDescriptorProto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allFields": obj.get("allFields"),
            "defaultInstanceForType": EnumDescriptorProto.from_dict(obj["defaultInstanceForType"]) if obj.get("defaultInstanceForType") is not None else None,
            "descriptorForType": Descriptor.from_dict(obj["descriptorForType"]) if obj.get("descriptorForType") is not None else None,
            "initializationErrorString": obj.get("initializationErrorString"),
            "initialized": obj.get("initialized"),
            "memoizedSerializedSize": obj.get("memoizedSerializedSize"),
            "name": obj.get("name"),
            "nameBytes": ByteString.from_dict(obj["nameBytes"]) if obj.get("nameBytes") is not None else None,
            "options": EnumOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "optionsOrBuilder": EnumOptionsOrBuilder.from_dict(obj["optionsOrBuilder"]) if obj.get("optionsOrBuilder") is not None else None,
            "parserForType": obj.get("parserForType"),
            "reservedNameCount": obj.get("reservedNameCount"),
            "reservedRangeCount": obj.get("reservedRangeCount"),
            "reservedRangeList": [EnumReservedRange.from_dict(_item) for _item in obj["reservedRangeList"]] if obj.get("reservedRangeList") is not None else None,
            "reservedRangeOrBuilderList": [EnumReservedRangeOrBuilder.from_dict(_item) for _item in obj["reservedRangeOrBuilderList"]] if obj.get("reservedRangeOrBuilderList") is not None else None,
            "serializedSize": obj.get("serializedSize"),
            "unknownFields": UnknownFieldSet.from_dict(obj["unknownFields"]) if obj.get("unknownFields") is not None else None,
            "valueCount": obj.get("valueCount"),
            "valueList": [EnumValueDescriptorProto.from_dict(_item) for _item in obj["valueList"]] if obj.get("valueList") is not None else None,
            "valueOrBuilderList": [EnumValueDescriptorProtoOrBuilder.from_dict(_item) for _item in obj["valueOrBuilderList"]] if obj.get("valueOrBuilderList") is not None else None
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.enum_options import EnumOptions
from conductor.asyncio_client.http.models.enum_options_or_builder import EnumOptionsOrBuilder
from conductor.asyncio_client.http.models.enum_reserved_range import EnumReservedRange
from conductor.asyncio_client.http.models.enum_reserved_range_or_builder import EnumReservedRangeOrBuilder
from conductor.asyncio_client.http.models.enum_value_descriptor_proto import EnumValueDescriptorProto
from conductor.asyncio_client.http.models.enum_value_descriptor_proto_or_builder import EnumValueDescriptorProtoOrBuilder
# TODO: Rewrite to not use raise_errors
EnumDescriptorProto.model_rebuild(raise_errors=False)

