# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.unknown_field_set import UnknownFieldSet
from typing import Optional, Set
from typing_extensions import Self

class EnumOptionsOrBuilder(BaseModel):
    """
    EnumOptionsOrBuilder
    """ # noqa: E501
    all_fields: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="allFields")
    allow_alias: Optional[StrictBool] = Field(default=None, alias="allowAlias")
    default_instance_for_type: Optional[Message] = Field(default=None, alias="defaultInstanceForType")
    deprecated: Optional[StrictBool] = None
    deprecated_legacy_json_field_conflicts: Optional[StrictBool] = Field(default=None, alias="deprecatedLegacyJsonFieldConflicts")
    descriptor_for_type: Optional[Descriptor] = Field(default=None, alias="descriptorForType")
    features: Optional[FeatureSet] = None
    features_or_builder: Optional[FeatureSetOrBuilder] = Field(default=None, alias="featuresOrBuilder")
    initialization_error_string: Optional[StrictStr] = Field(default=None, alias="initializationErrorString")
    initialized: Optional[StrictBool] = None
    uninterpreted_option_count: Optional[StrictInt] = Field(default=None, alias="uninterpretedOptionCount")
    uninterpreted_option_list: Optional[List[UninterpretedOption]] = Field(default=None, alias="uninterpretedOptionList")
    uninterpreted_option_or_builder_list: Optional[List[UninterpretedOptionOrBuilder]] = Field(default=None, alias="uninterpretedOptionOrBuilderList")
    unknown_fields: Optional[UnknownFieldSet] = Field(default=None, alias="unknownFields")
    __properties: ClassVar[List[str]] = ["allFields", "allowAlias", "defaultInstanceForType", "deprecated", "deprecatedLegacyJsonFieldConflicts", "descriptorForType", "features", "featuresOrBuilder", "initializationErrorString", "initialized", "uninterpretedOptionCount", "uninterpretedOptionList", "uninterpretedOptionOrBuilderList", "unknownFields"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EnumOptionsOrBuilder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_instance_for_type
        if self.default_instance_for_type:
            _dict['defaultInstanceForType'] = self.default_instance_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of descriptor_for_type
        if self.descriptor_for_type:
            _dict['descriptorForType'] = self.descriptor_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of features
        if self.features:
            _dict['features'] = self.features.to_dict()
        # override the default output from pydantic by calling `to_dict()` of features_or_builder
        if self.features_or_builder:
            _dict['featuresOrBuilder'] = self.features_or_builder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in uninterpreted_option_list (list)
        _items = []
        if self.uninterpreted_option_list:
            for _item_uninterpreted_option_list in self.uninterpreted_option_list:
                if _item_uninterpreted_option_list:
                    _items.append(_item_uninterpreted_option_list.to_dict())
            _dict['uninterpretedOptionList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in uninterpreted_option_or_builder_list (list)
        _items = []
        if self.uninterpreted_option_or_builder_list:
            for _item_uninterpreted_option_or_builder_list in self.uninterpreted_option_or_builder_list:
                if _item_uninterpreted_option_or_builder_list:
                    _items.append(_item_uninterpreted_option_or_builder_list.to_dict())
            _dict['uninterpretedOptionOrBuilderList'] = _items
        # override the default output from pydantic by calling `to_dict()` of unknown_fields
        if self.unknown_fields:
            _dict['unknownFields'] = self.unknown_fields.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EnumOptionsOrBuilder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allFields": obj.get("allFields"),
            "allowAlias": obj.get("allowAlias"),
            "defaultInstanceForType": Message.from_dict(obj["defaultInstanceForType"]) if obj.get("defaultInstanceForType") is not None else None,
            "deprecated": obj.get("deprecated"),
            "deprecatedLegacyJsonFieldConflicts": obj.get("deprecatedLegacyJsonFieldConflicts"),
            "descriptorForType": Descriptor.from_dict(obj["descriptorForType"]) if obj.get("descriptorForType") is not None else None,
            "features": FeatureSet.from_dict(obj["features"]) if obj.get("features") is not None else None,
            "featuresOrBuilder": FeatureSetOrBuilder.from_dict(obj["featuresOrBuilder"]) if obj.get("featuresOrBuilder") is not None else None,
            "initializationErrorString": obj.get("initializationErrorString"),
            "initialized": obj.get("initialized"),
            "uninterpretedOptionCount": obj.get("uninterpretedOptionCount"),
            "uninterpretedOptionList": [UninterpretedOption.from_dict(_item) for _item in obj["uninterpretedOptionList"]] if obj.get("uninterpretedOptionList") is not None else None,
            "uninterpretedOptionOrBuilderList": [UninterpretedOptionOrBuilder.from_dict(_item) for _item in obj["uninterpretedOptionOrBuilderList"]] if obj.get("uninterpretedOptionOrBuilderList") is not None else None,
            "unknownFields": UnknownFieldSet.from_dict(obj["unknownFields"]) if obj.get("unknownFields") is not None else None
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.feature_set import FeatureSet
from conductor.asyncio_client.http.models.feature_set_or_builder import FeatureSetOrBuilder
from conductor.asyncio_client.http.models.message import Message
from conductor.asyncio_client.http.models.uninterpreted_option import UninterpretedOption
from conductor.asyncio_client.http.models.uninterpreted_option_or_builder import UninterpretedOptionOrBuilder
# TODO: Rewrite to not use raise_errors
EnumOptionsOrBuilder.model_rebuild(raise_errors=False)

