# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.event_handler import EventHandler
from typing import Optional, Set
from typing_extensions import Self

class ExtendedEventExecution(BaseModel):
    """
    ExtendedEventExecution
    """ # noqa: E501
    action: Optional[StrictStr] = None
    created: Optional[StrictInt] = None
    event: Optional[StrictStr] = None
    event_handler: Optional[EventHandler] = Field(default=None, alias="eventHandler")
    full_message_payload: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="fullMessagePayload")
    id: Optional[StrictStr] = None
    message_id: Optional[StrictStr] = Field(default=None, alias="messageId")
    name: Optional[StrictStr] = None
    org_id: Optional[StrictStr] = Field(default=None, alias="orgId")
    output: Optional[Dict[str, Dict[str, Any]]] = None
    payload: Optional[Dict[str, Dict[str, Any]]] = None
    status: Optional[StrictStr] = None
    status_description: Optional[StrictStr] = Field(default=None, alias="statusDescription")
    __properties: ClassVar[List[str]] = ["action", "created", "event", "eventHandler", "fullMessagePayload", "id", "messageId", "name", "orgId", "output", "payload", "status", "statusDescription"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['start_workflow', 'complete_task', 'fail_task', 'terminate_workflow', 'update_workflow_variables']):
            raise ValueError("must be one of enum values ('start_workflow', 'complete_task', 'fail_task', 'terminate_workflow', 'update_workflow_variables')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['IN_PROGRESS', 'COMPLETED', 'FAILED', 'SKIPPED']):
            raise ValueError("must be one of enum values ('IN_PROGRESS', 'COMPLETED', 'FAILED', 'SKIPPED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExtendedEventExecution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of event_handler
        if self.event_handler:
            _dict['eventHandler'] = self.event_handler.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExtendedEventExecution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "created": obj.get("created"),
            "event": obj.get("event"),
            "eventHandler": EventHandler.from_dict(obj["eventHandler"]) if obj.get("eventHandler") is not None else None,
            "fullMessagePayload": obj.get("fullMessagePayload"),
            "id": obj.get("id"),
            "messageId": obj.get("messageId"),
            "name": obj.get("name"),
            "orgId": obj.get("orgId"),
            "output": obj.get("output"),
            "payload": obj.get("payload"),
            "status": obj.get("status"),
            "statusDescription": obj.get("statusDescription")
        })
        return _obj


