# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TaskSummary(BaseModel):
    """
    TaskSummary
    """ # noqa: E501
    correlation_id: Optional[StrictStr] = Field(default=None, alias="correlationId")
    end_time: Optional[StrictStr] = Field(default=None, alias="endTime")
    execution_time: Optional[StrictInt] = Field(default=None, alias="executionTime")
    external_input_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalInputPayloadStoragePath")
    external_output_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalOutputPayloadStoragePath")
    input: Optional[StrictStr] = None
    output: Optional[StrictStr] = None
    queue_wait_time: Optional[StrictInt] = Field(default=None, alias="queueWaitTime")
    reason_for_incompletion: Optional[StrictStr] = Field(default=None, alias="reasonForIncompletion")
    scheduled_time: Optional[StrictStr] = Field(default=None, alias="scheduledTime")
    start_time: Optional[StrictStr] = Field(default=None, alias="startTime")
    status: Optional[StrictStr] = None
    task_def_name: Optional[StrictStr] = Field(default=None, alias="taskDefName")
    task_id: Optional[StrictStr] = Field(default=None, alias="taskId")
    task_reference_name: Optional[StrictStr] = Field(default=None, alias="taskReferenceName")
    task_type: Optional[StrictStr] = Field(default=None, alias="taskType")
    update_time: Optional[StrictStr] = Field(default=None, alias="updateTime")
    workflow_id: Optional[StrictStr] = Field(default=None, alias="workflowId")
    workflow_priority: Optional[StrictInt] = Field(default=None, alias="workflowPriority")
    workflow_type: Optional[StrictStr] = Field(default=None, alias="workflowType")
    __properties: ClassVar[List[str]] = ["correlationId", "endTime", "executionTime", "externalInputPayloadStoragePath", "externalOutputPayloadStoragePath", "input", "output", "queueWaitTime", "reasonForIncompletion", "scheduledTime", "startTime", "status", "taskDefName", "taskId", "taskReferenceName", "taskType", "updateTime", "workflowId", "workflowPriority", "workflowType"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['IN_PROGRESS', 'CANCELED', 'FAILED', 'FAILED_WITH_TERMINAL_ERROR', 'COMPLETED', 'COMPLETED_WITH_ERRORS', 'SCHEDULED', 'TIMED_OUT', 'SKIPPED']):
            raise ValueError("must be one of enum values ('IN_PROGRESS', 'CANCELED', 'FAILED', 'FAILED_WITH_TERMINAL_ERROR', 'COMPLETED', 'COMPLETED_WITH_ERRORS', 'SCHEDULED', 'TIMED_OUT', 'SKIPPED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaskSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaskSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "correlationId": obj.get("correlationId"),
            "endTime": obj.get("endTime"),
            "executionTime": obj.get("executionTime"),
            "externalInputPayloadStoragePath": obj.get("externalInputPayloadStoragePath"),
            "externalOutputPayloadStoragePath": obj.get("externalOutputPayloadStoragePath"),
            "input": obj.get("input"),
            "output": obj.get("output"),
            "queueWaitTime": obj.get("queueWaitTime"),
            "reasonForIncompletion": obj.get("reasonForIncompletion"),
            "scheduledTime": obj.get("scheduledTime"),
            "startTime": obj.get("startTime"),
            "status": obj.get("status"),
            "taskDefName": obj.get("taskDefName"),
            "taskId": obj.get("taskId"),
            "taskReferenceName": obj.get("taskReferenceName"),
            "taskType": obj.get("taskType"),
            "updateTime": obj.get("updateTime"),
            "workflowId": obj.get("workflowId"),
            "workflowPriority": obj.get("workflowPriority"),
            "workflowType": obj.get("workflowType")
        })
        return _obj


