# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.tag import Tag
from conductor.asyncio_client.http.models.webhook_execution_history import WebhookExecutionHistory
from typing import Optional, Set
from typing_extensions import Self

class WebhookConfig(BaseModel):
    """
    WebhookConfig
    """ # noqa: E501
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    header_key: Optional[StrictStr] = Field(default=None, alias="headerKey")
    headers: Optional[Dict[str, StrictStr]] = None
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    receiver_workflow_names_to_versions: Optional[Dict[str, StrictInt]] = Field(default=None, alias="receiverWorkflowNamesToVersions")
    secret_key: Optional[StrictStr] = Field(default=None, alias="secretKey")
    secret_value: Optional[StrictStr] = Field(default=None, alias="secretValue")
    source_platform: Optional[StrictStr] = Field(default=None, alias="sourcePlatform")
    tags: Optional[List[Tag]] = None
    url_verified: Optional[StrictBool] = Field(default=None, alias="urlVerified")
    verifier: Optional[StrictStr] = None
    webhook_execution_history: Optional[List[WebhookExecutionHistory]] = Field(default=None, alias="webhookExecutionHistory")
    workflows_to_start: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="workflowsToStart")
    __properties: ClassVar[List[str]] = ["createdBy", "headerKey", "headers", "id", "name", "receiverWorkflowNamesToVersions", "secretKey", "secretValue", "sourcePlatform", "tags", "urlVerified", "verifier", "webhookExecutionHistory", "workflowsToStart"]

    @field_validator('verifier')
    def verifier_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SLACK_BASED', 'SIGNATURE_BASED', 'HEADER_BASED', 'STRIPE', 'TWITTER', 'HMAC_BASED', 'SENDGRID']):
            raise ValueError("must be one of enum values ('SLACK_BASED', 'SIGNATURE_BASED', 'HEADER_BASED', 'STRIPE', 'TWITTER', 'HMAC_BASED', 'SENDGRID')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in webhook_execution_history (list)
        _items = []
        if self.webhook_execution_history:
            for _item_webhook_execution_history in self.webhook_execution_history:
                if _item_webhook_execution_history:
                    _items.append(_item_webhook_execution_history.to_dict())
            _dict['webhookExecutionHistory'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdBy": obj.get("createdBy"),
            "headerKey": obj.get("headerKey"),
            "headers": obj.get("headers"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "receiverWorkflowNamesToVersions": obj.get("receiverWorkflowNamesToVersions"),
            "secretKey": obj.get("secretKey"),
            "secretValue": obj.get("secretValue"),
            "sourcePlatform": obj.get("sourcePlatform"),
            "tags": [Tag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "urlVerified": obj.get("urlVerified"),
            "verifier": obj.get("verifier"),
            "webhookExecutionHistory": [WebhookExecutionHistory.from_dict(_item) for _item in obj["webhookExecutionHistory"]] if obj.get("webhookExecutionHistory") is not None else None,
            "workflowsToStart": obj.get("workflowsToStart")
        })
        return _obj


