# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from conductor.asyncio_client.http.models.rate_limit_config import RateLimitConfig
from conductor.asyncio_client.http.models.schema_def import SchemaDef
from conductor.asyncio_client.http.models.workflow_task import WorkflowTask
from typing import Optional, Set
from typing_extensions import Self

class WorkflowDef(BaseModel):
    """
    WorkflowDef
    """ # noqa: E501
    create_time: Optional[StrictInt] = Field(default=None, alias="createTime")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    description: Optional[StrictStr] = None
    enforce_schema: Optional[StrictBool] = Field(default=None, alias="enforceSchema")
    failure_workflow: Optional[StrictStr] = Field(default=None, alias="failureWorkflow")
    input_parameters: Optional[List[StrictStr]] = Field(default=None, alias="inputParameters")
    input_schema: Optional[SchemaDef] = Field(default=None, alias="inputSchema")
    input_template: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="inputTemplate")
    name: StrictStr
    output_parameters: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="outputParameters")
    output_schema: Optional[SchemaDef] = Field(default=None, alias="outputSchema")
    owner_app: Optional[StrictStr] = Field(default=None, alias="ownerApp")
    owner_email: Optional[StrictStr] = Field(default=None, alias="ownerEmail")
    rate_limit_config: Optional[RateLimitConfig] = Field(default=None, alias="rateLimitConfig")
    restartable: Optional[StrictBool] = None
    schema_version: Optional[Annotated[int, Field(le=2, strict=True, ge=2)]] = Field(default=None, alias="schemaVersion")
    tasks: List[WorkflowTask]
    timeout_policy: Optional[StrictStr] = Field(default=None, alias="timeoutPolicy")
    timeout_seconds: StrictInt = Field(alias="timeoutSeconds")
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    variables: Optional[Dict[str, Dict[str, Any]]] = None
    version: Optional[StrictInt] = None
    workflow_status_listener_enabled: Optional[StrictBool] = Field(default=None, alias="workflowStatusListenerEnabled")
    workflow_status_listener_sink: Optional[StrictStr] = Field(default=None, alias="workflowStatusListenerSink")
    __properties: ClassVar[List[str]] = ["createTime", "createdBy", "description", "enforceSchema", "failureWorkflow", "inputParameters", "inputSchema", "inputTemplate", "name", "outputParameters", "outputSchema", "ownerApp", "ownerEmail", "rateLimitConfig", "restartable", "schemaVersion", "tasks", "timeoutPolicy", "timeoutSeconds", "updateTime", "updatedBy", "variables", "version", "workflowStatusListenerEnabled", "workflowStatusListenerSink"]

    @field_validator('timeout_policy')
    def timeout_policy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TIME_OUT_WF', 'ALERT_ONLY']):
            raise ValueError("must be one of enum values ('TIME_OUT_WF', 'ALERT_ONLY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowDef from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of input_schema
        if self.input_schema:
            _dict['inputSchema'] = self.input_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of output_schema
        if self.output_schema:
            _dict['outputSchema'] = self.output_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rate_limit_config
        if self.rate_limit_config:
            _dict['rateLimitConfig'] = self.rate_limit_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tasks (list)
        _items = []
        if self.tasks:
            for _item_tasks in self.tasks:
                if _item_tasks:
                    _items.append(_item_tasks.to_dict())
            _dict['tasks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowDef from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createTime": obj.get("createTime"),
            "createdBy": obj.get("createdBy"),
            "description": obj.get("description"),
            "enforceSchema": obj.get("enforceSchema"),
            "failureWorkflow": obj.get("failureWorkflow"),
            "inputParameters": obj.get("inputParameters"),
            "inputSchema": SchemaDef.from_dict(obj["inputSchema"]) if obj.get("inputSchema") is not None else None,
            "inputTemplate": obj.get("inputTemplate"),
            "name": obj.get("name"),
            "outputParameters": obj.get("outputParameters"),
            "outputSchema": SchemaDef.from_dict(obj["outputSchema"]) if obj.get("outputSchema") is not None else None,
            "ownerApp": obj.get("ownerApp"),
            "ownerEmail": obj.get("ownerEmail"),
            "rateLimitConfig": RateLimitConfig.from_dict(obj["rateLimitConfig"]) if obj.get("rateLimitConfig") is not None else None,
            "restartable": obj.get("restartable"),
            "schemaVersion": obj.get("schemaVersion"),
            "tasks": [WorkflowTask.from_dict(_item) for _item in obj["tasks"]] if obj.get("tasks") is not None else None,
            "timeoutPolicy": obj.get("timeoutPolicy"),
            "timeoutSeconds": obj.get("timeoutSeconds"),
            "updateTime": obj.get("updateTime"),
            "updatedBy": obj.get("updatedBy"),
            "variables": obj.get("variables"),
            "version": obj.get("version"),
            "workflowStatusListenerEnabled": obj.get("workflowStatusListenerEnabled"),
            "workflowStatusListenerSink": obj.get("workflowStatusListenerSink")
        })
        return _obj


