from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from conductor.client.codegen.api_client import ApiClient


class EventExecutionResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_event_handlers_for_event1(self, **kwargs):  # noqa: E501
        """Get All active Event Handlers for the last 24 hours  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_handlers_for_event1(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SearchResultHandledEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_handlers_for_event1_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_handlers_for_event1_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_handlers_for_event1_with_http_info(self, **kwargs):  # noqa: E501
        """Get All active Event Handlers for the last 24 hours  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_handlers_for_event1_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SearchResultHandledEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_handlers_for_event1" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/event/execution', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchResultHandledEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_handlers_for_event2(self, event, _from, **kwargs):  # noqa: E501
        """Get event handlers for a given event  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_handlers_for_event2(event, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event: (required)
        :param int _from: (required)
        :return: list[ExtendedEventExecution]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_handlers_for_event2_with_http_info(event, _from, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_handlers_for_event2_with_http_info(event, _from, **kwargs)  # noqa: E501
            return data

    def get_event_handlers_for_event2_with_http_info(self, event, _from, **kwargs):  # noqa: E501
        """Get event handlers for a given event  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_handlers_for_event2_with_http_info(event, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event: (required)
        :param int _from: (required)
        :return: list[ExtendedEventExecution]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event', '_from']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_handlers_for_event2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event' is set
        if ('event' not in params or
                params['event'] is None):
            raise ValueError("Missing the required parameter `event` when calling `get_event_handlers_for_event2`")  # noqa: E501
        # verify the required parameter '_from' is set
        if ('_from' not in params or
                params['_from'] is None):
            raise ValueError("Missing the required parameter `_from` when calling `get_event_handlers_for_event2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event' in params:
            path_params['event'] = params['event']  # noqa: E501

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/event/execution/{event}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExtendedEventExecution]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
