# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.start_workflow_request import StartWorkflowRequest
from conductor.asyncio_client.http.models.task_details import TaskDetails
from conductor.asyncio_client.http.models.terminate_workflow import TerminateWorkflow
from conductor.asyncio_client.http.models.update_workflow_variables import UpdateWorkflowVariables
from typing import Optional, Set
from typing_extensions import Self

class Action(BaseModel):
    """
    Action
    """ # noqa: E501
    action: Optional[StrictStr] = None
    complete_task: Optional[TaskDetails] = None
    expand_inline_json: Optional[StrictBool] = Field(default=None, alias="expandInlineJSON")
    fail_task: Optional[TaskDetails] = None
    start_workflow: Optional[StartWorkflowRequest] = None
    terminate_workflow: Optional[TerminateWorkflow] = None
    update_workflow_variables: Optional[UpdateWorkflowVariables] = None
    __properties: ClassVar[List[str]] = ["action", "complete_task", "expandInlineJSON", "fail_task", "start_workflow", "terminate_workflow", "update_workflow_variables"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['start_workflow', 'complete_task', 'fail_task', 'terminate_workflow', 'update_workflow_variables']):
            raise ValueError("must be one of enum values ('start_workflow', 'complete_task', 'fail_task', 'terminate_workflow', 'update_workflow_variables')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Action from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of complete_task
        if self.complete_task:
            _dict['complete_task'] = self.complete_task.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fail_task
        if self.fail_task:
            _dict['fail_task'] = self.fail_task.to_dict()
        # override the default output from pydantic by calling `to_dict()` of start_workflow
        if self.start_workflow:
            _dict['start_workflow'] = self.start_workflow.to_dict()
        # override the default output from pydantic by calling `to_dict()` of terminate_workflow
        if self.terminate_workflow:
            _dict['terminate_workflow'] = self.terminate_workflow.to_dict()
        # override the default output from pydantic by calling `to_dict()` of update_workflow_variables
        if self.update_workflow_variables:
            _dict['update_workflow_variables'] = self.update_workflow_variables.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Action from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "complete_task": TaskDetails.from_dict(obj["complete_task"]) if obj.get("complete_task") is not None else None,
            "expandInlineJSON": obj.get("expandInlineJSON"),
            "fail_task": TaskDetails.from_dict(obj["fail_task"]) if obj.get("fail_task") is not None else None,
            "start_workflow": StartWorkflowRequest.from_dict(obj["start_workflow"]) if obj.get("start_workflow") is not None else None,
            "terminate_workflow": TerminateWorkflow.from_dict(obj["terminate_workflow"]) if obj.get("terminate_workflow") is not None else None,
            "update_workflow_variables": UpdateWorkflowVariables.from_dict(obj["update_workflow_variables"]) if obj.get("update_workflow_variables") is not None else None
        })
        return _obj


