# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Descriptor(BaseModel):
    """
    Descriptor
    """ # noqa: E501
    containing_type: Optional[Descriptor] = Field(default=None, alias="containingType")
    enum_types: Optional[List[EnumDescriptor]] = Field(default=None, alias="enumTypes")
    extendable: Optional[StrictBool] = None
    extensions: Optional[List[FieldDescriptor]] = None
    fields: Optional[List[FieldDescriptor]] = None
    file: Optional[FileDescriptor] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    index: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    nested_types: Optional[List[Descriptor]] = Field(default=None, alias="nestedTypes")
    oneofs: Optional[List[OneofDescriptor]] = None
    options: Optional[MessageOptions] = None
    proto: Optional[DescriptorProto] = None
    real_oneofs: Optional[List[OneofDescriptor]] = Field(default=None, alias="realOneofs")
    __properties: ClassVar[List[str]] = ["containingType", "enumTypes", "extendable", "extensions", "fields", "file", "fullName", "index", "name", "nestedTypes", "oneofs", "options", "proto", "realOneofs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Descriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of containing_type
        if self.containing_type:
            _dict['containingType'] = self.containing_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in enum_types (list)
        _items = []
        if self.enum_types:
            for _item_enum_types in self.enum_types:
                if _item_enum_types:
                    _items.append(_item_enum_types.to_dict())
            _dict['enumTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in extensions (list)
        _items = []
        if self.extensions:
            for _item_extensions in self.extensions:
                if _item_extensions:
                    _items.append(_item_extensions.to_dict())
            _dict['extensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item_fields in self.fields:
                if _item_fields:
                    _items.append(_item_fields.to_dict())
            _dict['fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in nested_types (list)
        _items = []
        if self.nested_types:
            for _item_nested_types in self.nested_types:
                if _item_nested_types:
                    _items.append(_item_nested_types.to_dict())
            _dict['nestedTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in oneofs (list)
        _items = []
        if self.oneofs:
            for _item_oneofs in self.oneofs:
                if _item_oneofs:
                    _items.append(_item_oneofs.to_dict())
            _dict['oneofs'] = _items
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of proto
        if self.proto:
            _dict['proto'] = self.proto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in real_oneofs (list)
        _items = []
        if self.real_oneofs:
            for _item_real_oneofs in self.real_oneofs:
                if _item_real_oneofs:
                    _items.append(_item_real_oneofs.to_dict())
            _dict['realOneofs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Descriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "containingType": Descriptor.from_dict(obj["containingType"]) if obj.get("containingType") is not None else None,
            "enumTypes": [EnumDescriptor.from_dict(_item) for _item in obj["enumTypes"]] if obj.get("enumTypes") is not None else None,
            "extendable": obj.get("extendable"),
            "extensions": [FieldDescriptor.from_dict(_item) for _item in obj["extensions"]] if obj.get("extensions") is not None else None,
            "fields": [FieldDescriptor.from_dict(_item) for _item in obj["fields"]] if obj.get("fields") is not None else None,
            "file": FileDescriptor.from_dict(obj["file"]) if obj.get("file") is not None else None,
            "fullName": obj.get("fullName"),
            "index": obj.get("index"),
            "name": obj.get("name"),
            "nestedTypes": [Descriptor.from_dict(_item) for _item in obj["nestedTypes"]] if obj.get("nestedTypes") is not None else None,
            "oneofs": [OneofDescriptor.from_dict(_item) for _item in obj["oneofs"]] if obj.get("oneofs") is not None else None,
            "options": MessageOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "proto": DescriptorProto.from_dict(obj["proto"]) if obj.get("proto") is not None else None,
            "realOneofs": [OneofDescriptor.from_dict(_item) for _item in obj["realOneofs"]] if obj.get("realOneofs") is not None else None
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor_proto import DescriptorProto
from conductor.asyncio_client.http.models.enum_descriptor import EnumDescriptor
from conductor.asyncio_client.http.models.field_descriptor import FieldDescriptor
from conductor.asyncio_client.http.models.file_descriptor import FileDescriptor
from conductor.asyncio_client.http.models.message_options import MessageOptions
from conductor.asyncio_client.http.models.oneof_descriptor import OneofDescriptor
# TODO: Rewrite to not use raise_errors
Descriptor.model_rebuild(raise_errors=False)

