# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.unknown_field_set import UnknownFieldSet
from typing import Optional, Set
from typing_extensions import Self

class FeatureSetOrBuilder(BaseModel):
    """
    FeatureSetOrBuilder
    """ # noqa: E501
    all_fields: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="allFields")
    default_instance_for_type: Optional[Message] = Field(default=None, alias="defaultInstanceForType")
    descriptor_for_type: Optional[Descriptor] = Field(default=None, alias="descriptorForType")
    enum_type: Optional[StrictStr] = Field(default=None, alias="enumType")
    field_presence: Optional[StrictStr] = Field(default=None, alias="fieldPresence")
    initialization_error_string: Optional[StrictStr] = Field(default=None, alias="initializationErrorString")
    initialized: Optional[StrictBool] = None
    json_format: Optional[StrictStr] = Field(default=None, alias="jsonFormat")
    message_encoding: Optional[StrictStr] = Field(default=None, alias="messageEncoding")
    repeated_field_encoding: Optional[StrictStr] = Field(default=None, alias="repeatedFieldEncoding")
    unknown_fields: Optional[UnknownFieldSet] = Field(default=None, alias="unknownFields")
    utf8_validation: Optional[StrictStr] = Field(default=None, alias="utf8Validation")
    __properties: ClassVar[List[str]] = ["allFields", "defaultInstanceForType", "descriptorForType", "enumType", "fieldPresence", "initializationErrorString", "initialized", "jsonFormat", "messageEncoding", "repeatedFieldEncoding", "unknownFields", "utf8Validation"]

    @field_validator('enum_type')
    def enum_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ENUM_TYPE_UNKNOWN', 'OPEN', 'CLOSED']):
            raise ValueError("must be one of enum values ('ENUM_TYPE_UNKNOWN', 'OPEN', 'CLOSED')")
        return value

    @field_validator('field_presence')
    def field_presence_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FIELD_PRESENCE_UNKNOWN', 'EXPLICIT', 'IMPLICIT', 'LEGACY_REQUIRED']):
            raise ValueError("must be one of enum values ('FIELD_PRESENCE_UNKNOWN', 'EXPLICIT', 'IMPLICIT', 'LEGACY_REQUIRED')")
        return value

    @field_validator('json_format')
    def json_format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['JSON_FORMAT_UNKNOWN', 'ALLOW', 'LEGACY_BEST_EFFORT']):
            raise ValueError("must be one of enum values ('JSON_FORMAT_UNKNOWN', 'ALLOW', 'LEGACY_BEST_EFFORT')")
        return value

    @field_validator('message_encoding')
    def message_encoding_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MESSAGE_ENCODING_UNKNOWN', 'LENGTH_PREFIXED', 'DELIMITED']):
            raise ValueError("must be one of enum values ('MESSAGE_ENCODING_UNKNOWN', 'LENGTH_PREFIXED', 'DELIMITED')")
        return value

    @field_validator('repeated_field_encoding')
    def repeated_field_encoding_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['REPEATED_FIELD_ENCODING_UNKNOWN', 'PACKED', 'EXPANDED']):
            raise ValueError("must be one of enum values ('REPEATED_FIELD_ENCODING_UNKNOWN', 'PACKED', 'EXPANDED')")
        return value

    @field_validator('utf8_validation')
    def utf8_validation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['UTF8_VALIDATION_UNKNOWN', 'NONE', 'VERIFY']):
            raise ValueError("must be one of enum values ('UTF8_VALIDATION_UNKNOWN', 'NONE', 'VERIFY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FeatureSetOrBuilder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_instance_for_type
        if self.default_instance_for_type:
            _dict['defaultInstanceForType'] = self.default_instance_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of descriptor_for_type
        if self.descriptor_for_type:
            _dict['descriptorForType'] = self.descriptor_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unknown_fields
        if self.unknown_fields:
            _dict['unknownFields'] = self.unknown_fields.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FeatureSetOrBuilder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allFields": obj.get("allFields"),
            "defaultInstanceForType": Message.from_dict(obj["defaultInstanceForType"]) if obj.get("defaultInstanceForType") is not None else None,
            "descriptorForType": Descriptor.from_dict(obj["descriptorForType"]) if obj.get("descriptorForType") is not None else None,
            "enumType": obj.get("enumType"),
            "fieldPresence": obj.get("fieldPresence"),
            "initializationErrorString": obj.get("initializationErrorString"),
            "initialized": obj.get("initialized"),
            "jsonFormat": obj.get("jsonFormat"),
            "messageEncoding": obj.get("messageEncoding"),
            "repeatedFieldEncoding": obj.get("repeatedFieldEncoding"),
            "unknownFields": UnknownFieldSet.from_dict(obj["unknownFields"]) if obj.get("unknownFields") is not None else None,
            "utf8Validation": obj.get("utf8Validation")
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.message import Message
# TODO: Rewrite to not use raise_errors
FeatureSetOrBuilder.model_rebuild(raise_errors=False)

