# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.unknown_field_set import UnknownFieldSet
from typing import Optional, Set
from typing_extensions import Self

class FieldOptionsOrBuilder(BaseModel):
    """
    FieldOptionsOrBuilder
    """ # noqa: E501
    all_fields: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="allFields")
    ctype: Optional[StrictStr] = None
    debug_redact: Optional[StrictBool] = Field(default=None, alias="debugRedact")
    default_instance_for_type: Optional[Message] = Field(default=None, alias="defaultInstanceForType")
    deprecated: Optional[StrictBool] = None
    descriptor_for_type: Optional[Descriptor] = Field(default=None, alias="descriptorForType")
    edition_defaults_count: Optional[StrictInt] = Field(default=None, alias="editionDefaultsCount")
    edition_defaults_list: Optional[List[EditionDefault]] = Field(default=None, alias="editionDefaultsList")
    edition_defaults_or_builder_list: Optional[List[EditionDefaultOrBuilder]] = Field(default=None, alias="editionDefaultsOrBuilderList")
    features: Optional[FeatureSet] = None
    features_or_builder: Optional[FeatureSetOrBuilder] = Field(default=None, alias="featuresOrBuilder")
    initialization_error_string: Optional[StrictStr] = Field(default=None, alias="initializationErrorString")
    initialized: Optional[StrictBool] = None
    jstype: Optional[StrictStr] = None
    lazy: Optional[StrictBool] = None
    packed: Optional[StrictBool] = None
    retention: Optional[StrictStr] = None
    targets_count: Optional[StrictInt] = Field(default=None, alias="targetsCount")
    targets_list: Optional[List[StrictStr]] = Field(default=None, alias="targetsList")
    uninterpreted_option_count: Optional[StrictInt] = Field(default=None, alias="uninterpretedOptionCount")
    uninterpreted_option_list: Optional[List[UninterpretedOption]] = Field(default=None, alias="uninterpretedOptionList")
    uninterpreted_option_or_builder_list: Optional[List[UninterpretedOptionOrBuilder]] = Field(default=None, alias="uninterpretedOptionOrBuilderList")
    unknown_fields: Optional[UnknownFieldSet] = Field(default=None, alias="unknownFields")
    unverified_lazy: Optional[StrictBool] = Field(default=None, alias="unverifiedLazy")
    weak: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["allFields", "ctype", "debugRedact", "defaultInstanceForType", "deprecated", "descriptorForType", "editionDefaultsCount", "editionDefaultsList", "editionDefaultsOrBuilderList", "features", "featuresOrBuilder", "initializationErrorString", "initialized", "jstype", "lazy", "packed", "retention", "targetsCount", "targetsList", "uninterpretedOptionCount", "uninterpretedOptionList", "uninterpretedOptionOrBuilderList", "unknownFields", "unverifiedLazy", "weak"]

    @field_validator('ctype')
    def ctype_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['STRING', 'CORD', 'STRING_PIECE']):
            raise ValueError("must be one of enum values ('STRING', 'CORD', 'STRING_PIECE')")
        return value

    @field_validator('jstype')
    def jstype_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['JS_NORMAL', 'JS_STRING', 'JS_NUMBER']):
            raise ValueError("must be one of enum values ('JS_NORMAL', 'JS_STRING', 'JS_NUMBER')")
        return value

    @field_validator('retention')
    def retention_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RETENTION_UNKNOWN', 'RETENTION_RUNTIME', 'RETENTION_SOURCE']):
            raise ValueError("must be one of enum values ('RETENTION_UNKNOWN', 'RETENTION_RUNTIME', 'RETENTION_SOURCE')")
        return value

    @field_validator('targets_list')
    def targets_list_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['TARGET_TYPE_UNKNOWN', 'TARGET_TYPE_FILE', 'TARGET_TYPE_EXTENSION_RANGE', 'TARGET_TYPE_MESSAGE', 'TARGET_TYPE_FIELD', 'TARGET_TYPE_ONEOF', 'TARGET_TYPE_ENUM', 'TARGET_TYPE_ENUM_ENTRY', 'TARGET_TYPE_SERVICE', 'TARGET_TYPE_METHOD']):
                raise ValueError("each list item must be one of ('TARGET_TYPE_UNKNOWN', 'TARGET_TYPE_FILE', 'TARGET_TYPE_EXTENSION_RANGE', 'TARGET_TYPE_MESSAGE', 'TARGET_TYPE_FIELD', 'TARGET_TYPE_ONEOF', 'TARGET_TYPE_ENUM', 'TARGET_TYPE_ENUM_ENTRY', 'TARGET_TYPE_SERVICE', 'TARGET_TYPE_METHOD')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldOptionsOrBuilder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_instance_for_type
        if self.default_instance_for_type:
            _dict['defaultInstanceForType'] = self.default_instance_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of descriptor_for_type
        if self.descriptor_for_type:
            _dict['descriptorForType'] = self.descriptor_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in edition_defaults_list (list)
        _items = []
        if self.edition_defaults_list:
            for _item_edition_defaults_list in self.edition_defaults_list:
                if _item_edition_defaults_list:
                    _items.append(_item_edition_defaults_list.to_dict())
            _dict['editionDefaultsList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in edition_defaults_or_builder_list (list)
        _items = []
        if self.edition_defaults_or_builder_list:
            for _item_edition_defaults_or_builder_list in self.edition_defaults_or_builder_list:
                if _item_edition_defaults_or_builder_list:
                    _items.append(_item_edition_defaults_or_builder_list.to_dict())
            _dict['editionDefaultsOrBuilderList'] = _items
        # override the default output from pydantic by calling `to_dict()` of features
        if self.features:
            _dict['features'] = self.features.to_dict()
        # override the default output from pydantic by calling `to_dict()` of features_or_builder
        if self.features_or_builder:
            _dict['featuresOrBuilder'] = self.features_or_builder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in uninterpreted_option_list (list)
        _items = []
        if self.uninterpreted_option_list:
            for _item_uninterpreted_option_list in self.uninterpreted_option_list:
                if _item_uninterpreted_option_list:
                    _items.append(_item_uninterpreted_option_list.to_dict())
            _dict['uninterpretedOptionList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in uninterpreted_option_or_builder_list (list)
        _items = []
        if self.uninterpreted_option_or_builder_list:
            for _item_uninterpreted_option_or_builder_list in self.uninterpreted_option_or_builder_list:
                if _item_uninterpreted_option_or_builder_list:
                    _items.append(_item_uninterpreted_option_or_builder_list.to_dict())
            _dict['uninterpretedOptionOrBuilderList'] = _items
        # override the default output from pydantic by calling `to_dict()` of unknown_fields
        if self.unknown_fields:
            _dict['unknownFields'] = self.unknown_fields.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldOptionsOrBuilder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allFields": obj.get("allFields"),
            "ctype": obj.get("ctype"),
            "debugRedact": obj.get("debugRedact"),
            "defaultInstanceForType": Message.from_dict(obj["defaultInstanceForType"]) if obj.get("defaultInstanceForType") is not None else None,
            "deprecated": obj.get("deprecated"),
            "descriptorForType": Descriptor.from_dict(obj["descriptorForType"]) if obj.get("descriptorForType") is not None else None,
            "editionDefaultsCount": obj.get("editionDefaultsCount"),
            "editionDefaultsList": [EditionDefault.from_dict(_item) for _item in obj["editionDefaultsList"]] if obj.get("editionDefaultsList") is not None else None,
            "editionDefaultsOrBuilderList": [EditionDefaultOrBuilder.from_dict(_item) for _item in obj["editionDefaultsOrBuilderList"]] if obj.get("editionDefaultsOrBuilderList") is not None else None,
            "features": FeatureSet.from_dict(obj["features"]) if obj.get("features") is not None else None,
            "featuresOrBuilder": FeatureSetOrBuilder.from_dict(obj["featuresOrBuilder"]) if obj.get("featuresOrBuilder") is not None else None,
            "initializationErrorString": obj.get("initializationErrorString"),
            "initialized": obj.get("initialized"),
            "jstype": obj.get("jstype"),
            "lazy": obj.get("lazy"),
            "packed": obj.get("packed"),
            "retention": obj.get("retention"),
            "targetsCount": obj.get("targetsCount"),
            "targetsList": obj.get("targetsList"),
            "uninterpretedOptionCount": obj.get("uninterpretedOptionCount"),
            "uninterpretedOptionList": [UninterpretedOption.from_dict(_item) for _item in obj["uninterpretedOptionList"]] if obj.get("uninterpretedOptionList") is not None else None,
            "uninterpretedOptionOrBuilderList": [UninterpretedOptionOrBuilder.from_dict(_item) for _item in obj["uninterpretedOptionOrBuilderList"]] if obj.get("uninterpretedOptionOrBuilderList") is not None else None,
            "unknownFields": UnknownFieldSet.from_dict(obj["unknownFields"]) if obj.get("unknownFields") is not None else None,
            "unverifiedLazy": obj.get("unverifiedLazy"),
            "weak": obj.get("weak")
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.edition_default import EditionDefault
from conductor.asyncio_client.http.models.edition_default_or_builder import EditionDefaultOrBuilder
from conductor.asyncio_client.http.models.feature_set import FeatureSet
from conductor.asyncio_client.http.models.feature_set_or_builder import FeatureSetOrBuilder
from conductor.asyncio_client.http.models.message import Message
from conductor.asyncio_client.http.models.uninterpreted_option import UninterpretedOption
from conductor.asyncio_client.http.models.uninterpreted_option_or_builder import UninterpretedOptionOrBuilder
# TODO: Rewrite to not use raise_errors
FieldOptionsOrBuilder.model_rebuild(raise_errors=False)

