# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FileDescriptor(BaseModel):
    """
    FileDescriptor
    """ # noqa: E501
    dependencies: Optional[List[FileDescriptor]] = None
    edition: Optional[StrictStr] = None
    edition_name: Optional[StrictStr] = Field(default=None, alias="editionName")
    enum_types: Optional[List[EnumDescriptor]] = Field(default=None, alias="enumTypes")
    extensions: Optional[List[FieldDescriptor]] = None
    file: Optional[FileDescriptor] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    message_types: Optional[List[Descriptor]] = Field(default=None, alias="messageTypes")
    name: Optional[StrictStr] = None
    options: Optional[FileOptions] = None
    package: Optional[StrictStr] = None
    proto: Optional[FileDescriptorProto] = None
    public_dependencies: Optional[List[FileDescriptor]] = Field(default=None, alias="publicDependencies")
    services: Optional[List[ServiceDescriptor]] = None
    syntax: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["dependencies", "edition", "editionName", "enumTypes", "extensions", "file", "fullName", "messageTypes", "name", "options", "package", "proto", "publicDependencies", "services", "syntax"]

    @field_validator('edition')
    def edition_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['EDITION_UNKNOWN', 'EDITION_PROTO2', 'EDITION_PROTO3', 'EDITION_2023', 'EDITION_1_TEST_ONLY', 'EDITION_2_TEST_ONLY', 'EDITION_99997_TEST_ONLY', 'EDITION_99998_TEST_ONLY', 'EDITION_99999_TEST_ONLY']):
            raise ValueError("must be one of enum values ('EDITION_UNKNOWN', 'EDITION_PROTO2', 'EDITION_PROTO3', 'EDITION_2023', 'EDITION_1_TEST_ONLY', 'EDITION_2_TEST_ONLY', 'EDITION_99997_TEST_ONLY', 'EDITION_99998_TEST_ONLY', 'EDITION_99999_TEST_ONLY')")
        return value

    @field_validator('syntax')
    def syntax_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['UNKNOWN', 'PROTO2', 'PROTO3', 'EDITIONS']):
            raise ValueError("must be one of enum values ('UNKNOWN', 'PROTO2', 'PROTO3', 'EDITIONS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileDescriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dependencies (list)
        _items = []
        if self.dependencies:
            for _item_dependencies in self.dependencies:
                if _item_dependencies:
                    _items.append(_item_dependencies.to_dict())
            _dict['dependencies'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in enum_types (list)
        _items = []
        if self.enum_types:
            for _item_enum_types in self.enum_types:
                if _item_enum_types:
                    _items.append(_item_enum_types.to_dict())
            _dict['enumTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in extensions (list)
        _items = []
        if self.extensions:
            for _item_extensions in self.extensions:
                if _item_extensions:
                    _items.append(_item_extensions.to_dict())
            _dict['extensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in message_types (list)
        _items = []
        if self.message_types:
            for _item_message_types in self.message_types:
                if _item_message_types:
                    _items.append(_item_message_types.to_dict())
            _dict['messageTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of proto
        if self.proto:
            _dict['proto'] = self.proto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in public_dependencies (list)
        _items = []
        if self.public_dependencies:
            for _item_public_dependencies in self.public_dependencies:
                if _item_public_dependencies:
                    _items.append(_item_public_dependencies.to_dict())
            _dict['publicDependencies'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in services (list)
        _items = []
        if self.services:
            for _item_services in self.services:
                if _item_services:
                    _items.append(_item_services.to_dict())
            _dict['services'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileDescriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dependencies": [FileDescriptor.from_dict(_item) for _item in obj["dependencies"]] if obj.get("dependencies") is not None else None,
            "edition": obj.get("edition"),
            "editionName": obj.get("editionName"),
            "enumTypes": [EnumDescriptor.from_dict(_item) for _item in obj["enumTypes"]] if obj.get("enumTypes") is not None else None,
            "extensions": [FieldDescriptor.from_dict(_item) for _item in obj["extensions"]] if obj.get("extensions") is not None else None,
            "file": FileDescriptor.from_dict(obj["file"]) if obj.get("file") is not None else None,
            "fullName": obj.get("fullName"),
            "messageTypes": [Descriptor.from_dict(_item) for _item in obj["messageTypes"]] if obj.get("messageTypes") is not None else None,
            "name": obj.get("name"),
            "options": FileOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "package": obj.get("package"),
            "proto": FileDescriptorProto.from_dict(obj["proto"]) if obj.get("proto") is not None else None,
            "publicDependencies": [FileDescriptor.from_dict(_item) for _item in obj["publicDependencies"]] if obj.get("publicDependencies") is not None else None,
            "services": [ServiceDescriptor.from_dict(_item) for _item in obj["services"]] if obj.get("services") is not None else None,
            "syntax": obj.get("syntax")
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.enum_descriptor import EnumDescriptor
from conductor.asyncio_client.http.models.field_descriptor import FieldDescriptor
from conductor.asyncio_client.http.models.file_descriptor_proto import FileDescriptorProto
from conductor.asyncio_client.http.models.file_options import FileOptions
from conductor.asyncio_client.http.models.service_descriptor import ServiceDescriptor
# TODO: Rewrite to not use raise_errors
FileDescriptor.model_rebuild(raise_errors=False)

