# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.option import Option
from typing import Optional, Set
from typing_extensions import Self

class IntegrationDefFormField(BaseModel):
    """
    IntegrationDefFormField
    """ # noqa: E501
    default_value: Optional[StrictStr] = Field(default=None, alias="defaultValue")
    description: Optional[StrictStr] = None
    field_name: Optional[StrictStr] = Field(default=None, alias="fieldName")
    field_type: Optional[StrictStr] = Field(default=None, alias="fieldType")
    label: Optional[StrictStr] = None
    optional: Optional[StrictBool] = None
    value: Optional[StrictStr] = None
    value_options: Optional[List[Option]] = Field(default=None, alias="valueOptions")
    __properties: ClassVar[List[str]] = ["defaultValue", "description", "fieldName", "fieldType", "label", "optional", "value", "valueOptions"]

    @field_validator('field_name')
    def field_name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['api_key', 'user', 'endpoint', 'authUrl', 'environment', 'projectName', 'indexName', 'publisher', 'password', 'namespace', 'batchSize', 'batchWaitTime', 'visibilityTimeout', 'connectionType', 'consumer', 'stream', 'batchPollConsumersCount', 'consumer_type', 'region', 'awsAccountId', 'externalId', 'roleArn', 'protocol', 'mechanism', 'port', 'schemaRegistryUrl', 'schemaRegistryApiKey', 'schemaRegistryApiSecret', 'authenticationType', 'truststoreAuthenticationType', 'tls', 'cipherSuite', 'pubSubMethod', 'keyStorePassword', 'keyStoreLocation', 'schemaRegistryAuthType', 'valueSubjectNameStrategy', 'datasourceURL', 'jdbcDriver', 'subscription', 'serviceAccountCredentials', 'file', 'tlsFile', 'queueManager', 'groupId', 'channel', 'dimensions', 'distance_metric', 'indexing_method', 'inverted_list_count']):
            raise ValueError("must be one of enum values ('api_key', 'user', 'endpoint', 'authUrl', 'environment', 'projectName', 'indexName', 'publisher', 'password', 'namespace', 'batchSize', 'batchWaitTime', 'visibilityTimeout', 'connectionType', 'consumer', 'stream', 'batchPollConsumersCount', 'consumer_type', 'region', 'awsAccountId', 'externalId', 'roleArn', 'protocol', 'mechanism', 'port', 'schemaRegistryUrl', 'schemaRegistryApiKey', 'schemaRegistryApiSecret', 'authenticationType', 'truststoreAuthenticationType', 'tls', 'cipherSuite', 'pubSubMethod', 'keyStorePassword', 'keyStoreLocation', 'schemaRegistryAuthType', 'valueSubjectNameStrategy', 'datasourceURL', 'jdbcDriver', 'subscription', 'serviceAccountCredentials', 'file', 'tlsFile', 'queueManager', 'groupId', 'channel', 'dimensions', 'distance_metric', 'indexing_method', 'inverted_list_count')")
        return value

    @field_validator('field_type')
    def field_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DROPDOWN', 'TEXT', 'PASSWORD', 'FILE']):
            raise ValueError("must be one of enum values ('DROPDOWN', 'TEXT', 'PASSWORD', 'FILE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IntegrationDefFormField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in value_options (list)
        _items = []
        if self.value_options:
            for _item_value_options in self.value_options:
                if _item_value_options:
                    _items.append(_item_value_options.to_dict())
            _dict['valueOptions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IntegrationDefFormField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultValue": obj.get("defaultValue"),
            "description": obj.get("description"),
            "fieldName": obj.get("fieldName"),
            "fieldType": obj.get("fieldType"),
            "label": obj.get("label"),
            "optional": obj.get("optional"),
            "value": obj.get("value"),
            "valueOptions": [Option.from_dict(_item) for _item in obj["valueOptions"]] if obj.get("valueOptions") is not None else None
        })
        return _obj


