# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpsertGroupRequest(BaseModel):
    """
    UpsertGroupRequest
    """ # noqa: E501
    default_access: Optional[Dict[str, List[StrictStr]]] = Field(default=None, description="a default Map<TargetType, Set<Access> to share permissions, allowed target types: WORKFLOW_DEF, TASK_DEF, WORKFLOW_SCHEDULE", alias="defaultAccess")
    description: StrictStr = Field(description="A general description of the group")
    roles: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["defaultAccess", "description", "roles"]

    @field_validator('default_access')
    def default_access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value.values():
            if i not in set(['CREATE', 'READ', 'EXECUTE', 'UPDATE', 'DELETE']):
                raise ValueError("dict values must be one of enum values ('CREATE', 'READ', 'EXECUTE', 'UPDATE', 'DELETE')")
        return value

    @field_validator('roles')
    def roles_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['ADMIN', 'USER', 'WORKER', 'METADATA_MANAGER', 'WORKFLOW_MANAGER']):
                raise ValueError("each list item must be one of ('ADMIN', 'USER', 'WORKER', 'METADATA_MANAGER', 'WORKFLOW_MANAGER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpsertGroupRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpsertGroupRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultAccess": obj.get("defaultAccess"),
            "description": obj.get("description"),
            "roles": obj.get("roles")
        })
        return _obj


