# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.start_workflow_request import StartWorkflowRequest
from typing import Optional, Set
from typing_extensions import Self

class WorkflowScheduleExecutionModel(BaseModel):
    """
    WorkflowScheduleExecutionModel
    """ # noqa: E501
    execution_id: Optional[StrictStr] = Field(default=None, alias="executionId")
    execution_time: Optional[StrictInt] = Field(default=None, alias="executionTime")
    org_id: Optional[StrictStr] = Field(default=None, alias="orgId")
    queue_msg_id: Optional[StrictStr] = Field(default=None, alias="queueMsgId")
    reason: Optional[StrictStr] = None
    schedule_name: Optional[StrictStr] = Field(default=None, alias="scheduleName")
    scheduled_time: Optional[StrictInt] = Field(default=None, alias="scheduledTime")
    stack_trace: Optional[StrictStr] = Field(default=None, alias="stackTrace")
    start_workflow_request: Optional[StartWorkflowRequest] = Field(default=None, alias="startWorkflowRequest")
    state: Optional[StrictStr] = None
    workflow_id: Optional[StrictStr] = Field(default=None, alias="workflowId")
    workflow_name: Optional[StrictStr] = Field(default=None, alias="workflowName")
    zone_id: Optional[StrictStr] = Field(default=None, alias="zoneId")
    __properties: ClassVar[List[str]] = ["executionId", "executionTime", "orgId", "queueMsgId", "reason", "scheduleName", "scheduledTime", "stackTrace", "startWorkflowRequest", "state", "workflowId", "workflowName", "zoneId"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['POLLED', 'FAILED', 'EXECUTED']):
            raise ValueError("must be one of enum values ('POLLED', 'FAILED', 'EXECUTED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowScheduleExecutionModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of start_workflow_request
        if self.start_workflow_request:
            _dict['startWorkflowRequest'] = self.start_workflow_request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowScheduleExecutionModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "executionId": obj.get("executionId"),
            "executionTime": obj.get("executionTime"),
            "orgId": obj.get("orgId"),
            "queueMsgId": obj.get("queueMsgId"),
            "reason": obj.get("reason"),
            "scheduleName": obj.get("scheduleName"),
            "scheduledTime": obj.get("scheduledTime"),
            "stackTrace": obj.get("stackTrace"),
            "startWorkflowRequest": StartWorkflowRequest.from_dict(obj["startWorkflowRequest"]) if obj.get("startWorkflowRequest") is not None else None,
            "state": obj.get("state"),
            "workflowId": obj.get("workflowId"),
            "workflowName": obj.get("workflowName"),
            "zoneId": obj.get("zoneId")
        })
        return _obj


