# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from conductor.asyncio_client.http.models.task_mock import TaskMock
from conductor.asyncio_client.http.models.workflow_def import WorkflowDef
from typing import Optional, Set
from typing_extensions import Self

class WorkflowTestRequest(BaseModel):
    """
    WorkflowTestRequest
    """ # noqa: E501
    correlation_id: Optional[StrictStr] = Field(default=None, alias="correlationId")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    external_input_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalInputPayloadStoragePath")
    idempotency_key: Optional[StrictStr] = Field(default=None, alias="idempotencyKey")
    idempotency_strategy: Optional[StrictStr] = Field(default=None, alias="idempotencyStrategy")
    input: Optional[Dict[str, Dict[str, Any]]] = None
    name: StrictStr
    priority: Optional[Annotated[int, Field(le=99, strict=True, ge=0)]] = None
    sub_workflow_test_request: Optional[Dict[str, WorkflowTestRequest]] = Field(default=None, alias="subWorkflowTestRequest")
    task_ref_to_mock_output: Optional[Dict[str, List[TaskMock]]] = Field(default=None, alias="taskRefToMockOutput")
    task_to_domain: Optional[Dict[str, StrictStr]] = Field(default=None, alias="taskToDomain")
    version: Optional[StrictInt] = None
    workflow_def: Optional[WorkflowDef] = Field(default=None, alias="workflowDef")
    __properties: ClassVar[List[str]] = ["correlationId", "createdBy", "externalInputPayloadStoragePath", "idempotencyKey", "idempotencyStrategy", "input", "name", "priority", "subWorkflowTestRequest", "taskRefToMockOutput", "taskToDomain", "version", "workflowDef"]

    @field_validator('idempotency_strategy')
    def idempotency_strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FAIL', 'RETURN_EXISTING', 'FAIL_ON_RUNNING']):
            raise ValueError("must be one of enum values ('FAIL', 'RETURN_EXISTING', 'FAIL_ON_RUNNING')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowTestRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in sub_workflow_test_request (dict)
        _field_dict = {}
        if self.sub_workflow_test_request:
            for _key_sub_workflow_test_request in self.sub_workflow_test_request:
                if self.sub_workflow_test_request[_key_sub_workflow_test_request]:
                    _field_dict[_key_sub_workflow_test_request] = self.sub_workflow_test_request[_key_sub_workflow_test_request].to_dict()
            _dict['subWorkflowTestRequest'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in task_ref_to_mock_output (dict of array)
        _field_dict_of_array = {}
        if self.task_ref_to_mock_output:
            for _key_task_ref_to_mock_output in self.task_ref_to_mock_output:
                if self.task_ref_to_mock_output[_key_task_ref_to_mock_output] is not None:
                    _field_dict_of_array[_key_task_ref_to_mock_output] = [
                        _item.to_dict() for _item in self.task_ref_to_mock_output[_key_task_ref_to_mock_output]
                    ]
            _dict['taskRefToMockOutput'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of workflow_def
        if self.workflow_def:
            _dict['workflowDef'] = self.workflow_def.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowTestRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "correlationId": obj.get("correlationId"),
            "createdBy": obj.get("createdBy"),
            "externalInputPayloadStoragePath": obj.get("externalInputPayloadStoragePath"),
            "idempotencyKey": obj.get("idempotencyKey"),
            "idempotencyStrategy": obj.get("idempotencyStrategy"),
            "input": obj.get("input"),
            "name": obj.get("name"),
            "priority": obj.get("priority"),
            "subWorkflowTestRequest": dict(
                (_k, WorkflowTestRequest.from_dict(_v))
                for _k, _v in obj["subWorkflowTestRequest"].items()
            )
            if obj.get("subWorkflowTestRequest") is not None
            else None,
            "taskRefToMockOutput": dict(
                (_k,
                        [TaskMock.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("taskRefToMockOutput", {}).items()
            ),
            "taskToDomain": obj.get("taskToDomain"),
            "version": obj.get("version"),
            "workflowDef": WorkflowDef.from_dict(obj["workflowDef"]) if obj.get("workflowDef") is not None else None
        })
        return _obj

# TODO: Rewrite to not use raise_errors
WorkflowTestRequest.model_rebuild(raise_errors=False)

