# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class EnumDescriptor(BaseModel):
    """
    EnumDescriptor
    """ # noqa: E501
    closed: Optional[StrictBool] = None
    containing_type: Optional[Descriptor] = Field(default=None, alias="containingType")
    file: Optional[FileDescriptor] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    index: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    options: Optional[EnumOptions] = None
    proto: Optional[EnumDescriptorProto] = None
    values: Optional[List[EnumValueDescriptor]] = None
    __properties: ClassVar[List[str]] = ["closed", "containingType", "file", "fullName", "index", "name", "options", "proto", "values"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EnumDescriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of containing_type
        if self.containing_type:
            _dict['containingType'] = self.containing_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of proto
        if self.proto:
            _dict['proto'] = self.proto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in values (list)
        _items = []
        if self.values:
            for _item_values in self.values:
                if _item_values:
                    _items.append(_item_values.to_dict())
            _dict['values'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EnumDescriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "closed": obj.get("closed"),
            "containingType": Descriptor.from_dict(obj["containingType"]) if obj.get("containingType") is not None else None,
            "file": FileDescriptor.from_dict(obj["file"]) if obj.get("file") is not None else None,
            "fullName": obj.get("fullName"),
            "index": obj.get("index"),
            "name": obj.get("name"),
            "options": EnumOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "proto": EnumDescriptorProto.from_dict(obj["proto"]) if obj.get("proto") is not None else None,
            "values": [EnumValueDescriptor.from_dict(_item) for _item in obj["values"]] if obj.get("values") is not None else None
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.enum_descriptor_proto import EnumDescriptorProto
from conductor.asyncio_client.http.models.enum_options import EnumOptions
from conductor.asyncio_client.http.models.enum_value_descriptor import EnumValueDescriptor
from conductor.asyncio_client.http.models.file_descriptor import FileDescriptor
# TODO: Rewrite to not use raise_errors
EnumDescriptor.model_rebuild(raise_errors=False)

