# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from conductor.asyncio_client.http.models.schema_def import SchemaDef
from conductor.asyncio_client.http.models.tag import Tag
from typing import Optional, Set
from typing_extensions import Self

class ExtendedTaskDef(BaseModel):
    """
    ExtendedTaskDef
    """ # noqa: E501
    backoff_scale_factor: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=None, alias="backoffScaleFactor")
    base_type: Optional[StrictStr] = Field(default=None, alias="baseType")
    concurrent_exec_limit: Optional[StrictInt] = Field(default=None, alias="concurrentExecLimit")
    create_time: Optional[StrictInt] = Field(default=None, alias="createTime")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    description: Optional[StrictStr] = None
    enforce_schema: Optional[StrictBool] = Field(default=None, alias="enforceSchema")
    execution_name_space: Optional[StrictStr] = Field(default=None, alias="executionNameSpace")
    input_keys: Optional[List[StrictStr]] = Field(default=None, alias="inputKeys")
    input_schema: Optional[SchemaDef] = Field(default=None, alias="inputSchema")
    input_template: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="inputTemplate")
    isolation_group_id: Optional[StrictStr] = Field(default=None, alias="isolationGroupId")
    name: StrictStr
    output_keys: Optional[List[StrictStr]] = Field(default=None, alias="outputKeys")
    output_schema: Optional[SchemaDef] = Field(default=None, alias="outputSchema")
    overwrite_tags: Optional[StrictBool] = Field(default=None, alias="overwriteTags")
    owner_app: Optional[StrictStr] = Field(default=None, alias="ownerApp")
    owner_email: Optional[StrictStr] = Field(default=None, alias="ownerEmail")
    poll_timeout_seconds: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="pollTimeoutSeconds")
    rate_limit_frequency_in_seconds: Optional[StrictInt] = Field(default=None, alias="rateLimitFrequencyInSeconds")
    rate_limit_per_frequency: Optional[StrictInt] = Field(default=None, alias="rateLimitPerFrequency")
    response_timeout_seconds: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=None, alias="responseTimeoutSeconds")
    retry_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="retryCount")
    retry_delay_seconds: Optional[StrictInt] = Field(default=None, alias="retryDelaySeconds")
    retry_logic: Optional[StrictStr] = Field(default=None, alias="retryLogic")
    tags: Optional[List[Tag]] = None
    timeout_policy: Optional[StrictStr] = Field(default=None, alias="timeoutPolicy")
    timeout_seconds: StrictInt = Field(alias="timeoutSeconds")
    total_timeout_seconds: StrictInt = Field(alias="totalTimeoutSeconds")
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    __properties: ClassVar[List[str]] = ["backoffScaleFactor", "baseType", "concurrentExecLimit", "createTime", "createdBy", "description", "enforceSchema", "executionNameSpace", "inputKeys", "inputSchema", "inputTemplate", "isolationGroupId", "name", "outputKeys", "outputSchema", "overwriteTags", "ownerApp", "ownerEmail", "pollTimeoutSeconds", "rateLimitFrequencyInSeconds", "rateLimitPerFrequency", "responseTimeoutSeconds", "retryCount", "retryDelaySeconds", "retryLogic", "tags", "timeoutPolicy", "timeoutSeconds", "totalTimeoutSeconds", "updateTime", "updatedBy"]

    @field_validator('retry_logic')
    def retry_logic_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FIXED', 'EXPONENTIAL_BACKOFF', 'LINEAR_BACKOFF']):
            raise ValueError("must be one of enum values ('FIXED', 'EXPONENTIAL_BACKOFF', 'LINEAR_BACKOFF')")
        return value

    @field_validator('timeout_policy')
    def timeout_policy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RETRY', 'TIME_OUT_WF', 'ALERT_ONLY']):
            raise ValueError("must be one of enum values ('RETRY', 'TIME_OUT_WF', 'ALERT_ONLY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExtendedTaskDef from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of input_schema
        if self.input_schema:
            _dict['inputSchema'] = self.input_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of output_schema
        if self.output_schema:
            _dict['outputSchema'] = self.output_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExtendedTaskDef from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "backoffScaleFactor": obj.get("backoffScaleFactor"),
            "baseType": obj.get("baseType"),
            "concurrentExecLimit": obj.get("concurrentExecLimit"),
            "createTime": obj.get("createTime"),
            "createdBy": obj.get("createdBy"),
            "description": obj.get("description"),
            "enforceSchema": obj.get("enforceSchema"),
            "executionNameSpace": obj.get("executionNameSpace"),
            "inputKeys": obj.get("inputKeys"),
            "inputSchema": SchemaDef.from_dict(obj["inputSchema"]) if obj.get("inputSchema") is not None else None,
            "inputTemplate": obj.get("inputTemplate"),
            "isolationGroupId": obj.get("isolationGroupId"),
            "name": obj.get("name"),
            "outputKeys": obj.get("outputKeys"),
            "outputSchema": SchemaDef.from_dict(obj["outputSchema"]) if obj.get("outputSchema") is not None else None,
            "overwriteTags": obj.get("overwriteTags"),
            "ownerApp": obj.get("ownerApp"),
            "ownerEmail": obj.get("ownerEmail"),
            "pollTimeoutSeconds": obj.get("pollTimeoutSeconds"),
            "rateLimitFrequencyInSeconds": obj.get("rateLimitFrequencyInSeconds"),
            "rateLimitPerFrequency": obj.get("rateLimitPerFrequency"),
            "responseTimeoutSeconds": obj.get("responseTimeoutSeconds"),
            "retryCount": obj.get("retryCount"),
            "retryDelaySeconds": obj.get("retryDelaySeconds"),
            "retryLogic": obj.get("retryLogic"),
            "tags": [Tag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "timeoutPolicy": obj.get("timeoutPolicy"),
            "timeoutSeconds": obj.get("timeoutSeconds"),
            "totalTimeoutSeconds": obj.get("totalTimeoutSeconds"),
            "updateTime": obj.get("updateTime"),
            "updatedBy": obj.get("updatedBy")
        })
        return _obj


