# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SubWorkflowParams(BaseModel):
    """
    SubWorkflowParams
    """ # noqa: E501
    idempotency_key: Optional[StrictStr] = Field(default=None, alias="idempotencyKey")
    idempotency_strategy: Optional[StrictStr] = Field(default=None, alias="idempotencyStrategy")
    name: Optional[StrictStr] = None
    priority: Optional[Dict[str, Any]] = None
    task_to_domain: Optional[Dict[str, StrictStr]] = Field(default=None, alias="taskToDomain")
    version: Optional[StrictInt] = None
    workflow_definition: Optional[Dict[str, Any]] = Field(default=None, alias="workflowDefinition")
    __properties: ClassVar[List[str]] = ["idempotencyKey", "idempotencyStrategy", "name", "priority", "taskToDomain", "version", "workflowDefinition"]

    @field_validator('idempotency_strategy')
    def idempotency_strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FAIL', 'RETURN_EXISTING', 'FAIL_ON_RUNNING']):
            raise ValueError("must be one of enum values ('FAIL', 'RETURN_EXISTING', 'FAIL_ON_RUNNING')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubWorkflowParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubWorkflowParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "idempotencyKey": obj.get("idempotencyKey"),
            "idempotencyStrategy": obj.get("idempotencyStrategy"),
            "name": obj.get("name"),
            "priority": obj.get("priority"),
            "taskToDomain": obj.get("taskToDomain"),
            "version": obj.get("version"),
            "workflowDefinition": obj.get("workflowDefinition")
        })
        return _obj


