# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.task_def import TaskDef
from conductor.asyncio_client.http.models.workflow_task import WorkflowTask
from typing import Optional, Set
from typing_extensions import Self

class Task(BaseModel):
    """
    Task
    """ # noqa: E501
    callback_after_seconds: Optional[StrictInt] = Field(default=None, alias="callbackAfterSeconds")
    callback_from_worker: Optional[StrictBool] = Field(default=None, alias="callbackFromWorker")
    correlation_id: Optional[StrictStr] = Field(default=None, alias="correlationId")
    domain: Optional[StrictStr] = None
    end_time: Optional[StrictInt] = Field(default=None, alias="endTime")
    executed: Optional[StrictBool] = None
    execution_name_space: Optional[StrictStr] = Field(default=None, alias="executionNameSpace")
    external_input_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalInputPayloadStoragePath")
    external_output_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalOutputPayloadStoragePath")
    first_start_time: Optional[StrictInt] = Field(default=None, alias="firstStartTime")
    input_data: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="inputData")
    isolation_group_id: Optional[StrictStr] = Field(default=None, alias="isolationGroupId")
    iteration: Optional[StrictInt] = None
    loop_over_task: Optional[StrictBool] = Field(default=None, alias="loopOverTask")
    output_data: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="outputData")
    parent_task_id: Optional[StrictStr] = Field(default=None, alias="parentTaskId")
    poll_count: Optional[StrictInt] = Field(default=None, alias="pollCount")
    queue_wait_time: Optional[StrictInt] = Field(default=None, alias="queueWaitTime")
    rate_limit_frequency_in_seconds: Optional[StrictInt] = Field(default=None, alias="rateLimitFrequencyInSeconds")
    rate_limit_per_frequency: Optional[StrictInt] = Field(default=None, alias="rateLimitPerFrequency")
    reason_for_incompletion: Optional[StrictStr] = Field(default=None, alias="reasonForIncompletion")
    reference_task_name: Optional[StrictStr] = Field(default=None, alias="referenceTaskName")
    response_timeout_seconds: Optional[StrictInt] = Field(default=None, alias="responseTimeoutSeconds")
    retried: Optional[StrictBool] = None
    retried_task_id: Optional[StrictStr] = Field(default=None, alias="retriedTaskId")
    retry_count: Optional[StrictInt] = Field(default=None, alias="retryCount")
    scheduled_time: Optional[StrictInt] = Field(default=None, alias="scheduledTime")
    seq: Optional[StrictInt] = None
    start_delay_in_seconds: Optional[StrictInt] = Field(default=None, alias="startDelayInSeconds")
    start_time: Optional[StrictInt] = Field(default=None, alias="startTime")
    status: Optional[StrictStr] = None
    sub_workflow_id: Optional[StrictStr] = Field(default=None, alias="subWorkflowId")
    subworkflow_changed: Optional[StrictBool] = Field(default=None, alias="subworkflowChanged")
    task_def_name: Optional[StrictStr] = Field(default=None, alias="taskDefName")
    task_definition: Optional[TaskDef] = Field(default=None, alias="taskDefinition")
    task_id: Optional[StrictStr] = Field(default=None, alias="taskId")
    task_type: Optional[StrictStr] = Field(default=None, alias="taskType")
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    worker_id: Optional[StrictStr] = Field(default=None, alias="workerId")
    workflow_instance_id: Optional[StrictStr] = Field(default=None, alias="workflowInstanceId")
    workflow_priority: Optional[StrictInt] = Field(default=None, alias="workflowPriority")
    workflow_task: Optional[WorkflowTask] = Field(default=None, alias="workflowTask")
    workflow_type: Optional[StrictStr] = Field(default=None, alias="workflowType")
    __properties: ClassVar[List[str]] = ["callbackAfterSeconds", "callbackFromWorker", "correlationId", "domain", "endTime", "executed", "executionNameSpace", "externalInputPayloadStoragePath", "externalOutputPayloadStoragePath", "firstStartTime", "inputData", "isolationGroupId", "iteration", "loopOverTask", "outputData", "parentTaskId", "pollCount", "queueWaitTime", "rateLimitFrequencyInSeconds", "rateLimitPerFrequency", "reasonForIncompletion", "referenceTaskName", "responseTimeoutSeconds", "retried", "retriedTaskId", "retryCount", "scheduledTime", "seq", "startDelayInSeconds", "startTime", "status", "subWorkflowId", "subworkflowChanged", "taskDefName", "taskDefinition", "taskId", "taskType", "updateTime", "workerId", "workflowInstanceId", "workflowPriority", "workflowTask", "workflowType"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['IN_PROGRESS', 'CANCELED', 'FAILED', 'FAILED_WITH_TERMINAL_ERROR', 'COMPLETED', 'COMPLETED_WITH_ERRORS', 'SCHEDULED', 'TIMED_OUT', 'SKIPPED']):
            raise ValueError("must be one of enum values ('IN_PROGRESS', 'CANCELED', 'FAILED', 'FAILED_WITH_TERMINAL_ERROR', 'COMPLETED', 'COMPLETED_WITH_ERRORS', 'SCHEDULED', 'TIMED_OUT', 'SKIPPED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Task from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of task_definition
        if self.task_definition:
            _dict['taskDefinition'] = self.task_definition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow_task
        if self.workflow_task:
            _dict['workflowTask'] = self.workflow_task.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Task from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "callbackAfterSeconds": obj.get("callbackAfterSeconds"),
            "callbackFromWorker": obj.get("callbackFromWorker"),
            "correlationId": obj.get("correlationId"),
            "domain": obj.get("domain"),
            "endTime": obj.get("endTime"),
            "executed": obj.get("executed"),
            "executionNameSpace": obj.get("executionNameSpace"),
            "externalInputPayloadStoragePath": obj.get("externalInputPayloadStoragePath"),
            "externalOutputPayloadStoragePath": obj.get("externalOutputPayloadStoragePath"),
            "firstStartTime": obj.get("firstStartTime"),
            "inputData": obj.get("inputData"),
            "isolationGroupId": obj.get("isolationGroupId"),
            "iteration": obj.get("iteration"),
            "loopOverTask": obj.get("loopOverTask"),
            "outputData": obj.get("outputData"),
            "parentTaskId": obj.get("parentTaskId"),
            "pollCount": obj.get("pollCount"),
            "queueWaitTime": obj.get("queueWaitTime"),
            "rateLimitFrequencyInSeconds": obj.get("rateLimitFrequencyInSeconds"),
            "rateLimitPerFrequency": obj.get("rateLimitPerFrequency"),
            "reasonForIncompletion": obj.get("reasonForIncompletion"),
            "referenceTaskName": obj.get("referenceTaskName"),
            "responseTimeoutSeconds": obj.get("responseTimeoutSeconds"),
            "retried": obj.get("retried"),
            "retriedTaskId": obj.get("retriedTaskId"),
            "retryCount": obj.get("retryCount"),
            "scheduledTime": obj.get("scheduledTime"),
            "seq": obj.get("seq"),
            "startDelayInSeconds": obj.get("startDelayInSeconds"),
            "startTime": obj.get("startTime"),
            "status": obj.get("status"),
            "subWorkflowId": obj.get("subWorkflowId"),
            "subworkflowChanged": obj.get("subworkflowChanged"),
            "taskDefName": obj.get("taskDefName"),
            "taskDefinition": TaskDef.from_dict(obj["taskDefinition"]) if obj.get("taskDefinition") is not None else None,
            "taskId": obj.get("taskId"),
            "taskType": obj.get("taskType"),
            "updateTime": obj.get("updateTime"),
            "workerId": obj.get("workerId"),
            "workflowInstanceId": obj.get("workflowInstanceId"),
            "workflowPriority": obj.get("workflowPriority"),
            "workflowTask": WorkflowTask.from_dict(obj["workflowTask"]) if obj.get("workflowTask") is not None else None,
            "workflowType": obj.get("workflowType")
        })
        return _obj


