# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from conductor.asyncio_client.http.models.task import Task
from conductor.asyncio_client.http.models.workflow_def import WorkflowDef
from typing import Optional, Set
from typing_extensions import Self

class Workflow(BaseModel):
    """
    Workflow
    """ # noqa: E501
    correlation_id: Optional[StrictStr] = Field(default=None, alias="correlationId")
    create_time: Optional[StrictInt] = Field(default=None, alias="createTime")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    end_time: Optional[StrictInt] = Field(default=None, alias="endTime")
    event: Optional[StrictStr] = None
    external_input_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalInputPayloadStoragePath")
    external_output_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalOutputPayloadStoragePath")
    failed_reference_task_names: Optional[List[StrictStr]] = Field(default=None, alias="failedReferenceTaskNames")
    failed_task_names: Optional[List[StrictStr]] = Field(default=None, alias="failedTaskNames")
    history: Optional[List[Workflow]] = None
    idempotency_key: Optional[StrictStr] = Field(default=None, alias="idempotencyKey")
    input: Optional[Dict[str, Dict[str, Any]]] = None
    last_retried_time: Optional[StrictInt] = Field(default=None, alias="lastRetriedTime")
    output: Optional[Dict[str, Dict[str, Any]]] = None
    owner_app: Optional[StrictStr] = Field(default=None, alias="ownerApp")
    parent_workflow_id: Optional[StrictStr] = Field(default=None, alias="parentWorkflowId")
    parent_workflow_task_id: Optional[StrictStr] = Field(default=None, alias="parentWorkflowTaskId")
    priority: Optional[Annotated[int, Field(le=99, strict=True, ge=0)]] = None
    rate_limit_key: Optional[StrictStr] = Field(default=None, alias="rateLimitKey")
    rate_limited: Optional[StrictBool] = Field(default=None, alias="rateLimited")
    re_run_from_workflow_id: Optional[StrictStr] = Field(default=None, alias="reRunFromWorkflowId")
    reason_for_incompletion: Optional[StrictStr] = Field(default=None, alias="reasonForIncompletion")
    start_time: Optional[StrictInt] = Field(default=None, alias="startTime")
    status: Optional[StrictStr] = None
    task_to_domain: Optional[Dict[str, StrictStr]] = Field(default=None, alias="taskToDomain")
    tasks: Optional[List[Task]] = None
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    variables: Optional[Dict[str, Dict[str, Any]]] = None
    workflow_definition: Optional[WorkflowDef] = Field(default=None, alias="workflowDefinition")
    workflow_id: Optional[StrictStr] = Field(default=None, alias="workflowId")
    workflow_name: Optional[StrictStr] = Field(default=None, alias="workflowName")
    workflow_version: Optional[StrictInt] = Field(default=None, alias="workflowVersion")
    __properties: ClassVar[List[str]] = ["correlationId", "createTime", "createdBy", "endTime", "event", "externalInputPayloadStoragePath", "externalOutputPayloadStoragePath", "failedReferenceTaskNames", "failedTaskNames", "history", "idempotencyKey", "input", "lastRetriedTime", "output", "ownerApp", "parentWorkflowId", "parentWorkflowTaskId", "priority", "rateLimitKey", "rateLimited", "reRunFromWorkflowId", "reasonForIncompletion", "startTime", "status", "taskToDomain", "tasks", "updateTime", "updatedBy", "variables", "workflowDefinition", "workflowId", "workflowName", "workflowVersion"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RUNNING', 'COMPLETED', 'FAILED', 'TIMED_OUT', 'TERMINATED', 'PAUSED']):
            raise ValueError("must be one of enum values ('RUNNING', 'COMPLETED', 'FAILED', 'TIMED_OUT', 'TERMINATED', 'PAUSED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Workflow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item_history in self.history:
                if _item_history:
                    _items.append(_item_history.to_dict())
            _dict['history'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tasks (list)
        _items = []
        if self.tasks:
            for _item_tasks in self.tasks:
                if _item_tasks:
                    _items.append(_item_tasks.to_dict())
            _dict['tasks'] = _items
        # override the default output from pydantic by calling `to_dict()` of workflow_definition
        if self.workflow_definition:
            _dict['workflowDefinition'] = self.workflow_definition.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Workflow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "correlationId": obj.get("correlationId"),
            "createTime": obj.get("createTime"),
            "createdBy": obj.get("createdBy"),
            "endTime": obj.get("endTime"),
            "event": obj.get("event"),
            "externalInputPayloadStoragePath": obj.get("externalInputPayloadStoragePath"),
            "externalOutputPayloadStoragePath": obj.get("externalOutputPayloadStoragePath"),
            "failedReferenceTaskNames": obj.get("failedReferenceTaskNames"),
            "failedTaskNames": obj.get("failedTaskNames"),
            "history": [Workflow.from_dict(_item) for _item in obj["history"]] if obj.get("history") is not None else None,
            "idempotencyKey": obj.get("idempotencyKey"),
            "input": obj.get("input"),
            "lastRetriedTime": obj.get("lastRetriedTime"),
            "output": obj.get("output"),
            "ownerApp": obj.get("ownerApp"),
            "parentWorkflowId": obj.get("parentWorkflowId"),
            "parentWorkflowTaskId": obj.get("parentWorkflowTaskId"),
            "priority": obj.get("priority"),
            "rateLimitKey": obj.get("rateLimitKey"),
            "rateLimited": obj.get("rateLimited"),
            "reRunFromWorkflowId": obj.get("reRunFromWorkflowId"),
            "reasonForIncompletion": obj.get("reasonForIncompletion"),
            "startTime": obj.get("startTime"),
            "status": obj.get("status"),
            "taskToDomain": obj.get("taskToDomain"),
            "tasks": [Task.from_dict(_item) for _item in obj["tasks"]] if obj.get("tasks") is not None else None,
            "updateTime": obj.get("updateTime"),
            "updatedBy": obj.get("updatedBy"),
            "variables": obj.get("variables"),
            "workflowDefinition": WorkflowDef.from_dict(obj["workflowDefinition"]) if obj.get("workflowDefinition") is not None else None,
            "workflowId": obj.get("workflowId"),
            "workflowName": obj.get("workflowName"),
            "workflowVersion": obj.get("workflowVersion")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
Workflow.model_rebuild(raise_errors=False)

