# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.task import Task
from typing import Optional, Set
from typing_extensions import Self

class WorkflowRun(BaseModel):
    """
    WorkflowRun
    """ # noqa: E501
    correlation_id: Optional[StrictStr] = Field(default=None, alias="correlationId")
    create_time: Optional[StrictInt] = Field(default=None, alias="createTime")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    input: Optional[Dict[str, Dict[str, Any]]] = None
    output: Optional[Dict[str, Dict[str, Any]]] = None
    priority: Optional[StrictInt] = None
    request_id: Optional[StrictStr] = Field(default=None, alias="requestId")
    status: Optional[StrictStr] = None
    tasks: Optional[List[Task]] = None
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    variables: Optional[Dict[str, Dict[str, Any]]] = None
    workflow_id: Optional[StrictStr] = Field(default=None, alias="workflowId")
    __properties: ClassVar[List[str]] = ["correlationId", "createTime", "createdBy", "input", "output", "priority", "requestId", "status", "tasks", "updateTime", "variables", "workflowId"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RUNNING', 'COMPLETED', 'FAILED', 'TIMED_OUT', 'TERMINATED', 'PAUSED']):
            raise ValueError("must be one of enum values ('RUNNING', 'COMPLETED', 'FAILED', 'TIMED_OUT', 'TERMINATED', 'PAUSED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tasks (list)
        _items = []
        if self.tasks:
            for _item_tasks in self.tasks:
                if _item_tasks:
                    _items.append(_item_tasks.to_dict())
            _dict['tasks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "correlationId": obj.get("correlationId"),
            "createTime": obj.get("createTime"),
            "createdBy": obj.get("createdBy"),
            "input": obj.get("input"),
            "output": obj.get("output"),
            "priority": obj.get("priority"),
            "requestId": obj.get("requestId"),
            "status": obj.get("status"),
            "tasks": [Task.from_dict(_item) for _item in obj["tasks"]] if obj.get("tasks") is not None else None,
            "updateTime": obj.get("updateTime"),
            "variables": obj.get("variables"),
            "workflowId": obj.get("workflowId")
        })
        return _obj


