# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.start_workflow_request import StartWorkflowRequest
from conductor.asyncio_client.http.models.tag import Tag
from typing import Optional, Set
from typing_extensions import Self

class WorkflowScheduleModel(BaseModel):
    """
    WorkflowScheduleModel
    """ # noqa: E501
    create_time: Optional[StrictInt] = Field(default=None, alias="createTime")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    cron_expression: Optional[StrictStr] = Field(default=None, alias="cronExpression")
    description: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    org_id: Optional[StrictStr] = Field(default=None, alias="orgId")
    paused: Optional[StrictBool] = None
    paused_reason: Optional[StrictStr] = Field(default=None, alias="pausedReason")
    queue_msg_id: Optional[StrictStr] = Field(default=None, alias="queueMsgId")
    run_catchup_schedule_instances: Optional[StrictBool] = Field(default=None, alias="runCatchupScheduleInstances")
    schedule_end_time: Optional[StrictInt] = Field(default=None, alias="scheduleEndTime")
    schedule_start_time: Optional[StrictInt] = Field(default=None, alias="scheduleStartTime")
    start_workflow_request: Optional[StartWorkflowRequest] = Field(default=None, alias="startWorkflowRequest")
    tags: Optional[List[Tag]] = None
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    updated_time: Optional[StrictInt] = Field(default=None, alias="updatedTime")
    zone_id: Optional[StrictStr] = Field(default=None, alias="zoneId")
    __properties: ClassVar[List[str]] = ["createTime", "createdBy", "cronExpression", "description", "name", "orgId", "paused", "pausedReason", "queueMsgId", "runCatchupScheduleInstances", "scheduleEndTime", "scheduleStartTime", "startWorkflowRequest", "tags", "updatedBy", "updatedTime", "zoneId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowScheduleModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of start_workflow_request
        if self.start_workflow_request:
            _dict['startWorkflowRequest'] = self.start_workflow_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowScheduleModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createTime": obj.get("createTime"),
            "createdBy": obj.get("createdBy"),
            "cronExpression": obj.get("cronExpression"),
            "description": obj.get("description"),
            "name": obj.get("name"),
            "orgId": obj.get("orgId"),
            "paused": obj.get("paused"),
            "pausedReason": obj.get("pausedReason"),
            "queueMsgId": obj.get("queueMsgId"),
            "runCatchupScheduleInstances": obj.get("runCatchupScheduleInstances"),
            "scheduleEndTime": obj.get("scheduleEndTime"),
            "scheduleStartTime": obj.get("scheduleStartTime"),
            "startWorkflowRequest": StartWorkflowRequest.from_dict(obj["startWorkflowRequest"]) if obj.get("startWorkflowRequest") is not None else None,
            "tags": [Tag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "updatedBy": obj.get("updatedBy"),
            "updatedTime": obj.get("updatedTime"),
            "zoneId": obj.get("zoneId")
        })
        return _obj


