from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from conductor.client.codegen.api_client import ApiClient


class MetricsResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def prometheus_task_metrics(self, task_name, start, end, step, **kwargs):  # noqa: E501
        """Returns prometheus task metrics  # noqa: E501

        Proxy call of task metrics to prometheus  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.prometheus_task_metrics(task_name, start, end, step, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_name: (required)
        :param str start: (required)
        :param str end: (required)
        :param str step: (required)
        :return: dict(str, JsonNode)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.prometheus_task_metrics_with_http_info(task_name, start, end, step, **kwargs)  # noqa: E501
        else:
            (data) = self.prometheus_task_metrics_with_http_info(task_name, start, end, step, **kwargs)  # noqa: E501
            return data

    def prometheus_task_metrics_with_http_info(self, task_name, start, end, step, **kwargs):  # noqa: E501
        """Returns prometheus task metrics  # noqa: E501

        Proxy call of task metrics to prometheus  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.prometheus_task_metrics_with_http_info(task_name, start, end, step, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_name: (required)
        :param str start: (required)
        :param str end: (required)
        :param str step: (required)
        :return: dict(str, JsonNode)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_name', 'start', 'end', 'step']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method prometheus_task_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_name' is set
        if ('task_name' not in params or
                params['task_name'] is None):
            raise ValueError("Missing the required parameter `task_name` when calling `prometheus_task_metrics`")  # noqa: E501
        # verify the required parameter 'start' is set
        if ('start' not in params or
                params['start'] is None):
            raise ValueError("Missing the required parameter `start` when calling `prometheus_task_metrics`")  # noqa: E501
        # verify the required parameter 'end' is set
        if ('end' not in params or
                params['end'] is None):
            raise ValueError("Missing the required parameter `end` when calling `prometheus_task_metrics`")  # noqa: E501
        # verify the required parameter 'step' is set
        if ('step' not in params or
                params['step'] is None):
            raise ValueError("Missing the required parameter `step` when calling `prometheus_task_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_name' in params:
            path_params['taskName'] = params['task_name']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'step' in params:
            query_params.append(('step', params['step']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/metrics/task/{taskName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, JsonNode)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
