# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FieldDescriptor(BaseModel):
    """
    FieldDescriptor
    """ # noqa: E501
    containing_oneof: Optional[OneofDescriptor] = Field(default=None, alias="containingOneof")
    containing_type: Optional[Descriptor] = Field(default=None, alias="containingType")
    default_value: Optional[Dict[str, Any]] = Field(default=None, alias="defaultValue")
    enum_type: Optional[EnumDescriptor] = Field(default=None, alias="enumType")
    extension: Optional[StrictBool] = None
    extension_scope: Optional[Descriptor] = Field(default=None, alias="extensionScope")
    file: Optional[FileDescriptor] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    index: Optional[StrictInt] = None
    java_type: Optional[StrictStr] = Field(default=None, alias="javaType")
    json_name: Optional[StrictStr] = Field(default=None, alias="jsonName")
    lite_java_type: Optional[StrictStr] = Field(default=None, alias="liteJavaType")
    lite_type: Optional[StrictStr] = Field(default=None, alias="liteType")
    map_field: Optional[StrictBool] = Field(default=None, alias="mapField")
    message_type: Optional[Descriptor] = Field(default=None, alias="messageType")
    name: Optional[StrictStr] = None
    number: Optional[StrictInt] = None
    optional: Optional[StrictBool] = None
    options: Optional[FieldOptions] = None
    packable: Optional[StrictBool] = None
    packed: Optional[StrictBool] = None
    proto: Optional[FieldDescriptorProto] = None
    real_containing_oneof: Optional[OneofDescriptor] = Field(default=None, alias="realContainingOneof")
    repeated: Optional[StrictBool] = None
    required: Optional[StrictBool] = None
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["containingOneof", "containingType", "defaultValue", "enumType", "extension", "extensionScope", "file", "fullName", "index", "javaType", "jsonName", "liteJavaType", "liteType", "mapField", "messageType", "name", "number", "optional", "options", "packable", "packed", "proto", "realContainingOneof", "repeated", "required", "type"]

    @field_validator('java_type')
    def java_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['INT', 'LONG', 'FLOAT', 'DOUBLE', 'BOOLEAN', 'STRING', 'BYTE_STRING', 'ENUM', 'MESSAGE']):
            raise ValueError("must be one of enum values ('INT', 'LONG', 'FLOAT', 'DOUBLE', 'BOOLEAN', 'STRING', 'BYTE_STRING', 'ENUM', 'MESSAGE')")
        return value

    @field_validator('lite_java_type')
    def lite_java_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['INT', 'LONG', 'FLOAT', 'DOUBLE', 'BOOLEAN', 'STRING', 'BYTE_STRING', 'ENUM', 'MESSAGE']):
            raise ValueError("must be one of enum values ('INT', 'LONG', 'FLOAT', 'DOUBLE', 'BOOLEAN', 'STRING', 'BYTE_STRING', 'ENUM', 'MESSAGE')")
        return value

    @field_validator('lite_type')
    def lite_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DOUBLE', 'FLOAT', 'INT64', 'UINT64', 'INT32', 'FIXED64', 'FIXED32', 'BOOL', 'STRING', 'GROUP', 'MESSAGE', 'BYTES', 'UINT32', 'ENUM', 'SFIXED32', 'SFIXED64', 'SINT32', 'SINT64']):
            raise ValueError("must be one of enum values ('DOUBLE', 'FLOAT', 'INT64', 'UINT64', 'INT32', 'FIXED64', 'FIXED32', 'BOOL', 'STRING', 'GROUP', 'MESSAGE', 'BYTES', 'UINT32', 'ENUM', 'SFIXED32', 'SFIXED64', 'SINT32', 'SINT64')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DOUBLE', 'FLOAT', 'INT64', 'UINT64', 'INT32', 'FIXED64', 'FIXED32', 'BOOL', 'STRING', 'GROUP', 'MESSAGE', 'BYTES', 'UINT32', 'ENUM', 'SFIXED32', 'SFIXED64', 'SINT32', 'SINT64']):
            raise ValueError("must be one of enum values ('DOUBLE', 'FLOAT', 'INT64', 'UINT64', 'INT32', 'FIXED64', 'FIXED32', 'BOOL', 'STRING', 'GROUP', 'MESSAGE', 'BYTES', 'UINT32', 'ENUM', 'SFIXED32', 'SFIXED64', 'SINT32', 'SINT64')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldDescriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of containing_oneof
        if self.containing_oneof:
            _dict['containingOneof'] = self.containing_oneof.to_dict()
        # override the default output from pydantic by calling `to_dict()` of containing_type
        if self.containing_type:
            _dict['containingType'] = self.containing_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enum_type
        if self.enum_type:
            _dict['enumType'] = self.enum_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extension_scope
        if self.extension_scope:
            _dict['extensionScope'] = self.extension_scope.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of message_type
        if self.message_type:
            _dict['messageType'] = self.message_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of proto
        if self.proto:
            _dict['proto'] = self.proto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of real_containing_oneof
        if self.real_containing_oneof:
            _dict['realContainingOneof'] = self.real_containing_oneof.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldDescriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "containingOneof": OneofDescriptor.from_dict(obj["containingOneof"]) if obj.get("containingOneof") is not None else None,
            "containingType": Descriptor.from_dict(obj["containingType"]) if obj.get("containingType") is not None else None,
            "defaultValue": obj.get("defaultValue"),
            "enumType": EnumDescriptor.from_dict(obj["enumType"]) if obj.get("enumType") is not None else None,
            "extension": obj.get("extension"),
            "extensionScope": Descriptor.from_dict(obj["extensionScope"]) if obj.get("extensionScope") is not None else None,
            "file": FileDescriptor.from_dict(obj["file"]) if obj.get("file") is not None else None,
            "fullName": obj.get("fullName"),
            "index": obj.get("index"),
            "javaType": obj.get("javaType"),
            "jsonName": obj.get("jsonName"),
            "liteJavaType": obj.get("liteJavaType"),
            "liteType": obj.get("liteType"),
            "mapField": obj.get("mapField"),
            "messageType": Descriptor.from_dict(obj["messageType"]) if obj.get("messageType") is not None else None,
            "name": obj.get("name"),
            "number": obj.get("number"),
            "optional": obj.get("optional"),
            "options": FieldOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "packable": obj.get("packable"),
            "packed": obj.get("packed"),
            "proto": FieldDescriptorProto.from_dict(obj["proto"]) if obj.get("proto") is not None else None,
            "realContainingOneof": OneofDescriptor.from_dict(obj["realContainingOneof"]) if obj.get("realContainingOneof") is not None else None,
            "repeated": obj.get("repeated"),
            "required": obj.get("required"),
            "type": obj.get("type")
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.enum_descriptor import EnumDescriptor
from conductor.asyncio_client.http.models.field_descriptor_proto import FieldDescriptorProto
from conductor.asyncio_client.http.models.field_options import FieldOptions
from conductor.asyncio_client.http.models.file_descriptor import FileDescriptor
from conductor.asyncio_client.http.models.oneof_descriptor import OneofDescriptor
# TODO: Rewrite to not use raise_errors
FieldDescriptor.model_rebuild(raise_errors=False)

