# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.byte_string import ByteString
from conductor.asyncio_client.http.models.unknown_field_set import UnknownFieldSet
from typing import Optional, Set
from typing_extensions import Self

class FileOptions(BaseModel):
    """
    FileOptions
    """ # noqa: E501
    all_fields: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="allFields")
    all_fields_raw: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="allFieldsRaw")
    cc_enable_arenas: Optional[StrictBool] = Field(default=None, alias="ccEnableArenas")
    cc_generic_services: Optional[StrictBool] = Field(default=None, alias="ccGenericServices")
    csharp_namespace: Optional[StrictStr] = Field(default=None, alias="csharpNamespace")
    csharp_namespace_bytes: Optional[ByteString] = Field(default=None, alias="csharpNamespaceBytes")
    default_instance_for_type: Optional[FileOptions] = Field(default=None, alias="defaultInstanceForType")
    deprecated: Optional[StrictBool] = None
    descriptor_for_type: Optional[Descriptor] = Field(default=None, alias="descriptorForType")
    features: Optional[FeatureSet] = None
    features_or_builder: Optional[FeatureSetOrBuilder] = Field(default=None, alias="featuresOrBuilder")
    go_package: Optional[StrictStr] = Field(default=None, alias="goPackage")
    go_package_bytes: Optional[ByteString] = Field(default=None, alias="goPackageBytes")
    initialization_error_string: Optional[StrictStr] = Field(default=None, alias="initializationErrorString")
    initialized: Optional[StrictBool] = None
    java_generate_equals_and_hash: Optional[StrictBool] = Field(default=None, alias="javaGenerateEqualsAndHash")
    java_generic_services: Optional[StrictBool] = Field(default=None, alias="javaGenericServices")
    java_multiple_files: Optional[StrictBool] = Field(default=None, alias="javaMultipleFiles")
    java_outer_classname: Optional[StrictStr] = Field(default=None, alias="javaOuterClassname")
    java_outer_classname_bytes: Optional[ByteString] = Field(default=None, alias="javaOuterClassnameBytes")
    java_package: Optional[StrictStr] = Field(default=None, alias="javaPackage")
    java_package_bytes: Optional[ByteString] = Field(default=None, alias="javaPackageBytes")
    java_string_check_utf8: Optional[StrictBool] = Field(default=None, alias="javaStringCheckUtf8")
    memoized_serialized_size: Optional[StrictInt] = Field(default=None, alias="memoizedSerializedSize")
    objc_class_prefix: Optional[StrictStr] = Field(default=None, alias="objcClassPrefix")
    objc_class_prefix_bytes: Optional[ByteString] = Field(default=None, alias="objcClassPrefixBytes")
    optimize_for: Optional[StrictStr] = Field(default=None, alias="optimizeFor")
    parser_for_type: Optional[Dict[str, Any]] = Field(default=None, alias="parserForType")
    php_class_prefix: Optional[StrictStr] = Field(default=None, alias="phpClassPrefix")
    php_class_prefix_bytes: Optional[ByteString] = Field(default=None, alias="phpClassPrefixBytes")
    php_generic_services: Optional[StrictBool] = Field(default=None, alias="phpGenericServices")
    php_metadata_namespace: Optional[StrictStr] = Field(default=None, alias="phpMetadataNamespace")
    php_metadata_namespace_bytes: Optional[ByteString] = Field(default=None, alias="phpMetadataNamespaceBytes")
    php_namespace: Optional[StrictStr] = Field(default=None, alias="phpNamespace")
    php_namespace_bytes: Optional[ByteString] = Field(default=None, alias="phpNamespaceBytes")
    py_generic_services: Optional[StrictBool] = Field(default=None, alias="pyGenericServices")
    ruby_package: Optional[StrictStr] = Field(default=None, alias="rubyPackage")
    ruby_package_bytes: Optional[ByteString] = Field(default=None, alias="rubyPackageBytes")
    serialized_size: Optional[StrictInt] = Field(default=None, alias="serializedSize")
    swift_prefix: Optional[StrictStr] = Field(default=None, alias="swiftPrefix")
    swift_prefix_bytes: Optional[ByteString] = Field(default=None, alias="swiftPrefixBytes")
    uninterpreted_option_count: Optional[StrictInt] = Field(default=None, alias="uninterpretedOptionCount")
    uninterpreted_option_list: Optional[List[UninterpretedOption]] = Field(default=None, alias="uninterpretedOptionList")
    uninterpreted_option_or_builder_list: Optional[List[UninterpretedOptionOrBuilder]] = Field(default=None, alias="uninterpretedOptionOrBuilderList")
    unknown_fields: Optional[UnknownFieldSet] = Field(default=None, alias="unknownFields")
    __properties: ClassVar[List[str]] = ["allFields", "allFieldsRaw", "ccEnableArenas", "ccGenericServices", "csharpNamespace", "csharpNamespaceBytes", "defaultInstanceForType", "deprecated", "descriptorForType", "features", "featuresOrBuilder", "goPackage", "goPackageBytes", "initializationErrorString", "initialized", "javaGenerateEqualsAndHash", "javaGenericServices", "javaMultipleFiles", "javaOuterClassname", "javaOuterClassnameBytes", "javaPackage", "javaPackageBytes", "javaStringCheckUtf8", "memoizedSerializedSize", "objcClassPrefix", "objcClassPrefixBytes", "optimizeFor", "parserForType", "phpClassPrefix", "phpClassPrefixBytes", "phpGenericServices", "phpMetadataNamespace", "phpMetadataNamespaceBytes", "phpNamespace", "phpNamespaceBytes", "pyGenericServices", "rubyPackage", "rubyPackageBytes", "serializedSize", "swiftPrefix", "swiftPrefixBytes", "uninterpretedOptionCount", "uninterpretedOptionList", "uninterpretedOptionOrBuilderList", "unknownFields"]

    @field_validator('optimize_for')
    def optimize_for_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SPEED', 'CODE_SIZE', 'LITE_RUNTIME']):
            raise ValueError("must be one of enum values ('SPEED', 'CODE_SIZE', 'LITE_RUNTIME')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of csharp_namespace_bytes
        if self.csharp_namespace_bytes:
            _dict['csharpNamespaceBytes'] = self.csharp_namespace_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_instance_for_type
        if self.default_instance_for_type:
            _dict['defaultInstanceForType'] = self.default_instance_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of descriptor_for_type
        if self.descriptor_for_type:
            _dict['descriptorForType'] = self.descriptor_for_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of features
        if self.features:
            _dict['features'] = self.features.to_dict()
        # override the default output from pydantic by calling `to_dict()` of features_or_builder
        if self.features_or_builder:
            _dict['featuresOrBuilder'] = self.features_or_builder.to_dict()
        # override the default output from pydantic by calling `to_dict()` of go_package_bytes
        if self.go_package_bytes:
            _dict['goPackageBytes'] = self.go_package_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of java_outer_classname_bytes
        if self.java_outer_classname_bytes:
            _dict['javaOuterClassnameBytes'] = self.java_outer_classname_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of java_package_bytes
        if self.java_package_bytes:
            _dict['javaPackageBytes'] = self.java_package_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of objc_class_prefix_bytes
        if self.objc_class_prefix_bytes:
            _dict['objcClassPrefixBytes'] = self.objc_class_prefix_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of php_class_prefix_bytes
        if self.php_class_prefix_bytes:
            _dict['phpClassPrefixBytes'] = self.php_class_prefix_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of php_metadata_namespace_bytes
        if self.php_metadata_namespace_bytes:
            _dict['phpMetadataNamespaceBytes'] = self.php_metadata_namespace_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of php_namespace_bytes
        if self.php_namespace_bytes:
            _dict['phpNamespaceBytes'] = self.php_namespace_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ruby_package_bytes
        if self.ruby_package_bytes:
            _dict['rubyPackageBytes'] = self.ruby_package_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of swift_prefix_bytes
        if self.swift_prefix_bytes:
            _dict['swiftPrefixBytes'] = self.swift_prefix_bytes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in uninterpreted_option_list (list)
        _items = []
        if self.uninterpreted_option_list:
            for _item_uninterpreted_option_list in self.uninterpreted_option_list:
                if _item_uninterpreted_option_list:
                    _items.append(_item_uninterpreted_option_list.to_dict())
            _dict['uninterpretedOptionList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in uninterpreted_option_or_builder_list (list)
        _items = []
        if self.uninterpreted_option_or_builder_list:
            for _item_uninterpreted_option_or_builder_list in self.uninterpreted_option_or_builder_list:
                if _item_uninterpreted_option_or_builder_list:
                    _items.append(_item_uninterpreted_option_or_builder_list.to_dict())
            _dict['uninterpretedOptionOrBuilderList'] = _items
        # override the default output from pydantic by calling `to_dict()` of unknown_fields
        if self.unknown_fields:
            _dict['unknownFields'] = self.unknown_fields.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allFields": obj.get("allFields"),
            "allFieldsRaw": obj.get("allFieldsRaw"),
            "ccEnableArenas": obj.get("ccEnableArenas"),
            "ccGenericServices": obj.get("ccGenericServices"),
            "csharpNamespace": obj.get("csharpNamespace"),
            "csharpNamespaceBytes": ByteString.from_dict(obj["csharpNamespaceBytes"]) if obj.get("csharpNamespaceBytes") is not None else None,
            "defaultInstanceForType": FileOptions.from_dict(obj["defaultInstanceForType"]) if obj.get("defaultInstanceForType") is not None else None,
            "deprecated": obj.get("deprecated"),
            "descriptorForType": Descriptor.from_dict(obj["descriptorForType"]) if obj.get("descriptorForType") is not None else None,
            "features": FeatureSet.from_dict(obj["features"]) if obj.get("features") is not None else None,
            "featuresOrBuilder": FeatureSetOrBuilder.from_dict(obj["featuresOrBuilder"]) if obj.get("featuresOrBuilder") is not None else None,
            "goPackage": obj.get("goPackage"),
            "goPackageBytes": ByteString.from_dict(obj["goPackageBytes"]) if obj.get("goPackageBytes") is not None else None,
            "initializationErrorString": obj.get("initializationErrorString"),
            "initialized": obj.get("initialized"),
            "javaGenerateEqualsAndHash": obj.get("javaGenerateEqualsAndHash"),
            "javaGenericServices": obj.get("javaGenericServices"),
            "javaMultipleFiles": obj.get("javaMultipleFiles"),
            "javaOuterClassname": obj.get("javaOuterClassname"),
            "javaOuterClassnameBytes": ByteString.from_dict(obj["javaOuterClassnameBytes"]) if obj.get("javaOuterClassnameBytes") is not None else None,
            "javaPackage": obj.get("javaPackage"),
            "javaPackageBytes": ByteString.from_dict(obj["javaPackageBytes"]) if obj.get("javaPackageBytes") is not None else None,
            "javaStringCheckUtf8": obj.get("javaStringCheckUtf8"),
            "memoizedSerializedSize": obj.get("memoizedSerializedSize"),
            "objcClassPrefix": obj.get("objcClassPrefix"),
            "objcClassPrefixBytes": ByteString.from_dict(obj["objcClassPrefixBytes"]) if obj.get("objcClassPrefixBytes") is not None else None,
            "optimizeFor": obj.get("optimizeFor"),
            "parserForType": obj.get("parserForType"),
            "phpClassPrefix": obj.get("phpClassPrefix"),
            "phpClassPrefixBytes": ByteString.from_dict(obj["phpClassPrefixBytes"]) if obj.get("phpClassPrefixBytes") is not None else None,
            "phpGenericServices": obj.get("phpGenericServices"),
            "phpMetadataNamespace": obj.get("phpMetadataNamespace"),
            "phpMetadataNamespaceBytes": ByteString.from_dict(obj["phpMetadataNamespaceBytes"]) if obj.get("phpMetadataNamespaceBytes") is not None else None,
            "phpNamespace": obj.get("phpNamespace"),
            "phpNamespaceBytes": ByteString.from_dict(obj["phpNamespaceBytes"]) if obj.get("phpNamespaceBytes") is not None else None,
            "pyGenericServices": obj.get("pyGenericServices"),
            "rubyPackage": obj.get("rubyPackage"),
            "rubyPackageBytes": ByteString.from_dict(obj["rubyPackageBytes"]) if obj.get("rubyPackageBytes") is not None else None,
            "serializedSize": obj.get("serializedSize"),
            "swiftPrefix": obj.get("swiftPrefix"),
            "swiftPrefixBytes": ByteString.from_dict(obj["swiftPrefixBytes"]) if obj.get("swiftPrefixBytes") is not None else None,
            "uninterpretedOptionCount": obj.get("uninterpretedOptionCount"),
            "uninterpretedOptionList": [UninterpretedOption.from_dict(_item) for _item in obj["uninterpretedOptionList"]] if obj.get("uninterpretedOptionList") is not None else None,
            "uninterpretedOptionOrBuilderList": [UninterpretedOptionOrBuilder.from_dict(_item) for _item in obj["uninterpretedOptionOrBuilderList"]] if obj.get("uninterpretedOptionOrBuilderList") is not None else None,
            "unknownFields": UnknownFieldSet.from_dict(obj["unknownFields"]) if obj.get("unknownFields") is not None else None
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.feature_set import FeatureSet
from conductor.asyncio_client.http.models.feature_set_or_builder import FeatureSetOrBuilder
from conductor.asyncio_client.http.models.uninterpreted_option import UninterpretedOption
from conductor.asyncio_client.http.models.uninterpreted_option_or_builder import UninterpretedOptionOrBuilder
# TODO: Rewrite to not use raise_errors
FileOptions.model_rebuild(raise_errors=False)

