# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MethodDescriptor(BaseModel):
    """
    MethodDescriptor
    """ # noqa: E501
    client_streaming: Optional[StrictBool] = Field(default=None, alias="clientStreaming")
    file: Optional[FileDescriptor] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    index: Optional[StrictInt] = None
    input_type: Optional[Descriptor] = Field(default=None, alias="inputType")
    name: Optional[StrictStr] = None
    options: Optional[MethodOptions] = None
    output_type: Optional[Descriptor] = Field(default=None, alias="outputType")
    proto: Optional[MethodDescriptorProto] = None
    server_streaming: Optional[StrictBool] = Field(default=None, alias="serverStreaming")
    service: Optional[ServiceDescriptor] = None
    __properties: ClassVar[List[str]] = ["clientStreaming", "file", "fullName", "index", "inputType", "name", "options", "outputType", "proto", "serverStreaming", "service"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MethodDescriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of input_type
        if self.input_type:
            _dict['inputType'] = self.input_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of output_type
        if self.output_type:
            _dict['outputType'] = self.output_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of proto
        if self.proto:
            _dict['proto'] = self.proto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of service
        if self.service:
            _dict['service'] = self.service.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MethodDescriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientStreaming": obj.get("clientStreaming"),
            "file": FileDescriptor.from_dict(obj["file"]) if obj.get("file") is not None else None,
            "fullName": obj.get("fullName"),
            "index": obj.get("index"),
            "inputType": Descriptor.from_dict(obj["inputType"]) if obj.get("inputType") is not None else None,
            "name": obj.get("name"),
            "options": MethodOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "outputType": Descriptor.from_dict(obj["outputType"]) if obj.get("outputType") is not None else None,
            "proto": MethodDescriptorProto.from_dict(obj["proto"]) if obj.get("proto") is not None else None,
            "serverStreaming": obj.get("serverStreaming"),
            "service": ServiceDescriptor.from_dict(obj["service"]) if obj.get("service") is not None else None
        })
        return _obj

from conductor.asyncio_client.http.models.descriptor import Descriptor
from conductor.asyncio_client.http.models.file_descriptor import FileDescriptor
from conductor.asyncio_client.http.models.method_descriptor_proto import MethodDescriptorProto
from conductor.asyncio_client.http.models.method_options import MethodOptions
from conductor.asyncio_client.http.models.service_descriptor import ServiceDescriptor
# TODO: Rewrite to not use raise_errors
MethodDescriptor.model_rebuild(raise_errors=False)

