# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.cache_config import CacheConfig
from conductor.asyncio_client.http.models.state_change_event import StateChangeEvent
from conductor.asyncio_client.http.models.sub_workflow_params import SubWorkflowParams
from conductor.asyncio_client.http.models.task_def import TaskDef
from typing import Optional, Set
from typing_extensions import Self

class WorkflowTask(BaseModel):
    """
    WorkflowTask
    """ # noqa: E501
    async_complete: Optional[StrictBool] = Field(default=None, alias="asyncComplete")
    cache_config: Optional[CacheConfig] = Field(default=None, alias="cacheConfig")
    case_expression: Optional[StrictStr] = Field(default=None, alias="caseExpression")
    case_value_param: Optional[StrictStr] = Field(default=None, alias="caseValueParam")
    decision_cases: Optional[Dict[str, List[WorkflowTask]]] = Field(default=None, alias="decisionCases")
    default_case: Optional[List[WorkflowTask]] = Field(default=None, alias="defaultCase")
    default_exclusive_join_task: Optional[List[StrictStr]] = Field(default=None, alias="defaultExclusiveJoinTask")
    description: Optional[StrictStr] = None
    dynamic_fork_join_tasks_param: Optional[StrictStr] = Field(default=None, alias="dynamicForkJoinTasksParam")
    dynamic_fork_tasks_input_param_name: Optional[StrictStr] = Field(default=None, alias="dynamicForkTasksInputParamName")
    dynamic_fork_tasks_param: Optional[StrictStr] = Field(default=None, alias="dynamicForkTasksParam")
    dynamic_task_name_param: Optional[StrictStr] = Field(default=None, alias="dynamicTaskNameParam")
    evaluator_type: Optional[StrictStr] = Field(default=None, alias="evaluatorType")
    expression: Optional[StrictStr] = None
    fork_tasks: Optional[List[List[WorkflowTask]]] = Field(default=None, alias="forkTasks")
    input_parameters: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="inputParameters")
    join_on: Optional[List[StrictStr]] = Field(default=None, alias="joinOn")
    join_status: Optional[StrictStr] = Field(default=None, alias="joinStatus")
    loop_condition: Optional[StrictStr] = Field(default=None, alias="loopCondition")
    loop_over: Optional[List[WorkflowTask]] = Field(default=None, alias="loopOver")
    name: StrictStr
    on_state_change: Optional[Dict[str, List[StateChangeEvent]]] = Field(default=None, alias="onStateChange")
    optional: Optional[StrictBool] = None
    permissive: Optional[StrictBool] = None
    rate_limited: Optional[StrictBool] = Field(default=None, alias="rateLimited")
    retry_count: Optional[StrictInt] = Field(default=None, alias="retryCount")
    script_expression: Optional[StrictStr] = Field(default=None, alias="scriptExpression")
    sink: Optional[StrictStr] = None
    start_delay: Optional[StrictInt] = Field(default=None, alias="startDelay")
    sub_workflow_param: Optional[SubWorkflowParams] = Field(default=None, alias="subWorkflowParam")
    task_definition: Optional[TaskDef] = Field(default=None, alias="taskDefinition")
    task_reference_name: StrictStr = Field(alias="taskReferenceName")
    type: Optional[StrictStr] = None
    workflow_task_type: Optional[StrictStr] = Field(default=None, alias="workflowTaskType")
    __properties: ClassVar[List[str]] = ["asyncComplete", "cacheConfig", "caseExpression", "caseValueParam", "decisionCases", "defaultCase", "defaultExclusiveJoinTask", "description", "dynamicForkJoinTasksParam", "dynamicForkTasksInputParamName", "dynamicForkTasksParam", "dynamicTaskNameParam", "evaluatorType", "expression", "forkTasks", "inputParameters", "joinOn", "joinStatus", "loopCondition", "loopOver", "name", "onStateChange", "optional", "permissive", "rateLimited", "retryCount", "scriptExpression", "sink", "startDelay", "subWorkflowParam", "taskDefinition", "taskReferenceName", "type", "workflowTaskType"]

    @field_validator('workflow_task_type')
    def workflow_task_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SIMPLE', 'DYNAMIC', 'FORK_JOIN', 'FORK_JOIN_DYNAMIC', 'DECISION', 'SWITCH', 'JOIN', 'DO_WHILE', 'SUB_WORKFLOW', 'START_WORKFLOW', 'EVENT', 'WAIT', 'HUMAN', 'USER_DEFINED', 'HTTP', 'LAMBDA', 'INLINE', 'EXCLUSIVE_JOIN', 'TERMINATE', 'KAFKA_PUBLISH', 'JSON_JQ_TRANSFORM', 'SET_VARIABLE', 'NOOP']):
            raise ValueError("must be one of enum values ('SIMPLE', 'DYNAMIC', 'FORK_JOIN', 'FORK_JOIN_DYNAMIC', 'DECISION', 'SWITCH', 'JOIN', 'DO_WHILE', 'SUB_WORKFLOW', 'START_WORKFLOW', 'EVENT', 'WAIT', 'HUMAN', 'USER_DEFINED', 'HTTP', 'LAMBDA', 'INLINE', 'EXCLUSIVE_JOIN', 'TERMINATE', 'KAFKA_PUBLISH', 'JSON_JQ_TRANSFORM', 'SET_VARIABLE', 'NOOP')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cache_config
        if self.cache_config:
            _dict['cacheConfig'] = self.cache_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in decision_cases (dict of array)
        _field_dict_of_array = {}
        if self.decision_cases:
            for _key_decision_cases in self.decision_cases:
                if self.decision_cases[_key_decision_cases] is not None:
                    _field_dict_of_array[_key_decision_cases] = [
                        _item.to_dict() for _item in self.decision_cases[_key_decision_cases]
                    ]
            _dict['decisionCases'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each item in default_case (list)
        _items = []
        if self.default_case:
            for _item_default_case in self.default_case:
                if _item_default_case:
                    _items.append(_item_default_case.to_dict())
            _dict['defaultCase'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fork_tasks (list of list)
        _items = []
        if self.fork_tasks:
            for _item_fork_tasks in self.fork_tasks:
                if _item_fork_tasks:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_fork_tasks if _inner_item is not None]
                    )
            _dict['forkTasks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in loop_over (list)
        _items = []
        if self.loop_over:
            for _item_loop_over in self.loop_over:
                if _item_loop_over:
                    _items.append(_item_loop_over.to_dict())
            _dict['loopOver'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in on_state_change (dict of array)
        _field_dict_of_array = {}
        if self.on_state_change:
            for _key_on_state_change in self.on_state_change:
                if self.on_state_change[_key_on_state_change] is not None:
                    _field_dict_of_array[_key_on_state_change] = [
                        _item.to_dict() for _item in self.on_state_change[_key_on_state_change]
                    ]
            _dict['onStateChange'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of sub_workflow_param
        if self.sub_workflow_param:
            _dict['subWorkflowParam'] = self.sub_workflow_param.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task_definition
        if self.task_definition:
            _dict['taskDefinition'] = self.task_definition.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowTask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asyncComplete": obj.get("asyncComplete"),
            "cacheConfig": CacheConfig.from_dict(obj["cacheConfig"]) if obj.get("cacheConfig") is not None else None,
            "caseExpression": obj.get("caseExpression"),
            "caseValueParam": obj.get("caseValueParam"),
            "decisionCases": dict(
                (_k,
                        [WorkflowTask.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("decisionCases", {}).items()
            ),
            "defaultCase": [WorkflowTask.from_dict(_item) for _item in obj["defaultCase"]] if obj.get("defaultCase") is not None else None,
            "defaultExclusiveJoinTask": obj.get("defaultExclusiveJoinTask"),
            "description": obj.get("description"),
            "dynamicForkJoinTasksParam": obj.get("dynamicForkJoinTasksParam"),
            "dynamicForkTasksInputParamName": obj.get("dynamicForkTasksInputParamName"),
            "dynamicForkTasksParam": obj.get("dynamicForkTasksParam"),
            "dynamicTaskNameParam": obj.get("dynamicTaskNameParam"),
            "evaluatorType": obj.get("evaluatorType"),
            "expression": obj.get("expression"),
            "forkTasks": [
                    [WorkflowTask.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["forkTasks"]
                ] if obj.get("forkTasks") is not None else None,
            "inputParameters": obj.get("inputParameters"),
            "joinOn": obj.get("joinOn"),
            "joinStatus": obj.get("joinStatus"),
            "loopCondition": obj.get("loopCondition"),
            "loopOver": [WorkflowTask.from_dict(_item) for _item in obj["loopOver"]] if obj.get("loopOver") is not None else None,
            "name": obj.get("name"),
            "onStateChange": dict(
                (_k,
                        [StateChangeEvent.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("onStateChange", {}).items()
            ),
            "optional": obj.get("optional"),
            "permissive": obj.get("permissive"),
            "rateLimited": obj.get("rateLimited"),
            "retryCount": obj.get("retryCount"),
            "scriptExpression": obj.get("scriptExpression"),
            "sink": obj.get("sink"),
            "startDelay": obj.get("startDelay"),
            "subWorkflowParam": SubWorkflowParams.from_dict(obj["subWorkflowParam"]) if obj.get("subWorkflowParam") is not None else None,
            "taskDefinition": TaskDef.from_dict(obj["taskDefinition"]) if obj.get("taskDefinition") is not None else None,
            "taskReferenceName": obj.get("taskReferenceName"),
            "type": obj.get("type"),
            "workflowTaskType": obj.get("workflowTaskType")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
WorkflowTask.model_rebuild(raise_errors=False)

