from __future__ import annotations

from typing import Optional

from conductor.asyncio_client.workflow.task.task import TaskInterface
from conductor.shared.workflow.enums import TaskType


class LlmSearchIndex(TaskInterface):
    def __init__(
        self,
        task_ref_name: str,
        vector_db: str,
        namespace: str,
        index: str,
        embedding_model_provider: str,
        embedding_model: str,
        query: str,
        task_name: Optional[str] = None,
        max_results: int = 1,
    ):
        if task_name is None:
            task_name = "llm_search_index"

        super().__init__(
            task_name=task_name,
            task_reference_name=task_ref_name,
            task_type=TaskType.LLM_SEARCH_INDEX,
            input_parameters={
                "vectorDB": vector_db,
                "namespace": namespace,
                "index": index,
                "embeddingModelProvider": embedding_model_provider,
                "embeddingModel": embedding_model,
                "query": query,
                "maxResults": max_results,
            },
        )
