# coding: utf-8

"""
    Orkes Conductor API Server

    Orkes Conductor API Server

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from conductor.asyncio_client.http.models.task_exec_log import TaskExecLog
from typing import Optional, Set
from typing_extensions import Self

class TaskResult(BaseModel):
    """
    TaskResult
    """ # noqa: E501
    callback_after_seconds: Optional[StrictInt] = Field(default=None, alias="callbackAfterSeconds")
    extend_lease: Optional[StrictBool] = Field(default=None, alias="extendLease")
    external_output_payload_storage_path: Optional[StrictStr] = Field(default=None, alias="externalOutputPayloadStoragePath")
    logs: Optional[List[TaskExecLog]] = None
    output_data: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, alias="outputData")
    reason_for_incompletion: Optional[StrictStr] = Field(default=None, alias="reasonForIncompletion")
    status: Optional[StrictStr] = None
    sub_workflow_id: Optional[StrictStr] = Field(default=None, alias="subWorkflowId")
    task_id: StrictStr = Field(alias="taskId")
    worker_id: Optional[StrictStr] = Field(default=None, alias="workerId")
    workflow_instance_id: StrictStr = Field(alias="workflowInstanceId")
    __properties: ClassVar[List[str]] = ["callbackAfterSeconds", "extendLease", "externalOutputPayloadStoragePath", "logs", "outputData", "reasonForIncompletion", "status", "subWorkflowId", "taskId", "workerId", "workflowInstanceId"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['IN_PROGRESS', 'FAILED', 'FAILED_WITH_TERMINAL_ERROR', 'COMPLETED']):
            raise ValueError("must be one of enum values ('IN_PROGRESS', 'FAILED', 'FAILED_WITH_TERMINAL_ERROR', 'COMPLETED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaskResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in logs (list)
        _items = []
        if self.logs:
            for _item_logs in self.logs:
                if _item_logs:
                    _items.append(_item_logs.to_dict())
            _dict['logs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaskResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "callbackAfterSeconds": obj.get("callbackAfterSeconds"),
            "extendLease": obj.get("extendLease"),
            "externalOutputPayloadStoragePath": obj.get("externalOutputPayloadStoragePath"),
            "logs": [TaskExecLog.from_dict(_item) for _item in obj["logs"]] if obj.get("logs") is not None else None,
            "outputData": obj.get("outputData"),
            "reasonForIncompletion": obj.get("reasonForIncompletion"),
            "status": obj.get("status"),
            "subWorkflowId": obj.get("subWorkflowId"),
            "taskId": obj.get("taskId"),
            "workerId": obj.get("workerId"),
            "workflowInstanceId": obj.get("workflowInstanceId")
        })
        return _obj


