from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from conductor.client.codegen.api_client import ApiClient


class ServiceRegistryResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_registered_services(self, **kwargs):  # noqa: E501
        """Get all registered services  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_registered_services(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[ServiceRegistry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_registered_services_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_registered_services_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_registered_services_with_http_info(self, **kwargs):  # noqa: E501
        """Get all registered services  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_registered_services_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[ServiceRegistry]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_registered_services" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ServiceRegistry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_service(self, name, **kwargs):  # noqa: E501
        """Remove a service from the registry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_service(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_service_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_service_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def remove_service_with_http_info(self, name, **kwargs):  # noqa: E501
        """Remove a service from the registry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_service_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_service" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `remove_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_service(self, name, **kwargs):  # noqa: E501
        """Get a specific service by name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: ServiceRegistry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_service_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_service_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_service_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get a specific service by name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_service_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: ServiceRegistry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_service" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServiceRegistry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def open_circuit_breaker(self, name, **kwargs):  # noqa: E501
        """Open the circuit breaker for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.open_circuit_breaker(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: CircuitBreakerTransitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.open_circuit_breaker_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.open_circuit_breaker_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def open_circuit_breaker_with_http_info(self, name, **kwargs):  # noqa: E501
        """Open the circuit breaker for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.open_circuit_breaker_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: CircuitBreakerTransitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method open_circuit_breaker" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `open_circuit_breaker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/{name}/circuit-breaker/open', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CircuitBreakerTransitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def close_circuit_breaker(self, name, **kwargs):  # noqa: E501
        """Close the circuit breaker for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.close_circuit_breaker(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: CircuitBreakerTransitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.close_circuit_breaker_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.close_circuit_breaker_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def close_circuit_breaker_with_http_info(self, name, **kwargs):  # noqa: E501
        """Close the circuit breaker for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.close_circuit_breaker_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: CircuitBreakerTransitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method close_circuit_breaker" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `close_circuit_breaker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/{name}/circuit-breaker/close', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CircuitBreakerTransitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_circuit_breaker_status(self, name, **kwargs):  # noqa: E501
        """Get the circuit breaker status for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_circuit_breaker_status(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: CircuitBreakerTransitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_circuit_breaker_status_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_circuit_breaker_status_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_circuit_breaker_status_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get the circuit breaker status for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_circuit_breaker_status_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :return: CircuitBreakerTransitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_circuit_breaker_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `get_circuit_breaker_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/{name}/circuit-breaker/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CircuitBreakerTransitionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_or_update_service(self, body, **kwargs):  # noqa: E501
        """Add or update a service registry entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_or_update_service(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServiceRegistry body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_or_update_service_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_or_update_service_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_or_update_service_with_http_info(self, body, **kwargs):  # noqa: E501
        """Add or update a service registry entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_or_update_service_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ServiceRegistry body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_or_update_service" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_or_update_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_or_update_method(self, registry_name, body, **kwargs):  # noqa: E501
        """Add or update a service method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_or_update_method(registry_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param ServiceMethod body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_or_update_method_with_http_info(registry_name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_or_update_method_with_http_info(registry_name, body, **kwargs)  # noqa: E501
            return data

    def add_or_update_method_with_http_info(self, registry_name, body, **kwargs):  # noqa: E501
        """Add or update a service method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_or_update_method_with_http_info(registry_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param ServiceMethod body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['registry_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_or_update_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'registry_name' is set
        if ('registry_name' not in params or
                params['registry_name'] is None):
            raise ValueError(
                "Missing the required parameter `registry_name` when calling `add_or_update_method`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `add_or_update_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'registry_name' in params:
            path_params['registryName'] = params['registry_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/{registryName}/methods', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_method(self, registry_name, service_name, method, method_type, **kwargs):  # noqa: E501
        """Remove a method from a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_method(registry_name, service_name, method, method_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param str service_name: (required)
        :param str method: (required)
        :param str method_type: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_method_with_http_info(registry_name, service_name, method, method_type,
                                                     **kwargs)  # noqa: E501
        else:
            (data) = self.remove_method_with_http_info(registry_name, service_name, method, method_type,
                                                       **kwargs)  # noqa: E501
            return data

    def remove_method_with_http_info(self, registry_name, service_name, method, method_type, **kwargs):  # noqa: E501
        """Remove a method from a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_method_with_http_info(registry_name, service_name, method, method_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param str service_name: (required)
        :param str method: (required)
        :param str method_type: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['registry_name', 'service_name', 'method', 'method_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'registry_name' is set
        if ('registry_name' not in params or
                params['registry_name'] is None):
            raise ValueError(
                "Missing the required parameter `registry_name` when calling `remove_method`")  # noqa: E501
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params or
                params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `remove_method`")  # noqa: E501
        # verify the required parameter 'method' is set
        if ('method' not in params or
                params['method'] is None):
            raise ValueError("Missing the required parameter `method` when calling `remove_method`")  # noqa: E501
        # verify the required parameter 'method_type' is set
        if ('method_type' not in params or
                params['method_type'] is None):
            raise ValueError("Missing the required parameter `method_type` when calling `remove_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'registry_name' in params:
            path_params['registryName'] = params['registry_name']  # noqa: E501

        query_params = []
        if 'service_name' in params:
            query_params.append(('serviceName', params['service_name']))  # noqa: E501
        if 'method' in params:
            query_params.append(('method', params['method']))  # noqa: E501
        if 'method_type' in params:
            query_params.append(('methodType', params['method_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/{registryName}/methods', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_proto_data(self, registry_name, filename, **kwargs):  # noqa: E501
        """Get proto data for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proto_data(registry_name, filename, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param str filename: (required)
        :return: bytes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_proto_data_with_http_info(registry_name, filename, **kwargs)  # noqa: E501
        else:
            (data) = self.get_proto_data_with_http_info(registry_name, filename, **kwargs)  # noqa: E501
            return data

    def get_proto_data_with_http_info(self, registry_name, filename, **kwargs):  # noqa: E501
        """Get proto data for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proto_data_with_http_info(registry_name, filename, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param str filename: (required)
        :return: bytes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['registry_name', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_proto_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'registry_name' is set
        if ('registry_name' not in params or
                params['registry_name'] is None):
            raise ValueError(
                "Missing the required parameter `registry_name` when calling `get_proto_data`")  # noqa: E501
        # verify the required parameter 'filename' is set
        if ('filename' not in params or
                params['filename'] is None):
            raise ValueError("Missing the required parameter `filename` when calling `get_proto_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'registry_name' in params:
            path_params['registryName'] = params['registry_name']  # noqa: E501
        if 'filename' in params:
            path_params['filename'] = params['filename']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/protos/{registryName}/{filename}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bytes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_proto_data(self, registry_name, filename, data, **kwargs):  # noqa: E501
        """Set proto data for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_proto_data(registry_name, filename, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param str filename: (required)
        :param bytes data: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_proto_data_with_http_info(registry_name, filename, data, **kwargs)  # noqa: E501
        else:
            (data) = self.set_proto_data_with_http_info(registry_name, filename, data, **kwargs)  # noqa: E501
            return data

    def set_proto_data_with_http_info(self, registry_name, filename, data, **kwargs):  # noqa: E501
        """Set proto data for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_proto_data_with_http_info(registry_name, filename, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param str filename: (required)
        :param bytes data: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['registry_name', 'filename', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_proto_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'registry_name' is set
        if ('registry_name' not in params or
                params['registry_name'] is None):
            raise ValueError(
                "Missing the required parameter `registry_name` when calling `set_proto_data`")  # noqa: E501
        # verify the required parameter 'filename' is set
        if ('filename' not in params or
                params['filename'] is None):
            raise ValueError("Missing the required parameter `filename` when calling `set_proto_data`")  # noqa: E501
        # verify the required parameter 'data' is set
        if ('data' not in params or
                params['data'] is None):
            raise ValueError("Missing the required parameter `data` when calling `set_proto_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'registry_name' in params:
            path_params['registryName'] = params['registry_name']  # noqa: E501
        if 'filename' in params:
            path_params['filename'] = params['filename']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/protos/{registryName}/{filename}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_proto(self, registry_name, filename, **kwargs):  # noqa: E501
        """Delete a proto file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_proto(registry_name, filename, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param str filename: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_proto_with_http_info(registry_name, filename, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_proto_with_http_info(registry_name, filename, **kwargs)  # noqa: E501
            return data

    def delete_proto_with_http_info(self, registry_name, filename, **kwargs):  # noqa: E501
        """Delete a proto file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_proto_with_http_info(registry_name, filename, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :param str filename: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['registry_name', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_proto" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'registry_name' is set
        if ('registry_name' not in params or
                params['registry_name'] is None):
            raise ValueError(
                "Missing the required parameter `registry_name` when calling `delete_proto`")  # noqa: E501
        # verify the required parameter 'filename' is set
        if ('filename' not in params or
                params['filename'] is None):
            raise ValueError("Missing the required parameter `filename` when calling `delete_proto`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'registry_name' in params:
            path_params['registryName'] = params['registry_name']  # noqa: E501
        if 'filename' in params:
            path_params['filename'] = params['filename']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/protos/{registryName}/{filename}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_protos(self, registry_name, **kwargs):  # noqa: E501
        """Get all protos for a registry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_protos(registry_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :return: list[ProtoRegistryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_protos_with_http_info(registry_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_protos_with_http_info(registry_name, **kwargs)  # noqa: E501
            return data

    def get_all_protos_with_http_info(self, registry_name, **kwargs):  # noqa: E501
        """Get all protos for a registry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_protos_with_http_info(registry_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str registry_name: (required)
        :return: list[ProtoRegistryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['registry_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_protos" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'registry_name' is set
        if ('registry_name' not in params or
                params['registry_name'] is None):
            raise ValueError(
                "Missing the required parameter `registry_name` when calling `get_all_protos`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'registry_name' in params:
            path_params['registryName'] = params['registry_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/protos/{registryName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProtoRegistryEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def discover(self, name, **kwargs):  # noqa: E501
        """Discover methods for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.discover(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param bool create:
        :return: list[ServiceMethod]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.discover_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.discover_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def discover_with_http_info(self, name, **kwargs):  # noqa: E501
        """Discover methods for a service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.discover_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: (required)
        :param bool create:
        :return: list[ServiceMethod]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'create']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method discover" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `discover`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'create' in params:
            query_params.append(('create', params['create']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/registry/service/{name}/discover', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ServiceMethod]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)