import pprint
import re  # noqa: F401
import six
from dataclasses import dataclass, field, InitVar
from typing import List, Dict, Any, Optional
from dataclasses import dataclass, field, InitVar


@dataclass
class EventHandler:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'event': 'str',
        'condition': 'str',
        'actions': 'list[Action]',
        'active': 'bool',
        'evaluator_type': 'str'
    }

    attribute_map = {
        'name': 'name',
        'event': 'event',
        'condition': 'condition',
        'actions': 'actions',
        'active': 'active',
        'evaluator_type': 'evaluatorType'
    }

    name: str = field(default=None)
    event: str = field(default=None)
    condition: Optional[str] = field(default=None)
    actions: List[Any] = field(default=None)
    active: Optional[bool] = field(default=None)
    evaluator_type: Optional[str] = field(default=None)
    
    # Private backing fields for properties
    _name: str = field(init=False, repr=False, default=None)
    _event: str = field(init=False, repr=False, default=None)
    _condition: Optional[str] = field(init=False, repr=False, default=None)
    _actions: List[Any] = field(init=False, repr=False, default=None)
    _active: Optional[bool] = field(init=False, repr=False, default=None)
    _evaluator_type: Optional[str] = field(init=False, repr=False, default=None)
    
    # For backward compatibility
    discriminator: InitVar[Any] = None

    def __init__(self, name=None, event=None, condition=None, actions=None, active=None,
                 evaluator_type=None):  # noqa: E501
        """EventHandler - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._event = None
        self._condition = None
        self._actions = None
        self._active = None
        self._evaluator_type = None
        self.discriminator = None
        self.name = name
        self.event = event
        if condition is not None:
            self.condition = condition
        self.actions = actions
        if active is not None:
            self.active = active
        if evaluator_type is not None:
            self.evaluator_type = evaluator_type

    def __post_init__(self, discriminator):
        # Initialize properties from dataclass fields if not already set by __init__
        if self._name is None and self.name is not None:
            self._name = self.name
        if self._event is None and self.event is not None:
            self._event = self.event
        if self._condition is None and self.condition is not None:
            self._condition = self.condition
        if self._actions is None and self.actions is not None:
            self._actions = self.actions
        if self._active is None and self.active is not None:
            self._active = self.active
        if self._evaluator_type is None and self.evaluator_type is not None:
            self._evaluator_type = self.evaluator_type

    @property
    def name(self):
        """Gets the name of this EventHandler.  # noqa: E501


        :return: The name of this EventHandler.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EventHandler.


        :param name: The name of this EventHandler.  # noqa: E501
        :type: str
        """
        self._name = name

    @property
    def event(self):
        """Gets the event of this EventHandler.  # noqa: E501


        :return: The event of this EventHandler.  # noqa: E501
        :rtype: str
        """
        return self._event

    @event.setter
    def event(self, event):
        """Sets the event of this EventHandler.


        :param event: The event of this EventHandler.  # noqa: E501
        :type: str
        """
        self._event = event

    @property
    def condition(self):
        """Gets the condition of this EventHandler.  # noqa: E501


        :return: The condition of this EventHandler.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this EventHandler.


        :param condition: The condition of this EventHandler.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def actions(self):
        """Gets the actions of this EventHandler.  # noqa: E501


        :return: The actions of this EventHandler.  # noqa: E501
        :rtype: list[Action]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """Sets the actions of this EventHandler.


        :param actions: The actions of this EventHandler.  # noqa: E501
        :type: list[Action]
        """
        self._actions = actions

    @property
    def active(self):
        """Gets the active of this EventHandler.  # noqa: E501


        :return: The active of this EventHandler.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this EventHandler.


        :param active: The active of this EventHandler.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def evaluator_type(self):
        """Gets the evaluator_type of this EventHandler.  # noqa: E501


        :return: The evaluator_type of this EventHandler.  # noqa: E501
        :rtype: str
        """
        return self._evaluator_type

    @evaluator_type.setter
    def evaluator_type(self, evaluator_type):
        """Sets the evaluator_type of this EventHandler.


        :param evaluator_type: The evaluator_type of this EventHandler.  # noqa: E501
        :type: str
        """

        self._evaluator_type = evaluator_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EventHandler, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventHandler):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other