import pprint
import re  # noqa: F401
import six
from dataclasses import dataclass, field, asdict
from typing import Optional
from deprecated import deprecated

@dataclass
class RateLimit:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    _rate_limit_key: Optional[str] = field(default=None, init=False)
    _concurrent_exec_limit: Optional[int] = field(default=None, init=False)
    _tag: Optional[str] = field(default=None, init=False)
    _concurrent_execution_limit: Optional[int] = field(default=None, init=False)
    
    swagger_types = {
        'rate_limit_key': 'str',
        'concurrent_exec_limit': 'int',
        'tag': 'str',
        'concurrent_execution_limit': 'int'
    }

    attribute_map = {
        'rate_limit_key': 'rateLimitKey',
        'concurrent_exec_limit': 'concurrentExecLimit',
        'tag': 'tag',
        'concurrent_execution_limit': 'concurrentExecutionLimit'
    }

    def __init__(self, tag=None, concurrent_execution_limit=None, rate_limit_key=None, concurrent_exec_limit=None):  # noqa: E501
        """RateLimit - a model defined in Swagger"""  # noqa: E501
        self._tag = None
        self._concurrent_execution_limit = None
        self._rate_limit_key = None
        self._concurrent_exec_limit = None
        self.discriminator = None
        if tag is not None:
            self.tag = tag
        if concurrent_execution_limit is not None:
            self.concurrent_execution_limit = concurrent_execution_limit
        if rate_limit_key is not None:
            self.rate_limit_key = rate_limit_key
        if concurrent_exec_limit is not None:
            self.concurrent_exec_limit = concurrent_exec_limit

    def __post_init__(self):
        """Post initialization for dataclass"""
        pass

    @property
    def rate_limit_key(self):
        """Gets the rate_limit_key of this RateLimit.  # noqa: E501

        Key that defines the rate limit. Rate limit key is a combination of workflow payload such as
        name, or correlationId etc.

        :return: The rate_limit_key of this RateLimit.  # noqa: E501
        :rtype: str
        """
        return self._rate_limit_key

    @rate_limit_key.setter
    def rate_limit_key(self, rate_limit_key):
        """Sets the rate_limit_key of this RateLimit.

        Key that defines the rate limit. Rate limit key is a combination of workflow payload such as
        name, or correlationId etc.

        :param rate_limit_key: The rate_limit_key of this RateLimit.  # noqa: E501
        :type: str
        """
        self._rate_limit_key = rate_limit_key

    @property
    def concurrent_exec_limit(self):
        """Gets the concurrent_exec_limit of this RateLimit.  # noqa: E501

        Number of concurrently running workflows that are allowed per key

        :return: The concurrent_exec_limit of this RateLimit.  # noqa: E501
        :rtype: int
        """
        return self._concurrent_exec_limit

    @concurrent_exec_limit.setter
    def concurrent_exec_limit(self, concurrent_exec_limit):
        """Sets the concurrent_exec_limit of this RateLimit.

        Number of concurrently running workflows that are allowed per key

        :param concurrent_exec_limit: The concurrent_exec_limit of this RateLimit.  # noqa: E501
        :type: int
        """
        self._concurrent_exec_limit = concurrent_exec_limit

    @property
    @deprecated(reason="Use rate_limit_key instead")
    def tag(self):
        """Gets the tag of this RateLimit.  # noqa: E501


        :return: The tag of this RateLimit.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    @deprecated(reason="Use rate_limit_key instead")
    def tag(self, tag):
        """Sets the tag of this RateLimit.


        :param tag: The tag of this RateLimit.  # noqa: E501
        :type: str
        """
        self._tag = tag

    @property
    @deprecated(reason="Use concurrent_exec_limit instead")
    def concurrent_execution_limit(self):
        """Gets the concurrent_execution_limit of this RateLimit.  # noqa: E501


        :return: The concurrent_execution_limit of this RateLimit.  # noqa: E501
        :rtype: int
        """
        return self._concurrent_execution_limit

    @concurrent_execution_limit.setter
    @deprecated(reason="Use concurrent_exec_limit instead")
    def concurrent_execution_limit(self, concurrent_execution_limit):
        """Sets the concurrent_execution_limit of this RateLimit.


        :param concurrent_execution_limit: The concurrent_execution_limit of this RateLimit.  # noqa: E501
        :type: int
        """
        self._concurrent_execution_limit = concurrent_execution_limit

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RateLimit, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RateLimit):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other