import pprint
import re  # noqa: F401
import six
from dataclasses import dataclass, field
from typing import List, Optional


@dataclass
class CreateOrUpdateRoleRequest:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    name: Optional[str] = field(default=None)
    permissions: Optional[List[str]] = field(default=None)

    # Class variables
    swagger_types = {
        'name': 'str',
        'permissions': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'permissions': 'permissions'
    }

    def __init__(self, name=None, permissions=None):  # noqa: E501
        """CreateOrUpdateRoleRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._permissions = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if permissions is not None:
            self.permissions = permissions

    def __post_init__(self):
        """Post initialization for dataclass"""
        # This is intentionally left empty as the original __init__ handles initialization
        pass

    @property
    def name(self):
        """Gets the name of this CreateOrUpdateRoleRequest.  # noqa: E501


        :return: The name of this CreateOrUpdateRoleRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateOrUpdateRoleRequest.


        :param name: The name of this CreateOrUpdateRoleRequest.  # noqa: E501
        :type: str
        """
        self._name = name

    @property
    def permissions(self):
        """Gets the permissions of this CreateOrUpdateRoleRequest.  # noqa: E501


        :return: The permissions of this CreateOrUpdateRoleRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this CreateOrUpdateRoleRequest.


        :param permissions: The permissions of this CreateOrUpdateRoleRequest.  # noqa: E501
        :type: list[str]
        """
        self._permissions = permissions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateOrUpdateRoleRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateOrUpdateRoleRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
