import pprint
import re  # noqa: F401
import six
from dataclasses import dataclass, field
from typing import List, Optional


@dataclass
class AuthenticationConfig:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    # Private backing fields for properties
    _id: Optional[str] = field(init=False, repr=False, default=None)
    _application_id: Optional[str] = field(init=False, repr=False, default=None)
    _authentication_type: Optional[str] = field(init=False, repr=False, default=None)  # Enum: NONE, API_KEY, OIDC
    _api_keys: Optional[List[str]] = field(init=False, repr=False, default=None)
    _audience: Optional[str] = field(init=False, repr=False, default=None)
    _conductor_token: Optional[str] = field(init=False, repr=False, default=None)
    _created_by: Optional[str] = field(init=False, repr=False, default=None)
    _fallback_to_default_auth: Optional[bool] = field(init=False, repr=False, default=None)
    _issuer_uri: Optional[str] = field(init=False, repr=False, default=None)
    _passthrough: Optional[bool] = field(init=False, repr=False, default=None)
    _token_in_workflow_input: Optional[bool] = field(init=False, repr=False, default=None)
    _updated_by: Optional[str] = field(init=False, repr=False, default=None)

    # Class variables
    swagger_types = {
        'id': 'str',
        'application_id': 'str',
        'authentication_type': 'str',
        'api_keys': 'list[str]',
        'audience': 'str',
        'conductor_token': 'str',
        'created_by': 'str',
        'fallback_to_default_auth': 'bool',
        'issuer_uri': 'str',
        'passthrough': 'bool',
        'token_in_workflow_input': 'bool',
        'updated_by': 'str'
    }

    attribute_map = {
        'id': 'id',
        'application_id': 'applicationId',
        'authentication_type': 'authenticationType',
        'api_keys': 'apiKeys',
        'audience': 'audience',
        'conductor_token': 'conductorToken',
        'created_by': 'createdBy',
        'fallback_to_default_auth': 'fallbackToDefaultAuth',
        'issuer_uri': 'issuerUri',
        'passthrough': 'passthrough',
        'token_in_workflow_input': 'tokenInWorkflowInput',
        'updated_by': 'updatedBy'
    }

    def __init__(self, id=None, application_id=None, authentication_type=None,
                 api_keys=None, audience=None, conductor_token=None, created_by=None,
                 fallback_to_default_auth=None, issuer_uri=None,
                 passthrough=None, token_in_workflow_input=None, updated_by=None):  # noqa: E501
        """AuthenticationConfig - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._application_id = None
        self._authentication_type = None
        self._api_keys = None
        self._audience = None
        self._conductor_token = None
        self._created_by = None
        self._fallback_to_default_auth = None
        self._issuer_uri = None
        self._passthrough = None
        self._token_in_workflow_input = None
        self._updated_by = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if application_id is not None:
            self.application_id = application_id
        if authentication_type is not None:
            self.authentication_type = authentication_type
        if api_keys is not None:
            self.api_keys = api_keys
        if audience is not None:
            self.audience = audience
        if conductor_token is not None:
            self.conductor_token = conductor_token
        if created_by is not None:
            self.created_by = created_by
        if fallback_to_default_auth is not None:
            self.fallback_to_default_auth = fallback_to_default_auth
        if issuer_uri is not None:
            self.issuer_uri = issuer_uri
        if passthrough is not None:
            self.passthrough = passthrough
        if token_in_workflow_input is not None:
            self.token_in_workflow_input = token_in_workflow_input
        if updated_by is not None:
            self.updated_by = updated_by

    def __post_init__(self):
        """Post initialization for dataclass"""
        # This is intentionally left empty as the original __init__ handles initialization
        pass

    @property
    def id(self):
        """Gets the id of this AuthenticationConfig.  # noqa: E501


        :return: The id of this AuthenticationConfig.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AuthenticationConfig.


        :param id: The id of this AuthenticationConfig.  # noqa: E501
        :type: str
        """
        self._id = id

    @property
    def application_id(self):
        """Gets the application_id of this AuthenticationConfig.  # noqa: E501


        :return: The application_id of this AuthenticationConfig.  # noqa: E501
        :rtype: str
        """
        return self._application_id

    @application_id.setter
    def application_id(self, application_id):
        """Sets the application_id of this AuthenticationConfig.


        :param application_id: The application_id of this AuthenticationConfig.  # noqa: E501
        :type: str
        """
        self._application_id = application_id

    @property
    def authentication_type(self):
        """Gets the authentication_type of this AuthenticationConfig.  # noqa: E501


        :return: The authentication_type of this AuthenticationConfig.  # noqa: E501
        :rtype: str
        """
        return self._authentication_type

    @authentication_type.setter
    def authentication_type(self, authentication_type):
        """Sets the authentication_type of this AuthenticationConfig.


        :param authentication_type: The authentication_type of this AuthenticationConfig.  # noqa: E501
        :type: str
        """
        allowed_values = ["NONE", "API_KEY", "OIDC"]  # noqa: E501
        if authentication_type not in allowed_values:
            raise ValueError(
                "Invalid value for `authentication_type` ({0}), must be one of {1}"  # noqa: E501
                .format(authentication_type, allowed_values)
            )
        self._authentication_type = authentication_type

    @property
    def api_keys(self):
        """Gets the api_keys of this AuthenticationConfig.  # noqa: E501


        :return: The api_keys of this AuthenticationConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._api_keys

    @api_keys.setter
    def api_keys(self, api_keys):
        """Sets the api_keys of this AuthenticationConfig.


        :param api_keys: The api_keys of this AuthenticationConfig.  # noqa: E501
        :type: list[str]
        """
        self._api_keys = api_keys

    @property
    def audience(self):
        """Gets the audience of this AuthenticationConfig.  # noqa: E501


        :return: The audience of this AuthenticationConfig.  # noqa: E501
        :rtype: str
        """
        return self._audience

    @audience.setter
    def audience(self, audience):
        """Sets the audience of this AuthenticationConfig.


        :param audience: The audience of this AuthenticationConfig.  # noqa: E501
        :type: str
        """
        self._audience = audience

    @property
    def conductor_token(self):
        """Gets the conductor_token of this AuthenticationConfig.  # noqa: E501


        :return: The conductor_token of this AuthenticationConfig.  # noqa: E501
        :rtype: str
        """
        return self._conductor_token

    @conductor_token.setter
    def conductor_token(self, conductor_token):
        """Sets the conductor_token of this AuthenticationConfig.


        :param conductor_token: The conductor_token of this AuthenticationConfig.  # noqa: E501
        :type: str
        """
        self._conductor_token = conductor_token

    @property
    def created_by(self):
        """Gets the created_by of this AuthenticationConfig.  # noqa: E501


        :return: The created_by of this AuthenticationConfig.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this AuthenticationConfig.


        :param created_by: The created_by of this AuthenticationConfig.  # noqa: E501
        :type: str
        """
        self._created_by = created_by

    @property
    def fallback_to_default_auth(self):
        """Gets the fallback_to_default_auth of this AuthenticationConfig.  # noqa: E501


        :return: The fallback_to_default_auth of this AuthenticationConfig.  # noqa: E501
        :rtype: bool
        """
        return self._fallback_to_default_auth

    @fallback_to_default_auth.setter
    def fallback_to_default_auth(self, fallback_to_default_auth):
        """Sets the fallback_to_default_auth of this AuthenticationConfig.


        :param fallback_to_default_auth: The fallback_to_default_auth of this AuthenticationConfig.  # noqa: E501
        :type: bool
        """
        self._fallback_to_default_auth = fallback_to_default_auth

    @property
    def issuer_uri(self):
        """Gets the issuer_uri of this AuthenticationConfig.  # noqa: E501


        :return: The issuer_uri of this AuthenticationConfig.  # noqa: E501
        :rtype: str
        """
        return self._issuer_uri

    @issuer_uri.setter
    def issuer_uri(self, issuer_uri):
        """Sets the issuer_uri of this AuthenticationConfig.


        :param issuer_uri: The issuer_uri of this AuthenticationConfig.  # noqa: E501
        :type: str
        """
        self._issuer_uri = issuer_uri

    @property
    def passthrough(self):
        """Gets the passthrough of this AuthenticationConfig.  # noqa: E501


        :return: The passthrough of this AuthenticationConfig.  # noqa: E501
        :rtype: bool
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this AuthenticationConfig.


        :param passthrough: The passthrough of this AuthenticationConfig.  # noqa: E501
        :type: bool
        """
        self._passthrough = passthrough

    @property
    def token_in_workflow_input(self):
        """Gets the token_in_workflow_input of this AuthenticationConfig.  # noqa: E501


        :return: The token_in_workflow_input of this AuthenticationConfig.  # noqa: E501
        :rtype: bool
        """
        return self._token_in_workflow_input

    @token_in_workflow_input.setter
    def token_in_workflow_input(self, token_in_workflow_input):
        """Sets the token_in_workflow_input of this AuthenticationConfig.


        :param token_in_workflow_input: The token_in_workflow_input of this AuthenticationConfig.  # noqa: E501
        :type: bool
        """
        self._token_in_workflow_input = token_in_workflow_input

    @property
    def updated_by(self):
        """Gets the updated_by of this AuthenticationConfig.  # noqa: E501


        :return: The updated_by of this AuthenticationConfig.  # noqa: E501
        :rtype: str
        """
        return self._updated_by

    @updated_by.setter
    def updated_by(self, updated_by):
        """Sets the updated_by of this AuthenticationConfig.


        :param updated_by: The updated_by of this AuthenticationConfig.  # noqa: E501
        :type: str
        """
        self._updated_by = updated_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AuthenticationConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuthenticationConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
