import pprint
import re  # noqa: F401
import six
from dataclasses import dataclass, field, fields
from typing import Dict, Any, Optional, List, Union
from enum import Enum
from deprecated import deprecated


class Frequency(str, Enum):
    DAILY = "daily"
    WEEKLY = "weekly"
    MONTHLY = "monthly"

    @classmethod
    def from_value(cls, value: str) -> 'Frequency':
        for freq in cls:
            if freq.value.lower() == value.lower():
                return freq
        raise ValueError(f"Unknown frequency: {value}")


@dataclass
class IntegrationApiUpdate:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    _configuration: Optional[Dict[str, Any]] = field(default=None, init=False)
    _description: Optional[str] = field(default=None, init=False)
    _enabled: Optional[bool] = field(default=None, init=False)
    _max_tokens: Optional[int] = field(default=None, init=False)
    _frequency: Optional[Frequency] = field(default=None, init=False)
    
    swagger_types = {
        'configuration': 'dict(str, object)',
        'description': 'str',
        'enabled': 'bool',
        'max_tokens': 'int',
        'frequency': 'Frequency'
    }

    attribute_map = {
        'configuration': 'configuration',
        'description': 'description',
        'enabled': 'enabled',
        'max_tokens': 'maxTokens',
        'frequency': 'frequency'
    }

    def __init__(self, configuration=None, description=None, enabled=None, max_tokens=None, frequency=None):  # noqa: E501
        """IntegrationApiUpdate - a model defined in Swagger"""  # noqa: E501
        self._configuration = None
        self._description = None
        self._enabled = None
        self._max_tokens = None
        self._frequency = None
        self.discriminator = None
        if configuration is not None:
            self.configuration = configuration
        if description is not None:
            self.description = description
        if enabled is not None:
            self.enabled = enabled
        if max_tokens is not None:
            self.max_tokens = max_tokens
        if frequency is not None:
            self.frequency = frequency

    def __post_init__(self):
        """Initialize fields after dataclass initialization"""
        pass

    @property
    def configuration(self):
        """Gets the configuration of this IntegrationApiUpdate.  # noqa: E501


        :return: The configuration of this IntegrationApiUpdate.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """Sets the configuration of this IntegrationApiUpdate.


        :param configuration: The configuration of this IntegrationApiUpdate.  # noqa: E501
        :type: dict(str, object)
        """

        self._configuration = configuration

    @property
    def description(self):
        """Gets the description of this IntegrationApiUpdate.  # noqa: E501


        :return: The description of this IntegrationApiUpdate.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this IntegrationApiUpdate.


        :param description: The description of this IntegrationApiUpdate.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def enabled(self):
        """Gets the enabled of this IntegrationApiUpdate.  # noqa: E501


        :return: The enabled of this IntegrationApiUpdate.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this IntegrationApiUpdate.


        :param enabled: The enabled of this IntegrationApiUpdate.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def max_tokens(self):
        """Gets the max_tokens of this IntegrationApiUpdate.  # noqa: E501


        :return: The max_tokens of this IntegrationApiUpdate.  # noqa: E501
        :rtype: int
        """
        return self._max_tokens

    @max_tokens.setter
    def max_tokens(self, max_tokens):
        """Sets the max_tokens of this IntegrationApiUpdate.


        :param max_tokens: The max_tokens of this IntegrationApiUpdate.  # noqa: E501
        :type: int
        """

        self._max_tokens = max_tokens

    @property
    def frequency(self):
        """Gets the frequency of this IntegrationApiUpdate.  # noqa: E501


        :return: The frequency of this IntegrationApiUpdate.  # noqa: E501
        :rtype: Frequency
        """
        return self._frequency

    @frequency.setter
    def frequency(self, frequency):
        """Sets the frequency of this IntegrationApiUpdate.


        :param frequency: The frequency of this IntegrationApiUpdate.  # noqa: E501
        :type: Frequency
        """
        if isinstance(frequency, str):
            frequency = Frequency.from_value(frequency)

        self._frequency = frequency

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IntegrationApiUpdate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IntegrationApiUpdate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other