import pprint
import re  # noqa: F401
from enum import Enum
from dataclasses import dataclass, field, InitVar
from typing import Optional, Dict, List, Any
import six


class TargetType(str, Enum):
    WORKFLOW_DEF = "WORKFLOW_DEF",
    TASK_DEF = "TASK_DEF",
    APPLICATION = "APPLICATION",
    USER = "USER",
    SECRET = "SECRET",
    SECRET_NAME = "SECRET_NAME",
    TAG = "TAG",
    DOMAIN = "DOMAIN"


@dataclass
class TargetRef:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'id': 'str'
    }

    attribute_map = {
        'type': 'type',
        'id': 'id'
    }

    # Dataclass fields
    type: Optional[str] = field(default=None)
    id: Optional[str] = field(default=None)
    
    # InitVar for backward compatibility
    type_init: InitVar[Optional[str]] = field(default=None)
    id_init: InitVar[Optional[str]] = field(default=None)
    
    # Private backing fields
    _type: Optional[str] = field(init=False, default=None, repr=False)
    _id: Optional[str] = field(init=False, default=None, repr=False)
    
    # Keep original __init__ for backward compatibility
    def __init__(self, type=None, id=None):  # noqa: E501
        """TargetRef - a model defined in Swagger"""  # noqa: E501
        self._type = None
        self._id = None
        self.discriminator = None
        self.type = type
        self.id = id
    
    def __post_init__(self, type_init, id_init):
        # This will be called when instantiated as a dataclass
        if not hasattr(self, 'discriminator'):
            self.discriminator = None
            
        # Use init values if provided via dataclass instantiation
        if type_init is not None and self._type is None:
            self.type = type_init
        if id_init is not None and self._id is None:
            self.id = id_init

    @property
    def type(self):
        """Gets the type of this TargetRef.  # noqa: E501


        :return: The type of this TargetRef.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this TargetRef.


        :param type: The type of this TargetRef.  # noqa: E501
        :type: str
        """
        allowed_values = [t.value for t in TargetType]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def id(self):
        """Gets the id of this TargetRef.  # noqa: E501


        :return: The id of this TargetRef.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TargetRef.


        :param id: The id of this TargetRef.  # noqa: E501
        :type: str
        """
        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TargetRef, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TargetRef):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other