import pprint
import re  # noqa: F401
import six
from dataclasses import dataclass, field, fields
from typing import List, Optional, Dict
from deprecated import deprecated


@dataclass
class ConductorUser:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    _id: Optional[str] = field(default=None, init=False, repr=False)
    _name: Optional[str] = field(default=None, init=False, repr=False)
    _roles: Optional[List['Role']] = field(default=None, init=False, repr=False)
    _groups: Optional[List['Group']] = field(default=None, init=False, repr=False)
    _uuid: Optional[str] = field(default=None, init=False, repr=False)
    _application_user: Optional[bool] = field(default=None, init=False, repr=False)
    _encrypted_id: Optional[bool] = field(default=None, init=False, repr=False)
    _encrypted_id_display_value: Optional[str] = field(default=None, init=False, repr=False)
    _contact_information: Optional[Dict[str, str]] = field(default=None, init=False, repr=False)
    _namespace: Optional[str] = field(default=None, init=False, repr=False)

    swagger_types = {
        'id': 'str',
        'name': 'str',
        'roles': 'list[Role]',
        'groups': 'list[Group]',
        'uuid': 'str',
        'application_user': 'bool',
        'encrypted_id': 'bool',
        'encrypted_id_display_value': 'str',
        'contact_information': 'dict(str, str)',
        'namespace': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'roles': 'roles',
        'groups': 'groups',
        'uuid': 'uuid',
        'application_user': 'applicationUser',
        'encrypted_id': 'encryptedId',
        'encrypted_id_display_value': 'encryptedIdDisplayValue',
        'contact_information': 'contactInformation',
        'namespace': 'namespace'
    }

    def __init__(self, id=None, name=None, roles=None, groups=None, uuid=None, application_user=None, encrypted_id=None,
                 encrypted_id_display_value=None, contact_information=None, namespace=None):  # noqa: E501
        """ConductorUser - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._roles = None
        self._groups = None
        self._uuid = None
        self._application_user = None
        self._encrypted_id = None
        self._encrypted_id_display_value = None
        self._contact_information = None
        self._namespace = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if roles is not None:
            self.roles = roles
        if groups is not None:
            self.groups = groups
        if uuid is not None:
            self.uuid = uuid
        if application_user is not None:
            self.application_user = application_user
        if encrypted_id is not None:
            self.encrypted_id = encrypted_id
        if encrypted_id_display_value is not None:
            self.encrypted_id_display_value = encrypted_id_display_value
        if contact_information is not None:
            self.contact_information = contact_information
        if namespace is not None:
            self.namespace = namespace

    def __post_init__(self):
        """Initialize after dataclass initialization"""
        self.discriminator = None

    @property
    def id(self):
        """Gets the id of this ConductorUser.  # noqa: E501


        :return: The id of this ConductorUser.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ConductorUser.


        :param id: The id of this ConductorUser.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ConductorUser.  # noqa: E501


        :return: The name of this ConductorUser.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ConductorUser.


        :param name: The name of this ConductorUser.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def roles(self):
        """Gets the roles of this ConductorUser.  # noqa: E501


        :return: The roles of this ConductorUser.  # noqa: E501
        :rtype: list[Role]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this ConductorUser.


        :param roles: The roles of this ConductorUser.  # noqa: E501
        :type: list[Role]
        """

        self._roles = roles

    @property
    def groups(self):
        """Gets the groups of this ConductorUser.  # noqa: E501


        :return: The groups of this ConductorUser.  # noqa: E501
        :rtype: list[Group]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """Sets the groups of this ConductorUser.


        :param groups: The groups of this ConductorUser.  # noqa: E501
        :type: list[Group]
        """

        self._groups = groups

    @property
    def uuid(self):
        """Gets the uuid of this ConductorUser.  # noqa: E501


        :return: The uuid of this ConductorUser.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this ConductorUser.


        :param uuid: The uuid of this ConductorUser.  # noqa: E501
        :type: str
        """

        self._uuid = uuid

    @property
    @deprecated
    def application_user(self):
        """Gets the application_user of this ConductorUser.  # noqa: E501


        :return: The application_user of this ConductorUser.  # noqa: E501
        :rtype: bool
        """
        return self._application_user

    @application_user.setter
    @deprecated
    def application_user(self, application_user):
        """Sets the application_user of this ConductorUser.


        :param application_user: The application_user of this ConductorUser.  # noqa: E501
        :type: bool
        """

        self._application_user = application_user

    @property
    def encrypted_id(self):
        """Gets the encrypted_id of this ConductorUser.  # noqa: E501


        :return: The encrypted_id of this ConductorUser.  # noqa: E501
        :rtype: bool
        """
        return self._encrypted_id

    @encrypted_id.setter
    def encrypted_id(self, encrypted_id):
        """Sets the encrypted_id of this ConductorUser.


        :param encrypted_id: The encrypted_id of this ConductorUser.  # noqa: E501
        :type: bool
        """

        self._encrypted_id = encrypted_id

    @property
    def encrypted_id_display_value(self):
        """Gets the encrypted_id_display_value of this ConductorUser.  # noqa: E501


        :return: The encrypted_id_display_value of this ConductorUser.  # noqa: E501
        :rtype: str
        """
        return self._encrypted_id_display_value

    @encrypted_id_display_value.setter
    def encrypted_id_display_value(self, encrypted_id_display_value):
        """Sets the encrypted_id_display_value of this ConductorUser.


        :param encrypted_id_display_value: The encrypted_id_display_value of this ConductorUser.  # noqa: E501
        :type: str
        """

        self._encrypted_id_display_value = encrypted_id_display_value

    @property
    def contact_information(self):
        """Gets the contact_information of this ConductorUser.  # noqa: E501


        :return: The contact_information of this ConductorUser.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._contact_information

    @contact_information.setter
    def contact_information(self, contact_information):
        """Sets the contact_information of this ConductorUser.


        :param contact_information: The contact_information of this ConductorUser.  # noqa: E501
        :type: dict(str, str)
        """

        self._contact_information = contact_information

    @property
    def namespace(self):
        """Gets the namespace of this ConductorUser.  # noqa: E501


        :return: The namespace of this ConductorUser.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this ConductorUser.


        :param namespace: The namespace of this ConductorUser.  # noqa: E501
        :type: str
        """

        self._namespace = namespace

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ConductorUser, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConductorUser):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other