import pprint
import re  # noqa: F401
import six
from dataclasses import dataclass, field, InitVar
from typing import List, Optional


@dataclass
class Role:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'permissions': 'list[Permission]'
    }

    attribute_map = {
        'name': 'name',
        'permissions': 'permissions'
    }

    name: Optional[str] = field(default=None)
    permissions: Optional[List['Permission']] = field(default=None)
    
    # InitVar parameters for backward compatibility
    name_init: InitVar[Optional[str]] = field(default=None)
    permissions_init: InitVar[Optional[List['Permission']]] = field(default=None)
    
    def __init__(self, name=None, permissions=None):  # noqa: E501
        """Role - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._permissions = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if permissions is not None:
            self.permissions = permissions
    
    def __post_init__(self, name_init, permissions_init):
        # Handle initialization from dataclass fields
        if name_init is not None:
            self.name = name_init
        if permissions_init is not None:
            self.permissions = permissions_init

    @property
    def name(self):
        """Gets the name of this Role.  # noqa: E501


        :return: The name of this Role.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Role.


        :param name: The name of this Role.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def permissions(self):
        """Gets the permissions of this Role.  # noqa: E501


        :return: The permissions of this Role.  # noqa: E501
        :rtype: list[Permission]
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this Role.


        :param permissions: The permissions of this Role.  # noqa: E501
        :type: list[Permission]
        """

        self._permissions = permissions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Role, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Role):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other