# -*- coding: utf-8 -*-
#
# This class was auto-generated from the API references found at
# https://epayments-api.developer-ingenico.com/s2sapi/v1/
#
from ingenico.connect.sdk.data_object import DataObject


class CreateHostedMandateManagementResponse(DataObject):

    __returnmac = None
    __hosted_mandate_management_id = None
    __partial_redirect_url = None

    @property
    def returnmac(self):
        """
        | When the consumer is returned to your site we will append this field and value to the query-string. You should store this data, so you can identify the returning consumer.
        
        Type: str
        """
        return self.__returnmac

    @returnmac.setter
    def returnmac(self, value):
        self.__returnmac = value

    @property
    def hosted_mandate_management_id(self):
        """
        | This is the ID under which the data for this mandate management can be retrieved.
        
        Type: str
        """
        return self.__hosted_mandate_management_id

    @hosted_mandate_management_id.setter
    def hosted_mandate_management_id(self, value):
        self.__hosted_mandate_management_id = value

    @property
    def partial_redirect_url(self):
        """
        | The partial URL as generated by our system. You will need to add the protocol and the relevant subdomain to this URL, before redirecting your consumer to this URL. A special 'payment' subdomain will always work so you can always add 'https://payment.' at the beginning of this response value to view your hosted mandate management pages.
        
        Type: str
        """
        return self.__partial_redirect_url

    @partial_redirect_url.setter
    def partial_redirect_url(self, value):
        self.__partial_redirect_url = value

    def to_dictionary(self):
        dictionary = super(CreateHostedMandateManagementResponse, self).to_dictionary()
        self._add_to_dictionary(dictionary, 'RETURNMAC', self.returnmac)
        self._add_to_dictionary(dictionary, 'hostedMandateManagementId', self.hosted_mandate_management_id)
        self._add_to_dictionary(dictionary, 'partialRedirectUrl', self.partial_redirect_url)
        return dictionary

    def from_dictionary(self, dictionary):
        super(CreateHostedMandateManagementResponse, self).from_dictionary(dictionary)
        if 'RETURNMAC' in dictionary:
            self.returnmac = dictionary['RETURNMAC']
        if 'hostedMandateManagementId' in dictionary:
            self.hosted_mandate_management_id = dictionary['hostedMandateManagementId']
        if 'partialRedirectUrl' in dictionary:
            self.partial_redirect_url = dictionary['partialRedirectUrl']
        return self
