# -*- coding: utf-8 -*-
#
# This class was auto-generated from the API references found at
# https://apireference.connect.worldline-solutions.com/
#
from typing import Optional

from worldline.connect.sdk.domain.data_object import DataObject
from worldline.connect.sdk.v1.domain.amount_of_money import AmountOfMoney


class PaymentOperation(DataObject):

    __amount_of_money: Optional[AmountOfMoney] = None
    __id: Optional[str] = None
    __status: Optional[str] = None
    __timestamp: Optional[str] = None
    __type: Optional[str] = None

    @property
    def amount_of_money(self) -> Optional[AmountOfMoney]:
        """
        | Object containing amount and ISO currency code attributes

        Type: :class:`worldline.connect.sdk.v1.domain.amount_of_money.AmountOfMoney`
        """
        return self.__amount_of_money

    @amount_of_money.setter
    def amount_of_money(self, value: Optional[AmountOfMoney]) -> None:
        self.__amount_of_money = value

    @property
    def id(self) -> Optional[str]:
        """
        | A unique identifier of the operation, generated by us.

        Type: str
        """
        return self.__id

    @id.setter
    def id(self, value: Optional[str]) -> None:
        self.__id = value

    @property
    def status(self) -> Optional[str]:
        """
        | Status of the operation. Possible values of a capture operation are:
        
        * CREATED
        * REJECTED
        * CANCELLED
        * CAPTURED
        * PAID
        * CHARGEBACKED
        * CHARGEBACK_NOTIFICATION
        
        
        
        | Possible values of a refund operation are:
        
        * CREATED
        * PENDING_CAPTURE
        * REJECTED
        * REFUNDED

        Type: str
        """
        return self.__status

    @status.setter
    def status(self, value: Optional[str]) -> None:
        self.__status = value

    @property
    def timestamp(self) -> Optional[str]:
        """
        | Date and time of the operation.Format: YYYYMMDDHH24MISS

        Type: str
        """
        return self.__timestamp

    @timestamp.setter
    def timestamp(self, value: Optional[str]) -> None:
        self.__timestamp = value

    @property
    def type(self) -> Optional[str]:
        """
        | The type of operation. Possible values are: 
        
        * capture
        * refund

        Type: str
        """
        return self.__type

    @type.setter
    def type(self, value: Optional[str]) -> None:
        self.__type = value

    def to_dictionary(self) -> dict:
        dictionary = super(PaymentOperation, self).to_dictionary()
        if self.amount_of_money is not None:
            dictionary['amountOfMoney'] = self.amount_of_money.to_dictionary()
        if self.id is not None:
            dictionary['id'] = self.id
        if self.status is not None:
            dictionary['status'] = self.status
        if self.timestamp is not None:
            dictionary['timestamp'] = self.timestamp
        if self.type is not None:
            dictionary['type'] = self.type
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'PaymentOperation':
        super(PaymentOperation, self).from_dictionary(dictionary)
        if 'amountOfMoney' in dictionary:
            if not isinstance(dictionary['amountOfMoney'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['amountOfMoney']))
            value = AmountOfMoney()
            self.amount_of_money = value.from_dictionary(dictionary['amountOfMoney'])
        if 'id' in dictionary:
            self.id = dictionary['id']
        if 'status' in dictionary:
            self.status = dictionary['status']
        if 'timestamp' in dictionary:
            self.timestamp = dictionary['timestamp']
        if 'type' in dictionary:
            self.type = dictionary['type']
        return self
