"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

To regenerate api.pb.go run hack/update-generated-runtime.sh
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Protocol:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ProtocolEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Protocol.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TCP: _Protocol.ValueType  # 0
    UDP: _Protocol.ValueType  # 1
    SCTP: _Protocol.ValueType  # 2

class Protocol(_Protocol, metaclass=_ProtocolEnumTypeWrapper): ...

TCP: Protocol.ValueType  # 0
UDP: Protocol.ValueType  # 1
SCTP: Protocol.ValueType  # 2
global___Protocol = Protocol

class _MountPropagation:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MountPropagationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MountPropagation.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PROPAGATION_PRIVATE: _MountPropagation.ValueType  # 0
    """No mount propagation ("private" in Linux terminology)."""
    PROPAGATION_HOST_TO_CONTAINER: _MountPropagation.ValueType  # 1
    """Mounts get propagated from the host to the container ("rslave" in Linux)."""
    PROPAGATION_BIDIRECTIONAL: _MountPropagation.ValueType  # 2
    """Mounts get propagated from the host to the container and from the
    container to the host ("rshared" in Linux).
    """

class MountPropagation(_MountPropagation, metaclass=_MountPropagationEnumTypeWrapper): ...

PROPAGATION_PRIVATE: MountPropagation.ValueType  # 0
"""No mount propagation ("private" in Linux terminology)."""
PROPAGATION_HOST_TO_CONTAINER: MountPropagation.ValueType  # 1
"""Mounts get propagated from the host to the container ("rslave" in Linux)."""
PROPAGATION_BIDIRECTIONAL: MountPropagation.ValueType  # 2
"""Mounts get propagated from the host to the container and from the
container to the host ("rshared" in Linux).
"""
global___MountPropagation = MountPropagation

class _NamespaceMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NamespaceModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NamespaceMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    POD: _NamespaceMode.ValueType  # 0
    """A POD namespace is common to all containers in a pod.
    For example, a container with a PID namespace of POD expects to view
    all of the processes in all of the containers in the pod.
    """
    CONTAINER: _NamespaceMode.ValueType  # 1
    """A CONTAINER namespace is restricted to a single container.
    For example, a container with a PID namespace of CONTAINER expects to
    view only the processes in that container.
    """
    NODE: _NamespaceMode.ValueType  # 2
    """A NODE namespace is the namespace of the Kubernetes node.
    For example, a container with a PID namespace of NODE expects to view
    all of the processes on the host running the kubelet.
    """
    TARGET: _NamespaceMode.ValueType  # 3
    """TARGET targets the namespace of another container. When this is specified,
    a target_id must be specified in NamespaceOption and refer to a container
    previously created with NamespaceMode CONTAINER. This containers namespace
    will be made to match that of container target_id.
    For example, a container with a PID namespace of TARGET expects to view
    all of the processes that container target_id can view.
    """

class NamespaceMode(_NamespaceMode, metaclass=_NamespaceModeEnumTypeWrapper):
    """A NamespaceMode describes the intended namespace configuration for each
    of the namespaces (Network, PID, IPC) in NamespaceOption. Runtimes should
    map these modes as appropriate for the technology underlying the runtime.
    """

POD: NamespaceMode.ValueType  # 0
"""A POD namespace is common to all containers in a pod.
For example, a container with a PID namespace of POD expects to view
all of the processes in all of the containers in the pod.
"""
CONTAINER: NamespaceMode.ValueType  # 1
"""A CONTAINER namespace is restricted to a single container.
For example, a container with a PID namespace of CONTAINER expects to
view only the processes in that container.
"""
NODE: NamespaceMode.ValueType  # 2
"""A NODE namespace is the namespace of the Kubernetes node.
For example, a container with a PID namespace of NODE expects to view
all of the processes on the host running the kubelet.
"""
TARGET: NamespaceMode.ValueType  # 3
"""TARGET targets the namespace of another container. When this is specified,
a target_id must be specified in NamespaceOption and refer to a container
previously created with NamespaceMode CONTAINER. This containers namespace
will be made to match that of container target_id.
For example, a container with a PID namespace of TARGET expects to view
all of the processes that container target_id can view.
"""
global___NamespaceMode = NamespaceMode

class _PodSandboxState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PodSandboxStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PodSandboxState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SANDBOX_READY: _PodSandboxState.ValueType  # 0
    SANDBOX_NOTREADY: _PodSandboxState.ValueType  # 1

class PodSandboxState(_PodSandboxState, metaclass=_PodSandboxStateEnumTypeWrapper): ...

SANDBOX_READY: PodSandboxState.ValueType  # 0
SANDBOX_NOTREADY: PodSandboxState.ValueType  # 1
global___PodSandboxState = PodSandboxState

class _ContainerState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ContainerStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ContainerState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CONTAINER_CREATED: _ContainerState.ValueType  # 0
    CONTAINER_RUNNING: _ContainerState.ValueType  # 1
    CONTAINER_EXITED: _ContainerState.ValueType  # 2
    CONTAINER_UNKNOWN: _ContainerState.ValueType  # 3

class ContainerState(_ContainerState, metaclass=_ContainerStateEnumTypeWrapper): ...

CONTAINER_CREATED: ContainerState.ValueType  # 0
CONTAINER_RUNNING: ContainerState.ValueType  # 1
CONTAINER_EXITED: ContainerState.ValueType  # 2
CONTAINER_UNKNOWN: ContainerState.ValueType  # 3
global___ContainerState = ContainerState

@typing_extensions.final
class VersionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of the kubelet runtime API."""
    def __init__(
        self,
        *,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["version", b"version"]) -> None: ...

global___VersionRequest = VersionRequest

@typing_extensions.final
class VersionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    RUNTIME_NAME_FIELD_NUMBER: builtins.int
    RUNTIME_VERSION_FIELD_NUMBER: builtins.int
    RUNTIME_API_VERSION_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of the kubelet runtime API."""
    runtime_name: builtins.str
    """Name of the container runtime."""
    runtime_version: builtins.str
    """Version of the container runtime. The string must be
    semver-compatible.
    """
    runtime_api_version: builtins.str
    """API version of the container runtime. The string must be
    semver-compatible.
    """
    def __init__(
        self,
        *,
        version: builtins.str = ...,
        runtime_name: builtins.str = ...,
        runtime_version: builtins.str = ...,
        runtime_api_version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["runtime_api_version", b"runtime_api_version", "runtime_name", b"runtime_name", "runtime_version", b"runtime_version", "version", b"version"]) -> None: ...

global___VersionResponse = VersionResponse

@typing_extensions.final
class DNSConfig(google.protobuf.message.Message):
    """DNSConfig specifies the DNS servers and search domains of a sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SERVERS_FIELD_NUMBER: builtins.int
    SEARCHES_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def servers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of DNS servers of the cluster."""
    @property
    def searches(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of DNS search domains of the cluster."""
    @property
    def options(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of DNS options. See https://linux.die.net/man/5/resolv.conf
        for all available options.
        """
    def __init__(
        self,
        *,
        servers: collections.abc.Iterable[builtins.str] | None = ...,
        searches: collections.abc.Iterable[builtins.str] | None = ...,
        options: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["options", b"options", "searches", b"searches", "servers", b"servers"]) -> None: ...

global___DNSConfig = DNSConfig

@typing_extensions.final
class PortMapping(google.protobuf.message.Message):
    """PortMapping specifies the port mapping configurations of a sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROTOCOL_FIELD_NUMBER: builtins.int
    CONTAINER_PORT_FIELD_NUMBER: builtins.int
    HOST_PORT_FIELD_NUMBER: builtins.int
    HOST_IP_FIELD_NUMBER: builtins.int
    protocol: global___Protocol.ValueType
    """Protocol of the port mapping."""
    container_port: builtins.int
    """Port number within the container. Default: 0 (not specified)."""
    host_port: builtins.int
    """Port number on the host. Default: 0 (not specified)."""
    host_ip: builtins.str
    """Host IP."""
    def __init__(
        self,
        *,
        protocol: global___Protocol.ValueType = ...,
        container_port: builtins.int = ...,
        host_port: builtins.int = ...,
        host_ip: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_port", b"container_port", "host_ip", b"host_ip", "host_port", b"host_port", "protocol", b"protocol"]) -> None: ...

global___PortMapping = PortMapping

@typing_extensions.final
class Mount(google.protobuf.message.Message):
    """Mount specifies a host volume to mount into a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_PATH_FIELD_NUMBER: builtins.int
    HOST_PATH_FIELD_NUMBER: builtins.int
    READONLY_FIELD_NUMBER: builtins.int
    SELINUX_RELABEL_FIELD_NUMBER: builtins.int
    PROPAGATION_FIELD_NUMBER: builtins.int
    container_path: builtins.str
    """Path of the mount within the container."""
    host_path: builtins.str
    """Path of the mount on the host. If the hostPath doesn't exist, then runtimes
    should report error. If the hostpath is a symbolic link, runtimes should
    follow the symlink and mount the real destination to container.
    """
    readonly: builtins.bool
    """If set, the mount is read-only."""
    selinux_relabel: builtins.bool
    """If set, the mount needs SELinux relabeling."""
    propagation: global___MountPropagation.ValueType
    """Requested propagation mode."""
    def __init__(
        self,
        *,
        container_path: builtins.str = ...,
        host_path: builtins.str = ...,
        readonly: builtins.bool = ...,
        selinux_relabel: builtins.bool = ...,
        propagation: global___MountPropagation.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_path", b"container_path", "host_path", b"host_path", "propagation", b"propagation", "readonly", b"readonly", "selinux_relabel", b"selinux_relabel"]) -> None: ...

global___Mount = Mount

@typing_extensions.final
class IDMapping(google.protobuf.message.Message):
    """IDMapping describes host to container ID mappings for a pod sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOST_ID_FIELD_NUMBER: builtins.int
    CONTAINER_ID_FIELD_NUMBER: builtins.int
    LENGTH_FIELD_NUMBER: builtins.int
    host_id: builtins.int
    """HostId is the id on the host."""
    container_id: builtins.int
    """ContainerId is the id in the container."""
    length: builtins.int
    """Length is the size of the range to map."""
    def __init__(
        self,
        *,
        host_id: builtins.int = ...,
        container_id: builtins.int = ...,
        length: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id", "host_id", b"host_id", "length", b"length"]) -> None: ...

global___IDMapping = IDMapping

@typing_extensions.final
class UserNamespace(google.protobuf.message.Message):
    """UserNamespace describes the intended user namespace configuration for a pod sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODE_FIELD_NUMBER: builtins.int
    UIDS_FIELD_NUMBER: builtins.int
    GIDS_FIELD_NUMBER: builtins.int
    mode: global___NamespaceMode.ValueType
    """Mode is the NamespaceMode for this UserNamespace.
    Note: NamespaceMode for UserNamespace currently supports only POD and NODE, not CONTAINER OR TARGET.
    """
    @property
    def uids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IDMapping]:
        """Uids specifies the UID mappings for the user namespace."""
    @property
    def gids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IDMapping]:
        """Gids specifies the GID mappings for the user namespace."""
    def __init__(
        self,
        *,
        mode: global___NamespaceMode.ValueType = ...,
        uids: collections.abc.Iterable[global___IDMapping] | None = ...,
        gids: collections.abc.Iterable[global___IDMapping] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["gids", b"gids", "mode", b"mode", "uids", b"uids"]) -> None: ...

global___UserNamespace = UserNamespace

@typing_extensions.final
class NamespaceOption(google.protobuf.message.Message):
    """NamespaceOption provides options for Linux namespaces."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_FIELD_NUMBER: builtins.int
    PID_FIELD_NUMBER: builtins.int
    IPC_FIELD_NUMBER: builtins.int
    TARGET_ID_FIELD_NUMBER: builtins.int
    USERNS_OPTIONS_FIELD_NUMBER: builtins.int
    network: global___NamespaceMode.ValueType
    """Network namespace for this container/sandbox.
    Note: There is currently no way to set CONTAINER scoped network in the Kubernetes API.
    Namespaces currently set by the kubelet: POD, NODE
    """
    pid: global___NamespaceMode.ValueType
    """PID namespace for this container/sandbox.
    Note: The CRI default is POD, but the v1.PodSpec default is CONTAINER.
    The kubelet's runtime manager will set this to CONTAINER explicitly for v1 pods.
    Namespaces currently set by the kubelet: POD, CONTAINER, NODE, TARGET
    """
    ipc: global___NamespaceMode.ValueType
    """IPC namespace for this container/sandbox.
    Note: There is currently no way to set CONTAINER scoped IPC in the Kubernetes API.
    Namespaces currently set by the kubelet: POD, NODE
    """
    target_id: builtins.str
    """Target Container ID for NamespaceMode of TARGET. This container must have been
    previously created in the same pod. It is not possible to specify different targets
    for each namespace.
    """
    @property
    def userns_options(self) -> global___UserNamespace:
        """UsernsOptions for this pod sandbox.
        The Kubelet picks the user namespace configuration to use for the pod sandbox.  The mappings
        are specified as part of the UserNamespace struct.  If the struct is nil, then the POD mode
        must be assumed.  This is done for backward compatibility with older Kubelet versions that
        do not set a user namespace.
        """
    def __init__(
        self,
        *,
        network: global___NamespaceMode.ValueType = ...,
        pid: global___NamespaceMode.ValueType = ...,
        ipc: global___NamespaceMode.ValueType = ...,
        target_id: builtins.str = ...,
        userns_options: global___UserNamespace | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["userns_options", b"userns_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["ipc", b"ipc", "network", b"network", "pid", b"pid", "target_id", b"target_id", "userns_options", b"userns_options"]) -> None: ...

global___NamespaceOption = NamespaceOption

@typing_extensions.final
class Int64Value(google.protobuf.message.Message):
    """Int64Value is the wrapper of int64."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.int
    """The value."""
    def __init__(
        self,
        *,
        value: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

global___Int64Value = Int64Value

@typing_extensions.final
class LinuxSandboxSecurityContext(google.protobuf.message.Message):
    """LinuxSandboxSecurityContext holds linux security configuration that will be
    applied to a sandbox. Note that:
    1) It does not apply to containers in the pods.
    2) It may not be applicable to a PodSandbox which does not contain any running
       process.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_OPTIONS_FIELD_NUMBER: builtins.int
    SELINUX_OPTIONS_FIELD_NUMBER: builtins.int
    RUN_AS_USER_FIELD_NUMBER: builtins.int
    RUN_AS_GROUP_FIELD_NUMBER: builtins.int
    READONLY_ROOTFS_FIELD_NUMBER: builtins.int
    SUPPLEMENTAL_GROUPS_FIELD_NUMBER: builtins.int
    PRIVILEGED_FIELD_NUMBER: builtins.int
    SECCOMP_FIELD_NUMBER: builtins.int
    APPARMOR_FIELD_NUMBER: builtins.int
    SECCOMP_PROFILE_PATH_FIELD_NUMBER: builtins.int
    @property
    def namespace_options(self) -> global___NamespaceOption:
        """Configurations for the sandbox's namespaces.
        This will be used only if the PodSandbox uses namespace for isolation.
        """
    @property
    def selinux_options(self) -> global___SELinuxOption:
        """Optional SELinux context to be applied."""
    @property
    def run_as_user(self) -> global___Int64Value:
        """UID to run sandbox processes as, when applicable."""
    @property
    def run_as_group(self) -> global___Int64Value:
        """GID to run sandbox processes as, when applicable. run_as_group should only
        be specified when run_as_user is specified; otherwise, the runtime MUST error.
        """
    readonly_rootfs: builtins.bool
    """If set, the root filesystem of the sandbox is read-only."""
    @property
    def supplemental_groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """List of groups applied to the first process run in the sandbox, in
        addition to the sandbox's primary GID.
        """
    privileged: builtins.bool
    """Indicates whether the sandbox will be asked to run a privileged
    container. If a privileged container is to be executed within it, this
    MUST be true.
    This allows a sandbox to take additional security precautions if no
    privileged containers are expected to be run.
    """
    @property
    def seccomp(self) -> global___SecurityProfile:
        """Seccomp profile for the sandbox."""
    @property
    def apparmor(self) -> global___SecurityProfile:
        """AppArmor profile for the sandbox."""
    seccomp_profile_path: builtins.str
    """Seccomp profile for the sandbox, candidate values are:
    * runtime/default: the default profile for the container runtime
    * unconfined: unconfined profile, ie, no seccomp sandboxing
    * localhost/<full-path-to-profile>: the profile installed on the node.
      <full-path-to-profile> is the full path of the profile.
    Default: "", which is identical with unconfined.
    """
    def __init__(
        self,
        *,
        namespace_options: global___NamespaceOption | None = ...,
        selinux_options: global___SELinuxOption | None = ...,
        run_as_user: global___Int64Value | None = ...,
        run_as_group: global___Int64Value | None = ...,
        readonly_rootfs: builtins.bool = ...,
        supplemental_groups: collections.abc.Iterable[builtins.int] | None = ...,
        privileged: builtins.bool = ...,
        seccomp: global___SecurityProfile | None = ...,
        apparmor: global___SecurityProfile | None = ...,
        seccomp_profile_path: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["apparmor", b"apparmor", "namespace_options", b"namespace_options", "run_as_group", b"run_as_group", "run_as_user", b"run_as_user", "seccomp", b"seccomp", "selinux_options", b"selinux_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["apparmor", b"apparmor", "namespace_options", b"namespace_options", "privileged", b"privileged", "readonly_rootfs", b"readonly_rootfs", "run_as_group", b"run_as_group", "run_as_user", b"run_as_user", "seccomp", b"seccomp", "seccomp_profile_path", b"seccomp_profile_path", "selinux_options", b"selinux_options", "supplemental_groups", b"supplemental_groups"]) -> None: ...

global___LinuxSandboxSecurityContext = LinuxSandboxSecurityContext

@typing_extensions.final
class SecurityProfile(google.protobuf.message.Message):
    """A security profile which can be used for sandboxes and containers."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ProfileType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProfileTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityProfile._ProfileType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RuntimeDefault: SecurityProfile._ProfileType.ValueType  # 0
        """The container runtime default profile should be used."""
        Unconfined: SecurityProfile._ProfileType.ValueType  # 1
        """Disable the feature for the sandbox or the container."""
        Localhost: SecurityProfile._ProfileType.ValueType  # 2
        """A pre-defined profile on the node should be used."""

    class ProfileType(_ProfileType, metaclass=_ProfileTypeEnumTypeWrapper):
        """Available profile types."""

    RuntimeDefault: SecurityProfile.ProfileType.ValueType  # 0
    """The container runtime default profile should be used."""
    Unconfined: SecurityProfile.ProfileType.ValueType  # 1
    """Disable the feature for the sandbox or the container."""
    Localhost: SecurityProfile.ProfileType.ValueType  # 2
    """A pre-defined profile on the node should be used."""

    PROFILE_TYPE_FIELD_NUMBER: builtins.int
    LOCALHOST_REF_FIELD_NUMBER: builtins.int
    profile_type: global___SecurityProfile.ProfileType.ValueType
    """Indicator which `ProfileType` should be applied."""
    localhost_ref: builtins.str
    """Indicates that a pre-defined profile on the node should be used.
    Must only be set if `ProfileType` is `Localhost`.
    For seccomp, it must be an absolute path to the seccomp profile.
    For AppArmor, this field is the AppArmor `<profile name>/`
    """
    def __init__(
        self,
        *,
        profile_type: global___SecurityProfile.ProfileType.ValueType = ...,
        localhost_ref: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["localhost_ref", b"localhost_ref", "profile_type", b"profile_type"]) -> None: ...

global___SecurityProfile = SecurityProfile

@typing_extensions.final
class LinuxPodSandboxConfig(google.protobuf.message.Message):
    """LinuxPodSandboxConfig holds platform-specific configurations for Linux
    host platforms and Linux-based containers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SysctlsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    CGROUP_PARENT_FIELD_NUMBER: builtins.int
    SECURITY_CONTEXT_FIELD_NUMBER: builtins.int
    SYSCTLS_FIELD_NUMBER: builtins.int
    OVERHEAD_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    cgroup_parent: builtins.str
    """Parent cgroup of the PodSandbox.
    The cgroupfs style syntax will be used, but the container runtime can
    convert it to systemd semantics if needed.
    """
    @property
    def security_context(self) -> global___LinuxSandboxSecurityContext:
        """LinuxSandboxSecurityContext holds sandbox security attributes."""
    @property
    def sysctls(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Sysctls holds linux sysctls config for the sandbox."""
    @property
    def overhead(self) -> global___LinuxContainerResources:
        """Optional overhead represents the overheads associated with this sandbox"""
    @property
    def resources(self) -> global___LinuxContainerResources:
        """Optional resources represents the sum of container resources for this sandbox"""
    def __init__(
        self,
        *,
        cgroup_parent: builtins.str = ...,
        security_context: global___LinuxSandboxSecurityContext | None = ...,
        sysctls: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        overhead: global___LinuxContainerResources | None = ...,
        resources: global___LinuxContainerResources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["overhead", b"overhead", "resources", b"resources", "security_context", b"security_context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cgroup_parent", b"cgroup_parent", "overhead", b"overhead", "resources", b"resources", "security_context", b"security_context", "sysctls", b"sysctls"]) -> None: ...

global___LinuxPodSandboxConfig = LinuxPodSandboxConfig

@typing_extensions.final
class PodSandboxMetadata(google.protobuf.message.Message):
    """PodSandboxMetadata holds all necessary information for building the sandbox name.
    The container runtime is encouraged to expose the metadata associated with the
    PodSandbox in its user interface for better user experience. For example,
    the runtime can construct a unique PodSandboxName based on the metadata.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pod name of the sandbox. Same as the pod name in the Pod ObjectMeta."""
    uid: builtins.str
    """Pod UID of the sandbox. Same as the pod UID in the Pod ObjectMeta."""
    namespace: builtins.str
    """Pod namespace of the sandbox. Same as the pod namespace in the Pod ObjectMeta."""
    attempt: builtins.int
    """Attempt number of creating the sandbox. Default: 0."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        namespace: builtins.str = ...,
        attempt: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["attempt", b"attempt", "name", b"name", "namespace", b"namespace", "uid", b"uid"]) -> None: ...

global___PodSandboxMetadata = PodSandboxMetadata

@typing_extensions.final
class PodSandboxConfig(google.protobuf.message.Message):
    """PodSandboxConfig holds all the required and optional fields for creating a
    sandbox.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    METADATA_FIELD_NUMBER: builtins.int
    HOSTNAME_FIELD_NUMBER: builtins.int
    LOG_DIRECTORY_FIELD_NUMBER: builtins.int
    DNS_CONFIG_FIELD_NUMBER: builtins.int
    PORT_MAPPINGS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> global___PodSandboxMetadata:
        """Metadata of the sandbox. This information will uniquely identify the
        sandbox, and the runtime should leverage this to ensure correct
        operation. The runtime may also use this information to improve UX, such
        as by constructing a readable name.
        """
    hostname: builtins.str
    """Hostname of the sandbox. Hostname could only be empty when the pod
    network namespace is NODE.
    """
    log_directory: builtins.str
    """Path to the directory on the host in which container log files are
    stored.
    By default the log of a container going into the LogDirectory will be
    hooked up to STDOUT and STDERR. However, the LogDirectory may contain
    binary log files with structured logging data from the individual
    containers. For example, the files might be newline separated JSON
    structured logs, systemd-journald journal files, gRPC trace files, etc.
    E.g.,
        PodSandboxConfig.LogDirectory = `/var/log/pods/<podUID>/`
        ContainerConfig.LogPath = `containerName/Instance#.log`
    """
    @property
    def dns_config(self) -> global___DNSConfig:
        """DNS config for the sandbox."""
    @property
    def port_mappings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PortMapping]:
        """Port mappings for the sandbox."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map that may be set by the kubelet to store and
        retrieve arbitrary metadata. This will include any annotations set on a
        pod through the Kubernetes API.

        Annotations MUST NOT be altered by the runtime; the annotations stored
        here MUST be returned in the PodSandboxStatus associated with the pod
        this PodSandboxConfig creates.

        In general, in order to preserve a well-defined interface between the
        kubelet and the container runtime, annotations SHOULD NOT influence
        runtime behaviour.

        Annotations can also be useful for runtime authors to experiment with
        new features that are opaque to the Kubernetes APIs (both user-facing
        and the CRI). Whenever possible, however, runtime authors SHOULD
        consider proposing new typed fields for any new features instead.
        """
    @property
    def linux(self) -> global___LinuxPodSandboxConfig:
        """Optional configurations specific to Linux hosts."""
    @property
    def windows(self) -> global___WindowsPodSandboxConfig:
        """Optional configurations specific to Windows hosts."""
    def __init__(
        self,
        *,
        metadata: global___PodSandboxMetadata | None = ...,
        hostname: builtins.str = ...,
        log_directory: builtins.str = ...,
        dns_config: global___DNSConfig | None = ...,
        port_mappings: collections.abc.Iterable[global___PortMapping] | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        linux: global___LinuxPodSandboxConfig | None = ...,
        windows: global___WindowsPodSandboxConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["dns_config", b"dns_config", "linux", b"linux", "metadata", b"metadata", "windows", b"windows"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "dns_config", b"dns_config", "hostname", b"hostname", "labels", b"labels", "linux", b"linux", "log_directory", b"log_directory", "metadata", b"metadata", "port_mappings", b"port_mappings", "windows", b"windows"]) -> None: ...

global___PodSandboxConfig = PodSandboxConfig

@typing_extensions.final
class RunPodSandboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    RUNTIME_HANDLER_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___PodSandboxConfig:
        """Configuration for creating a PodSandbox."""
    runtime_handler: builtins.str
    """Named runtime configuration to use for this PodSandbox.
    If the runtime handler is unknown, this request should be rejected.  An
    empty string should select the default handler, equivalent to the
    behavior before this feature was added.
    See https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
    """
    def __init__(
        self,
        *,
        config: global___PodSandboxConfig | None = ...,
        runtime_handler: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "runtime_handler", b"runtime_handler"]) -> None: ...

global___RunPodSandboxRequest = RunPodSandboxRequest

@typing_extensions.final
class RunPodSandboxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox to run."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pod_sandbox_id", b"pod_sandbox_id"]) -> None: ...

global___RunPodSandboxResponse = RunPodSandboxResponse

@typing_extensions.final
class StopPodSandboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox to stop."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pod_sandbox_id", b"pod_sandbox_id"]) -> None: ...

global___StopPodSandboxRequest = StopPodSandboxRequest

@typing_extensions.final
class StopPodSandboxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopPodSandboxResponse = StopPodSandboxResponse

@typing_extensions.final
class RemovePodSandboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox to remove."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pod_sandbox_id", b"pod_sandbox_id"]) -> None: ...

global___RemovePodSandboxRequest = RemovePodSandboxRequest

@typing_extensions.final
class RemovePodSandboxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemovePodSandboxResponse = RemovePodSandboxResponse

@typing_extensions.final
class PodSandboxStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    VERBOSE_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox for which to retrieve status."""
    verbose: builtins.bool
    """Verbose indicates whether to return extra information about the pod sandbox."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
        verbose: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pod_sandbox_id", b"pod_sandbox_id", "verbose", b"verbose"]) -> None: ...

global___PodSandboxStatusRequest = PodSandboxStatusRequest

@typing_extensions.final
class PodIP(google.protobuf.message.Message):
    """PodIP represents an ip of a Pod"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IP_FIELD_NUMBER: builtins.int
    ip: builtins.str
    """an ip is a string representation of an IPv4 or an IPv6"""
    def __init__(
        self,
        *,
        ip: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ip", b"ip"]) -> None: ...

global___PodIP = PodIP

@typing_extensions.final
class PodSandboxNetworkStatus(google.protobuf.message.Message):
    """PodSandboxNetworkStatus is the status of the network for a PodSandbox.
    Currently ignored for pods sharing the host networking namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IP_FIELD_NUMBER: builtins.int
    ADDITIONAL_IPS_FIELD_NUMBER: builtins.int
    ip: builtins.str
    """IP address of the PodSandbox."""
    @property
    def additional_ips(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PodIP]:
        """list of additional ips (not inclusive of PodSandboxNetworkStatus.Ip) of the PodSandBoxNetworkStatus"""
    def __init__(
        self,
        *,
        ip: builtins.str = ...,
        additional_ips: collections.abc.Iterable[global___PodIP] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["additional_ips", b"additional_ips", "ip", b"ip"]) -> None: ...

global___PodSandboxNetworkStatus = PodSandboxNetworkStatus

@typing_extensions.final
class Namespace(google.protobuf.message.Message):
    """Namespace contains paths to the namespaces."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> global___NamespaceOption:
        """Namespace options for Linux namespaces."""
    def __init__(
        self,
        *,
        options: global___NamespaceOption | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["options", b"options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["options", b"options"]) -> None: ...

global___Namespace = Namespace

@typing_extensions.final
class LinuxPodSandboxStatus(google.protobuf.message.Message):
    """LinuxSandboxStatus contains status specific to Linux sandboxes."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACES_FIELD_NUMBER: builtins.int
    @property
    def namespaces(self) -> global___Namespace:
        """Paths to the sandbox's namespaces."""
    def __init__(
        self,
        *,
        namespaces: global___Namespace | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["namespaces", b"namespaces"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespaces", b"namespaces"]) -> None: ...

global___LinuxPodSandboxStatus = LinuxPodSandboxStatus

@typing_extensions.final
class PodSandboxStatus(google.protobuf.message.Message):
    """PodSandboxStatus contains the status of the PodSandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    RUNTIME_HANDLER_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the sandbox."""
    @property
    def metadata(self) -> global___PodSandboxMetadata:
        """Metadata of the sandbox."""
    state: global___PodSandboxState.ValueType
    """State of the sandbox."""
    created_at: builtins.int
    """Creation timestamp of the sandbox in nanoseconds. Must be > 0."""
    @property
    def network(self) -> global___PodSandboxNetworkStatus:
        """Network contains network status if network is handled by the runtime."""
    @property
    def linux(self) -> global___LinuxPodSandboxStatus:
        """Linux-specific status to a pod sandbox."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels are key-value pairs that may be used to scope and select individual resources."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding PodSandboxConfig used to
        instantiate the pod sandbox this status represents.
        """
    runtime_handler: builtins.str
    """runtime configuration used for this PodSandbox."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___PodSandboxMetadata | None = ...,
        state: global___PodSandboxState.ValueType = ...,
        created_at: builtins.int = ...,
        network: global___PodSandboxNetworkStatus | None = ...,
        linux: global___LinuxPodSandboxStatus | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        runtime_handler: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["linux", b"linux", "metadata", b"metadata", "network", b"network"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "created_at", b"created_at", "id", b"id", "labels", b"labels", "linux", b"linux", "metadata", b"metadata", "network", b"network", "runtime_handler", b"runtime_handler", "state", b"state"]) -> None: ...

global___PodSandboxStatus = PodSandboxStatus

@typing_extensions.final
class PodSandboxStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class InfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> global___PodSandboxStatus:
        """Status of the PodSandbox."""
    @property
    def info(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Info is extra information of the PodSandbox. The key could be arbitrary string, and
        value should be in json format. The information could include anything useful for
        debug, e.g. network namespace for linux container based container runtime.
        It should only be returned non-empty when Verbose is true.
        """
    def __init__(
        self,
        *,
        status: global___PodSandboxStatus | None = ...,
        info: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["info", b"info", "status", b"status"]) -> None: ...

global___PodSandboxStatusResponse = PodSandboxStatusResponse

@typing_extensions.final
class PodSandboxStateValue(google.protobuf.message.Message):
    """PodSandboxStateValue is the wrapper of PodSandboxState."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___PodSandboxState.ValueType
    """State of the sandbox."""
    def __init__(
        self,
        *,
        state: global___PodSandboxState.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___PodSandboxStateValue = PodSandboxStateValue

@typing_extensions.final
class PodSandboxFilter(google.protobuf.message.Message):
    """PodSandboxFilter is used to filter a list of PodSandboxes.
    All those fields are combined with 'AND'
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelSelectorEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    LABEL_SELECTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the sandbox."""
    @property
    def state(self) -> global___PodSandboxStateValue:
        """State of the sandbox."""
    @property
    def label_selector(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """LabelSelector to select matches.
        Only api.MatchLabels is supported for now and the requirements
        are ANDed. MatchExpressions is not supported yet.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        state: global___PodSandboxStateValue | None = ...,
        label_selector: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "label_selector", b"label_selector", "state", b"state"]) -> None: ...

global___PodSandboxFilter = PodSandboxFilter

@typing_extensions.final
class ListPodSandboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___PodSandboxFilter:
        """PodSandboxFilter to filter a list of PodSandboxes."""
    def __init__(
        self,
        *,
        filter: global___PodSandboxFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> None: ...

global___ListPodSandboxRequest = ListPodSandboxRequest

@typing_extensions.final
class PodSandbox(google.protobuf.message.Message):
    """PodSandbox contains minimal information about a sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    RUNTIME_HANDLER_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the PodSandbox."""
    @property
    def metadata(self) -> global___PodSandboxMetadata:
        """Metadata of the PodSandbox."""
    state: global___PodSandboxState.ValueType
    """State of the PodSandbox."""
    created_at: builtins.int
    """Creation timestamps of the PodSandbox in nanoseconds. Must be > 0."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the PodSandbox."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding PodSandboxConfig used to
        instantiate this PodSandbox.
        """
    runtime_handler: builtins.str
    """runtime configuration used for this PodSandbox."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___PodSandboxMetadata | None = ...,
        state: global___PodSandboxState.ValueType = ...,
        created_at: builtins.int = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        runtime_handler: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "created_at", b"created_at", "id", b"id", "labels", b"labels", "metadata", b"metadata", "runtime_handler", b"runtime_handler", "state", b"state"]) -> None: ...

global___PodSandbox = PodSandbox

@typing_extensions.final
class ListPodSandboxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PodSandbox]:
        """List of PodSandboxes."""
    def __init__(
        self,
        *,
        items: collections.abc.Iterable[global___PodSandbox] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["items", b"items"]) -> None: ...

global___ListPodSandboxResponse = ListPodSandboxResponse

@typing_extensions.final
class PodSandboxStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the pod sandbox for which to retrieve stats."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pod_sandbox_id", b"pod_sandbox_id"]) -> None: ...

global___PodSandboxStatsRequest = PodSandboxStatsRequest

@typing_extensions.final
class PodSandboxStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_FIELD_NUMBER: builtins.int
    @property
    def stats(self) -> global___PodSandboxStats: ...
    def __init__(
        self,
        *,
        stats: global___PodSandboxStats | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> None: ...

global___PodSandboxStatsResponse = PodSandboxStatsResponse

@typing_extensions.final
class PodSandboxStatsFilter(google.protobuf.message.Message):
    """PodSandboxStatsFilter is used to filter the list of pod sandboxes to retrieve stats for.
    All those fields are combined with 'AND'.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelSelectorEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    LABEL_SELECTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the pod sandbox."""
    @property
    def label_selector(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """LabelSelector to select matches.
        Only api.MatchLabels is supported for now and the requirements
        are ANDed. MatchExpressions is not supported yet.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        label_selector: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "label_selector", b"label_selector"]) -> None: ...

global___PodSandboxStatsFilter = PodSandboxStatsFilter

@typing_extensions.final
class ListPodSandboxStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___PodSandboxStatsFilter:
        """Filter for the list request."""
    def __init__(
        self,
        *,
        filter: global___PodSandboxStatsFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> None: ...

global___ListPodSandboxStatsRequest = ListPodSandboxStatsRequest

@typing_extensions.final
class ListPodSandboxStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_FIELD_NUMBER: builtins.int
    @property
    def stats(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PodSandboxStats]:
        """Stats of the pod sandbox."""
    def __init__(
        self,
        *,
        stats: collections.abc.Iterable[global___PodSandboxStats] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> None: ...

global___ListPodSandboxStatsResponse = ListPodSandboxStatsResponse

@typing_extensions.final
class PodSandboxAttributes(google.protobuf.message.Message):
    """PodSandboxAttributes provides basic information of the pod sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the pod sandbox."""
    @property
    def metadata(self) -> global___PodSandboxMetadata:
        """Metadata of the pod sandbox."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding PodSandboxStatus used to
        instantiate the PodSandbox this status represents.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___PodSandboxMetadata | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "id", b"id", "labels", b"labels", "metadata", b"metadata"]) -> None: ...

global___PodSandboxAttributes = PodSandboxAttributes

@typing_extensions.final
class PodSandboxStats(google.protobuf.message.Message):
    """PodSandboxStats provides the resource usage statistics for a pod.
    The linux or windows field will be populated depending on the platform.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTRIBUTES_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    @property
    def attributes(self) -> global___PodSandboxAttributes:
        """Information of the pod."""
    @property
    def linux(self) -> global___LinuxPodSandboxStats:
        """Stats from linux."""
    @property
    def windows(self) -> global___WindowsPodSandboxStats:
        """Stats from windows."""
    def __init__(
        self,
        *,
        attributes: global___PodSandboxAttributes | None = ...,
        linux: global___LinuxPodSandboxStats | None = ...,
        windows: global___WindowsPodSandboxStats | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attributes", b"attributes", "linux", b"linux", "windows", b"windows"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attributes", b"attributes", "linux", b"linux", "windows", b"windows"]) -> None: ...

global___PodSandboxStats = PodSandboxStats

@typing_extensions.final
class LinuxPodSandboxStats(google.protobuf.message.Message):
    """LinuxPodSandboxStats provides the resource usage statistics for a pod sandbox on linux."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPU_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    PROCESS_FIELD_NUMBER: builtins.int
    CONTAINERS_FIELD_NUMBER: builtins.int
    @property
    def cpu(self) -> global___CpuUsage:
        """CPU usage gathered for the pod sandbox."""
    @property
    def memory(self) -> global___MemoryUsage:
        """Memory usage gathered for the pod sandbox."""
    @property
    def network(self) -> global___NetworkUsage:
        """Network usage gathered for the pod sandbox"""
    @property
    def process(self) -> global___ProcessUsage:
        """Stats pertaining to processes in the pod sandbox."""
    @property
    def containers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ContainerStats]:
        """Stats of containers in the measured pod sandbox."""
    def __init__(
        self,
        *,
        cpu: global___CpuUsage | None = ...,
        memory: global___MemoryUsage | None = ...,
        network: global___NetworkUsage | None = ...,
        process: global___ProcessUsage | None = ...,
        containers: collections.abc.Iterable[global___ContainerStats] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cpu", b"cpu", "memory", b"memory", "network", b"network", "process", b"process"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["containers", b"containers", "cpu", b"cpu", "memory", b"memory", "network", b"network", "process", b"process"]) -> None: ...

global___LinuxPodSandboxStats = LinuxPodSandboxStats

@typing_extensions.final
class WindowsPodSandboxStats(google.protobuf.message.Message):
    """WindowsPodSandboxStats provides the resource usage statistics for a pod sandbox on windows
    TODO: Add stats relevant to windows.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___WindowsPodSandboxStats = WindowsPodSandboxStats

@typing_extensions.final
class NetworkUsage(google.protobuf.message.Message):
    """NetworkUsage contains data about network resources."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    DEFAULT_INTERFACE_FIELD_NUMBER: builtins.int
    INTERFACES_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """The time at which these stats were updated."""
    @property
    def default_interface(self) -> global___NetworkInterfaceUsage:
        """Stats for the default network interface."""
    @property
    def interfaces(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetworkInterfaceUsage]:
        """Stats for all found network interfaces, excluding the default."""
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        default_interface: global___NetworkInterfaceUsage | None = ...,
        interfaces: collections.abc.Iterable[global___NetworkInterfaceUsage] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["default_interface", b"default_interface"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["default_interface", b"default_interface", "interfaces", b"interfaces", "timestamp", b"timestamp"]) -> None: ...

global___NetworkUsage = NetworkUsage

@typing_extensions.final
class NetworkInterfaceUsage(google.protobuf.message.Message):
    """NetworkInterfaceUsage contains resource value data about a network interface."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    RX_BYTES_FIELD_NUMBER: builtins.int
    RX_ERRORS_FIELD_NUMBER: builtins.int
    TX_BYTES_FIELD_NUMBER: builtins.int
    TX_ERRORS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the network interface."""
    @property
    def rx_bytes(self) -> global___UInt64Value:
        """Cumulative count of bytes received."""
    @property
    def rx_errors(self) -> global___UInt64Value:
        """Cumulative count of receive errors encountered."""
    @property
    def tx_bytes(self) -> global___UInt64Value:
        """Cumulative count of bytes transmitted."""
    @property
    def tx_errors(self) -> global___UInt64Value:
        """Cumulative count of transmit errors encountered."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        rx_bytes: global___UInt64Value | None = ...,
        rx_errors: global___UInt64Value | None = ...,
        tx_bytes: global___UInt64Value | None = ...,
        tx_errors: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["rx_bytes", b"rx_bytes", "rx_errors", b"rx_errors", "tx_bytes", b"tx_bytes", "tx_errors", b"tx_errors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "rx_bytes", b"rx_bytes", "rx_errors", b"rx_errors", "tx_bytes", b"tx_bytes", "tx_errors", b"tx_errors"]) -> None: ...

global___NetworkInterfaceUsage = NetworkInterfaceUsage

@typing_extensions.final
class ProcessUsage(google.protobuf.message.Message):
    """ProcessUsage are stats pertaining to processes."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    PROCESS_COUNT_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """The time at which these stats were updated."""
    @property
    def process_count(self) -> global___UInt64Value:
        """Number of processes."""
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        process_count: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["process_count", b"process_count"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["process_count", b"process_count", "timestamp", b"timestamp"]) -> None: ...

global___ProcessUsage = ProcessUsage

@typing_extensions.final
class ImageSpec(google.protobuf.message.Message):
    """ImageSpec is an internal representation of an image."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    IMAGE_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    image: builtins.str
    """Container's Image field (e.g. imageID or imageDigest)."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        ImageSpec Annotations can be used to help the runtime target specific
        images in multi-arch images.
        """
    def __init__(
        self,
        *,
        image: builtins.str = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "image", b"image"]) -> None: ...

global___ImageSpec = ImageSpec

@typing_extensions.final
class KeyValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    value: builtins.str
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

global___KeyValue = KeyValue

@typing_extensions.final
class LinuxContainerResources(google.protobuf.message.Message):
    """LinuxContainerResources specifies Linux specific configuration for
    resources.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class UnifiedEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    CPU_PERIOD_FIELD_NUMBER: builtins.int
    CPU_QUOTA_FIELD_NUMBER: builtins.int
    CPU_SHARES_FIELD_NUMBER: builtins.int
    MEMORY_LIMIT_IN_BYTES_FIELD_NUMBER: builtins.int
    OOM_SCORE_ADJ_FIELD_NUMBER: builtins.int
    CPUSET_CPUS_FIELD_NUMBER: builtins.int
    CPUSET_MEMS_FIELD_NUMBER: builtins.int
    HUGEPAGE_LIMITS_FIELD_NUMBER: builtins.int
    UNIFIED_FIELD_NUMBER: builtins.int
    MEMORY_SWAP_LIMIT_IN_BYTES_FIELD_NUMBER: builtins.int
    cpu_period: builtins.int
    """CPU CFS (Completely Fair Scheduler) period. Default: 0 (not specified)."""
    cpu_quota: builtins.int
    """CPU CFS (Completely Fair Scheduler) quota. Default: 0 (not specified)."""
    cpu_shares: builtins.int
    """CPU shares (relative weight vs. other containers). Default: 0 (not specified)."""
    memory_limit_in_bytes: builtins.int
    """Memory limit in bytes. Default: 0 (not specified)."""
    oom_score_adj: builtins.int
    """OOMScoreAdj adjusts the oom-killer score. Default: 0 (not specified)."""
    cpuset_cpus: builtins.str
    """CpusetCpus constrains the allowed set of logical CPUs. Default: "" (not specified)."""
    cpuset_mems: builtins.str
    """CpusetMems constrains the allowed set of memory nodes. Default: "" (not specified)."""
    @property
    def hugepage_limits(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HugepageLimit]:
        """List of HugepageLimits to limit the HugeTLB usage of container per page size. Default: nil (not specified)."""
    @property
    def unified(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unified resources for cgroup v2. Default: nil (not specified).
        Each key/value in the map refers to the cgroup v2.
        e.g. "memory.max": "6937202688" or "io.weight": "default 100".
        """
    memory_swap_limit_in_bytes: builtins.int
    """Memory swap limit in bytes. Default 0 (not specified)."""
    def __init__(
        self,
        *,
        cpu_period: builtins.int = ...,
        cpu_quota: builtins.int = ...,
        cpu_shares: builtins.int = ...,
        memory_limit_in_bytes: builtins.int = ...,
        oom_score_adj: builtins.int = ...,
        cpuset_cpus: builtins.str = ...,
        cpuset_mems: builtins.str = ...,
        hugepage_limits: collections.abc.Iterable[global___HugepageLimit] | None = ...,
        unified: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        memory_swap_limit_in_bytes: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpu_period", b"cpu_period", "cpu_quota", b"cpu_quota", "cpu_shares", b"cpu_shares", "cpuset_cpus", b"cpuset_cpus", "cpuset_mems", b"cpuset_mems", "hugepage_limits", b"hugepage_limits", "memory_limit_in_bytes", b"memory_limit_in_bytes", "memory_swap_limit_in_bytes", b"memory_swap_limit_in_bytes", "oom_score_adj", b"oom_score_adj", "unified", b"unified"]) -> None: ...

global___LinuxContainerResources = LinuxContainerResources

@typing_extensions.final
class HugepageLimit(google.protobuf.message.Message):
    """HugepageLimit corresponds to the file`hugetlb.<hugepagesize>.limit_in_byte` in container level cgroup.
    For example, `PageSize=1GB`, `Limit=1073741824` means setting `1073741824` bytes to hugetlb.1GB.limit_in_bytes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    page_size: builtins.str
    """The value of PageSize has the format <size><unit-prefix>B (2MB, 1GB),
    and must match the <hugepagesize> of the corresponding control file found in `hugetlb.<hugepagesize>.limit_in_bytes`.
    The values of <unit-prefix> are intended to be parsed using base 1024("1KB" = 1024, "1MB" = 1048576, etc).
    """
    limit: builtins.int
    """limit in bytes of hugepagesize HugeTLB usage."""
    def __init__(
        self,
        *,
        page_size: builtins.str = ...,
        limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["limit", b"limit", "page_size", b"page_size"]) -> None: ...

global___HugepageLimit = HugepageLimit

@typing_extensions.final
class SELinuxOption(google.protobuf.message.Message):
    """SELinuxOption are the labels to be applied to the container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LEVEL_FIELD_NUMBER: builtins.int
    user: builtins.str
    role: builtins.str
    type: builtins.str
    level: builtins.str
    def __init__(
        self,
        *,
        user: builtins.str = ...,
        role: builtins.str = ...,
        type: builtins.str = ...,
        level: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["level", b"level", "role", b"role", "type", b"type", "user", b"user"]) -> None: ...

global___SELinuxOption = SELinuxOption

@typing_extensions.final
class Capability(google.protobuf.message.Message):
    """Capability contains the container capabilities to add or drop
    Dropping a capability will drop it from all sets.
    If a capability is added to only the add_capabilities list then it gets added to permitted,
    inheritable, effective and bounding sets, i.e. all sets except the ambient set.
    If a capability is added to only the add_ambient_capabilities list then it gets added to all sets, i.e permitted
    inheritable, effective, bounding and ambient sets.
    If a capability is added to add_capabilities and add_ambient_capabilities lists then it gets added to all sets, i.e.
    permitted, inheritable, effective, bounding and ambient sets.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADD_CAPABILITIES_FIELD_NUMBER: builtins.int
    DROP_CAPABILITIES_FIELD_NUMBER: builtins.int
    ADD_AMBIENT_CAPABILITIES_FIELD_NUMBER: builtins.int
    @property
    def add_capabilities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of capabilities to add."""
    @property
    def drop_capabilities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of capabilities to drop."""
    @property
    def add_ambient_capabilities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of ambient capabilities to add."""
    def __init__(
        self,
        *,
        add_capabilities: collections.abc.Iterable[builtins.str] | None = ...,
        drop_capabilities: collections.abc.Iterable[builtins.str] | None = ...,
        add_ambient_capabilities: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["add_ambient_capabilities", b"add_ambient_capabilities", "add_capabilities", b"add_capabilities", "drop_capabilities", b"drop_capabilities"]) -> None: ...

global___Capability = Capability

@typing_extensions.final
class LinuxContainerSecurityContext(google.protobuf.message.Message):
    """LinuxContainerSecurityContext holds linux security configuration that will be applied to a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAPABILITIES_FIELD_NUMBER: builtins.int
    PRIVILEGED_FIELD_NUMBER: builtins.int
    NAMESPACE_OPTIONS_FIELD_NUMBER: builtins.int
    SELINUX_OPTIONS_FIELD_NUMBER: builtins.int
    RUN_AS_USER_FIELD_NUMBER: builtins.int
    RUN_AS_GROUP_FIELD_NUMBER: builtins.int
    RUN_AS_USERNAME_FIELD_NUMBER: builtins.int
    READONLY_ROOTFS_FIELD_NUMBER: builtins.int
    SUPPLEMENTAL_GROUPS_FIELD_NUMBER: builtins.int
    NO_NEW_PRIVS_FIELD_NUMBER: builtins.int
    MASKED_PATHS_FIELD_NUMBER: builtins.int
    READONLY_PATHS_FIELD_NUMBER: builtins.int
    SECCOMP_FIELD_NUMBER: builtins.int
    APPARMOR_FIELD_NUMBER: builtins.int
    APPARMOR_PROFILE_FIELD_NUMBER: builtins.int
    SECCOMP_PROFILE_PATH_FIELD_NUMBER: builtins.int
    @property
    def capabilities(self) -> global___Capability:
        """Capabilities to add or drop."""
    privileged: builtins.bool
    """If set, run container in privileged mode.
    Privileged mode is incompatible with the following options. If
    privileged is set, the following features MAY have no effect:
    1. capabilities
    2. selinux_options
    4. seccomp
    5. apparmor

    Privileged mode implies the following specific options are applied:
    1. All capabilities are added.
    2. Sensitive paths, such as kernel module paths within sysfs, are not masked.
    3. Any sysfs and procfs mounts are mounted RW.
    4. AppArmor confinement is not applied.
    5. Seccomp restrictions are not applied.
    6. The device cgroup does not restrict access to any devices.
    7. All devices from the host's /dev are available within the container.
    8. SELinux restrictions are not applied (e.g. label=disabled).
    """
    @property
    def namespace_options(self) -> global___NamespaceOption:
        """Configurations for the container's namespaces.
        Only used if the container uses namespace for isolation.
        """
    @property
    def selinux_options(self) -> global___SELinuxOption:
        """SELinux context to be optionally applied."""
    @property
    def run_as_user(self) -> global___Int64Value:
        """UID to run the container process as. Only one of run_as_user and
        run_as_username can be specified at a time.
        """
    @property
    def run_as_group(self) -> global___Int64Value:
        """GID to run the container process as. run_as_group should only be specified
        when run_as_user or run_as_username is specified; otherwise, the runtime
        MUST error.
        """
    run_as_username: builtins.str
    """User name to run the container process as. If specified, the user MUST
    exist in the container image (i.e. in the /etc/passwd inside the image),
    and be resolved there by the runtime; otherwise, the runtime MUST error.
    """
    readonly_rootfs: builtins.bool
    """If set, the root filesystem of the container is read-only."""
    @property
    def supplemental_groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """List of groups applied to the first process run in the container, in
        addition to the container's primary GID.
        """
    no_new_privs: builtins.bool
    """no_new_privs defines if the flag for no_new_privs should be set on the
    container.
    """
    @property
    def masked_paths(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """masked_paths is a slice of paths that should be masked by the container
        runtime, this can be passed directly to the OCI spec.
        """
    @property
    def readonly_paths(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """readonly_paths is a slice of paths that should be set as readonly by the
        container runtime, this can be passed directly to the OCI spec.
        """
    @property
    def seccomp(self) -> global___SecurityProfile:
        """Seccomp profile for the container."""
    @property
    def apparmor(self) -> global___SecurityProfile:
        """AppArmor profile for the container."""
    apparmor_profile: builtins.str
    """AppArmor profile for the container, candidate values are:
    * runtime/default: equivalent to not specifying a profile.
    * unconfined: no profiles are loaded
    * localhost/<profile_name>: profile loaded on the node
       (localhost) by name. The possible profile names are detailed at
       https://gitlab.com/apparmor/apparmor/-/wikis/AppArmor_Core_Policy_Reference
    """
    seccomp_profile_path: builtins.str
    """Seccomp profile for the container, candidate values are:
    * runtime/default: the default profile for the container runtime
    * unconfined: unconfined profile, ie, no seccomp sandboxing
    * localhost/<full-path-to-profile>: the profile installed on the node.
      <full-path-to-profile> is the full path of the profile.
    Default: "", which is identical with unconfined.
    """
    def __init__(
        self,
        *,
        capabilities: global___Capability | None = ...,
        privileged: builtins.bool = ...,
        namespace_options: global___NamespaceOption | None = ...,
        selinux_options: global___SELinuxOption | None = ...,
        run_as_user: global___Int64Value | None = ...,
        run_as_group: global___Int64Value | None = ...,
        run_as_username: builtins.str = ...,
        readonly_rootfs: builtins.bool = ...,
        supplemental_groups: collections.abc.Iterable[builtins.int] | None = ...,
        no_new_privs: builtins.bool = ...,
        masked_paths: collections.abc.Iterable[builtins.str] | None = ...,
        readonly_paths: collections.abc.Iterable[builtins.str] | None = ...,
        seccomp: global___SecurityProfile | None = ...,
        apparmor: global___SecurityProfile | None = ...,
        apparmor_profile: builtins.str = ...,
        seccomp_profile_path: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["apparmor", b"apparmor", "capabilities", b"capabilities", "namespace_options", b"namespace_options", "run_as_group", b"run_as_group", "run_as_user", b"run_as_user", "seccomp", b"seccomp", "selinux_options", b"selinux_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["apparmor", b"apparmor", "apparmor_profile", b"apparmor_profile", "capabilities", b"capabilities", "masked_paths", b"masked_paths", "namespace_options", b"namespace_options", "no_new_privs", b"no_new_privs", "privileged", b"privileged", "readonly_paths", b"readonly_paths", "readonly_rootfs", b"readonly_rootfs", "run_as_group", b"run_as_group", "run_as_user", b"run_as_user", "run_as_username", b"run_as_username", "seccomp", b"seccomp", "seccomp_profile_path", b"seccomp_profile_path", "selinux_options", b"selinux_options", "supplemental_groups", b"supplemental_groups"]) -> None: ...

global___LinuxContainerSecurityContext = LinuxContainerSecurityContext

@typing_extensions.final
class LinuxContainerConfig(google.protobuf.message.Message):
    """LinuxContainerConfig contains platform-specific configuration for
    Linux-based containers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    SECURITY_CONTEXT_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___LinuxContainerResources:
        """Resources specification for the container."""
    @property
    def security_context(self) -> global___LinuxContainerSecurityContext:
        """LinuxContainerSecurityContext configuration for the container."""
    def __init__(
        self,
        *,
        resources: global___LinuxContainerResources | None = ...,
        security_context: global___LinuxContainerSecurityContext | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resources", b"resources", "security_context", b"security_context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["resources", b"resources", "security_context", b"security_context"]) -> None: ...

global___LinuxContainerConfig = LinuxContainerConfig

@typing_extensions.final
class WindowsSandboxSecurityContext(google.protobuf.message.Message):
    """WindowsSandboxSecurityContext holds platform-specific configurations that will be
    applied to a sandbox.
    These settings will only apply to the sandbox container.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_AS_USERNAME_FIELD_NUMBER: builtins.int
    CREDENTIAL_SPEC_FIELD_NUMBER: builtins.int
    HOST_PROCESS_FIELD_NUMBER: builtins.int
    run_as_username: builtins.str
    """User name to run the container process as. If specified, the user MUST
    exist in the container image and be resolved there by the runtime;
    otherwise, the runtime MUST return error.
    """
    credential_spec: builtins.str
    """The contents of the GMSA credential spec to use to run this container."""
    host_process: builtins.bool
    """Indicates whether the container requested to run as a HostProcess container."""
    def __init__(
        self,
        *,
        run_as_username: builtins.str = ...,
        credential_spec: builtins.str = ...,
        host_process: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["credential_spec", b"credential_spec", "host_process", b"host_process", "run_as_username", b"run_as_username"]) -> None: ...

global___WindowsSandboxSecurityContext = WindowsSandboxSecurityContext

@typing_extensions.final
class WindowsPodSandboxConfig(google.protobuf.message.Message):
    """WindowsPodSandboxConfig holds platform-specific configurations for Windows
    host platforms and Windows-based containers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_CONTEXT_FIELD_NUMBER: builtins.int
    @property
    def security_context(self) -> global___WindowsSandboxSecurityContext:
        """WindowsSandboxSecurityContext holds sandbox security attributes."""
    def __init__(
        self,
        *,
        security_context: global___WindowsSandboxSecurityContext | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["security_context", b"security_context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["security_context", b"security_context"]) -> None: ...

global___WindowsPodSandboxConfig = WindowsPodSandboxConfig

@typing_extensions.final
class WindowsContainerSecurityContext(google.protobuf.message.Message):
    """WindowsContainerSecurityContext holds windows security configuration that will be applied to a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_AS_USERNAME_FIELD_NUMBER: builtins.int
    CREDENTIAL_SPEC_FIELD_NUMBER: builtins.int
    HOST_PROCESS_FIELD_NUMBER: builtins.int
    run_as_username: builtins.str
    """User name to run the container process as. If specified, the user MUST
    exist in the container image and be resolved there by the runtime;
    otherwise, the runtime MUST return error.
    """
    credential_spec: builtins.str
    """The contents of the GMSA credential spec to use to run this container."""
    host_process: builtins.bool
    """Indicates whether a container is to be run as a HostProcess container."""
    def __init__(
        self,
        *,
        run_as_username: builtins.str = ...,
        credential_spec: builtins.str = ...,
        host_process: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["credential_spec", b"credential_spec", "host_process", b"host_process", "run_as_username", b"run_as_username"]) -> None: ...

global___WindowsContainerSecurityContext = WindowsContainerSecurityContext

@typing_extensions.final
class WindowsContainerConfig(google.protobuf.message.Message):
    """WindowsContainerConfig contains platform-specific configuration for
    Windows-based containers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    SECURITY_CONTEXT_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___WindowsContainerResources:
        """Resources specification for the container."""
    @property
    def security_context(self) -> global___WindowsContainerSecurityContext:
        """WindowsContainerSecurityContext configuration for the container."""
    def __init__(
        self,
        *,
        resources: global___WindowsContainerResources | None = ...,
        security_context: global___WindowsContainerSecurityContext | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resources", b"resources", "security_context", b"security_context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["resources", b"resources", "security_context", b"security_context"]) -> None: ...

global___WindowsContainerConfig = WindowsContainerConfig

@typing_extensions.final
class WindowsContainerResources(google.protobuf.message.Message):
    """WindowsContainerResources specifies Windows specific configuration for
    resources.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPU_SHARES_FIELD_NUMBER: builtins.int
    CPU_COUNT_FIELD_NUMBER: builtins.int
    CPU_MAXIMUM_FIELD_NUMBER: builtins.int
    MEMORY_LIMIT_IN_BYTES_FIELD_NUMBER: builtins.int
    ROOTFS_SIZE_IN_BYTES_FIELD_NUMBER: builtins.int
    cpu_shares: builtins.int
    """CPU shares (relative weight vs. other containers). Default: 0 (not specified)."""
    cpu_count: builtins.int
    """Number of CPUs available to the container. Default: 0 (not specified)."""
    cpu_maximum: builtins.int
    """Specifies the portion of processor cycles that this container can use as a percentage times 100."""
    memory_limit_in_bytes: builtins.int
    """Memory limit in bytes. Default: 0 (not specified)."""
    rootfs_size_in_bytes: builtins.int
    """Specifies the size of the rootfs / scratch space in bytes to be configured for this container. Default: 0 (not specified)."""
    def __init__(
        self,
        *,
        cpu_shares: builtins.int = ...,
        cpu_count: builtins.int = ...,
        cpu_maximum: builtins.int = ...,
        memory_limit_in_bytes: builtins.int = ...,
        rootfs_size_in_bytes: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpu_count", b"cpu_count", "cpu_maximum", b"cpu_maximum", "cpu_shares", b"cpu_shares", "memory_limit_in_bytes", b"memory_limit_in_bytes", "rootfs_size_in_bytes", b"rootfs_size_in_bytes"]) -> None: ...

global___WindowsContainerResources = WindowsContainerResources

@typing_extensions.final
class ContainerMetadata(google.protobuf.message.Message):
    """ContainerMetadata holds all necessary information for building the container
    name. The container runtime is encouraged to expose the metadata in its user
    interface for better user experience. E.g., runtime can construct a unique
    container name based on the metadata. Note that (name, attempt) is unique
    within a sandbox for the entire lifetime of the sandbox.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the container. Same as the container name in the PodSpec."""
    attempt: builtins.int
    """Attempt number of creating the container. Default: 0."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        attempt: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["attempt", b"attempt", "name", b"name"]) -> None: ...

global___ContainerMetadata = ContainerMetadata

@typing_extensions.final
class Device(google.protobuf.message.Message):
    """Device specifies a host device to mount into a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_PATH_FIELD_NUMBER: builtins.int
    HOST_PATH_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    container_path: builtins.str
    """Path of the device within the container."""
    host_path: builtins.str
    """Path of the device on the host."""
    permissions: builtins.str
    """Cgroups permissions of the device, candidates are one or more of
    * r - allows container to read from the specified device.
    * w - allows container to write to the specified device.
    * m - allows container to create device files that do not yet exist.
    """
    def __init__(
        self,
        *,
        container_path: builtins.str = ...,
        host_path: builtins.str = ...,
        permissions: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_path", b"container_path", "host_path", b"host_path", "permissions", b"permissions"]) -> None: ...

global___Device = Device

@typing_extensions.final
class ContainerConfig(google.protobuf.message.Message):
    """ContainerConfig holds all the required and optional fields for creating a
    container.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    METADATA_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    COMMAND_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    WORKING_DIR_FIELD_NUMBER: builtins.int
    ENVS_FIELD_NUMBER: builtins.int
    MOUNTS_FIELD_NUMBER: builtins.int
    DEVICES_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    LOG_PATH_FIELD_NUMBER: builtins.int
    STDIN_FIELD_NUMBER: builtins.int
    STDIN_ONCE_FIELD_NUMBER: builtins.int
    TTY_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> global___ContainerMetadata:
        """Metadata of the container. This information will uniquely identify the
        container, and the runtime should leverage this to ensure correct
        operation. The runtime may also use this information to improve UX, such
        as by constructing a readable name.
        """
    @property
    def image(self) -> global___ImageSpec:
        """Image to use."""
    @property
    def command(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Command to execute (i.e., entrypoint for docker)"""
    @property
    def args(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Args for the Command (i.e., command for docker)"""
    working_dir: builtins.str
    """Current working directory of the command."""
    @property
    def envs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___KeyValue]:
        """List of environment variable to set in the container."""
    @property
    def mounts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Mount]:
        """Mounts for the container."""
    @property
    def devices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Device]:
        """Devices for the container."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources.
        Label keys are of the form:
            label-key ::= prefixed-name | name
            prefixed-name ::= prefix '/' name
            prefix ::= DNS_SUBDOMAIN
            name ::= DNS_LABEL
        """
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map that may be used by the kubelet to store and
        retrieve arbitrary metadata.

        Annotations MUST NOT be altered by the runtime; the annotations stored
        here MUST be returned in the ContainerStatus associated with the container
        this ContainerConfig creates.

        In general, in order to preserve a well-defined interface between the
        kubelet and the container runtime, annotations SHOULD NOT influence
        runtime behaviour.
        """
    log_path: builtins.str
    """Path relative to PodSandboxConfig.LogDirectory for container to store
    the log (STDOUT and STDERR) on the host.
    E.g.,
        PodSandboxConfig.LogDirectory = `/var/log/pods/<podUID>/`
        ContainerConfig.LogPath = `containerName/Instance#.log`

    WARNING: Log management and how kubelet should interface with the
    container logs are under active discussion in
    https://issues.k8s.io/24677. There *may* be future change of direction
    for logging as the discussion carries on.
    """
    stdin: builtins.bool
    """Variables for interactive containers, these have very specialized
    use-cases (e.g. debugging).
    """
    stdin_once: builtins.bool
    tty: builtins.bool
    @property
    def linux(self) -> global___LinuxContainerConfig:
        """Configuration specific to Linux containers."""
    @property
    def windows(self) -> global___WindowsContainerConfig:
        """Configuration specific to Windows containers."""
    def __init__(
        self,
        *,
        metadata: global___ContainerMetadata | None = ...,
        image: global___ImageSpec | None = ...,
        command: collections.abc.Iterable[builtins.str] | None = ...,
        args: collections.abc.Iterable[builtins.str] | None = ...,
        working_dir: builtins.str = ...,
        envs: collections.abc.Iterable[global___KeyValue] | None = ...,
        mounts: collections.abc.Iterable[global___Mount] | None = ...,
        devices: collections.abc.Iterable[global___Device] | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        log_path: builtins.str = ...,
        stdin: builtins.bool = ...,
        stdin_once: builtins.bool = ...,
        tty: builtins.bool = ...,
        linux: global___LinuxContainerConfig | None = ...,
        windows: global___WindowsContainerConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["image", b"image", "linux", b"linux", "metadata", b"metadata", "windows", b"windows"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "args", b"args", "command", b"command", "devices", b"devices", "envs", b"envs", "image", b"image", "labels", b"labels", "linux", b"linux", "log_path", b"log_path", "metadata", b"metadata", "mounts", b"mounts", "stdin", b"stdin", "stdin_once", b"stdin_once", "tty", b"tty", "windows", b"windows", "working_dir", b"working_dir"]) -> None: ...

global___ContainerConfig = ContainerConfig

@typing_extensions.final
class CreateContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    SANDBOX_CONFIG_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox in which the container should be created."""
    @property
    def config(self) -> global___ContainerConfig:
        """Config of the container."""
    @property
    def sandbox_config(self) -> global___PodSandboxConfig:
        """Config of the PodSandbox. This is the same config that was passed
        to RunPodSandboxRequest to create the PodSandbox. It is passed again
        here just for easy reference. The PodSandboxConfig is immutable and
        remains the same throughout the lifetime of the pod.
        """
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
        config: global___ContainerConfig | None = ...,
        sandbox_config: global___PodSandboxConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config", "sandbox_config", b"sandbox_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "pod_sandbox_id", b"pod_sandbox_id", "sandbox_config", b"sandbox_config"]) -> None: ...

global___CreateContainerRequest = CreateContainerRequest

@typing_extensions.final
class CreateContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the created container."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id"]) -> None: ...

global___CreateContainerResponse = CreateContainerResponse

@typing_extensions.final
class StartContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to start."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id"]) -> None: ...

global___StartContainerRequest = StartContainerRequest

@typing_extensions.final
class StartContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StartContainerResponse = StartContainerResponse

@typing_extensions.final
class StopContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to stop."""
    timeout: builtins.int
    """Timeout in seconds to wait for the container to stop before forcibly
    terminating it. Default: 0 (forcibly terminate the container immediately)
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id", "timeout", b"timeout"]) -> None: ...

global___StopContainerRequest = StopContainerRequest

@typing_extensions.final
class StopContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopContainerResponse = StopContainerResponse

@typing_extensions.final
class RemoveContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to remove."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id"]) -> None: ...

global___RemoveContainerRequest = RemoveContainerRequest

@typing_extensions.final
class RemoveContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoveContainerResponse = RemoveContainerResponse

@typing_extensions.final
class ContainerStateValue(google.protobuf.message.Message):
    """ContainerStateValue is the wrapper of ContainerState."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___ContainerState.ValueType
    """State of the container."""
    def __init__(
        self,
        *,
        state: global___ContainerState.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___ContainerStateValue = ContainerStateValue

@typing_extensions.final
class ContainerFilter(google.protobuf.message.Message):
    """ContainerFilter is used to filter containers.
    All those fields are combined with 'AND'
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelSelectorEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    LABEL_SELECTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container."""
    @property
    def state(self) -> global___ContainerStateValue:
        """State of the container."""
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox."""
    @property
    def label_selector(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """LabelSelector to select matches.
        Only api.MatchLabels is supported for now and the requirements
        are ANDed. MatchExpressions is not supported yet.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        state: global___ContainerStateValue | None = ...,
        pod_sandbox_id: builtins.str = ...,
        label_selector: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "label_selector", b"label_selector", "pod_sandbox_id", b"pod_sandbox_id", "state", b"state"]) -> None: ...

global___ContainerFilter = ContainerFilter

@typing_extensions.final
class ListContainersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ContainerFilter: ...
    def __init__(
        self,
        *,
        filter: global___ContainerFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> None: ...

global___ListContainersRequest = ListContainersRequest

@typing_extensions.final
class Container(google.protobuf.message.Message):
    """Container provides the runtime information for a container, such as ID, hash,
    state of the container.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    IMAGE_REF_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container, used by the container runtime to identify
    a container.
    """
    pod_sandbox_id: builtins.str
    """ID of the sandbox to which this container belongs."""
    @property
    def metadata(self) -> global___ContainerMetadata:
        """Metadata of the container."""
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""
    image_ref: builtins.str
    """Reference to the image in use. For most runtimes, this should be an
    image ID.
    """
    state: global___ContainerState.ValueType
    """State of the container."""
    created_at: builtins.int
    """Creation time of the container in nanoseconds."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding ContainerConfig used to
        instantiate this Container.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        pod_sandbox_id: builtins.str = ...,
        metadata: global___ContainerMetadata | None = ...,
        image: global___ImageSpec | None = ...,
        image_ref: builtins.str = ...,
        state: global___ContainerState.ValueType = ...,
        created_at: builtins.int = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["image", b"image", "metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "created_at", b"created_at", "id", b"id", "image", b"image", "image_ref", b"image_ref", "labels", b"labels", "metadata", b"metadata", "pod_sandbox_id", b"pod_sandbox_id", "state", b"state"]) -> None: ...

global___Container = Container

@typing_extensions.final
class ListContainersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINERS_FIELD_NUMBER: builtins.int
    @property
    def containers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Container]:
        """List of containers."""
    def __init__(
        self,
        *,
        containers: collections.abc.Iterable[global___Container] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["containers", b"containers"]) -> None: ...

global___ListContainersResponse = ListContainersResponse

@typing_extensions.final
class ContainerStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    VERBOSE_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container for which to retrieve status."""
    verbose: builtins.bool
    """Verbose indicates whether to return extra information about the container."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        verbose: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id", "verbose", b"verbose"]) -> None: ...

global___ContainerStatusRequest = ContainerStatusRequest

@typing_extensions.final
class ContainerStatus(google.protobuf.message.Message):
    """ContainerStatus represents the status of a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    FINISHED_AT_FIELD_NUMBER: builtins.int
    EXIT_CODE_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    IMAGE_REF_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    MOUNTS_FIELD_NUMBER: builtins.int
    LOG_PATH_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container."""
    @property
    def metadata(self) -> global___ContainerMetadata:
        """Metadata of the container."""
    state: global___ContainerState.ValueType
    """Status of the container."""
    created_at: builtins.int
    """Creation time of the container in nanoseconds."""
    started_at: builtins.int
    """Start time of the container in nanoseconds. Default: 0 (not specified)."""
    finished_at: builtins.int
    """Finish time of the container in nanoseconds. Default: 0 (not specified)."""
    exit_code: builtins.int
    """Exit code of the container. Only required when finished_at != 0. Default: 0."""
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""
    image_ref: builtins.str
    """Reference to the image in use. For most runtimes, this should be an
    image ID
    """
    reason: builtins.str
    """Brief CamelCase string explaining why container is in its current state."""
    message: builtins.str
    """Human-readable message indicating details about why container is in its
    current state.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding ContainerConfig used to
        instantiate the Container this status represents.
        """
    @property
    def mounts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Mount]:
        """Mounts for the container."""
    log_path: builtins.str
    """Log path of container."""
    @property
    def resources(self) -> global___ContainerResources:
        """Resource limits configuration of the container."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___ContainerMetadata | None = ...,
        state: global___ContainerState.ValueType = ...,
        created_at: builtins.int = ...,
        started_at: builtins.int = ...,
        finished_at: builtins.int = ...,
        exit_code: builtins.int = ...,
        image: global___ImageSpec | None = ...,
        image_ref: builtins.str = ...,
        reason: builtins.str = ...,
        message: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        mounts: collections.abc.Iterable[global___Mount] | None = ...,
        log_path: builtins.str = ...,
        resources: global___ContainerResources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["image", b"image", "metadata", b"metadata", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "created_at", b"created_at", "exit_code", b"exit_code", "finished_at", b"finished_at", "id", b"id", "image", b"image", "image_ref", b"image_ref", "labels", b"labels", "log_path", b"log_path", "message", b"message", "metadata", b"metadata", "mounts", b"mounts", "reason", b"reason", "resources", b"resources", "started_at", b"started_at", "state", b"state"]) -> None: ...

global___ContainerStatus = ContainerStatus

@typing_extensions.final
class ContainerStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class InfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> global___ContainerStatus:
        """Status of the container."""
    @property
    def info(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Info is extra information of the Container. The key could be arbitrary string, and
        value should be in json format. The information could include anything useful for
        debug, e.g. pid for linux container based container runtime.
        It should only be returned non-empty when Verbose is true.
        """
    def __init__(
        self,
        *,
        status: global___ContainerStatus | None = ...,
        info: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["info", b"info", "status", b"status"]) -> None: ...

global___ContainerStatusResponse = ContainerStatusResponse

@typing_extensions.final
class ContainerResources(google.protobuf.message.Message):
    """ContainerResources holds resource limits configuration for a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    @property
    def linux(self) -> global___LinuxContainerResources:
        """Resource limits configuration specific to Linux container."""
    @property
    def windows(self) -> global___WindowsContainerResources:
        """Resource limits configuration specific to Windows container."""
    def __init__(
        self,
        *,
        linux: global___LinuxContainerResources | None = ...,
        windows: global___WindowsContainerResources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["linux", b"linux", "windows", b"windows"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["linux", b"linux", "windows", b"windows"]) -> None: ...

global___ContainerResources = ContainerResources

@typing_extensions.final
class UpdateContainerResourcesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to update."""
    @property
    def linux(self) -> global___LinuxContainerResources:
        """Resource configuration specific to Linux containers."""
    @property
    def windows(self) -> global___WindowsContainerResources:
        """Resource configuration specific to Windows containers."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary additional information for
        container resources updating. This can be used for specifying experimental
        resources to update or other options to use when updating the container.
        """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        linux: global___LinuxContainerResources | None = ...,
        windows: global___WindowsContainerResources | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["linux", b"linux", "windows", b"windows"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "container_id", b"container_id", "linux", b"linux", "windows", b"windows"]) -> None: ...

global___UpdateContainerResourcesRequest = UpdateContainerResourcesRequest

@typing_extensions.final
class UpdateContainerResourcesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateContainerResourcesResponse = UpdateContainerResourcesResponse

@typing_extensions.final
class ExecSyncRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    CMD_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container."""
    @property
    def cmd(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Command to execute."""
    timeout: builtins.int
    """Timeout in seconds to stop the command. Default: 0 (run forever)."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        cmd: collections.abc.Iterable[builtins.str] | None = ...,
        timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cmd", b"cmd", "container_id", b"container_id", "timeout", b"timeout"]) -> None: ...

global___ExecSyncRequest = ExecSyncRequest

@typing_extensions.final
class ExecSyncResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STDOUT_FIELD_NUMBER: builtins.int
    STDERR_FIELD_NUMBER: builtins.int
    EXIT_CODE_FIELD_NUMBER: builtins.int
    stdout: builtins.bytes
    """Captured command stdout output."""
    stderr: builtins.bytes
    """Captured command stderr output."""
    exit_code: builtins.int
    """Exit code the command finished with. Default: 0 (success)."""
    def __init__(
        self,
        *,
        stdout: builtins.bytes = ...,
        stderr: builtins.bytes = ...,
        exit_code: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["exit_code", b"exit_code", "stderr", b"stderr", "stdout", b"stdout"]) -> None: ...

global___ExecSyncResponse = ExecSyncResponse

@typing_extensions.final
class ExecRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    CMD_FIELD_NUMBER: builtins.int
    TTY_FIELD_NUMBER: builtins.int
    STDIN_FIELD_NUMBER: builtins.int
    STDOUT_FIELD_NUMBER: builtins.int
    STDERR_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container in which to execute the command."""
    @property
    def cmd(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Command to execute."""
    tty: builtins.bool
    """Whether to exec the command in a TTY."""
    stdin: builtins.bool
    """Whether to stream stdin.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    """
    stdout: builtins.bool
    """Whether to stream stdout.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    """
    stderr: builtins.bool
    """Whether to stream stderr.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
    in this case. The output of stdout and stderr will be combined to a
    single stream.
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        cmd: collections.abc.Iterable[builtins.str] | None = ...,
        tty: builtins.bool = ...,
        stdin: builtins.bool = ...,
        stdout: builtins.bool = ...,
        stderr: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cmd", b"cmd", "container_id", b"container_id", "stderr", b"stderr", "stdin", b"stdin", "stdout", b"stdout", "tty", b"tty"]) -> None: ...

global___ExecRequest = ExecRequest

@typing_extensions.final
class ExecResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """Fully qualified URL of the exec streaming server."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["url", b"url"]) -> None: ...

global___ExecResponse = ExecResponse

@typing_extensions.final
class AttachRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    STDIN_FIELD_NUMBER: builtins.int
    TTY_FIELD_NUMBER: builtins.int
    STDOUT_FIELD_NUMBER: builtins.int
    STDERR_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to which to attach."""
    stdin: builtins.bool
    """Whether to stream stdin.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    """
    tty: builtins.bool
    """Whether the process being attached is running in a TTY.
    This must match the TTY setting in the ContainerConfig.
    """
    stdout: builtins.bool
    """Whether to stream stdout.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    """
    stderr: builtins.bool
    """Whether to stream stderr.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
    in this case. The output of stdout and stderr will be combined to a
    single stream.
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        stdin: builtins.bool = ...,
        tty: builtins.bool = ...,
        stdout: builtins.bool = ...,
        stderr: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id", "stderr", b"stderr", "stdin", b"stdin", "stdout", b"stdout", "tty", b"tty"]) -> None: ...

global___AttachRequest = AttachRequest

@typing_extensions.final
class AttachResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """Fully qualified URL of the attach streaming server."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["url", b"url"]) -> None: ...

global___AttachResponse = AttachResponse

@typing_extensions.final
class PortForwardRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the container to which to forward the port."""
    @property
    def port(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Port to forward."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
        port: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pod_sandbox_id", b"pod_sandbox_id", "port", b"port"]) -> None: ...

global___PortForwardRequest = PortForwardRequest

@typing_extensions.final
class PortForwardResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """Fully qualified URL of the port-forward streaming server."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["url", b"url"]) -> None: ...

global___PortForwardResponse = PortForwardResponse

@typing_extensions.final
class ImageFilter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""
    def __init__(
        self,
        *,
        image: global___ImageSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["image", b"image"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["image", b"image"]) -> None: ...

global___ImageFilter = ImageFilter

@typing_extensions.final
class ListImagesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ImageFilter:
        """Filter to list images."""
    def __init__(
        self,
        *,
        filter: global___ImageFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> None: ...

global___ListImagesRequest = ListImagesRequest

@typing_extensions.final
class Image(google.protobuf.message.Message):
    """Basic information about a container image."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    REPO_TAGS_FIELD_NUMBER: builtins.int
    REPO_DIGESTS_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    PINNED_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the image."""
    @property
    def repo_tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Other names by which this image is known."""
    @property
    def repo_digests(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Digests by which this image is known."""
    size: builtins.int
    """Size of the image in bytes. Must be > 0."""
    @property
    def uid(self) -> global___Int64Value:
        """UID that will run the command(s). This is used as a default if no user is
        specified when creating the container. UID and the following user name
        are mutually exclusive.
        """
    username: builtins.str
    """User name that will run the command(s). This is used if UID is not set
    and no user is specified when creating container.
    """
    @property
    def spec(self) -> global___ImageSpec:
        """ImageSpec for image which includes annotations"""
    pinned: builtins.bool
    """Recommendation on whether this image should be exempt from garbage collection.
    It must only be treated as a recommendation -- the client can still request that the image be deleted,
    and the runtime must oblige.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        repo_tags: collections.abc.Iterable[builtins.str] | None = ...,
        repo_digests: collections.abc.Iterable[builtins.str] | None = ...,
        size: builtins.int = ...,
        uid: global___Int64Value | None = ...,
        username: builtins.str = ...,
        spec: global___ImageSpec | None = ...,
        pinned: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec", "uid", b"uid"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "pinned", b"pinned", "repo_digests", b"repo_digests", "repo_tags", b"repo_tags", "size", b"size", "spec", b"spec", "uid", b"uid", "username", b"username"]) -> None: ...

global___Image = Image

@typing_extensions.final
class ListImagesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGES_FIELD_NUMBER: builtins.int
    @property
    def images(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Image]:
        """List of images."""
    def __init__(
        self,
        *,
        images: collections.abc.Iterable[global___Image] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["images", b"images"]) -> None: ...

global___ListImagesResponse = ListImagesResponse

@typing_extensions.final
class ImageStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    VERBOSE_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""
    verbose: builtins.bool
    """Verbose indicates whether to return extra information about the image."""
    def __init__(
        self,
        *,
        image: global___ImageSpec | None = ...,
        verbose: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["image", b"image"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["image", b"image", "verbose", b"verbose"]) -> None: ...

global___ImageStatusRequest = ImageStatusRequest

@typing_extensions.final
class ImageStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class InfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    IMAGE_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___Image:
        """Status of the image."""
    @property
    def info(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Info is extra information of the Image. The key could be arbitrary string, and
        value should be in json format. The information could include anything useful
        for debug, e.g. image config for oci image based container runtime.
        It should only be returned non-empty when Verbose is true.
        """
    def __init__(
        self,
        *,
        image: global___Image | None = ...,
        info: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["image", b"image"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["image", b"image", "info", b"info"]) -> None: ...

global___ImageStatusResponse = ImageStatusResponse

@typing_extensions.final
class AuthConfig(google.protobuf.message.Message):
    """AuthConfig contains authorization information for connecting to a registry."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERNAME_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    AUTH_FIELD_NUMBER: builtins.int
    SERVER_ADDRESS_FIELD_NUMBER: builtins.int
    IDENTITY_TOKEN_FIELD_NUMBER: builtins.int
    REGISTRY_TOKEN_FIELD_NUMBER: builtins.int
    username: builtins.str
    password: builtins.str
    auth: builtins.str
    server_address: builtins.str
    identity_token: builtins.str
    """IdentityToken is used to authenticate the user and get
    an access token for the registry.
    """
    registry_token: builtins.str
    """RegistryToken is a bearer token to be sent to a registry"""
    def __init__(
        self,
        *,
        username: builtins.str = ...,
        password: builtins.str = ...,
        auth: builtins.str = ...,
        server_address: builtins.str = ...,
        identity_token: builtins.str = ...,
        registry_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth", b"auth", "identity_token", b"identity_token", "password", b"password", "registry_token", b"registry_token", "server_address", b"server_address", "username", b"username"]) -> None: ...

global___AuthConfig = AuthConfig

@typing_extensions.final
class PullImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    AUTH_FIELD_NUMBER: builtins.int
    SANDBOX_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""
    @property
    def auth(self) -> global___AuthConfig:
        """Authentication configuration for pulling the image."""
    @property
    def sandbox_config(self) -> global___PodSandboxConfig:
        """Config of the PodSandbox, which is used to pull image in PodSandbox context."""
    def __init__(
        self,
        *,
        image: global___ImageSpec | None = ...,
        auth: global___AuthConfig | None = ...,
        sandbox_config: global___PodSandboxConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auth", b"auth", "image", b"image", "sandbox_config", b"sandbox_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auth", b"auth", "image", b"image", "sandbox_config", b"sandbox_config"]) -> None: ...

global___PullImageRequest = PullImageRequest

@typing_extensions.final
class PullImageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_REF_FIELD_NUMBER: builtins.int
    image_ref: builtins.str
    """Reference to the image in use. For most runtimes, this should be an
    image ID or digest.
    """
    def __init__(
        self,
        *,
        image_ref: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["image_ref", b"image_ref"]) -> None: ...

global___PullImageResponse = PullImageResponse

@typing_extensions.final
class RemoveImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image to remove."""
    def __init__(
        self,
        *,
        image: global___ImageSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["image", b"image"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["image", b"image"]) -> None: ...

global___RemoveImageRequest = RemoveImageRequest

@typing_extensions.final
class RemoveImageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoveImageResponse = RemoveImageResponse

@typing_extensions.final
class NetworkConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_CIDR_FIELD_NUMBER: builtins.int
    pod_cidr: builtins.str
    """CIDR to use for pod IP addresses. If the CIDR is empty, runtimes
    should omit it.
    """
    def __init__(
        self,
        *,
        pod_cidr: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pod_cidr", b"pod_cidr"]) -> None: ...

global___NetworkConfig = NetworkConfig

@typing_extensions.final
class RuntimeConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def network_config(self) -> global___NetworkConfig: ...
    def __init__(
        self,
        *,
        network_config: global___NetworkConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["network_config", b"network_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["network_config", b"network_config"]) -> None: ...

global___RuntimeConfig = RuntimeConfig

@typing_extensions.final
class UpdateRuntimeConfigRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUNTIME_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def runtime_config(self) -> global___RuntimeConfig: ...
    def __init__(
        self,
        *,
        runtime_config: global___RuntimeConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["runtime_config", b"runtime_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["runtime_config", b"runtime_config"]) -> None: ...

global___UpdateRuntimeConfigRequest = UpdateRuntimeConfigRequest

@typing_extensions.final
class UpdateRuntimeConfigResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateRuntimeConfigResponse = UpdateRuntimeConfigResponse

@typing_extensions.final
class RuntimeCondition(google.protobuf.message.Message):
    """RuntimeCondition contains condition information for the runtime.
    There are 2 kinds of runtime conditions:
    1. Required conditions: Conditions are required for kubelet to work
    properly. If any required condition is unmet, the node will be not ready.
    The required conditions include:
      * RuntimeReady: RuntimeReady means the runtime is up and ready to accept
      basic containers e.g. container only needs host network.
      * NetworkReady: NetworkReady means the runtime network is up and ready to
      accept containers which require container network.
    2. Optional conditions: Conditions are informative to the user, but kubelet
    will not rely on. Since condition type is an arbitrary string, all conditions
    not required are optional. These conditions will be exposed to users to help
    them understand the status of the system.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    type: builtins.str
    """Type of runtime condition."""
    status: builtins.bool
    """Status of the condition, one of true/false. Default: false."""
    reason: builtins.str
    """Brief CamelCase string containing reason for the condition's last transition."""
    message: builtins.str
    """Human-readable message indicating details about last transition."""
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        status: builtins.bool = ...,
        reason: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "reason", b"reason", "status", b"status", "type", b"type"]) -> None: ...

global___RuntimeCondition = RuntimeCondition

@typing_extensions.final
class RuntimeStatus(google.protobuf.message.Message):
    """RuntimeStatus is information about the current status of the runtime."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONDITIONS_FIELD_NUMBER: builtins.int
    @property
    def conditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RuntimeCondition]:
        """List of current observed runtime conditions."""
    def __init__(
        self,
        *,
        conditions: collections.abc.Iterable[global___RuntimeCondition] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["conditions", b"conditions"]) -> None: ...

global___RuntimeStatus = RuntimeStatus

@typing_extensions.final
class StatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERBOSE_FIELD_NUMBER: builtins.int
    verbose: builtins.bool
    """Verbose indicates whether to return extra information about the runtime."""
    def __init__(
        self,
        *,
        verbose: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["verbose", b"verbose"]) -> None: ...

global___StatusRequest = StatusRequest

@typing_extensions.final
class StatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class InfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> global___RuntimeStatus:
        """Status of the Runtime."""
    @property
    def info(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Info is extra information of the Runtime. The key could be arbitrary string, and
        value should be in json format. The information could include anything useful for
        debug, e.g. plugins used by the container runtime.
        It should only be returned non-empty when Verbose is true.
        """
    def __init__(
        self,
        *,
        status: global___RuntimeStatus | None = ...,
        info: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["info", b"info", "status", b"status"]) -> None: ...

global___StatusResponse = StatusResponse

@typing_extensions.final
class ImageFsInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ImageFsInfoRequest = ImageFsInfoRequest

@typing_extensions.final
class UInt64Value(google.protobuf.message.Message):
    """UInt64Value is the wrapper of uint64."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.int
    """The value."""
    def __init__(
        self,
        *,
        value: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

global___UInt64Value = UInt64Value

@typing_extensions.final
class FilesystemIdentifier(google.protobuf.message.Message):
    """FilesystemIdentifier uniquely identify the filesystem."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MOUNTPOINT_FIELD_NUMBER: builtins.int
    mountpoint: builtins.str
    """Mountpoint of a filesystem."""
    def __init__(
        self,
        *,
        mountpoint: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["mountpoint", b"mountpoint"]) -> None: ...

global___FilesystemIdentifier = FilesystemIdentifier

@typing_extensions.final
class FilesystemUsage(google.protobuf.message.Message):
    """FilesystemUsage provides the filesystem usage information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    FS_ID_FIELD_NUMBER: builtins.int
    USED_BYTES_FIELD_NUMBER: builtins.int
    INODES_USED_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def fs_id(self) -> global___FilesystemIdentifier:
        """The unique identifier of the filesystem."""
    @property
    def used_bytes(self) -> global___UInt64Value:
        """UsedBytes represents the bytes used for images on the filesystem.
        This may differ from the total bytes used on the filesystem and may not
        equal CapacityBytes - AvailableBytes.
        """
    @property
    def inodes_used(self) -> global___UInt64Value:
        """InodesUsed represents the inodes used by the images.
        This may not equal InodesCapacity - InodesAvailable because the underlying
        filesystem may also be used for purposes other than storing images.
        """
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        fs_id: global___FilesystemIdentifier | None = ...,
        used_bytes: global___UInt64Value | None = ...,
        inodes_used: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["fs_id", b"fs_id", "inodes_used", b"inodes_used", "used_bytes", b"used_bytes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["fs_id", b"fs_id", "inodes_used", b"inodes_used", "timestamp", b"timestamp", "used_bytes", b"used_bytes"]) -> None: ...

global___FilesystemUsage = FilesystemUsage

@typing_extensions.final
class ImageFsInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FILESYSTEMS_FIELD_NUMBER: builtins.int
    @property
    def image_filesystems(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FilesystemUsage]:
        """Information of image filesystem(s)."""
    def __init__(
        self,
        *,
        image_filesystems: collections.abc.Iterable[global___FilesystemUsage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["image_filesystems", b"image_filesystems"]) -> None: ...

global___ImageFsInfoResponse = ImageFsInfoResponse

@typing_extensions.final
class ContainerStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container for which to retrieve stats."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id"]) -> None: ...

global___ContainerStatsRequest = ContainerStatsRequest

@typing_extensions.final
class ContainerStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_FIELD_NUMBER: builtins.int
    @property
    def stats(self) -> global___ContainerStats:
        """Stats of the container."""
    def __init__(
        self,
        *,
        stats: global___ContainerStats | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> None: ...

global___ContainerStatsResponse = ContainerStatsResponse

@typing_extensions.final
class ListContainerStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ContainerStatsFilter:
        """Filter for the list request."""
    def __init__(
        self,
        *,
        filter: global___ContainerStatsFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> None: ...

global___ListContainerStatsRequest = ListContainerStatsRequest

@typing_extensions.final
class ContainerStatsFilter(google.protobuf.message.Message):
    """ContainerStatsFilter is used to filter containers.
    All those fields are combined with 'AND'
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelSelectorEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    LABEL_SELECTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container."""
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox."""
    @property
    def label_selector(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """LabelSelector to select matches.
        Only api.MatchLabels is supported for now and the requirements
        are ANDed. MatchExpressions is not supported yet.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        pod_sandbox_id: builtins.str = ...,
        label_selector: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "label_selector", b"label_selector", "pod_sandbox_id", b"pod_sandbox_id"]) -> None: ...

global___ContainerStatsFilter = ContainerStatsFilter

@typing_extensions.final
class ListContainerStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_FIELD_NUMBER: builtins.int
    @property
    def stats(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ContainerStats]:
        """Stats of the container."""
    def __init__(
        self,
        *,
        stats: collections.abc.Iterable[global___ContainerStats] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["stats", b"stats"]) -> None: ...

global___ListContainerStatsResponse = ListContainerStatsResponse

@typing_extensions.final
class ContainerAttributes(google.protobuf.message.Message):
    """ContainerAttributes provides basic information of the container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container."""
    @property
    def metadata(self) -> global___ContainerMetadata:
        """Metadata of the container."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding ContainerConfig used to
        instantiate the Container this status represents.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___ContainerMetadata | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "id", b"id", "labels", b"labels", "metadata", b"metadata"]) -> None: ...

global___ContainerAttributes = ContainerAttributes

@typing_extensions.final
class ContainerStats(google.protobuf.message.Message):
    """ContainerStats provides the resource usage statistics for a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTRIBUTES_FIELD_NUMBER: builtins.int
    CPU_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    WRITABLE_LAYER_FIELD_NUMBER: builtins.int
    @property
    def attributes(self) -> global___ContainerAttributes:
        """Information of the container."""
    @property
    def cpu(self) -> global___CpuUsage:
        """CPU usage gathered from the container."""
    @property
    def memory(self) -> global___MemoryUsage:
        """Memory usage gathered from the container."""
    @property
    def writable_layer(self) -> global___FilesystemUsage:
        """Usage of the writable layer."""
    def __init__(
        self,
        *,
        attributes: global___ContainerAttributes | None = ...,
        cpu: global___CpuUsage | None = ...,
        memory: global___MemoryUsage | None = ...,
        writable_layer: global___FilesystemUsage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attributes", b"attributes", "cpu", b"cpu", "memory", b"memory", "writable_layer", b"writable_layer"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attributes", b"attributes", "cpu", b"cpu", "memory", b"memory", "writable_layer", b"writable_layer"]) -> None: ...

global___ContainerStats = ContainerStats

@typing_extensions.final
class CpuUsage(google.protobuf.message.Message):
    """CpuUsage provides the CPU usage information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    USAGE_CORE_NANO_SECONDS_FIELD_NUMBER: builtins.int
    USAGE_NANO_CORES_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def usage_core_nano_seconds(self) -> global___UInt64Value:
        """Cumulative CPU usage (sum across all cores) since object creation."""
    @property
    def usage_nano_cores(self) -> global___UInt64Value:
        """Total CPU usage (sum of all cores) averaged over the sample window.
        The "core" unit can be interpreted as CPU core-nanoseconds per second.
        """
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        usage_core_nano_seconds: global___UInt64Value | None = ...,
        usage_nano_cores: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["usage_core_nano_seconds", b"usage_core_nano_seconds", "usage_nano_cores", b"usage_nano_cores"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["timestamp", b"timestamp", "usage_core_nano_seconds", b"usage_core_nano_seconds", "usage_nano_cores", b"usage_nano_cores"]) -> None: ...

global___CpuUsage = CpuUsage

@typing_extensions.final
class MemoryUsage(google.protobuf.message.Message):
    """MemoryUsage provides the memory usage information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    WORKING_SET_BYTES_FIELD_NUMBER: builtins.int
    AVAILABLE_BYTES_FIELD_NUMBER: builtins.int
    USAGE_BYTES_FIELD_NUMBER: builtins.int
    RSS_BYTES_FIELD_NUMBER: builtins.int
    PAGE_FAULTS_FIELD_NUMBER: builtins.int
    MAJOR_PAGE_FAULTS_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def working_set_bytes(self) -> global___UInt64Value:
        """The amount of working set memory in bytes."""
    @property
    def available_bytes(self) -> global___UInt64Value:
        """Available memory for use. This is defined as the memory limit - workingSetBytes."""
    @property
    def usage_bytes(self) -> global___UInt64Value:
        """Total memory in use. This includes all memory regardless of when it was accessed."""
    @property
    def rss_bytes(self) -> global___UInt64Value:
        """The amount of anonymous and swap cache memory (includes transparent hugepages)."""
    @property
    def page_faults(self) -> global___UInt64Value:
        """Cumulative number of minor page faults."""
    @property
    def major_page_faults(self) -> global___UInt64Value:
        """Cumulative number of major page faults."""
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        working_set_bytes: global___UInt64Value | None = ...,
        available_bytes: global___UInt64Value | None = ...,
        usage_bytes: global___UInt64Value | None = ...,
        rss_bytes: global___UInt64Value | None = ...,
        page_faults: global___UInt64Value | None = ...,
        major_page_faults: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["available_bytes", b"available_bytes", "major_page_faults", b"major_page_faults", "page_faults", b"page_faults", "rss_bytes", b"rss_bytes", "usage_bytes", b"usage_bytes", "working_set_bytes", b"working_set_bytes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["available_bytes", b"available_bytes", "major_page_faults", b"major_page_faults", "page_faults", b"page_faults", "rss_bytes", b"rss_bytes", "timestamp", b"timestamp", "usage_bytes", b"usage_bytes", "working_set_bytes", b"working_set_bytes"]) -> None: ...

global___MemoryUsage = MemoryUsage

@typing_extensions.final
class ReopenContainerLogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container for which to reopen the log."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id"]) -> None: ...

global___ReopenContainerLogRequest = ReopenContainerLogRequest

@typing_extensions.final
class ReopenContainerLogResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ReopenContainerLogResponse = ReopenContainerLogResponse
