"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

To regenerate api.pb.go run `hack/update-codegen.sh protobindings`
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Protocol:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ProtocolEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Protocol.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TCP: _Protocol.ValueType  # 0
    UDP: _Protocol.ValueType  # 1
    SCTP: _Protocol.ValueType  # 2

class Protocol(_Protocol, metaclass=_ProtocolEnumTypeWrapper): ...

TCP: Protocol.ValueType  # 0
UDP: Protocol.ValueType  # 1
SCTP: Protocol.ValueType  # 2
global___Protocol = Protocol

class _MountPropagation:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MountPropagationEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _MountPropagation.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PROPAGATION_PRIVATE: _MountPropagation.ValueType  # 0
    """No mount propagation ("rprivate" in Linux terminology)."""
    PROPAGATION_HOST_TO_CONTAINER: _MountPropagation.ValueType  # 1
    """Mounts get propagated from the host to the container ("rslave" in Linux)."""
    PROPAGATION_BIDIRECTIONAL: _MountPropagation.ValueType  # 2
    """Mounts get propagated from the host to the container and from the
    container to the host ("rshared" in Linux).
    """

class MountPropagation(
    _MountPropagation, metaclass=_MountPropagationEnumTypeWrapper
): ...

PROPAGATION_PRIVATE: MountPropagation.ValueType  # 0
"""No mount propagation ("rprivate" in Linux terminology)."""
PROPAGATION_HOST_TO_CONTAINER: MountPropagation.ValueType  # 1
"""Mounts get propagated from the host to the container ("rslave" in Linux)."""
PROPAGATION_BIDIRECTIONAL: MountPropagation.ValueType  # 2
"""Mounts get propagated from the host to the container and from the
container to the host ("rshared" in Linux).
"""
global___MountPropagation = MountPropagation

class _NamespaceMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NamespaceModeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _NamespaceMode.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    POD: _NamespaceMode.ValueType  # 0
    """A POD namespace is common to all containers in a pod.
    For example, a container with a PID namespace of POD expects to view
    all of the processes in all of the containers in the pod.
    """
    CONTAINER: _NamespaceMode.ValueType  # 1
    """A CONTAINER namespace is restricted to a single container.
    For example, a container with a PID namespace of CONTAINER expects to
    view only the processes in that container.
    """
    NODE: _NamespaceMode.ValueType  # 2
    """A NODE namespace is the namespace of the Kubernetes node.
    For example, a container with a PID namespace of NODE expects to view
    all of the processes on the host running the kubelet.
    """
    TARGET: _NamespaceMode.ValueType  # 3
    """TARGET targets the namespace of another container. When this is specified,
    a target_id must be specified in NamespaceOption and refer to a container
    previously created with NamespaceMode CONTAINER. This containers namespace
    will be made to match that of container target_id.
    For example, a container with a PID namespace of TARGET expects to view
    all of the processes that container target_id can view.
    """

class NamespaceMode(_NamespaceMode, metaclass=_NamespaceModeEnumTypeWrapper):
    """A NamespaceMode describes the intended namespace configuration for each
    of the namespaces (Network, PID, IPC) in NamespaceOption. Runtimes should
    map these modes as appropriate for the technology underlying the runtime.
    """

POD: NamespaceMode.ValueType  # 0
"""A POD namespace is common to all containers in a pod.
For example, a container with a PID namespace of POD expects to view
all of the processes in all of the containers in the pod.
"""
CONTAINER: NamespaceMode.ValueType  # 1
"""A CONTAINER namespace is restricted to a single container.
For example, a container with a PID namespace of CONTAINER expects to
view only the processes in that container.
"""
NODE: NamespaceMode.ValueType  # 2
"""A NODE namespace is the namespace of the Kubernetes node.
For example, a container with a PID namespace of NODE expects to view
all of the processes on the host running the kubelet.
"""
TARGET: NamespaceMode.ValueType  # 3
"""TARGET targets the namespace of another container. When this is specified,
a target_id must be specified in NamespaceOption and refer to a container
previously created with NamespaceMode CONTAINER. This containers namespace
will be made to match that of container target_id.
For example, a container with a PID namespace of TARGET expects to view
all of the processes that container target_id can view.
"""
global___NamespaceMode = NamespaceMode

class _SupplementalGroupsPolicy:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SupplementalGroupsPolicyEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _SupplementalGroupsPolicy.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    Merge: _SupplementalGroupsPolicy.ValueType  # 0
    """Merge means that the container's provided SupplementalGroups 
    and FsGroup (specified in SecurityContext) will be merged with 
    the primary user's groups as defined in the container image
    (in /etc/group).
    """
    Strict: _SupplementalGroupsPolicy.ValueType  # 1
    """Strict means that the container's provided SupplementalGroups
    and FsGroup (specified in SecurityContext) will be used instead of 
    any groups defined in the container image.
    """

class SupplementalGroupsPolicy(
    _SupplementalGroupsPolicy, metaclass=_SupplementalGroupsPolicyEnumTypeWrapper
):
    """SupplementalGroupsPolicy defines how supplemental groups
    of the first container processes are calculated.
    """

Merge: SupplementalGroupsPolicy.ValueType  # 0
"""Merge means that the container's provided SupplementalGroups 
and FsGroup (specified in SecurityContext) will be merged with 
the primary user's groups as defined in the container image
(in /etc/group).
"""
Strict: SupplementalGroupsPolicy.ValueType  # 1
"""Strict means that the container's provided SupplementalGroups
and FsGroup (specified in SecurityContext) will be used instead of 
any groups defined in the container image.
"""
global___SupplementalGroupsPolicy = SupplementalGroupsPolicy

class _PodSandboxState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PodSandboxStateEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _PodSandboxState.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SANDBOX_READY: _PodSandboxState.ValueType  # 0
    SANDBOX_NOTREADY: _PodSandboxState.ValueType  # 1

class PodSandboxState(_PodSandboxState, metaclass=_PodSandboxStateEnumTypeWrapper): ...

SANDBOX_READY: PodSandboxState.ValueType  # 0
SANDBOX_NOTREADY: PodSandboxState.ValueType  # 1
global___PodSandboxState = PodSandboxState

class _Signal:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SignalEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Signal.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RUNTIME_DEFAULT: _Signal.ValueType  # 0
    SIGABRT: _Signal.ValueType  # 1
    SIGALRM: _Signal.ValueType  # 2
    SIGBUS: _Signal.ValueType  # 3
    SIGCHLD: _Signal.ValueType  # 4
    SIGCLD: _Signal.ValueType  # 5
    SIGCONT: _Signal.ValueType  # 6
    SIGFPE: _Signal.ValueType  # 7
    SIGHUP: _Signal.ValueType  # 8
    SIGILL: _Signal.ValueType  # 9
    SIGINT: _Signal.ValueType  # 10
    SIGIO: _Signal.ValueType  # 11
    SIGIOT: _Signal.ValueType  # 12
    SIGKILL: _Signal.ValueType  # 13
    SIGPIPE: _Signal.ValueType  # 14
    SIGPOLL: _Signal.ValueType  # 15
    SIGPROF: _Signal.ValueType  # 16
    SIGPWR: _Signal.ValueType  # 17
    SIGQUIT: _Signal.ValueType  # 18
    SIGSEGV: _Signal.ValueType  # 19
    SIGSTKFLT: _Signal.ValueType  # 20
    SIGSTOP: _Signal.ValueType  # 21
    SIGSYS: _Signal.ValueType  # 22
    SIGTERM: _Signal.ValueType  # 23
    SIGTRAP: _Signal.ValueType  # 24
    SIGTSTP: _Signal.ValueType  # 25
    SIGTTIN: _Signal.ValueType  # 26
    SIGTTOU: _Signal.ValueType  # 27
    SIGURG: _Signal.ValueType  # 28
    SIGUSR1: _Signal.ValueType  # 29
    SIGUSR2: _Signal.ValueType  # 30
    SIGVTALRM: _Signal.ValueType  # 31
    SIGWINCH: _Signal.ValueType  # 32
    SIGXCPU: _Signal.ValueType  # 33
    SIGXFSZ: _Signal.ValueType  # 34
    SIGRTMIN: _Signal.ValueType  # 35
    SIGRTMINPLUS1: _Signal.ValueType  # 36
    SIGRTMINPLUS2: _Signal.ValueType  # 37
    SIGRTMINPLUS3: _Signal.ValueType  # 38
    SIGRTMINPLUS4: _Signal.ValueType  # 39
    SIGRTMINPLUS5: _Signal.ValueType  # 40
    SIGRTMINPLUS6: _Signal.ValueType  # 41
    SIGRTMINPLUS7: _Signal.ValueType  # 42
    SIGRTMINPLUS8: _Signal.ValueType  # 43
    SIGRTMINPLUS9: _Signal.ValueType  # 44
    SIGRTMINPLUS10: _Signal.ValueType  # 45
    SIGRTMINPLUS11: _Signal.ValueType  # 46
    SIGRTMINPLUS12: _Signal.ValueType  # 47
    SIGRTMINPLUS13: _Signal.ValueType  # 48
    SIGRTMINPLUS14: _Signal.ValueType  # 49
    SIGRTMINPLUS15: _Signal.ValueType  # 50
    SIGRTMAXMINUS14: _Signal.ValueType  # 51
    SIGRTMAXMINUS13: _Signal.ValueType  # 52
    SIGRTMAXMINUS12: _Signal.ValueType  # 53
    SIGRTMAXMINUS11: _Signal.ValueType  # 54
    SIGRTMAXMINUS10: _Signal.ValueType  # 55
    SIGRTMAXMINUS9: _Signal.ValueType  # 56
    SIGRTMAXMINUS8: _Signal.ValueType  # 57
    SIGRTMAXMINUS7: _Signal.ValueType  # 58
    SIGRTMAXMINUS6: _Signal.ValueType  # 59
    SIGRTMAXMINUS5: _Signal.ValueType  # 60
    SIGRTMAXMINUS4: _Signal.ValueType  # 61
    SIGRTMAXMINUS3: _Signal.ValueType  # 62
    SIGRTMAXMINUS2: _Signal.ValueType  # 63
    SIGRTMAXMINUS1: _Signal.ValueType  # 64
    SIGRTMAX: _Signal.ValueType  # 65

class Signal(_Signal, metaclass=_SignalEnumTypeWrapper): ...

RUNTIME_DEFAULT: Signal.ValueType  # 0
SIGABRT: Signal.ValueType  # 1
SIGALRM: Signal.ValueType  # 2
SIGBUS: Signal.ValueType  # 3
SIGCHLD: Signal.ValueType  # 4
SIGCLD: Signal.ValueType  # 5
SIGCONT: Signal.ValueType  # 6
SIGFPE: Signal.ValueType  # 7
SIGHUP: Signal.ValueType  # 8
SIGILL: Signal.ValueType  # 9
SIGINT: Signal.ValueType  # 10
SIGIO: Signal.ValueType  # 11
SIGIOT: Signal.ValueType  # 12
SIGKILL: Signal.ValueType  # 13
SIGPIPE: Signal.ValueType  # 14
SIGPOLL: Signal.ValueType  # 15
SIGPROF: Signal.ValueType  # 16
SIGPWR: Signal.ValueType  # 17
SIGQUIT: Signal.ValueType  # 18
SIGSEGV: Signal.ValueType  # 19
SIGSTKFLT: Signal.ValueType  # 20
SIGSTOP: Signal.ValueType  # 21
SIGSYS: Signal.ValueType  # 22
SIGTERM: Signal.ValueType  # 23
SIGTRAP: Signal.ValueType  # 24
SIGTSTP: Signal.ValueType  # 25
SIGTTIN: Signal.ValueType  # 26
SIGTTOU: Signal.ValueType  # 27
SIGURG: Signal.ValueType  # 28
SIGUSR1: Signal.ValueType  # 29
SIGUSR2: Signal.ValueType  # 30
SIGVTALRM: Signal.ValueType  # 31
SIGWINCH: Signal.ValueType  # 32
SIGXCPU: Signal.ValueType  # 33
SIGXFSZ: Signal.ValueType  # 34
SIGRTMIN: Signal.ValueType  # 35
SIGRTMINPLUS1: Signal.ValueType  # 36
SIGRTMINPLUS2: Signal.ValueType  # 37
SIGRTMINPLUS3: Signal.ValueType  # 38
SIGRTMINPLUS4: Signal.ValueType  # 39
SIGRTMINPLUS5: Signal.ValueType  # 40
SIGRTMINPLUS6: Signal.ValueType  # 41
SIGRTMINPLUS7: Signal.ValueType  # 42
SIGRTMINPLUS8: Signal.ValueType  # 43
SIGRTMINPLUS9: Signal.ValueType  # 44
SIGRTMINPLUS10: Signal.ValueType  # 45
SIGRTMINPLUS11: Signal.ValueType  # 46
SIGRTMINPLUS12: Signal.ValueType  # 47
SIGRTMINPLUS13: Signal.ValueType  # 48
SIGRTMINPLUS14: Signal.ValueType  # 49
SIGRTMINPLUS15: Signal.ValueType  # 50
SIGRTMAXMINUS14: Signal.ValueType  # 51
SIGRTMAXMINUS13: Signal.ValueType  # 52
SIGRTMAXMINUS12: Signal.ValueType  # 53
SIGRTMAXMINUS11: Signal.ValueType  # 54
SIGRTMAXMINUS10: Signal.ValueType  # 55
SIGRTMAXMINUS9: Signal.ValueType  # 56
SIGRTMAXMINUS8: Signal.ValueType  # 57
SIGRTMAXMINUS7: Signal.ValueType  # 58
SIGRTMAXMINUS6: Signal.ValueType  # 59
SIGRTMAXMINUS5: Signal.ValueType  # 60
SIGRTMAXMINUS4: Signal.ValueType  # 61
SIGRTMAXMINUS3: Signal.ValueType  # 62
SIGRTMAXMINUS2: Signal.ValueType  # 63
SIGRTMAXMINUS1: Signal.ValueType  # 64
SIGRTMAX: Signal.ValueType  # 65
global___Signal = Signal

class _ContainerState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ContainerStateEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _ContainerState.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CONTAINER_CREATED: _ContainerState.ValueType  # 0
    CONTAINER_RUNNING: _ContainerState.ValueType  # 1
    CONTAINER_EXITED: _ContainerState.ValueType  # 2
    CONTAINER_UNKNOWN: _ContainerState.ValueType  # 3

class ContainerState(_ContainerState, metaclass=_ContainerStateEnumTypeWrapper): ...

CONTAINER_CREATED: ContainerState.ValueType  # 0
CONTAINER_RUNNING: ContainerState.ValueType  # 1
CONTAINER_EXITED: ContainerState.ValueType  # 2
CONTAINER_UNKNOWN: ContainerState.ValueType  # 3
global___ContainerState = ContainerState

class _ContainerEventType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ContainerEventTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _ContainerEventType.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CONTAINER_CREATED_EVENT: _ContainerEventType.ValueType  # 0
    """Container created"""
    CONTAINER_STARTED_EVENT: _ContainerEventType.ValueType  # 1
    """Container started"""
    CONTAINER_STOPPED_EVENT: _ContainerEventType.ValueType  # 2
    """Container stopped"""
    CONTAINER_DELETED_EVENT: _ContainerEventType.ValueType  # 3
    """Container deleted"""

class ContainerEventType(
    _ContainerEventType, metaclass=_ContainerEventTypeEnumTypeWrapper
): ...

CONTAINER_CREATED_EVENT: ContainerEventType.ValueType  # 0
"""Container created"""
CONTAINER_STARTED_EVENT: ContainerEventType.ValueType  # 1
"""Container started"""
CONTAINER_STOPPED_EVENT: ContainerEventType.ValueType  # 2
"""Container stopped"""
CONTAINER_DELETED_EVENT: ContainerEventType.ValueType  # 3
"""Container deleted"""
global___ContainerEventType = ContainerEventType

class _MetricType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MetricTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MetricType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    COUNTER: _MetricType.ValueType  # 0
    GAUGE: _MetricType.ValueType  # 1

class MetricType(_MetricType, metaclass=_MetricTypeEnumTypeWrapper): ...

COUNTER: MetricType.ValueType  # 0
GAUGE: MetricType.ValueType  # 1
global___MetricType = MetricType

class _CgroupDriver:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CgroupDriverEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _CgroupDriver.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SYSTEMD: _CgroupDriver.ValueType  # 0
    CGROUPFS: _CgroupDriver.ValueType  # 1

class CgroupDriver(_CgroupDriver, metaclass=_CgroupDriverEnumTypeWrapper): ...

SYSTEMD: CgroupDriver.ValueType  # 0
CGROUPFS: CgroupDriver.ValueType  # 1
global___CgroupDriver = CgroupDriver

@typing.final
class VersionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of the kubelet runtime API."""
    def __init__(
        self,
        *,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["version", b"version"]) -> None: ...

global___VersionRequest = VersionRequest

@typing.final
class VersionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    RUNTIME_NAME_FIELD_NUMBER: builtins.int
    RUNTIME_VERSION_FIELD_NUMBER: builtins.int
    RUNTIME_API_VERSION_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of the kubelet runtime API."""
    runtime_name: builtins.str
    """Name of the container runtime."""
    runtime_version: builtins.str
    """Version of the container runtime. The string must be
    semver-compatible.
    """
    runtime_api_version: builtins.str
    """API version of the container runtime. The string must be
    semver-compatible.
    """
    def __init__(
        self,
        *,
        version: builtins.str = ...,
        runtime_name: builtins.str = ...,
        runtime_version: builtins.str = ...,
        runtime_api_version: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "runtime_api_version",
            b"runtime_api_version",
            "runtime_name",
            b"runtime_name",
            "runtime_version",
            b"runtime_version",
            "version",
            b"version",
        ],
    ) -> None: ...

global___VersionResponse = VersionResponse

@typing.final
class DNSConfig(google.protobuf.message.Message):
    """DNSConfig specifies the DNS servers and search domains of a sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SERVERS_FIELD_NUMBER: builtins.int
    SEARCHES_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def servers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of DNS servers of the cluster."""

    @property
    def searches(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of DNS search domains of the cluster."""

    @property
    def options(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of DNS options. See https://linux.die.net/man/5/resolv.conf
        for all available options.
        """

    def __init__(
        self,
        *,
        servers: collections.abc.Iterable[builtins.str] | None = ...,
        searches: collections.abc.Iterable[builtins.str] | None = ...,
        options: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "options", b"options", "searches", b"searches", "servers", b"servers"
        ],
    ) -> None: ...

global___DNSConfig = DNSConfig

@typing.final
class PortMapping(google.protobuf.message.Message):
    """PortMapping specifies the port mapping configurations of a sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROTOCOL_FIELD_NUMBER: builtins.int
    CONTAINER_PORT_FIELD_NUMBER: builtins.int
    HOST_PORT_FIELD_NUMBER: builtins.int
    HOST_IP_FIELD_NUMBER: builtins.int
    protocol: global___Protocol.ValueType
    """Protocol of the port mapping."""
    container_port: builtins.int
    """Port number within the container. Default: 0 (not specified)."""
    host_port: builtins.int
    """Port number on the host to map the container port to.

    * Valid host port range is 1-65535.
    * The value 0 has explicit semantic meaning: it indicates NO host port should be allocated.
    * The value 0 does NOT indicate dynamic port allocation. Future implementations
      of dynamic allocation will use different values/semantics.
    * Implementations MUST handle the case where this field is explicitly set to 0,
      This field SHOULD be omitted when no port is required.

    Default: If omitted, container port will not be exposed on the host.
    """
    host_ip: builtins.str
    """Host IP."""
    def __init__(
        self,
        *,
        protocol: global___Protocol.ValueType = ...,
        container_port: builtins.int = ...,
        host_port: builtins.int = ...,
        host_ip: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_port",
            b"container_port",
            "host_ip",
            b"host_ip",
            "host_port",
            b"host_port",
            "protocol",
            b"protocol",
        ],
    ) -> None: ...

global___PortMapping = PortMapping

@typing.final
class Mount(google.protobuf.message.Message):
    """Mount specifies a host volume to mount into a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_PATH_FIELD_NUMBER: builtins.int
    HOST_PATH_FIELD_NUMBER: builtins.int
    READONLY_FIELD_NUMBER: builtins.int
    SELINUX_RELABEL_FIELD_NUMBER: builtins.int
    PROPAGATION_FIELD_NUMBER: builtins.int
    UIDMAPPINGS_FIELD_NUMBER: builtins.int
    GIDMAPPINGS_FIELD_NUMBER: builtins.int
    RECURSIVE_READ_ONLY_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    IMAGE_SUB_PATH_FIELD_NUMBER: builtins.int
    container_path: builtins.str
    """Path of the mount within the container."""
    host_path: builtins.str
    """Path of the mount on the host. Has to be empty if the image field below
    is provided, because those fields are mutually exclusive. If the image
    field below is nil and the host path doesn't exist, then runtimes should
    report an error. If the hostpath is a symbolic link, runtimes should
    follow the symlink and mount the real destination to container.
    """
    readonly: builtins.bool
    """If set, the mount is read-only."""
    selinux_relabel: builtins.bool
    """If set, the mount needs SELinux relabeling."""
    propagation: global___MountPropagation.ValueType
    """Requested propagation mode."""
    recursive_read_only: builtins.bool
    """If set to true, the mount is made recursive read-only.
    In this CRI API, recursive_read_only is a plain true/false boolean, although its equivalent
    in the Kubernetes core API is a quaternary that can be nil, "Enabled", "IfPossible", or "Disabled".
    kubelet translates that quaternary value in the core API into a boolean in this CRI API.
    Remarks:
    - nil is just treated as false
    - when set to true, readonly must be explicitly set to true, and propagation must be PRIVATE (0).
    - (readonly == false && recursive_read_only == false) does not make the mount read-only.
    """
    image_sub_path: builtins.str
    """Specific image sub path to be used from inside the image instead of its
    root, only necessary if the above image field is set. If the sub path is
    not empty and does not exist in the image, then runtimes should fail and
    return an error.
    Introduced in the Image Volume Source KEP beta graduation: https://kep.k8s.io/4639
    """
    @property
    def uidMappings(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___IDMapping
    ]:
        """UidMappings specifies the runtime UID mappings for the mount."""

    @property
    def gidMappings(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___IDMapping
    ]:
        """GidMappings specifies the runtime GID mappings for the mount."""

    @property
    def image(self) -> global___ImageSpec:
        """Mount an image reference (image ID, with or without digest), which is a
        special use case for image volume mounts. If this field is set, then
        host_path should be unset. All image mounts are per feature definition
        readonly (noexec). The kubelet does an PullImage RPC and evaluates the returned
        PullImageResponse.image_ref value, which is then set to the
        ImageSpec.image field. Runtimes are expected to mount the image as
        required.
        Introduced in the Image Volume Source KEP: https://kep.k8s.io/4639
        """

    def __init__(
        self,
        *,
        container_path: builtins.str = ...,
        host_path: builtins.str = ...,
        readonly: builtins.bool = ...,
        selinux_relabel: builtins.bool = ...,
        propagation: global___MountPropagation.ValueType = ...,
        uidMappings: collections.abc.Iterable[global___IDMapping] | None = ...,
        gidMappings: collections.abc.Iterable[global___IDMapping] | None = ...,
        recursive_read_only: builtins.bool = ...,
        image: global___ImageSpec | None = ...,
        image_sub_path: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["image", b"image"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_path",
            b"container_path",
            "gidMappings",
            b"gidMappings",
            "host_path",
            b"host_path",
            "image",
            b"image",
            "image_sub_path",
            b"image_sub_path",
            "propagation",
            b"propagation",
            "readonly",
            b"readonly",
            "recursive_read_only",
            b"recursive_read_only",
            "selinux_relabel",
            b"selinux_relabel",
            "uidMappings",
            b"uidMappings",
        ],
    ) -> None: ...

global___Mount = Mount

@typing.final
class IDMapping(google.protobuf.message.Message):
    """IDMapping describes host to container ID mappings for a pod sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOST_ID_FIELD_NUMBER: builtins.int
    CONTAINER_ID_FIELD_NUMBER: builtins.int
    LENGTH_FIELD_NUMBER: builtins.int
    host_id: builtins.int
    """HostId is the id on the host."""
    container_id: builtins.int
    """ContainerId is the id in the container."""
    length: builtins.int
    """Length is the size of the range to map."""
    def __init__(
        self,
        *,
        host_id: builtins.int = ...,
        container_id: builtins.int = ...,
        length: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_id", b"container_id", "host_id", b"host_id", "length", b"length"
        ],
    ) -> None: ...

global___IDMapping = IDMapping

@typing.final
class UserNamespace(google.protobuf.message.Message):
    """UserNamespace describes the intended user namespace configuration for a pod sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODE_FIELD_NUMBER: builtins.int
    UIDS_FIELD_NUMBER: builtins.int
    GIDS_FIELD_NUMBER: builtins.int
    mode: global___NamespaceMode.ValueType
    """Mode is the NamespaceMode for this UserNamespace.
    Note: NamespaceMode for UserNamespace currently supports only POD and NODE, not CONTAINER OR TARGET.
    """
    @property
    def uids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___IDMapping
    ]:
        """Uids specifies the UID mappings for the user namespace."""

    @property
    def gids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___IDMapping
    ]:
        """Gids specifies the GID mappings for the user namespace."""

    def __init__(
        self,
        *,
        mode: global___NamespaceMode.ValueType = ...,
        uids: collections.abc.Iterable[global___IDMapping] | None = ...,
        gids: collections.abc.Iterable[global___IDMapping] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["gids", b"gids", "mode", b"mode", "uids", b"uids"],
    ) -> None: ...

global___UserNamespace = UserNamespace

@typing.final
class NamespaceOption(google.protobuf.message.Message):
    """NamespaceOption provides options for Linux namespaces."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_FIELD_NUMBER: builtins.int
    PID_FIELD_NUMBER: builtins.int
    IPC_FIELD_NUMBER: builtins.int
    TARGET_ID_FIELD_NUMBER: builtins.int
    USERNS_OPTIONS_FIELD_NUMBER: builtins.int
    network: global___NamespaceMode.ValueType
    """Network namespace for this container/sandbox.
    Note: There is currently no way to set CONTAINER scoped network in the Kubernetes API.
    Namespaces currently set by the kubelet: POD, NODE
    """
    pid: global___NamespaceMode.ValueType
    """PID namespace for this container/sandbox.
    Note: The CRI default is POD, but the v1.PodSpec default is CONTAINER.
    The kubelet's runtime manager will set this to CONTAINER explicitly for v1 pods.
    Namespaces currently set by the kubelet: POD, CONTAINER, NODE, TARGET
    """
    ipc: global___NamespaceMode.ValueType
    """IPC namespace for this container/sandbox.
    Note: There is currently no way to set CONTAINER scoped IPC in the Kubernetes API.
    Namespaces currently set by the kubelet: POD, NODE
    """
    target_id: builtins.str
    """Target Container ID for NamespaceMode of TARGET. This container must have been
    previously created in the same pod. It is not possible to specify different targets
    for each namespace.
    """
    @property
    def userns_options(self) -> global___UserNamespace:
        """UsernsOptions for this pod sandbox.
        The Kubelet picks the user namespace configuration to use for the pod sandbox.  The mappings
        are specified as part of the UserNamespace struct.  If the struct is nil, then the POD mode
        must be assumed.  This is done for backward compatibility with older Kubelet versions that
        do not set a user namespace.
        """

    def __init__(
        self,
        *,
        network: global___NamespaceMode.ValueType = ...,
        pid: global___NamespaceMode.ValueType = ...,
        ipc: global___NamespaceMode.ValueType = ...,
        target_id: builtins.str = ...,
        userns_options: global___UserNamespace | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["userns_options", b"userns_options"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "ipc",
            b"ipc",
            "network",
            b"network",
            "pid",
            b"pid",
            "target_id",
            b"target_id",
            "userns_options",
            b"userns_options",
        ],
    ) -> None: ...

global___NamespaceOption = NamespaceOption

@typing.final
class Int64Value(google.protobuf.message.Message):
    """Int64Value is the wrapper of int64."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.int
    """The value."""
    def __init__(
        self,
        *,
        value: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["value", b"value"]) -> None: ...

global___Int64Value = Int64Value

@typing.final
class LinuxSandboxSecurityContext(google.protobuf.message.Message):
    """LinuxSandboxSecurityContext holds linux security configuration that will be
    applied to a sandbox. Note that:
    1) It does not apply to containers in the pods.
    2) It may not be applicable to a PodSandbox which does not contain any running
       process.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_OPTIONS_FIELD_NUMBER: builtins.int
    SELINUX_OPTIONS_FIELD_NUMBER: builtins.int
    RUN_AS_USER_FIELD_NUMBER: builtins.int
    RUN_AS_GROUP_FIELD_NUMBER: builtins.int
    READONLY_ROOTFS_FIELD_NUMBER: builtins.int
    SUPPLEMENTAL_GROUPS_FIELD_NUMBER: builtins.int
    SUPPLEMENTAL_GROUPS_POLICY_FIELD_NUMBER: builtins.int
    PRIVILEGED_FIELD_NUMBER: builtins.int
    SECCOMP_FIELD_NUMBER: builtins.int
    APPARMOR_FIELD_NUMBER: builtins.int
    SECCOMP_PROFILE_PATH_FIELD_NUMBER: builtins.int
    readonly_rootfs: builtins.bool
    """If set, the root filesystem of the sandbox is read-only."""
    supplemental_groups_policy: global___SupplementalGroupsPolicy.ValueType
    """supplemental_groups_policy defines how supplemental groups of the first 
    container processes are calculated.
    Valid values are "Merge" and "Strict".
    If not specified, "Merge" is used.
    """
    privileged: builtins.bool
    """Indicates whether the sandbox will be asked to run a privileged
    container. If a privileged container is to be executed within it, this
    MUST be true.
    This allows a sandbox to take additional security precautions if no
    privileged containers are expected to be run.
    """
    seccomp_profile_path: builtins.str
    """Seccomp profile for the sandbox, candidate values are:
    * runtime/default: the default profile for the container runtime
    * unconfined: unconfined profile, ie, no seccomp sandboxing
    * localhost/<full-path-to-profile>: the profile installed on the node.
      <full-path-to-profile> is the full path of the profile.
    Default: "", which is identical with unconfined.
    """
    @property
    def namespace_options(self) -> global___NamespaceOption:
        """Configurations for the sandbox's namespaces.
        This will be used only if the PodSandbox uses namespace for isolation.
        """

    @property
    def selinux_options(self) -> global___SELinuxOption:
        """Optional SELinux context to be applied."""

    @property
    def run_as_user(self) -> global___Int64Value:
        """UID to run sandbox processes as, when applicable."""

    @property
    def run_as_group(self) -> global___Int64Value:
        """GID to run sandbox processes as, when applicable. run_as_group should only
        be specified when run_as_user is specified; otherwise, the runtime MUST error.
        """

    @property
    def supplemental_groups(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """List of groups applied to the first process run in each container.
        supplemental_groups_policy can control how groups will be calculated.
        """

    @property
    def seccomp(self) -> global___SecurityProfile:
        """Seccomp profile for the sandbox."""

    @property
    def apparmor(self) -> global___SecurityProfile:
        """AppArmor profile for the sandbox."""

    def __init__(
        self,
        *,
        namespace_options: global___NamespaceOption | None = ...,
        selinux_options: global___SELinuxOption | None = ...,
        run_as_user: global___Int64Value | None = ...,
        run_as_group: global___Int64Value | None = ...,
        readonly_rootfs: builtins.bool = ...,
        supplemental_groups: collections.abc.Iterable[builtins.int] | None = ...,
        supplemental_groups_policy: global___SupplementalGroupsPolicy.ValueType = ...,
        privileged: builtins.bool = ...,
        seccomp: global___SecurityProfile | None = ...,
        apparmor: global___SecurityProfile | None = ...,
        seccomp_profile_path: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "apparmor",
            b"apparmor",
            "namespace_options",
            b"namespace_options",
            "run_as_group",
            b"run_as_group",
            "run_as_user",
            b"run_as_user",
            "seccomp",
            b"seccomp",
            "selinux_options",
            b"selinux_options",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "apparmor",
            b"apparmor",
            "namespace_options",
            b"namespace_options",
            "privileged",
            b"privileged",
            "readonly_rootfs",
            b"readonly_rootfs",
            "run_as_group",
            b"run_as_group",
            "run_as_user",
            b"run_as_user",
            "seccomp",
            b"seccomp",
            "seccomp_profile_path",
            b"seccomp_profile_path",
            "selinux_options",
            b"selinux_options",
            "supplemental_groups",
            b"supplemental_groups",
            "supplemental_groups_policy",
            b"supplemental_groups_policy",
        ],
    ) -> None: ...

global___LinuxSandboxSecurityContext = LinuxSandboxSecurityContext

@typing.final
class SecurityProfile(google.protobuf.message.Message):
    """A security profile which can be used for sandboxes and containers."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ProfileType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProfileTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            SecurityProfile._ProfileType.ValueType
        ],
        builtins.type,
    ):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RuntimeDefault: SecurityProfile._ProfileType.ValueType  # 0
        """The container runtime default profile should be used."""
        Unconfined: SecurityProfile._ProfileType.ValueType  # 1
        """Disable the feature for the sandbox or the container."""
        Localhost: SecurityProfile._ProfileType.ValueType  # 2
        """A pre-defined profile on the node should be used."""

    class ProfileType(_ProfileType, metaclass=_ProfileTypeEnumTypeWrapper):
        """Available profile types."""

    RuntimeDefault: SecurityProfile.ProfileType.ValueType  # 0
    """The container runtime default profile should be used."""
    Unconfined: SecurityProfile.ProfileType.ValueType  # 1
    """Disable the feature for the sandbox or the container."""
    Localhost: SecurityProfile.ProfileType.ValueType  # 2
    """A pre-defined profile on the node should be used."""

    PROFILE_TYPE_FIELD_NUMBER: builtins.int
    LOCALHOST_REF_FIELD_NUMBER: builtins.int
    profile_type: global___SecurityProfile.ProfileType.ValueType
    """Indicator which `ProfileType` should be applied."""
    localhost_ref: builtins.str
    """Indicates that a pre-defined profile on the node should be used.
    Must only be set if `ProfileType` is `Localhost`.
    For seccomp, it must be an absolute path to the seccomp profile.
    For AppArmor, this field is the AppArmor `<profile name>/`
    """
    def __init__(
        self,
        *,
        profile_type: global___SecurityProfile.ProfileType.ValueType = ...,
        localhost_ref: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "localhost_ref", b"localhost_ref", "profile_type", b"profile_type"
        ],
    ) -> None: ...

global___SecurityProfile = SecurityProfile

@typing.final
class LinuxPodSandboxConfig(google.protobuf.message.Message):
    """LinuxPodSandboxConfig holds platform-specific configurations for Linux
    host platforms and Linux-based containers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class SysctlsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    CGROUP_PARENT_FIELD_NUMBER: builtins.int
    SECURITY_CONTEXT_FIELD_NUMBER: builtins.int
    SYSCTLS_FIELD_NUMBER: builtins.int
    OVERHEAD_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    cgroup_parent: builtins.str
    """Parent cgroup of the PodSandbox.
    The cgroupfs style syntax will be used, but the container runtime can
    convert it to systemd semantics if needed.
    """
    @property
    def security_context(self) -> global___LinuxSandboxSecurityContext:
        """LinuxSandboxSecurityContext holds sandbox security attributes."""

    @property
    def sysctls(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Sysctls holds linux sysctls config for the sandbox."""

    @property
    def overhead(self) -> global___LinuxContainerResources:
        """Optional overhead represents the overheads associated with this sandbox"""

    @property
    def resources(self) -> global___LinuxContainerResources:
        """Optional resources represents the sum of container resources for this sandbox"""

    def __init__(
        self,
        *,
        cgroup_parent: builtins.str = ...,
        security_context: global___LinuxSandboxSecurityContext | None = ...,
        sysctls: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        overhead: global___LinuxContainerResources | None = ...,
        resources: global___LinuxContainerResources | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "overhead",
            b"overhead",
            "resources",
            b"resources",
            "security_context",
            b"security_context",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "cgroup_parent",
            b"cgroup_parent",
            "overhead",
            b"overhead",
            "resources",
            b"resources",
            "security_context",
            b"security_context",
            "sysctls",
            b"sysctls",
        ],
    ) -> None: ...

global___LinuxPodSandboxConfig = LinuxPodSandboxConfig

@typing.final
class PodSandboxMetadata(google.protobuf.message.Message):
    """PodSandboxMetadata holds all necessary information for building the sandbox name.
    The container runtime is encouraged to expose the metadata associated with the
    PodSandbox in its user interface for better user experience. For example,
    the runtime can construct a unique PodSandboxName based on the metadata.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pod name of the sandbox. Same as the pod name in the Pod ObjectMeta."""
    uid: builtins.str
    """Pod UID of the sandbox. Same as the pod UID in the Pod ObjectMeta."""
    namespace: builtins.str
    """Pod namespace of the sandbox. Same as the pod namespace in the Pod ObjectMeta."""
    attempt: builtins.int
    """Attempt number of creating the sandbox. Default: 0."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        namespace: builtins.str = ...,
        attempt: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "attempt",
            b"attempt",
            "name",
            b"name",
            "namespace",
            b"namespace",
            "uid",
            b"uid",
        ],
    ) -> None: ...

global___PodSandboxMetadata = PodSandboxMetadata

@typing.final
class PodSandboxConfig(google.protobuf.message.Message):
    """PodSandboxConfig holds all the required and optional fields for creating a
    sandbox.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    METADATA_FIELD_NUMBER: builtins.int
    HOSTNAME_FIELD_NUMBER: builtins.int
    LOG_DIRECTORY_FIELD_NUMBER: builtins.int
    DNS_CONFIG_FIELD_NUMBER: builtins.int
    PORT_MAPPINGS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    hostname: builtins.str
    """Hostname of the sandbox. Hostname could only be empty when the pod
    network namespace is NODE.
    """
    log_directory: builtins.str
    """Path to the directory on the host in which container log files are
    stored.
    By default the log of a container going into the LogDirectory will be
    hooked up to STDOUT and STDERR. However, the LogDirectory may contain
    binary log files with structured logging data from the individual
    containers. For example, the files might be newline separated JSON
    structured logs, systemd-journald journal files, gRPC trace files, etc.
    E.g.,
        PodSandboxConfig.LogDirectory = `/var/log/pods/<NAMESPACE>_<NAME>_<UID>/`
        ContainerConfig.LogPath = `containerName/Instance#.log`
    """
    @property
    def metadata(self) -> global___PodSandboxMetadata:
        """Metadata of the sandbox. This information will uniquely identify the
        sandbox, and the runtime should leverage this to ensure correct
        operation. The runtime may also use this information to improve UX, such
        as by constructing a readable name.
        """

    @property
    def dns_config(self) -> global___DNSConfig:
        """DNS config for the sandbox."""

    @property
    def port_mappings(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PortMapping
    ]:
        """Port mappings for the sandbox."""

    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map that may be set by the kubelet to store and
        retrieve arbitrary metadata. This will include any annotations set on a
        pod through the Kubernetes API.

        Annotations MUST NOT be altered by the runtime; the annotations stored
        here MUST be returned in the PodSandboxStatus associated with the pod
        this PodSandboxConfig creates.

        In general, in order to preserve a well-defined interface between the
        kubelet and the container runtime, annotations SHOULD NOT influence
        runtime behaviour.

        Annotations can also be useful for runtime authors to experiment with
        new features that are opaque to the Kubernetes APIs (both user-facing
        and the CRI). Whenever possible, however, runtime authors SHOULD
        consider proposing new typed fields for any new features instead.
        """

    @property
    def linux(self) -> global___LinuxPodSandboxConfig:
        """Optional configurations specific to Linux hosts."""

    @property
    def windows(self) -> global___WindowsPodSandboxConfig:
        """Optional configurations specific to Windows hosts."""

    def __init__(
        self,
        *,
        metadata: global___PodSandboxMetadata | None = ...,
        hostname: builtins.str = ...,
        log_directory: builtins.str = ...,
        dns_config: global___DNSConfig | None = ...,
        port_mappings: collections.abc.Iterable[global___PortMapping] | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        linux: global___LinuxPodSandboxConfig | None = ...,
        windows: global___WindowsPodSandboxConfig | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "dns_config",
            b"dns_config",
            "linux",
            b"linux",
            "metadata",
            b"metadata",
            "windows",
            b"windows",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "dns_config",
            b"dns_config",
            "hostname",
            b"hostname",
            "labels",
            b"labels",
            "linux",
            b"linux",
            "log_directory",
            b"log_directory",
            "metadata",
            b"metadata",
            "port_mappings",
            b"port_mappings",
            "windows",
            b"windows",
        ],
    ) -> None: ...

global___PodSandboxConfig = PodSandboxConfig

@typing.final
class RunPodSandboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    RUNTIME_HANDLER_FIELD_NUMBER: builtins.int
    runtime_handler: builtins.str
    """Named runtime configuration to use for this PodSandbox.
    If the runtime handler is unknown, this request should be rejected.  An
    empty string should select the default handler, equivalent to the
    behavior before this feature was added.
    See https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
    """
    @property
    def config(self) -> global___PodSandboxConfig:
        """Configuration for creating a PodSandbox."""

    def __init__(
        self,
        *,
        config: global___PodSandboxConfig | None = ...,
        runtime_handler: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["config", b"config"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "config", b"config", "runtime_handler", b"runtime_handler"
        ],
    ) -> None: ...

global___RunPodSandboxRequest = RunPodSandboxRequest

@typing.final
class RunPodSandboxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox to run."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["pod_sandbox_id", b"pod_sandbox_id"]
    ) -> None: ...

global___RunPodSandboxResponse = RunPodSandboxResponse

@typing.final
class StopPodSandboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox to stop."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["pod_sandbox_id", b"pod_sandbox_id"]
    ) -> None: ...

global___StopPodSandboxRequest = StopPodSandboxRequest

@typing.final
class StopPodSandboxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopPodSandboxResponse = StopPodSandboxResponse

@typing.final
class RemovePodSandboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox to remove."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["pod_sandbox_id", b"pod_sandbox_id"]
    ) -> None: ...

global___RemovePodSandboxRequest = RemovePodSandboxRequest

@typing.final
class RemovePodSandboxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemovePodSandboxResponse = RemovePodSandboxResponse

@typing.final
class PodSandboxStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    VERBOSE_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox for which to retrieve status."""
    verbose: builtins.bool
    """Verbose indicates whether to return extra information about the pod sandbox."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
        verbose: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "pod_sandbox_id", b"pod_sandbox_id", "verbose", b"verbose"
        ],
    ) -> None: ...

global___PodSandboxStatusRequest = PodSandboxStatusRequest

@typing.final
class PodIP(google.protobuf.message.Message):
    """PodIP represents an ip of a Pod"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IP_FIELD_NUMBER: builtins.int
    ip: builtins.str
    """an ip is a string representation of an IPv4 or an IPv6"""
    def __init__(
        self,
        *,
        ip: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ip", b"ip"]) -> None: ...

global___PodIP = PodIP

@typing.final
class PodSandboxNetworkStatus(google.protobuf.message.Message):
    """PodSandboxNetworkStatus is the status of the network for a PodSandbox.
    Currently ignored for pods sharing the host networking namespace.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IP_FIELD_NUMBER: builtins.int
    ADDITIONAL_IPS_FIELD_NUMBER: builtins.int
    ip: builtins.str
    """IP address of the PodSandbox."""
    @property
    def additional_ips(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PodIP
    ]:
        """list of additional ips (not inclusive of PodSandboxNetworkStatus.Ip) of the PodSandBoxNetworkStatus"""

    def __init__(
        self,
        *,
        ip: builtins.str = ...,
        additional_ips: collections.abc.Iterable[global___PodIP] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["additional_ips", b"additional_ips", "ip", b"ip"],
    ) -> None: ...

global___PodSandboxNetworkStatus = PodSandboxNetworkStatus

@typing.final
class Namespace(google.protobuf.message.Message):
    """Namespace contains paths to the namespaces."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> global___NamespaceOption:
        """Namespace options for Linux namespaces."""

    def __init__(
        self,
        *,
        options: global___NamespaceOption | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["options", b"options"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["options", b"options"]) -> None: ...

global___Namespace = Namespace

@typing.final
class LinuxPodSandboxStatus(google.protobuf.message.Message):
    """LinuxSandboxStatus contains status specific to Linux sandboxes."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACES_FIELD_NUMBER: builtins.int
    @property
    def namespaces(self) -> global___Namespace:
        """Paths to the sandbox's namespaces."""

    def __init__(
        self,
        *,
        namespaces: global___Namespace | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["namespaces", b"namespaces"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["namespaces", b"namespaces"]
    ) -> None: ...

global___LinuxPodSandboxStatus = LinuxPodSandboxStatus

@typing.final
class PodSandboxStatus(google.protobuf.message.Message):
    """PodSandboxStatus contains the status of the PodSandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    RUNTIME_HANDLER_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the sandbox."""
    state: global___PodSandboxState.ValueType
    """State of the sandbox."""
    created_at: builtins.int
    """Creation timestamp of the sandbox in nanoseconds. Must be > 0."""
    runtime_handler: builtins.str
    """runtime configuration used for this PodSandbox."""
    @property
    def metadata(self) -> global___PodSandboxMetadata:
        """Metadata of the sandbox."""

    @property
    def network(self) -> global___PodSandboxNetworkStatus:
        """Network contains network status if network is handled by the runtime."""

    @property
    def linux(self) -> global___LinuxPodSandboxStatus:
        """Linux-specific status to a pod sandbox."""

    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels are key-value pairs that may be used to scope and select individual resources."""

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding PodSandboxConfig used to
        instantiate the pod sandbox this status represents.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___PodSandboxMetadata | None = ...,
        state: global___PodSandboxState.ValueType = ...,
        created_at: builtins.int = ...,
        network: global___PodSandboxNetworkStatus | None = ...,
        linux: global___LinuxPodSandboxStatus | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        runtime_handler: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "linux", b"linux", "metadata", b"metadata", "network", b"network"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "created_at",
            b"created_at",
            "id",
            b"id",
            "labels",
            b"labels",
            "linux",
            b"linux",
            "metadata",
            b"metadata",
            "network",
            b"network",
            "runtime_handler",
            b"runtime_handler",
            "state",
            b"state",
        ],
    ) -> None: ...

global___PodSandboxStatus = PodSandboxStatus

@typing.final
class PodSandboxStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class InfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    CONTAINERS_STATUSES_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which container and pod statuses were recorded"""
    @property
    def status(self) -> global___PodSandboxStatus:
        """Status of the PodSandbox."""

    @property
    def info(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Info is extra information of the PodSandbox. The key could be arbitrary string, and
        value should be in json format. The information could include anything useful for
        debug, e.g. network namespace for linux container based container runtime.
        It should only be returned non-empty when Verbose is true.
        """

    @property
    def containers_statuses(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ContainerStatus
    ]:
        """Container statuses"""

    def __init__(
        self,
        *,
        status: global___PodSandboxStatus | None = ...,
        info: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        containers_statuses: (
            collections.abc.Iterable[global___ContainerStatus] | None
        ) = ...,
        timestamp: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["status", b"status"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "containers_statuses",
            b"containers_statuses",
            "info",
            b"info",
            "status",
            b"status",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___PodSandboxStatusResponse = PodSandboxStatusResponse

@typing.final
class PodSandboxStateValue(google.protobuf.message.Message):
    """PodSandboxStateValue is the wrapper of PodSandboxState."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___PodSandboxState.ValueType
    """State of the sandbox."""
    def __init__(
        self,
        *,
        state: global___PodSandboxState.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["state", b"state"]) -> None: ...

global___PodSandboxStateValue = PodSandboxStateValue

@typing.final
class PodSandboxFilter(google.protobuf.message.Message):
    """PodSandboxFilter is used to filter a list of PodSandboxes.
    All those fields are combined with 'AND'
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelSelectorEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    LABEL_SELECTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the sandbox."""
    @property
    def state(self) -> global___PodSandboxStateValue:
        """State of the sandbox."""

    @property
    def label_selector(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """LabelSelector to select matches.
        Only api.MatchLabels is supported for now and the requirements
        are ANDed. MatchExpressions is not supported yet.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        state: global___PodSandboxStateValue | None = ...,
        label_selector: (
            collections.abc.Mapping[builtins.str, builtins.str] | None
        ) = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["state", b"state"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "id", b"id", "label_selector", b"label_selector", "state", b"state"
        ],
    ) -> None: ...

global___PodSandboxFilter = PodSandboxFilter

@typing.final
class ListPodSandboxRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___PodSandboxFilter:
        """PodSandboxFilter to filter a list of PodSandboxes."""

    def __init__(
        self,
        *,
        filter: global___PodSandboxFilter | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["filter", b"filter"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

global___ListPodSandboxRequest = ListPodSandboxRequest

@typing.final
class PodSandbox(google.protobuf.message.Message):
    """PodSandbox contains minimal information about a sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    RUNTIME_HANDLER_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the PodSandbox."""
    state: global___PodSandboxState.ValueType
    """State of the PodSandbox."""
    created_at: builtins.int
    """Creation timestamps of the PodSandbox in nanoseconds. Must be > 0."""
    runtime_handler: builtins.str
    """runtime configuration used for this PodSandbox."""
    @property
    def metadata(self) -> global___PodSandboxMetadata:
        """Metadata of the PodSandbox."""

    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the PodSandbox."""

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding PodSandboxConfig used to
        instantiate this PodSandbox.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___PodSandboxMetadata | None = ...,
        state: global___PodSandboxState.ValueType = ...,
        created_at: builtins.int = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        runtime_handler: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["metadata", b"metadata"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "created_at",
            b"created_at",
            "id",
            b"id",
            "labels",
            b"labels",
            "metadata",
            b"metadata",
            "runtime_handler",
            b"runtime_handler",
            "state",
            b"state",
        ],
    ) -> None: ...

global___PodSandbox = PodSandbox

@typing.final
class ListPodSandboxResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PodSandbox
    ]:
        """List of PodSandboxes."""

    def __init__(
        self,
        *,
        items: collections.abc.Iterable[global___PodSandbox] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["items", b"items"]) -> None: ...

global___ListPodSandboxResponse = ListPodSandboxResponse

@typing.final
class PodSandboxStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the pod sandbox for which to retrieve stats."""
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["pod_sandbox_id", b"pod_sandbox_id"]
    ) -> None: ...

global___PodSandboxStatsRequest = PodSandboxStatsRequest

@typing.final
class PodSandboxStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_FIELD_NUMBER: builtins.int
    @property
    def stats(self) -> global___PodSandboxStats: ...
    def __init__(
        self,
        *,
        stats: global___PodSandboxStats | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["stats", b"stats"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["stats", b"stats"]) -> None: ...

global___PodSandboxStatsResponse = PodSandboxStatsResponse

@typing.final
class PodSandboxStatsFilter(google.protobuf.message.Message):
    """PodSandboxStatsFilter is used to filter the list of pod sandboxes to retrieve stats for.
    All those fields are combined with 'AND'.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelSelectorEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    LABEL_SELECTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the pod sandbox."""
    @property
    def label_selector(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """LabelSelector to select matches.
        Only api.MatchLabels is supported for now and the requirements
        are ANDed. MatchExpressions is not supported yet.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        label_selector: (
            collections.abc.Mapping[builtins.str, builtins.str] | None
        ) = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["id", b"id", "label_selector", b"label_selector"],
    ) -> None: ...

global___PodSandboxStatsFilter = PodSandboxStatsFilter

@typing.final
class ListPodSandboxStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___PodSandboxStatsFilter:
        """Filter for the list request."""

    def __init__(
        self,
        *,
        filter: global___PodSandboxStatsFilter | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["filter", b"filter"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

global___ListPodSandboxStatsRequest = ListPodSandboxStatsRequest

@typing.final
class ListPodSandboxStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_FIELD_NUMBER: builtins.int
    @property
    def stats(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PodSandboxStats
    ]:
        """Stats of the pod sandbox."""

    def __init__(
        self,
        *,
        stats: collections.abc.Iterable[global___PodSandboxStats] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stats", b"stats"]) -> None: ...

global___ListPodSandboxStatsResponse = ListPodSandboxStatsResponse

@typing.final
class PodSandboxAttributes(google.protobuf.message.Message):
    """PodSandboxAttributes provides basic information of the pod sandbox."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the pod sandbox."""
    @property
    def metadata(self) -> global___PodSandboxMetadata:
        """Metadata of the pod sandbox."""

    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding PodSandboxStatus used to
        instantiate the PodSandbox this status represents.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___PodSandboxMetadata | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["metadata", b"metadata"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "id",
            b"id",
            "labels",
            b"labels",
            "metadata",
            b"metadata",
        ],
    ) -> None: ...

global___PodSandboxAttributes = PodSandboxAttributes

@typing.final
class PodSandboxStats(google.protobuf.message.Message):
    """PodSandboxStats provides the resource usage statistics for a pod.
    The linux or windows field will be populated depending on the platform.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTRIBUTES_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    @property
    def attributes(self) -> global___PodSandboxAttributes:
        """Information of the pod."""

    @property
    def linux(self) -> global___LinuxPodSandboxStats:
        """Stats from linux."""

    @property
    def windows(self) -> global___WindowsPodSandboxStats:
        """Stats from windows."""

    def __init__(
        self,
        *,
        attributes: global___PodSandboxAttributes | None = ...,
        linux: global___LinuxPodSandboxStats | None = ...,
        windows: global___WindowsPodSandboxStats | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "attributes", b"attributes", "linux", b"linux", "windows", b"windows"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "attributes", b"attributes", "linux", b"linux", "windows", b"windows"
        ],
    ) -> None: ...

global___PodSandboxStats = PodSandboxStats

@typing.final
class LinuxPodSandboxStats(google.protobuf.message.Message):
    """LinuxPodSandboxStats provides the resource usage statistics for a pod sandbox on linux."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPU_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    PROCESS_FIELD_NUMBER: builtins.int
    CONTAINERS_FIELD_NUMBER: builtins.int
    IO_FIELD_NUMBER: builtins.int
    @property
    def cpu(self) -> global___CpuUsage:
        """CPU usage gathered for the pod sandbox."""

    @property
    def memory(self) -> global___MemoryUsage:
        """Memory usage gathered for the pod sandbox."""

    @property
    def network(self) -> global___NetworkUsage:
        """Network usage gathered for the pod sandbox"""

    @property
    def process(self) -> global___ProcessUsage:
        """Stats pertaining to processes in the pod sandbox."""

    @property
    def containers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ContainerStats
    ]:
        """Stats of containers in the measured pod sandbox."""

    @property
    def io(self) -> global___IoUsage:
        """IO usage gathered for the pod sandbox."""

    def __init__(
        self,
        *,
        cpu: global___CpuUsage | None = ...,
        memory: global___MemoryUsage | None = ...,
        network: global___NetworkUsage | None = ...,
        process: global___ProcessUsage | None = ...,
        containers: collections.abc.Iterable[global___ContainerStats] | None = ...,
        io: global___IoUsage | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "cpu",
            b"cpu",
            "io",
            b"io",
            "memory",
            b"memory",
            "network",
            b"network",
            "process",
            b"process",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "containers",
            b"containers",
            "cpu",
            b"cpu",
            "io",
            b"io",
            "memory",
            b"memory",
            "network",
            b"network",
            "process",
            b"process",
        ],
    ) -> None: ...

global___LinuxPodSandboxStats = LinuxPodSandboxStats

@typing.final
class WindowsPodSandboxStats(google.protobuf.message.Message):
    """WindowsPodSandboxStats provides the resource usage statistics for a pod sandbox on windows"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPU_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    PROCESS_FIELD_NUMBER: builtins.int
    CONTAINERS_FIELD_NUMBER: builtins.int
    @property
    def cpu(self) -> global___WindowsCpuUsage:
        """CPU usage gathered for the pod sandbox."""

    @property
    def memory(self) -> global___WindowsMemoryUsage:
        """Memory usage gathered for the pod sandbox."""

    @property
    def network(self) -> global___WindowsNetworkUsage:
        """Network usage gathered for the pod sandbox"""

    @property
    def process(self) -> global___WindowsProcessUsage:
        """Stats pertaining to processes in the pod sandbox."""

    @property
    def containers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___WindowsContainerStats
    ]:
        """Stats of containers in the measured pod sandbox."""

    def __init__(
        self,
        *,
        cpu: global___WindowsCpuUsage | None = ...,
        memory: global___WindowsMemoryUsage | None = ...,
        network: global___WindowsNetworkUsage | None = ...,
        process: global___WindowsProcessUsage | None = ...,
        containers: (
            collections.abc.Iterable[global___WindowsContainerStats] | None
        ) = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "cpu",
            b"cpu",
            "memory",
            b"memory",
            "network",
            b"network",
            "process",
            b"process",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "containers",
            b"containers",
            "cpu",
            b"cpu",
            "memory",
            b"memory",
            "network",
            b"network",
            "process",
            b"process",
        ],
    ) -> None: ...

global___WindowsPodSandboxStats = WindowsPodSandboxStats

@typing.final
class NetworkUsage(google.protobuf.message.Message):
    """NetworkUsage contains data about network resources."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    DEFAULT_INTERFACE_FIELD_NUMBER: builtins.int
    INTERFACES_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def default_interface(self) -> global___NetworkInterfaceUsage:
        """Stats for the default network interface."""

    @property
    def interfaces(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___NetworkInterfaceUsage
    ]:
        """Stats for all found network interfaces, excluding the default."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        default_interface: global___NetworkInterfaceUsage | None = ...,
        interfaces: (
            collections.abc.Iterable[global___NetworkInterfaceUsage] | None
        ) = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["default_interface", b"default_interface"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "default_interface",
            b"default_interface",
            "interfaces",
            b"interfaces",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___NetworkUsage = NetworkUsage

@typing.final
class WindowsNetworkUsage(google.protobuf.message.Message):
    """WindowsNetworkUsage contains data about network resources specific to Windows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    DEFAULT_INTERFACE_FIELD_NUMBER: builtins.int
    INTERFACES_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def default_interface(self) -> global___WindowsNetworkInterfaceUsage:
        """Stats for the default network interface."""

    @property
    def interfaces(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___WindowsNetworkInterfaceUsage
    ]:
        """Stats for all found network interfaces, excluding the default."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        default_interface: global___WindowsNetworkInterfaceUsage | None = ...,
        interfaces: (
            collections.abc.Iterable[global___WindowsNetworkInterfaceUsage] | None
        ) = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["default_interface", b"default_interface"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "default_interface",
            b"default_interface",
            "interfaces",
            b"interfaces",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___WindowsNetworkUsage = WindowsNetworkUsage

@typing.final
class NetworkInterfaceUsage(google.protobuf.message.Message):
    """NetworkInterfaceUsage contains resource value data about a network interface."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    RX_BYTES_FIELD_NUMBER: builtins.int
    RX_ERRORS_FIELD_NUMBER: builtins.int
    TX_BYTES_FIELD_NUMBER: builtins.int
    TX_ERRORS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the network interface."""
    @property
    def rx_bytes(self) -> global___UInt64Value:
        """Cumulative count of bytes received."""

    @property
    def rx_errors(self) -> global___UInt64Value:
        """Cumulative count of receive errors encountered."""

    @property
    def tx_bytes(self) -> global___UInt64Value:
        """Cumulative count of bytes transmitted."""

    @property
    def tx_errors(self) -> global___UInt64Value:
        """Cumulative count of transmit errors encountered."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        rx_bytes: global___UInt64Value | None = ...,
        rx_errors: global___UInt64Value | None = ...,
        tx_bytes: global___UInt64Value | None = ...,
        tx_errors: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "rx_bytes",
            b"rx_bytes",
            "rx_errors",
            b"rx_errors",
            "tx_bytes",
            b"tx_bytes",
            "tx_errors",
            b"tx_errors",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "name",
            b"name",
            "rx_bytes",
            b"rx_bytes",
            "rx_errors",
            b"rx_errors",
            "tx_bytes",
            b"tx_bytes",
            "tx_errors",
            b"tx_errors",
        ],
    ) -> None: ...

global___NetworkInterfaceUsage = NetworkInterfaceUsage

@typing.final
class WindowsNetworkInterfaceUsage(google.protobuf.message.Message):
    """WindowsNetworkInterfaceUsage contains resource value data about a network interface specific for Windows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    RX_BYTES_FIELD_NUMBER: builtins.int
    RX_PACKETS_DROPPED_FIELD_NUMBER: builtins.int
    TX_BYTES_FIELD_NUMBER: builtins.int
    TX_PACKETS_DROPPED_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the network interface."""
    @property
    def rx_bytes(self) -> global___UInt64Value:
        """Cumulative count of bytes received."""

    @property
    def rx_packets_dropped(self) -> global___UInt64Value:
        """Cumulative count of receive errors encountered."""

    @property
    def tx_bytes(self) -> global___UInt64Value:
        """Cumulative count of bytes transmitted."""

    @property
    def tx_packets_dropped(self) -> global___UInt64Value:
        """Cumulative count of transmit errors encountered."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        rx_bytes: global___UInt64Value | None = ...,
        rx_packets_dropped: global___UInt64Value | None = ...,
        tx_bytes: global___UInt64Value | None = ...,
        tx_packets_dropped: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "rx_bytes",
            b"rx_bytes",
            "rx_packets_dropped",
            b"rx_packets_dropped",
            "tx_bytes",
            b"tx_bytes",
            "tx_packets_dropped",
            b"tx_packets_dropped",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "name",
            b"name",
            "rx_bytes",
            b"rx_bytes",
            "rx_packets_dropped",
            b"rx_packets_dropped",
            "tx_bytes",
            b"tx_bytes",
            "tx_packets_dropped",
            b"tx_packets_dropped",
        ],
    ) -> None: ...

global___WindowsNetworkInterfaceUsage = WindowsNetworkInterfaceUsage

@typing.final
class ProcessUsage(google.protobuf.message.Message):
    """ProcessUsage are stats pertaining to processes."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    PROCESS_COUNT_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def process_count(self) -> global___UInt64Value:
        """Number of processes."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        process_count: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["process_count", b"process_count"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "process_count", b"process_count", "timestamp", b"timestamp"
        ],
    ) -> None: ...

global___ProcessUsage = ProcessUsage

@typing.final
class WindowsProcessUsage(google.protobuf.message.Message):
    """WindowsProcessUsage are stats pertaining to processes specific to Windows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    PROCESS_COUNT_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def process_count(self) -> global___UInt64Value:
        """Number of processes."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        process_count: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["process_count", b"process_count"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "process_count", b"process_count", "timestamp", b"timestamp"
        ],
    ) -> None: ...

global___WindowsProcessUsage = WindowsProcessUsage

@typing.final
class ImageSpec(google.protobuf.message.Message):
    """ImageSpec is an internal representation of an image."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    IMAGE_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    USER_SPECIFIED_IMAGE_FIELD_NUMBER: builtins.int
    RUNTIME_HANDLER_FIELD_NUMBER: builtins.int
    image: builtins.str
    """Container's Image field (e.g. imageID or imageDigest)."""
    user_specified_image: builtins.str
    """The container image reference specified by the user (e.g. image[:tag] or digest).
    Only set if available within the RPC context.
    """
    runtime_handler: builtins.str
    """Runtime handler to use for pulling the image.
    If the runtime handler is unknown, the request should be rejected.
    An empty string would select the default runtime handler.
    """
    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        ImageSpec Annotations can be used to help the runtime target specific
        images in multi-arch images.
        """

    def __init__(
        self,
        *,
        image: builtins.str = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        user_specified_image: builtins.str = ...,
        runtime_handler: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "image",
            b"image",
            "runtime_handler",
            b"runtime_handler",
            "user_specified_image",
            b"user_specified_image",
        ],
    ) -> None: ...

global___ImageSpec = ImageSpec

@typing.final
class KeyValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    value: builtins.str
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["key", b"key", "value", b"value"]
    ) -> None: ...

global___KeyValue = KeyValue

@typing.final
class LinuxContainerResources(google.protobuf.message.Message):
    """LinuxContainerResources specifies Linux specific configuration for
    resources.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class UnifiedEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    CPU_PERIOD_FIELD_NUMBER: builtins.int
    CPU_QUOTA_FIELD_NUMBER: builtins.int
    CPU_SHARES_FIELD_NUMBER: builtins.int
    MEMORY_LIMIT_IN_BYTES_FIELD_NUMBER: builtins.int
    OOM_SCORE_ADJ_FIELD_NUMBER: builtins.int
    CPUSET_CPUS_FIELD_NUMBER: builtins.int
    CPUSET_MEMS_FIELD_NUMBER: builtins.int
    HUGEPAGE_LIMITS_FIELD_NUMBER: builtins.int
    UNIFIED_FIELD_NUMBER: builtins.int
    MEMORY_SWAP_LIMIT_IN_BYTES_FIELD_NUMBER: builtins.int
    cpu_period: builtins.int
    """CPU CFS (Completely Fair Scheduler) period. Default: 0 (not specified)."""
    cpu_quota: builtins.int
    """CPU CFS (Completely Fair Scheduler) quota. Default: 0 (not specified)."""
    cpu_shares: builtins.int
    """CPU shares (relative weight vs. other containers). Default: 0 (not specified)."""
    memory_limit_in_bytes: builtins.int
    """Memory limit in bytes. Default: 0 (not specified)."""
    oom_score_adj: builtins.int
    """OOMScoreAdj adjusts the oom-killer score. Default: 0 (not specified)."""
    cpuset_cpus: builtins.str
    """CpusetCpus constrains the allowed set of logical CPUs. Default: "" (not specified)."""
    cpuset_mems: builtins.str
    """CpusetMems constrains the allowed set of memory nodes. Default: "" (not specified)."""
    memory_swap_limit_in_bytes: builtins.int
    """Memory swap limit in bytes. Default 0 (not specified)."""
    @property
    def hugepage_limits(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___HugepageLimit
    ]:
        """List of HugepageLimits to limit the HugeTLB usage of container per page size. Default: nil (not specified)."""

    @property
    def unified(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unified resources for cgroup v2. Default: nil (not specified).
        Each key/value in the map refers to the cgroup v2.
        e.g. "memory.max": "6937202688" or "io.weight": "default 100".
        """

    def __init__(
        self,
        *,
        cpu_period: builtins.int = ...,
        cpu_quota: builtins.int = ...,
        cpu_shares: builtins.int = ...,
        memory_limit_in_bytes: builtins.int = ...,
        oom_score_adj: builtins.int = ...,
        cpuset_cpus: builtins.str = ...,
        cpuset_mems: builtins.str = ...,
        hugepage_limits: collections.abc.Iterable[global___HugepageLimit] | None = ...,
        unified: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        memory_swap_limit_in_bytes: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "cpu_period",
            b"cpu_period",
            "cpu_quota",
            b"cpu_quota",
            "cpu_shares",
            b"cpu_shares",
            "cpuset_cpus",
            b"cpuset_cpus",
            "cpuset_mems",
            b"cpuset_mems",
            "hugepage_limits",
            b"hugepage_limits",
            "memory_limit_in_bytes",
            b"memory_limit_in_bytes",
            "memory_swap_limit_in_bytes",
            b"memory_swap_limit_in_bytes",
            "oom_score_adj",
            b"oom_score_adj",
            "unified",
            b"unified",
        ],
    ) -> None: ...

global___LinuxContainerResources = LinuxContainerResources

@typing.final
class HugepageLimit(google.protobuf.message.Message):
    """HugepageLimit corresponds to the file`hugetlb.<hugepagesize>.limit_in_byte` in container level cgroup.
    For example, `PageSize=1GB`, `Limit=1073741824` means setting `1073741824` bytes to hugetlb.1GB.limit_in_bytes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    page_size: builtins.str
    """The value of PageSize has the format <size><unit-prefix>B (2MB, 1GB),
    and must match the <hugepagesize> of the corresponding control file found in `hugetlb.<hugepagesize>.limit_in_bytes`.
    The values of <unit-prefix> are intended to be parsed using base 1024("1KB" = 1024, "1MB" = 1048576, etc).
    """
    limit: builtins.int
    """limit in bytes of hugepagesize HugeTLB usage."""
    def __init__(
        self,
        *,
        page_size: builtins.str = ...,
        limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["limit", b"limit", "page_size", b"page_size"]
    ) -> None: ...

global___HugepageLimit = HugepageLimit

@typing.final
class SELinuxOption(google.protobuf.message.Message):
    """SELinuxOption are the labels to be applied to the container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LEVEL_FIELD_NUMBER: builtins.int
    user: builtins.str
    role: builtins.str
    type: builtins.str
    level: builtins.str
    def __init__(
        self,
        *,
        user: builtins.str = ...,
        role: builtins.str = ...,
        type: builtins.str = ...,
        level: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "level", b"level", "role", b"role", "type", b"type", "user", b"user"
        ],
    ) -> None: ...

global___SELinuxOption = SELinuxOption

@typing.final
class Capability(google.protobuf.message.Message):
    """Capability contains the container capabilities to add or drop
    Dropping a capability will drop it from all sets.
    If a capability is added to only the add_capabilities list then it gets added to permitted,
    inheritable, effective and bounding sets, i.e. all sets except the ambient set.
    If a capability is added to only the add_ambient_capabilities list then it gets added to all sets, i.e permitted
    inheritable, effective, bounding and ambient sets.
    If a capability is added to add_capabilities and add_ambient_capabilities lists then it gets added to all sets, i.e.
    permitted, inheritable, effective, bounding and ambient sets.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADD_CAPABILITIES_FIELD_NUMBER: builtins.int
    DROP_CAPABILITIES_FIELD_NUMBER: builtins.int
    ADD_AMBIENT_CAPABILITIES_FIELD_NUMBER: builtins.int
    @property
    def add_capabilities(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of capabilities to add."""

    @property
    def drop_capabilities(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of capabilities to drop."""

    @property
    def add_ambient_capabilities(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of ambient capabilities to add."""

    def __init__(
        self,
        *,
        add_capabilities: collections.abc.Iterable[builtins.str] | None = ...,
        drop_capabilities: collections.abc.Iterable[builtins.str] | None = ...,
        add_ambient_capabilities: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "add_ambient_capabilities",
            b"add_ambient_capabilities",
            "add_capabilities",
            b"add_capabilities",
            "drop_capabilities",
            b"drop_capabilities",
        ],
    ) -> None: ...

global___Capability = Capability

@typing.final
class LinuxContainerSecurityContext(google.protobuf.message.Message):
    """LinuxContainerSecurityContext holds linux security configuration that will be applied to a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAPABILITIES_FIELD_NUMBER: builtins.int
    PRIVILEGED_FIELD_NUMBER: builtins.int
    NAMESPACE_OPTIONS_FIELD_NUMBER: builtins.int
    SELINUX_OPTIONS_FIELD_NUMBER: builtins.int
    RUN_AS_USER_FIELD_NUMBER: builtins.int
    RUN_AS_GROUP_FIELD_NUMBER: builtins.int
    RUN_AS_USERNAME_FIELD_NUMBER: builtins.int
    READONLY_ROOTFS_FIELD_NUMBER: builtins.int
    SUPPLEMENTAL_GROUPS_FIELD_NUMBER: builtins.int
    SUPPLEMENTAL_GROUPS_POLICY_FIELD_NUMBER: builtins.int
    NO_NEW_PRIVS_FIELD_NUMBER: builtins.int
    MASKED_PATHS_FIELD_NUMBER: builtins.int
    READONLY_PATHS_FIELD_NUMBER: builtins.int
    SECCOMP_FIELD_NUMBER: builtins.int
    APPARMOR_FIELD_NUMBER: builtins.int
    APPARMOR_PROFILE_FIELD_NUMBER: builtins.int
    SECCOMP_PROFILE_PATH_FIELD_NUMBER: builtins.int
    privileged: builtins.bool
    """If set, run container in privileged mode.
    Privileged mode is incompatible with the following options. If
    privileged is set, the following features MAY have no effect:
    1. capabilities
    2. selinux_options
    4. seccomp
    5. apparmor

    Privileged mode implies the following specific options are applied:
    1. All capabilities are added.
    2. Sensitive paths, such as kernel module paths within sysfs, are not masked.
    3. Any sysfs and procfs mounts are mounted RW.
    4. AppArmor confinement is not applied.
    5. Seccomp restrictions are not applied.
    6. The device cgroup does not restrict access to any devices.
    7. All devices from the host's /dev are available within the container.
    8. SELinux restrictions are not applied (e.g. label=disabled).
    """
    run_as_username: builtins.str
    """User name to run the container process as. If specified, the user MUST
    exist in the container image (i.e. in the /etc/passwd inside the image),
    and be resolved there by the runtime; otherwise, the runtime MUST error.
    """
    readonly_rootfs: builtins.bool
    """If set, the root filesystem of the container is read-only."""
    supplemental_groups_policy: global___SupplementalGroupsPolicy.ValueType
    """supplemental_groups_policy defines how supplemental groups of the first 
    container processes are calculated.
    Valid values are "Merge" and "Strict".
    If not specified, "Merge" is used.
    """
    no_new_privs: builtins.bool
    """no_new_privs defines if the flag for no_new_privs should be set on the
    container.
    """
    apparmor_profile: builtins.str
    """AppArmor profile for the container, candidate values are:
    * runtime/default: equivalent to not specifying a profile.
    * unconfined: no profiles are loaded
    * localhost/<profile_name>: profile loaded on the node
       (localhost) by name. The possible profile names are detailed at
       https://gitlab.com/apparmor/apparmor/-/wikis/AppArmor_Core_Policy_Reference
    """
    seccomp_profile_path: builtins.str
    """Seccomp profile for the container, candidate values are:
    * runtime/default: the default profile for the container runtime
    * unconfined: unconfined profile, ie, no seccomp sandboxing
    * localhost/<full-path-to-profile>: the profile installed on the node.
      <full-path-to-profile> is the full path of the profile.
    Default: "", which is identical with unconfined.
    """
    @property
    def capabilities(self) -> global___Capability:
        """Capabilities to add or drop."""

    @property
    def namespace_options(self) -> global___NamespaceOption:
        """Configurations for the container's namespaces.
        Only used if the container uses namespace for isolation.
        """

    @property
    def selinux_options(self) -> global___SELinuxOption:
        """SELinux context to be optionally applied."""

    @property
    def run_as_user(self) -> global___Int64Value:
        """UID to run the container process as. Only one of run_as_user and
        run_as_username can be specified at a time.
        """

    @property
    def run_as_group(self) -> global___Int64Value:
        """GID to run the container process as. run_as_group should only be specified
        when run_as_user or run_as_username is specified; otherwise, the runtime
        MUST error.
        """

    @property
    def supplemental_groups(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """List of groups applied to the first process run in each container.
        supplemental_groups_policy can control how groups will be calculated.
        """

    @property
    def masked_paths(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """masked_paths is a slice of paths that should be masked by the container
        runtime, this can be passed directly to the OCI spec.
        """

    @property
    def readonly_paths(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """readonly_paths is a slice of paths that should be set as readonly by the
        container runtime, this can be passed directly to the OCI spec.
        """

    @property
    def seccomp(self) -> global___SecurityProfile:
        """Seccomp profile for the container."""

    @property
    def apparmor(self) -> global___SecurityProfile:
        """AppArmor profile for the container."""

    def __init__(
        self,
        *,
        capabilities: global___Capability | None = ...,
        privileged: builtins.bool = ...,
        namespace_options: global___NamespaceOption | None = ...,
        selinux_options: global___SELinuxOption | None = ...,
        run_as_user: global___Int64Value | None = ...,
        run_as_group: global___Int64Value | None = ...,
        run_as_username: builtins.str = ...,
        readonly_rootfs: builtins.bool = ...,
        supplemental_groups: collections.abc.Iterable[builtins.int] | None = ...,
        supplemental_groups_policy: global___SupplementalGroupsPolicy.ValueType = ...,
        no_new_privs: builtins.bool = ...,
        masked_paths: collections.abc.Iterable[builtins.str] | None = ...,
        readonly_paths: collections.abc.Iterable[builtins.str] | None = ...,
        seccomp: global___SecurityProfile | None = ...,
        apparmor: global___SecurityProfile | None = ...,
        apparmor_profile: builtins.str = ...,
        seccomp_profile_path: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "apparmor",
            b"apparmor",
            "capabilities",
            b"capabilities",
            "namespace_options",
            b"namespace_options",
            "run_as_group",
            b"run_as_group",
            "run_as_user",
            b"run_as_user",
            "seccomp",
            b"seccomp",
            "selinux_options",
            b"selinux_options",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "apparmor",
            b"apparmor",
            "apparmor_profile",
            b"apparmor_profile",
            "capabilities",
            b"capabilities",
            "masked_paths",
            b"masked_paths",
            "namespace_options",
            b"namespace_options",
            "no_new_privs",
            b"no_new_privs",
            "privileged",
            b"privileged",
            "readonly_paths",
            b"readonly_paths",
            "readonly_rootfs",
            b"readonly_rootfs",
            "run_as_group",
            b"run_as_group",
            "run_as_user",
            b"run_as_user",
            "run_as_username",
            b"run_as_username",
            "seccomp",
            b"seccomp",
            "seccomp_profile_path",
            b"seccomp_profile_path",
            "selinux_options",
            b"selinux_options",
            "supplemental_groups",
            b"supplemental_groups",
            "supplemental_groups_policy",
            b"supplemental_groups_policy",
        ],
    ) -> None: ...

global___LinuxContainerSecurityContext = LinuxContainerSecurityContext

@typing.final
class LinuxContainerConfig(google.protobuf.message.Message):
    """LinuxContainerConfig contains platform-specific configuration for
    Linux-based containers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    SECURITY_CONTEXT_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___LinuxContainerResources:
        """Resources specification for the container."""

    @property
    def security_context(self) -> global___LinuxContainerSecurityContext:
        """LinuxContainerSecurityContext configuration for the container."""

    def __init__(
        self,
        *,
        resources: global___LinuxContainerResources | None = ...,
        security_context: global___LinuxContainerSecurityContext | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "resources", b"resources", "security_context", b"security_context"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "resources", b"resources", "security_context", b"security_context"
        ],
    ) -> None: ...

global___LinuxContainerConfig = LinuxContainerConfig

@typing.final
class LinuxContainerUser(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    GID_FIELD_NUMBER: builtins.int
    SUPPLEMENTAL_GROUPS_FIELD_NUMBER: builtins.int
    uid: builtins.int
    """uid is the primary uid initially attached to the first process in the container"""
    gid: builtins.int
    """gid is the primary gid initially attached to the first process in the container"""
    @property
    def supplemental_groups(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """supplemental_groups are the supplemental groups initially attached to the first process in the container"""

    def __init__(
        self,
        *,
        uid: builtins.int = ...,
        gid: builtins.int = ...,
        supplemental_groups: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "gid", b"gid", "supplemental_groups", b"supplemental_groups", "uid", b"uid"
        ],
    ) -> None: ...

global___LinuxContainerUser = LinuxContainerUser

@typing.final
class WindowsNamespaceOption(google.protobuf.message.Message):
    """WindowsNamespaceOption provides options for Windows namespaces."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_FIELD_NUMBER: builtins.int
    network: global___NamespaceMode.ValueType
    """Network namespace for this container/sandbox.
    This is currently never set by the kubelet
    """
    def __init__(
        self,
        *,
        network: global___NamespaceMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["network", b"network"]) -> None: ...

global___WindowsNamespaceOption = WindowsNamespaceOption

@typing.final
class WindowsSandboxSecurityContext(google.protobuf.message.Message):
    """WindowsSandboxSecurityContext holds platform-specific configurations that will be
    applied to a sandbox.
    These settings will only apply to the sandbox container.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_AS_USERNAME_FIELD_NUMBER: builtins.int
    CREDENTIAL_SPEC_FIELD_NUMBER: builtins.int
    HOST_PROCESS_FIELD_NUMBER: builtins.int
    NAMESPACE_OPTIONS_FIELD_NUMBER: builtins.int
    run_as_username: builtins.str
    """User name to run the container process as. If specified, the user MUST
    exist in the container image and be resolved there by the runtime;
    otherwise, the runtime MUST return error.
    """
    credential_spec: builtins.str
    """The contents of the GMSA credential spec to use to run this container."""
    host_process: builtins.bool
    """Indicates whether the container requested to run as a HostProcess container."""
    @property
    def namespace_options(self) -> global___WindowsNamespaceOption:
        """Configuration for the sandbox's namespaces"""

    def __init__(
        self,
        *,
        run_as_username: builtins.str = ...,
        credential_spec: builtins.str = ...,
        host_process: builtins.bool = ...,
        namespace_options: global___WindowsNamespaceOption | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["namespace_options", b"namespace_options"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "credential_spec",
            b"credential_spec",
            "host_process",
            b"host_process",
            "namespace_options",
            b"namespace_options",
            "run_as_username",
            b"run_as_username",
        ],
    ) -> None: ...

global___WindowsSandboxSecurityContext = WindowsSandboxSecurityContext

@typing.final
class WindowsPodSandboxConfig(google.protobuf.message.Message):
    """WindowsPodSandboxConfig holds platform-specific configurations for Windows
    host platforms and Windows-based containers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_CONTEXT_FIELD_NUMBER: builtins.int
    @property
    def security_context(self) -> global___WindowsSandboxSecurityContext:
        """WindowsSandboxSecurityContext holds sandbox security attributes."""

    def __init__(
        self,
        *,
        security_context: global___WindowsSandboxSecurityContext | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["security_context", b"security_context"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["security_context", b"security_context"]
    ) -> None: ...

global___WindowsPodSandboxConfig = WindowsPodSandboxConfig

@typing.final
class WindowsContainerSecurityContext(google.protobuf.message.Message):
    """WindowsContainerSecurityContext holds windows security configuration that will be applied to a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_AS_USERNAME_FIELD_NUMBER: builtins.int
    CREDENTIAL_SPEC_FIELD_NUMBER: builtins.int
    HOST_PROCESS_FIELD_NUMBER: builtins.int
    run_as_username: builtins.str
    """User name to run the container process as. If specified, the user MUST
    exist in the container image and be resolved there by the runtime;
    otherwise, the runtime MUST return error.
    """
    credential_spec: builtins.str
    """The contents of the GMSA credential spec to use to run this container."""
    host_process: builtins.bool
    """Indicates whether a container is to be run as a HostProcess container."""
    def __init__(
        self,
        *,
        run_as_username: builtins.str = ...,
        credential_spec: builtins.str = ...,
        host_process: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "credential_spec",
            b"credential_spec",
            "host_process",
            b"host_process",
            "run_as_username",
            b"run_as_username",
        ],
    ) -> None: ...

global___WindowsContainerSecurityContext = WindowsContainerSecurityContext

@typing.final
class WindowsContainerConfig(google.protobuf.message.Message):
    """WindowsContainerConfig contains platform-specific configuration for
    Windows-based containers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    SECURITY_CONTEXT_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___WindowsContainerResources:
        """Resources specification for the container."""

    @property
    def security_context(self) -> global___WindowsContainerSecurityContext:
        """WindowsContainerSecurityContext configuration for the container."""

    def __init__(
        self,
        *,
        resources: global___WindowsContainerResources | None = ...,
        security_context: global___WindowsContainerSecurityContext | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "resources", b"resources", "security_context", b"security_context"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "resources", b"resources", "security_context", b"security_context"
        ],
    ) -> None: ...

global___WindowsContainerConfig = WindowsContainerConfig

@typing.final
class WindowsContainerResources(google.protobuf.message.Message):
    """WindowsContainerResources specifies Windows specific configuration for
    resources.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPU_SHARES_FIELD_NUMBER: builtins.int
    CPU_COUNT_FIELD_NUMBER: builtins.int
    CPU_MAXIMUM_FIELD_NUMBER: builtins.int
    MEMORY_LIMIT_IN_BYTES_FIELD_NUMBER: builtins.int
    ROOTFS_SIZE_IN_BYTES_FIELD_NUMBER: builtins.int
    AFFINITY_CPUS_FIELD_NUMBER: builtins.int
    cpu_shares: builtins.int
    """CPU shares (relative weight vs. other containers). Default: 0 (not specified)."""
    cpu_count: builtins.int
    """Number of CPUs available to the container. Default: 0 (not specified)."""
    cpu_maximum: builtins.int
    """Specifies the portion of processor cycles that this container can use as a percentage times 100."""
    memory_limit_in_bytes: builtins.int
    """Memory limit in bytes. Default: 0 (not specified)."""
    rootfs_size_in_bytes: builtins.int
    """Specifies the size of the rootfs / scratch space in bytes to be configured for this container. Default: 0 (not specified)."""
    @property
    def affinity_cpus(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___WindowsCpuGroupAffinity
    ]:
        """Optionally specifies the set of CPUs to affinitize for this container."""

    def __init__(
        self,
        *,
        cpu_shares: builtins.int = ...,
        cpu_count: builtins.int = ...,
        cpu_maximum: builtins.int = ...,
        memory_limit_in_bytes: builtins.int = ...,
        rootfs_size_in_bytes: builtins.int = ...,
        affinity_cpus: (
            collections.abc.Iterable[global___WindowsCpuGroupAffinity] | None
        ) = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "affinity_cpus",
            b"affinity_cpus",
            "cpu_count",
            b"cpu_count",
            "cpu_maximum",
            b"cpu_maximum",
            "cpu_shares",
            b"cpu_shares",
            "memory_limit_in_bytes",
            b"memory_limit_in_bytes",
            "rootfs_size_in_bytes",
            b"rootfs_size_in_bytes",
        ],
    ) -> None: ...

global___WindowsContainerResources = WindowsContainerResources

@typing.final
class WindowsCpuGroupAffinity(google.protobuf.message.Message):
    """WindowsCpuGroupAffinity specifies the CPU mask and group to affinitize.
    This is similar to the following _GROUP_AFFINITY structure:
    https://learn.microsoft.com/en-us/windows-hardware/drivers/ddi/miniport/ns-miniport-_group_affinity
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPU_MASK_FIELD_NUMBER: builtins.int
    CPU_GROUP_FIELD_NUMBER: builtins.int
    cpu_mask: builtins.int
    """CPU mask relative to this CPU group."""
    cpu_group: builtins.int
    """Processor group the mask refers to, as returned by
    GetLogicalProcessorInformationEx.
    """
    def __init__(
        self,
        *,
        cpu_mask: builtins.int = ...,
        cpu_group: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["cpu_group", b"cpu_group", "cpu_mask", b"cpu_mask"],
    ) -> None: ...

global___WindowsCpuGroupAffinity = WindowsCpuGroupAffinity

@typing.final
class ContainerMetadata(google.protobuf.message.Message):
    """ContainerMetadata holds all necessary information for building the container
    name. The container runtime is encouraged to expose the metadata in its user
    interface for better user experience. E.g., runtime can construct a unique
    container name based on the metadata. Note that (name, attempt) is unique
    within a sandbox for the entire lifetime of the sandbox.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the container. Same as the container name in the PodSpec."""
    attempt: builtins.int
    """Attempt number of creating the container. Default: 0."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        attempt: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["attempt", b"attempt", "name", b"name"]
    ) -> None: ...

global___ContainerMetadata = ContainerMetadata

@typing.final
class Device(google.protobuf.message.Message):
    """Device specifies a host device to mount into a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_PATH_FIELD_NUMBER: builtins.int
    HOST_PATH_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    container_path: builtins.str
    """Path of the device within the container."""
    host_path: builtins.str
    """Path of the device on the host."""
    permissions: builtins.str
    """Cgroups permissions of the device, candidates are one or more of
    * r - allows container to read from the specified device.
    * w - allows container to write to the specified device.
    * m - allows container to create device files that do not yet exist.
    """
    def __init__(
        self,
        *,
        container_path: builtins.str = ...,
        host_path: builtins.str = ...,
        permissions: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_path",
            b"container_path",
            "host_path",
            b"host_path",
            "permissions",
            b"permissions",
        ],
    ) -> None: ...

global___Device = Device

@typing.final
class CDIDevice(google.protobuf.message.Message):
    """CDIDevice specifies a CDI device information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Fully qualified CDI device name
    for example: vendor.com/gpu=gpudevice1
    see more details in the CDI specification:
    https://github.com/container-orchestrated-devices/container-device-interface/blob/main/SPEC.md
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name"]) -> None: ...

global___CDIDevice = CDIDevice

@typing.final
class ContainerConfig(google.protobuf.message.Message):
    """ContainerConfig holds all the required and optional fields for creating a
    container.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    METADATA_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    COMMAND_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    WORKING_DIR_FIELD_NUMBER: builtins.int
    ENVS_FIELD_NUMBER: builtins.int
    MOUNTS_FIELD_NUMBER: builtins.int
    DEVICES_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    LOG_PATH_FIELD_NUMBER: builtins.int
    STDIN_FIELD_NUMBER: builtins.int
    STDIN_ONCE_FIELD_NUMBER: builtins.int
    TTY_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    CDI_DEVICES_FIELD_NUMBER: builtins.int
    STOP_SIGNAL_FIELD_NUMBER: builtins.int
    working_dir: builtins.str
    """Current working directory of the command."""
    log_path: builtins.str
    """Path relative to PodSandboxConfig.LogDirectory for container to store
    the log (STDOUT and STDERR) on the host.
    E.g.,
        PodSandboxConfig.LogDirectory = `/var/log/pods/<NAMESPACE>_<NAME>_<UID>/`
        ContainerConfig.LogPath = `containerName/Instance#.log`
    """
    stdin: builtins.bool
    """Variables for interactive containers, these have very specialized
    use-cases (e.g. debugging).
    """
    stdin_once: builtins.bool
    tty: builtins.bool
    stop_signal: global___Signal.ValueType
    """The custom stop signal for the container"""
    @property
    def metadata(self) -> global___ContainerMetadata:
        """Metadata of the container. This information will uniquely identify the
        container, and the runtime should leverage this to ensure correct
        operation. The runtime may also use this information to improve UX, such
        as by constructing a readable name.
        """

    @property
    def image(self) -> global___ImageSpec:
        """Image to use."""

    @property
    def command(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Command to execute (i.e., entrypoint for docker)"""

    @property
    def args(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Args for the Command (i.e., command for docker)"""

    @property
    def envs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___KeyValue
    ]:
        """List of environment variable to set in the container."""

    @property
    def mounts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Mount
    ]:
        """Mounts for the container."""

    @property
    def devices(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Device
    ]:
        """Devices for the container."""

    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources.
        Label keys are of the form:
            label-key ::= prefixed-name | name
            prefixed-name ::= prefix '/' name
            prefix ::= DNS_SUBDOMAIN
            name ::= DNS_LABEL
        """

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map that may be used by the kubelet to store and
        retrieve arbitrary metadata.

        Annotations MUST NOT be altered by the runtime; the annotations stored
        here MUST be returned in the ContainerStatus associated with the container
        this ContainerConfig creates.

        In general, in order to preserve a well-defined interface between the
        kubelet and the container runtime, annotations SHOULD NOT influence
        runtime behaviour.
        """

    @property
    def linux(self) -> global___LinuxContainerConfig:
        """Configuration specific to Linux containers."""

    @property
    def windows(self) -> global___WindowsContainerConfig:
        """Configuration specific to Windows containers."""

    @property
    def CDI_devices(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___CDIDevice
    ]:
        """CDI devices for the container."""

    def __init__(
        self,
        *,
        metadata: global___ContainerMetadata | None = ...,
        image: global___ImageSpec | None = ...,
        command: collections.abc.Iterable[builtins.str] | None = ...,
        args: collections.abc.Iterable[builtins.str] | None = ...,
        working_dir: builtins.str = ...,
        envs: collections.abc.Iterable[global___KeyValue] | None = ...,
        mounts: collections.abc.Iterable[global___Mount] | None = ...,
        devices: collections.abc.Iterable[global___Device] | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        log_path: builtins.str = ...,
        stdin: builtins.bool = ...,
        stdin_once: builtins.bool = ...,
        tty: builtins.bool = ...,
        linux: global___LinuxContainerConfig | None = ...,
        windows: global___WindowsContainerConfig | None = ...,
        CDI_devices: collections.abc.Iterable[global___CDIDevice] | None = ...,
        stop_signal: global___Signal.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "image",
            b"image",
            "linux",
            b"linux",
            "metadata",
            b"metadata",
            "windows",
            b"windows",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "CDI_devices",
            b"CDI_devices",
            "annotations",
            b"annotations",
            "args",
            b"args",
            "command",
            b"command",
            "devices",
            b"devices",
            "envs",
            b"envs",
            "image",
            b"image",
            "labels",
            b"labels",
            "linux",
            b"linux",
            "log_path",
            b"log_path",
            "metadata",
            b"metadata",
            "mounts",
            b"mounts",
            "stdin",
            b"stdin",
            "stdin_once",
            b"stdin_once",
            "stop_signal",
            b"stop_signal",
            "tty",
            b"tty",
            "windows",
            b"windows",
            "working_dir",
            b"working_dir",
        ],
    ) -> None: ...

global___ContainerConfig = ContainerConfig

@typing.final
class CreateContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    SANDBOX_CONFIG_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox in which the container should be created."""
    @property
    def config(self) -> global___ContainerConfig:
        """Config of the container."""

    @property
    def sandbox_config(self) -> global___PodSandboxConfig:
        """Config of the PodSandbox. This is the same config that was passed
        to RunPodSandboxRequest to create the PodSandbox. It is passed again
        here just for easy reference. The PodSandboxConfig is immutable and
        remains the same throughout the lifetime of the pod.
        """

    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
        config: global___ContainerConfig | None = ...,
        sandbox_config: global___PodSandboxConfig | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "config", b"config", "sandbox_config", b"sandbox_config"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "config",
            b"config",
            "pod_sandbox_id",
            b"pod_sandbox_id",
            "sandbox_config",
            b"sandbox_config",
        ],
    ) -> None: ...

global___CreateContainerRequest = CreateContainerRequest

@typing.final
class CreateContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the created container."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["container_id", b"container_id"]
    ) -> None: ...

global___CreateContainerResponse = CreateContainerResponse

@typing.final
class StartContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to start."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["container_id", b"container_id"]
    ) -> None: ...

global___StartContainerRequest = StartContainerRequest

@typing.final
class StartContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StartContainerResponse = StartContainerResponse

@typing.final
class StopContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to stop."""
    timeout: builtins.int
    """Timeout in seconds to wait for the container to stop before forcibly
    terminating it. Default: 0 (forcibly terminate the container immediately)
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_id", b"container_id", "timeout", b"timeout"
        ],
    ) -> None: ...

global___StopContainerRequest = StopContainerRequest

@typing.final
class StopContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopContainerResponse = StopContainerResponse

@typing.final
class RemoveContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to remove."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["container_id", b"container_id"]
    ) -> None: ...

global___RemoveContainerRequest = RemoveContainerRequest

@typing.final
class RemoveContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoveContainerResponse = RemoveContainerResponse

@typing.final
class ContainerStateValue(google.protobuf.message.Message):
    """ContainerStateValue is the wrapper of ContainerState."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___ContainerState.ValueType
    """State of the container."""
    def __init__(
        self,
        *,
        state: global___ContainerState.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["state", b"state"]) -> None: ...

global___ContainerStateValue = ContainerStateValue

@typing.final
class ContainerFilter(google.protobuf.message.Message):
    """ContainerFilter is used to filter containers.
    All those fields are combined with 'AND'
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelSelectorEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    LABEL_SELECTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container."""
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox."""
    @property
    def state(self) -> global___ContainerStateValue:
        """State of the container."""

    @property
    def label_selector(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """LabelSelector to select matches.
        Only api.MatchLabels is supported for now and the requirements
        are ANDed. MatchExpressions is not supported yet.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        state: global___ContainerStateValue | None = ...,
        pod_sandbox_id: builtins.str = ...,
        label_selector: (
            collections.abc.Mapping[builtins.str, builtins.str] | None
        ) = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["state", b"state"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "id",
            b"id",
            "label_selector",
            b"label_selector",
            "pod_sandbox_id",
            b"pod_sandbox_id",
            "state",
            b"state",
        ],
    ) -> None: ...

global___ContainerFilter = ContainerFilter

@typing.final
class ListContainersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ContainerFilter: ...
    def __init__(
        self,
        *,
        filter: global___ContainerFilter | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["filter", b"filter"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

global___ListContainersRequest = ListContainersRequest

@typing.final
class Container(google.protobuf.message.Message):
    """Container provides the runtime information for a container, such as ID, hash,
    state of the container.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    IMAGE_REF_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    IMAGE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container, used by the container runtime to identify
    a container.
    """
    pod_sandbox_id: builtins.str
    """ID of the sandbox to which this container belongs."""
    image_ref: builtins.str
    """Digested reference to the image in use."""
    state: global___ContainerState.ValueType
    """State of the container."""
    created_at: builtins.int
    """Creation time of the container in nanoseconds."""
    image_id: builtins.str
    """Reference to the unique identifier of the image, on the node, as
    returned in the image service apis.

    Note: The image_ref above has been historically used by container
    runtimes to reference images by digest. The image_ref has been also used
    in the kubelet image garbage collection, which does not work with
    digests at all. To separate and avoid possible misusage, we now
    introduce the image_id field, which should always refer to a unique
    image identifier on the node.
    """
    @property
    def metadata(self) -> global___ContainerMetadata:
        """Metadata of the container."""

    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""

    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding ContainerConfig used to
        instantiate this Container.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        pod_sandbox_id: builtins.str = ...,
        metadata: global___ContainerMetadata | None = ...,
        image: global___ImageSpec | None = ...,
        image_ref: builtins.str = ...,
        state: global___ContainerState.ValueType = ...,
        created_at: builtins.int = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        image_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["image", b"image", "metadata", b"metadata"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "created_at",
            b"created_at",
            "id",
            b"id",
            "image",
            b"image",
            "image_id",
            b"image_id",
            "image_ref",
            b"image_ref",
            "labels",
            b"labels",
            "metadata",
            b"metadata",
            "pod_sandbox_id",
            b"pod_sandbox_id",
            "state",
            b"state",
        ],
    ) -> None: ...

global___Container = Container

@typing.final
class ListContainersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINERS_FIELD_NUMBER: builtins.int
    @property
    def containers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Container
    ]:
        """List of containers."""

    def __init__(
        self,
        *,
        containers: collections.abc.Iterable[global___Container] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["containers", b"containers"]
    ) -> None: ...

global___ListContainersResponse = ListContainersResponse

@typing.final
class ContainerStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    VERBOSE_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container for which to retrieve status."""
    verbose: builtins.bool
    """Verbose indicates whether to return extra information about the container."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        verbose: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_id", b"container_id", "verbose", b"verbose"
        ],
    ) -> None: ...

global___ContainerStatusRequest = ContainerStatusRequest

@typing.final
class ContainerStatus(google.protobuf.message.Message):
    """ContainerStatus represents the status of a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    FINISHED_AT_FIELD_NUMBER: builtins.int
    EXIT_CODE_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    IMAGE_REF_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    MOUNTS_FIELD_NUMBER: builtins.int
    LOG_PATH_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    IMAGE_ID_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    STOP_SIGNAL_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container."""
    state: global___ContainerState.ValueType
    """Status of the container."""
    created_at: builtins.int
    """Creation time of the container in nanoseconds."""
    started_at: builtins.int
    """Start time of the container in nanoseconds. Default: 0 (not specified)."""
    finished_at: builtins.int
    """Finish time of the container in nanoseconds. Default: 0 (not specified)."""
    exit_code: builtins.int
    """Exit code of the container. Only required when finished_at != 0. Default: 0."""
    image_ref: builtins.str
    """Digested reference to the image in use."""
    reason: builtins.str
    """Brief CamelCase string explaining why container is in its current state.
    Must be set to "OOMKilled" for containers terminated by cgroup-based Out-of-Memory killer.
    """
    message: builtins.str
    """Human-readable message indicating details about why container is in its
    current state.
    """
    log_path: builtins.str
    """Log path of container."""
    image_id: builtins.str
    """Reference to the unique identifier of the image, on the node, as
    returned in the image service apis.

    Note: The image_ref above has been historically used by container
    runtimes to reference images by digest. To separate and avoid possible
    misusage, we now introduce the image_id field, which should always refer
    to a unique image identifier on the node.
    """
    stop_signal: global___Signal.ValueType
    """Returns the stop signal used by the container runtime to terminate the container"""
    @property
    def metadata(self) -> global___ContainerMetadata:
        """Metadata of the container."""

    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""

    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding ContainerConfig used to
        instantiate the Container this status represents.
        """

    @property
    def mounts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Mount
    ]:
        """Mounts for the container."""

    @property
    def resources(self) -> global___ContainerResources:
        """Resource limits configuration of the container."""

    @property
    def user(self) -> global___ContainerUser:
        """User identities initially attached to the container"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___ContainerMetadata | None = ...,
        state: global___ContainerState.ValueType = ...,
        created_at: builtins.int = ...,
        started_at: builtins.int = ...,
        finished_at: builtins.int = ...,
        exit_code: builtins.int = ...,
        image: global___ImageSpec | None = ...,
        image_ref: builtins.str = ...,
        reason: builtins.str = ...,
        message: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        mounts: collections.abc.Iterable[global___Mount] | None = ...,
        log_path: builtins.str = ...,
        resources: global___ContainerResources | None = ...,
        image_id: builtins.str = ...,
        user: global___ContainerUser | None = ...,
        stop_signal: global___Signal.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "image",
            b"image",
            "metadata",
            b"metadata",
            "resources",
            b"resources",
            "user",
            b"user",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "created_at",
            b"created_at",
            "exit_code",
            b"exit_code",
            "finished_at",
            b"finished_at",
            "id",
            b"id",
            "image",
            b"image",
            "image_id",
            b"image_id",
            "image_ref",
            b"image_ref",
            "labels",
            b"labels",
            "log_path",
            b"log_path",
            "message",
            b"message",
            "metadata",
            b"metadata",
            "mounts",
            b"mounts",
            "reason",
            b"reason",
            "resources",
            b"resources",
            "started_at",
            b"started_at",
            "state",
            b"state",
            "stop_signal",
            b"stop_signal",
            "user",
            b"user",
        ],
    ) -> None: ...

global___ContainerStatus = ContainerStatus

@typing.final
class ContainerStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class InfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> global___ContainerStatus:
        """Status of the container."""

    @property
    def info(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Info is extra information of the Container. The key could be arbitrary string, and
        value should be in json format. The information could include anything useful for
        debug, e.g. pid for linux container based container runtime.
        It should only be returned non-empty when Verbose is true.
        """

    def __init__(
        self,
        *,
        status: global___ContainerStatus | None = ...,
        info: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["status", b"status"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["info", b"info", "status", b"status"]
    ) -> None: ...

global___ContainerStatusResponse = ContainerStatusResponse

@typing.final
class ContainerResources(google.protobuf.message.Message):
    """ContainerResources holds resource limits configuration for a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    @property
    def linux(self) -> global___LinuxContainerResources:
        """Resource limits configuration specific to Linux container."""

    @property
    def windows(self) -> global___WindowsContainerResources:
        """Resource limits configuration specific to Windows container."""

    def __init__(
        self,
        *,
        linux: global___LinuxContainerResources | None = ...,
        windows: global___WindowsContainerResources | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["linux", b"linux", "windows", b"windows"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["linux", b"linux", "windows", b"windows"]
    ) -> None: ...

global___ContainerResources = ContainerResources

@typing.final
class ContainerUser(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LINUX_FIELD_NUMBER: builtins.int
    @property
    def linux(self) -> global___LinuxContainerUser:
        """User identities initially attached to first process in the Linux container.
        Note that the actual running identity can be changed if the process has enough privilege to do so.
        """

    def __init__(
        self,
        *,
        linux: global___LinuxContainerUser | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["linux", b"linux"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["linux", b"linux"]) -> None: ...

global___ContainerUser = ContainerUser

@typing.final
class UpdateContainerResourcesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    LINUX_FIELD_NUMBER: builtins.int
    WINDOWS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to update."""
    @property
    def linux(self) -> global___LinuxContainerResources:
        """Resource configuration specific to Linux containers."""

    @property
    def windows(self) -> global___WindowsContainerResources:
        """Resource configuration specific to Windows containers."""

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary additional information for
        container resources updating. This can be used for specifying experimental
        resources to update or other options to use when updating the container.
        """

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        linux: global___LinuxContainerResources | None = ...,
        windows: global___WindowsContainerResources | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["linux", b"linux", "windows", b"windows"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "container_id",
            b"container_id",
            "linux",
            b"linux",
            "windows",
            b"windows",
        ],
    ) -> None: ...

global___UpdateContainerResourcesRequest = UpdateContainerResourcesRequest

@typing.final
class UpdateContainerResourcesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateContainerResourcesResponse = UpdateContainerResourcesResponse

@typing.final
class ExecSyncRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    CMD_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container."""
    timeout: builtins.int
    """Timeout in seconds to stop the command. Default: 0 (run forever)."""
    @property
    def cmd(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Command to execute."""

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        cmd: collections.abc.Iterable[builtins.str] | None = ...,
        timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "cmd", b"cmd", "container_id", b"container_id", "timeout", b"timeout"
        ],
    ) -> None: ...

global___ExecSyncRequest = ExecSyncRequest

@typing.final
class ExecSyncResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STDOUT_FIELD_NUMBER: builtins.int
    STDERR_FIELD_NUMBER: builtins.int
    EXIT_CODE_FIELD_NUMBER: builtins.int
    stdout: builtins.bytes
    """Captured command stdout output.
    The runtime should cap the output of this response to 16MB.
    If the stdout of the command produces more than 16MB, the remaining output
    should be discarded, and the command should proceed with no error.
    See CVE-2022-1708 and CVE-2022-31030 for more information.
    """
    stderr: builtins.bytes
    """Captured command stderr output.
    The runtime should cap the output of this response to 16MB.
    If the stderr of the command produces more than 16MB, the remaining output
    should be discarded, and the command should proceed with no error.
    See CVE-2022-1708 and CVE-2022-31030 for more information.
    """
    exit_code: builtins.int
    """Exit code the command finished with. Default: 0 (success)."""
    def __init__(
        self,
        *,
        stdout: builtins.bytes = ...,
        stderr: builtins.bytes = ...,
        exit_code: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "exit_code", b"exit_code", "stderr", b"stderr", "stdout", b"stdout"
        ],
    ) -> None: ...

global___ExecSyncResponse = ExecSyncResponse

@typing.final
class ExecRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    CMD_FIELD_NUMBER: builtins.int
    TTY_FIELD_NUMBER: builtins.int
    STDIN_FIELD_NUMBER: builtins.int
    STDOUT_FIELD_NUMBER: builtins.int
    STDERR_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container in which to execute the command."""
    tty: builtins.bool
    """Whether to exec the command in a TTY."""
    stdin: builtins.bool
    """Whether to stream stdin.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    """
    stdout: builtins.bool
    """Whether to stream stdout.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    """
    stderr: builtins.bool
    """Whether to stream stderr.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
    in this case. The output of stdout and stderr will be combined to a
    single stream.
    """
    @property
    def cmd(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Command to execute."""

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        cmd: collections.abc.Iterable[builtins.str] | None = ...,
        tty: builtins.bool = ...,
        stdin: builtins.bool = ...,
        stdout: builtins.bool = ...,
        stderr: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "cmd",
            b"cmd",
            "container_id",
            b"container_id",
            "stderr",
            b"stderr",
            "stdin",
            b"stdin",
            "stdout",
            b"stdout",
            "tty",
            b"tty",
        ],
    ) -> None: ...

global___ExecRequest = ExecRequest

@typing.final
class ExecResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """Fully qualified URL of the exec streaming server."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

global___ExecResponse = ExecResponse

@typing.final
class AttachRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    STDIN_FIELD_NUMBER: builtins.int
    TTY_FIELD_NUMBER: builtins.int
    STDOUT_FIELD_NUMBER: builtins.int
    STDERR_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to which to attach."""
    stdin: builtins.bool
    """Whether to stream stdin.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    """
    tty: builtins.bool
    """Whether the process being attached is running in a TTY.
    This must match the TTY setting in the ContainerConfig.
    """
    stdout: builtins.bool
    """Whether to stream stdout.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    """
    stderr: builtins.bool
    """Whether to stream stderr.
    One of `stdin`, `stdout`, and `stderr` MUST be true.
    If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
    in this case. The output of stdout and stderr will be combined to a
    single stream.
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        stdin: builtins.bool = ...,
        tty: builtins.bool = ...,
        stdout: builtins.bool = ...,
        stderr: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_id",
            b"container_id",
            "stderr",
            b"stderr",
            "stdin",
            b"stdin",
            "stdout",
            b"stdout",
            "tty",
            b"tty",
        ],
    ) -> None: ...

global___AttachRequest = AttachRequest

@typing.final
class AttachResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """Fully qualified URL of the attach streaming server."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

global___AttachResponse = AttachResponse

@typing.final
class PortForwardRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the container to which to forward the port."""
    @property
    def port(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Port to forward."""

    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
        port: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "pod_sandbox_id", b"pod_sandbox_id", "port", b"port"
        ],
    ) -> None: ...

global___PortForwardRequest = PortForwardRequest

@typing.final
class PortForwardResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """Fully qualified URL of the port-forward streaming server."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

global___PortForwardResponse = PortForwardResponse

@typing.final
class ImageFilter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""

    def __init__(
        self,
        *,
        image: global___ImageSpec | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["image", b"image"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["image", b"image"]) -> None: ...

global___ImageFilter = ImageFilter

@typing.final
class ListImagesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ImageFilter:
        """Filter to list images."""

    def __init__(
        self,
        *,
        filter: global___ImageFilter | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["filter", b"filter"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

global___ListImagesRequest = ListImagesRequest

@typing.final
class Image(google.protobuf.message.Message):
    """Basic information about a container image."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    REPO_TAGS_FIELD_NUMBER: builtins.int
    REPO_DIGESTS_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    PINNED_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the image."""
    size: builtins.int
    """Size of the image in bytes. Must be > 0."""
    username: builtins.str
    """User name that will run the command(s). This is used if UID is not set
    and no user is specified when creating container.
    """
    pinned: builtins.bool
    """Recommendation on whether this image should be exempt from garbage collection.
    It must only be treated as a recommendation -- the client can still request that the image be deleted,
    and the runtime must oblige.
    """
    @property
    def repo_tags(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Other names by which this image is known."""

    @property
    def repo_digests(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Digests by which this image is known."""

    @property
    def uid(self) -> global___Int64Value:
        """UID that will run the command(s). This is used as a default if no user is
        specified when creating the container. UID and the following user name
        are mutually exclusive.
        """

    @property
    def spec(self) -> global___ImageSpec:
        """ImageSpec for image which includes annotations"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        repo_tags: collections.abc.Iterable[builtins.str] | None = ...,
        repo_digests: collections.abc.Iterable[builtins.str] | None = ...,
        size: builtins.int = ...,
        uid: global___Int64Value | None = ...,
        username: builtins.str = ...,
        spec: global___ImageSpec | None = ...,
        pinned: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["spec", b"spec", "uid", b"uid"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "id",
            b"id",
            "pinned",
            b"pinned",
            "repo_digests",
            b"repo_digests",
            "repo_tags",
            b"repo_tags",
            "size",
            b"size",
            "spec",
            b"spec",
            "uid",
            b"uid",
            "username",
            b"username",
        ],
    ) -> None: ...

global___Image = Image

@typing.final
class ListImagesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGES_FIELD_NUMBER: builtins.int
    @property
    def images(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Image
    ]:
        """List of images."""

    def __init__(
        self,
        *,
        images: collections.abc.Iterable[global___Image] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["images", b"images"]) -> None: ...

global___ListImagesResponse = ListImagesResponse

@typing.final
class ImageStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    VERBOSE_FIELD_NUMBER: builtins.int
    verbose: builtins.bool
    """Verbose indicates whether to return extra information about the image."""
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""

    def __init__(
        self,
        *,
        image: global___ImageSpec | None = ...,
        verbose: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["image", b"image"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["image", b"image", "verbose", b"verbose"]
    ) -> None: ...

global___ImageStatusRequest = ImageStatusRequest

@typing.final
class ImageStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class InfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    IMAGE_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___Image:
        """Status of the image."""

    @property
    def info(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Info is extra information of the Image. The key could be arbitrary string, and
        value should be in json format. The information could include anything useful
        for debug, e.g. image config for oci image based container runtime.
        It should only be returned non-empty when Verbose is true.
        """

    def __init__(
        self,
        *,
        image: global___Image | None = ...,
        info: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["image", b"image"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["image", b"image", "info", b"info"]
    ) -> None: ...

global___ImageStatusResponse = ImageStatusResponse

@typing.final
class AuthConfig(google.protobuf.message.Message):
    """AuthConfig contains authorization information for connecting to a registry."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERNAME_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    AUTH_FIELD_NUMBER: builtins.int
    SERVER_ADDRESS_FIELD_NUMBER: builtins.int
    IDENTITY_TOKEN_FIELD_NUMBER: builtins.int
    REGISTRY_TOKEN_FIELD_NUMBER: builtins.int
    username: builtins.str
    password: builtins.str
    auth: builtins.str
    server_address: builtins.str
    identity_token: builtins.str
    """IdentityToken is used to authenticate the user and get
    an access token for the registry.
    """
    registry_token: builtins.str
    """RegistryToken is a bearer token to be sent to a registry"""
    def __init__(
        self,
        *,
        username: builtins.str = ...,
        password: builtins.str = ...,
        auth: builtins.str = ...,
        server_address: builtins.str = ...,
        identity_token: builtins.str = ...,
        registry_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "auth",
            b"auth",
            "identity_token",
            b"identity_token",
            "password",
            b"password",
            "registry_token",
            b"registry_token",
            "server_address",
            b"server_address",
            "username",
            b"username",
        ],
    ) -> None: ...

global___AuthConfig = AuthConfig

@typing.final
class PullImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    AUTH_FIELD_NUMBER: builtins.int
    SANDBOX_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image."""

    @property
    def auth(self) -> global___AuthConfig:
        """Authentication configuration for pulling the image."""

    @property
    def sandbox_config(self) -> global___PodSandboxConfig:
        """Config of the PodSandbox, which is used to pull image in PodSandbox context."""

    def __init__(
        self,
        *,
        image: global___ImageSpec | None = ...,
        auth: global___AuthConfig | None = ...,
        sandbox_config: global___PodSandboxConfig | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "auth", b"auth", "image", b"image", "sandbox_config", b"sandbox_config"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "auth", b"auth", "image", b"image", "sandbox_config", b"sandbox_config"
        ],
    ) -> None: ...

global___PullImageRequest = PullImageRequest

@typing.final
class PullImageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_REF_FIELD_NUMBER: builtins.int
    image_ref: builtins.str
    """Reference to the image in use. For most runtimes, this should be an
    image ID or digest.
    """
    def __init__(
        self,
        *,
        image_ref: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["image_ref", b"image_ref"]
    ) -> None: ...

global___PullImageResponse = PullImageResponse

@typing.final
class RemoveImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___ImageSpec:
        """Spec of the image to remove."""

    def __init__(
        self,
        *,
        image: global___ImageSpec | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["image", b"image"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["image", b"image"]) -> None: ...

global___RemoveImageRequest = RemoveImageRequest

@typing.final
class RemoveImageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoveImageResponse = RemoveImageResponse

@typing.final
class NetworkConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_CIDR_FIELD_NUMBER: builtins.int
    pod_cidr: builtins.str
    """CIDR to use for pod IP addresses. If the CIDR is empty, runtimes
    should omit it.
    """
    def __init__(
        self,
        *,
        pod_cidr: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["pod_cidr", b"pod_cidr"]
    ) -> None: ...

global___NetworkConfig = NetworkConfig

@typing.final
class RuntimeConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def network_config(self) -> global___NetworkConfig: ...
    def __init__(
        self,
        *,
        network_config: global___NetworkConfig | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["network_config", b"network_config"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["network_config", b"network_config"]
    ) -> None: ...

global___RuntimeConfig = RuntimeConfig

@typing.final
class UpdateRuntimeConfigRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUNTIME_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def runtime_config(self) -> global___RuntimeConfig: ...
    def __init__(
        self,
        *,
        runtime_config: global___RuntimeConfig | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["runtime_config", b"runtime_config"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["runtime_config", b"runtime_config"]
    ) -> None: ...

global___UpdateRuntimeConfigRequest = UpdateRuntimeConfigRequest

@typing.final
class UpdateRuntimeConfigResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateRuntimeConfigResponse = UpdateRuntimeConfigResponse

@typing.final
class RuntimeCondition(google.protobuf.message.Message):
    """RuntimeCondition contains condition information for the runtime.
    There are 2 kinds of runtime conditions:
    1. Required conditions: Conditions are required for kubelet to work
    properly. If any required condition is unmet, the node will be not ready.
    The required conditions include:
      * RuntimeReady: RuntimeReady means the runtime is up and ready to accept
      basic containers e.g. container only needs host network.
      * NetworkReady: NetworkReady means the runtime network is up and ready to
      accept containers which require container network.
    2. Optional conditions: Conditions are informative to the user, but kubelet
    will not rely on. Since condition type is an arbitrary string, all conditions
    not required are optional. These conditions will be exposed to users to help
    them understand the status of the system.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    type: builtins.str
    """Type of runtime condition."""
    status: builtins.bool
    """Status of the condition, one of true/false. Default: false."""
    reason: builtins.str
    """Brief CamelCase string containing reason for the condition's last transition."""
    message: builtins.str
    """Human-readable message indicating details about last transition."""
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        status: builtins.bool = ...,
        reason: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "message",
            b"message",
            "reason",
            b"reason",
            "status",
            b"status",
            "type",
            b"type",
        ],
    ) -> None: ...

global___RuntimeCondition = RuntimeCondition

@typing.final
class RuntimeStatus(google.protobuf.message.Message):
    """RuntimeStatus is information about the current status of the runtime."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONDITIONS_FIELD_NUMBER: builtins.int
    @property
    def conditions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___RuntimeCondition
    ]:
        """List of current observed runtime conditions."""

    def __init__(
        self,
        *,
        conditions: collections.abc.Iterable[global___RuntimeCondition] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["conditions", b"conditions"]
    ) -> None: ...

global___RuntimeStatus = RuntimeStatus

@typing.final
class StatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERBOSE_FIELD_NUMBER: builtins.int
    verbose: builtins.bool
    """Verbose indicates whether to return extra information about the runtime."""
    def __init__(
        self,
        *,
        verbose: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["verbose", b"verbose"]) -> None: ...

global___StatusRequest = StatusRequest

@typing.final
class RuntimeHandlerFeatures(google.protobuf.message.Message):
    """RuntimeHandlerFeatures is a set of features implemented by the runtime handler."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECURSIVE_READ_ONLY_MOUNTS_FIELD_NUMBER: builtins.int
    USER_NAMESPACES_FIELD_NUMBER: builtins.int
    recursive_read_only_mounts: builtins.bool
    """recursive_read_only_mounts is set to true if the runtime handler supports
    recursive read-only mounts.
    For runc-compatible runtimes, availability of this feature can be detected by checking whether
    the Linux kernel version is >= 5.12, and,  `runc features | jq .mountOptions` contains "rro".
    """
    user_namespaces: builtins.bool
    """user_namespaces is set to true if the runtime handler supports user namespaces as implemented
    in Kubernetes. This means support for both, user namespaces and idmap mounts.
    """
    def __init__(
        self,
        *,
        recursive_read_only_mounts: builtins.bool = ...,
        user_namespaces: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "recursive_read_only_mounts",
            b"recursive_read_only_mounts",
            "user_namespaces",
            b"user_namespaces",
        ],
    ) -> None: ...

global___RuntimeHandlerFeatures = RuntimeHandlerFeatures

@typing.final
class RuntimeHandler(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name must be unique in StatusResponse.
    An empty string denotes the default handler.
    """
    @property
    def features(self) -> global___RuntimeHandlerFeatures:
        """Supported features."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        features: global___RuntimeHandlerFeatures | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["features", b"features"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["features", b"features", "name", b"name"]
    ) -> None: ...

global___RuntimeHandler = RuntimeHandler

@typing.final
class RuntimeFeatures(google.protobuf.message.Message):
    """RuntimeFeatures describes the set of features implemented by the CRI implementation.
    The features contained in the RuntimeFeatures should depend only on the cri implementation
    independent of runtime handlers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUPPLEMENTAL_GROUPS_POLICY_FIELD_NUMBER: builtins.int
    supplemental_groups_policy: builtins.bool
    """supplemental_groups_policy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser."""
    def __init__(
        self,
        *,
        supplemental_groups_policy: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "supplemental_groups_policy", b"supplemental_groups_policy"
        ],
    ) -> None: ...

global___RuntimeFeatures = RuntimeFeatures

@typing.final
class StatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class InfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    RUNTIME_HANDLERS_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> global___RuntimeStatus:
        """Status of the Runtime."""

    @property
    def info(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Info is extra information of the Runtime. The key could be arbitrary string, and
        value should be in json format. The information could include anything useful for
        debug, e.g. plugins used by the container runtime.
        It should only be returned non-empty when Verbose is true.
        """

    @property
    def runtime_handlers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___RuntimeHandler
    ]:
        """Runtime handlers."""

    @property
    def features(self) -> global___RuntimeFeatures:
        """features describes the set of features implemented by the CRI implementation.
        This field is supposed to propagate to NodeFeatures in Kubernetes API.
        """

    def __init__(
        self,
        *,
        status: global___RuntimeStatus | None = ...,
        info: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        runtime_handlers: (
            collections.abc.Iterable[global___RuntimeHandler] | None
        ) = ...,
        features: global___RuntimeFeatures | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["features", b"features", "status", b"status"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "features",
            b"features",
            "info",
            b"info",
            "runtime_handlers",
            b"runtime_handlers",
            "status",
            b"status",
        ],
    ) -> None: ...

global___StatusResponse = StatusResponse

@typing.final
class ImageFsInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ImageFsInfoRequest = ImageFsInfoRequest

@typing.final
class UInt64Value(google.protobuf.message.Message):
    """UInt64Value is the wrapper of uint64."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.int
    """The value."""
    def __init__(
        self,
        *,
        value: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["value", b"value"]) -> None: ...

global___UInt64Value = UInt64Value

@typing.final
class FilesystemIdentifier(google.protobuf.message.Message):
    """FilesystemIdentifier uniquely identify the filesystem."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MOUNTPOINT_FIELD_NUMBER: builtins.int
    mountpoint: builtins.str
    """Mountpoint of a filesystem."""
    def __init__(
        self,
        *,
        mountpoint: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["mountpoint", b"mountpoint"]
    ) -> None: ...

global___FilesystemIdentifier = FilesystemIdentifier

@typing.final
class FilesystemUsage(google.protobuf.message.Message):
    """FilesystemUsage provides the filesystem usage information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    FS_ID_FIELD_NUMBER: builtins.int
    USED_BYTES_FIELD_NUMBER: builtins.int
    INODES_USED_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def fs_id(self) -> global___FilesystemIdentifier:
        """The unique identifier of the filesystem."""

    @property
    def used_bytes(self) -> global___UInt64Value:
        """UsedBytes represents the bytes used for images on the filesystem.
        This may differ from the total bytes used on the filesystem and may not
        equal CapacityBytes - AvailableBytes.
        """

    @property
    def inodes_used(self) -> global___UInt64Value:
        """InodesUsed represents the inodes used by the images.
        This may not equal InodesCapacity - InodesAvailable because the underlying
        filesystem may also be used for purposes other than storing images.
        """

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        fs_id: global___FilesystemIdentifier | None = ...,
        used_bytes: global___UInt64Value | None = ...,
        inodes_used: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "fs_id",
            b"fs_id",
            "inodes_used",
            b"inodes_used",
            "used_bytes",
            b"used_bytes",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "fs_id",
            b"fs_id",
            "inodes_used",
            b"inodes_used",
            "timestamp",
            b"timestamp",
            "used_bytes",
            b"used_bytes",
        ],
    ) -> None: ...

global___FilesystemUsage = FilesystemUsage

@typing.final
class WindowsFilesystemUsage(google.protobuf.message.Message):
    """WindowsFilesystemUsage provides the filesystem usage information specific to Windows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    FS_ID_FIELD_NUMBER: builtins.int
    USED_BYTES_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def fs_id(self) -> global___FilesystemIdentifier:
        """The unique identifier of the filesystem."""

    @property
    def used_bytes(self) -> global___UInt64Value:
        """UsedBytes represents the bytes used for images on the filesystem.
        This may differ from the total bytes used on the filesystem and may not
        equal CapacityBytes - AvailableBytes.
        """

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        fs_id: global___FilesystemIdentifier | None = ...,
        used_bytes: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["fs_id", b"fs_id", "used_bytes", b"used_bytes"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "fs_id", b"fs_id", "timestamp", b"timestamp", "used_bytes", b"used_bytes"
        ],
    ) -> None: ...

global___WindowsFilesystemUsage = WindowsFilesystemUsage

@typing.final
class ImageFsInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FILESYSTEMS_FIELD_NUMBER: builtins.int
    CONTAINER_FILESYSTEMS_FIELD_NUMBER: builtins.int
    @property
    def image_filesystems(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___FilesystemUsage
    ]:
        """Information of image filesystem(s)."""

    @property
    def container_filesystems(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___FilesystemUsage
    ]:
        """Information of container filesystem(s).
        This is an optional field, may be used for example if container and image
        storage are separated.
        Default will be to return this as empty.
        """

    def __init__(
        self,
        *,
        image_filesystems: (
            collections.abc.Iterable[global___FilesystemUsage] | None
        ) = ...,
        container_filesystems: (
            collections.abc.Iterable[global___FilesystemUsage] | None
        ) = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_filesystems",
            b"container_filesystems",
            "image_filesystems",
            b"image_filesystems",
        ],
    ) -> None: ...

global___ImageFsInfoResponse = ImageFsInfoResponse

@typing.final
class ContainerStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container for which to retrieve stats."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["container_id", b"container_id"]
    ) -> None: ...

global___ContainerStatsRequest = ContainerStatsRequest

@typing.final
class ContainerStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_FIELD_NUMBER: builtins.int
    @property
    def stats(self) -> global___ContainerStats:
        """Stats of the container."""

    def __init__(
        self,
        *,
        stats: global___ContainerStats | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["stats", b"stats"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["stats", b"stats"]) -> None: ...

global___ContainerStatsResponse = ContainerStatsResponse

@typing.final
class ListContainerStatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ContainerStatsFilter:
        """Filter for the list request."""

    def __init__(
        self,
        *,
        filter: global___ContainerStatsFilter | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["filter", b"filter"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

global___ListContainerStatsRequest = ListContainerStatsRequest

@typing.final
class ContainerStatsFilter(google.protobuf.message.Message):
    """ContainerStatsFilter is used to filter containers.
    All those fields are combined with 'AND'
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelSelectorEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    LABEL_SELECTOR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container."""
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox."""
    @property
    def label_selector(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """LabelSelector to select matches.
        Only api.MatchLabels is supported for now and the requirements
        are ANDed. MatchExpressions is not supported yet.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        pod_sandbox_id: builtins.str = ...,
        label_selector: (
            collections.abc.Mapping[builtins.str, builtins.str] | None
        ) = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "id",
            b"id",
            "label_selector",
            b"label_selector",
            "pod_sandbox_id",
            b"pod_sandbox_id",
        ],
    ) -> None: ...

global___ContainerStatsFilter = ContainerStatsFilter

@typing.final
class ListContainerStatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_FIELD_NUMBER: builtins.int
    @property
    def stats(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ContainerStats
    ]:
        """Stats of the container."""

    def __init__(
        self,
        *,
        stats: collections.abc.Iterable[global___ContainerStats] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stats", b"stats"]) -> None: ...

global___ListContainerStatsResponse = ListContainerStatsResponse

@typing.final
class ContainerAttributes(google.protobuf.message.Message):
    """ContainerAttributes provides basic information of the container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the container."""
    @property
    def metadata(self) -> global___ContainerMetadata:
        """Metadata of the container."""

    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Key-value pairs that may be used to scope and select individual resources."""

    @property
    def annotations(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Unstructured key-value map holding arbitrary metadata.
        Annotations MUST NOT be altered by the runtime; the value of this field
        MUST be identical to that of the corresponding ContainerConfig used to
        instantiate the Container this status represents.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: global___ContainerMetadata | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["metadata", b"metadata"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "annotations",
            b"annotations",
            "id",
            b"id",
            "labels",
            b"labels",
            "metadata",
            b"metadata",
        ],
    ) -> None: ...

global___ContainerAttributes = ContainerAttributes

@typing.final
class ContainerStats(google.protobuf.message.Message):
    """ContainerStats provides the resource usage statistics for a container."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTRIBUTES_FIELD_NUMBER: builtins.int
    CPU_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    WRITABLE_LAYER_FIELD_NUMBER: builtins.int
    SWAP_FIELD_NUMBER: builtins.int
    IO_FIELD_NUMBER: builtins.int
    @property
    def attributes(self) -> global___ContainerAttributes:
        """Information of the container."""

    @property
    def cpu(self) -> global___CpuUsage:
        """CPU usage gathered from the container."""

    @property
    def memory(self) -> global___MemoryUsage:
        """Memory usage gathered from the container."""

    @property
    def writable_layer(self) -> global___FilesystemUsage:
        """Usage of the writable layer."""

    @property
    def swap(self) -> global___SwapUsage:
        """Swap usage gathered from the container."""

    @property
    def io(self) -> global___IoUsage:
        """IO usage gathered from the container."""

    def __init__(
        self,
        *,
        attributes: global___ContainerAttributes | None = ...,
        cpu: global___CpuUsage | None = ...,
        memory: global___MemoryUsage | None = ...,
        writable_layer: global___FilesystemUsage | None = ...,
        swap: global___SwapUsage | None = ...,
        io: global___IoUsage | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "attributes",
            b"attributes",
            "cpu",
            b"cpu",
            "io",
            b"io",
            "memory",
            b"memory",
            "swap",
            b"swap",
            "writable_layer",
            b"writable_layer",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "attributes",
            b"attributes",
            "cpu",
            b"cpu",
            "io",
            b"io",
            "memory",
            b"memory",
            "swap",
            b"swap",
            "writable_layer",
            b"writable_layer",
        ],
    ) -> None: ...

global___ContainerStats = ContainerStats

@typing.final
class WindowsContainerStats(google.protobuf.message.Message):
    """WindowsContainerStats provides the resource usage statistics for a container specific for Windows"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATTRIBUTES_FIELD_NUMBER: builtins.int
    CPU_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    WRITABLE_LAYER_FIELD_NUMBER: builtins.int
    @property
    def attributes(self) -> global___ContainerAttributes:
        """Information of the container."""

    @property
    def cpu(self) -> global___WindowsCpuUsage:
        """CPU usage gathered from the container."""

    @property
    def memory(self) -> global___WindowsMemoryUsage:
        """Memory usage gathered from the container."""

    @property
    def writable_layer(self) -> global___WindowsFilesystemUsage:
        """Usage of the writable layer."""

    def __init__(
        self,
        *,
        attributes: global___ContainerAttributes | None = ...,
        cpu: global___WindowsCpuUsage | None = ...,
        memory: global___WindowsMemoryUsage | None = ...,
        writable_layer: global___WindowsFilesystemUsage | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "attributes",
            b"attributes",
            "cpu",
            b"cpu",
            "memory",
            b"memory",
            "writable_layer",
            b"writable_layer",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "attributes",
            b"attributes",
            "cpu",
            b"cpu",
            "memory",
            b"memory",
            "writable_layer",
            b"writable_layer",
        ],
    ) -> None: ...

global___WindowsContainerStats = WindowsContainerStats

@typing.final
class PsiStats(google.protobuf.message.Message):
    """PSI statistics for an individual resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FULL_FIELD_NUMBER: builtins.int
    SOME_FIELD_NUMBER: builtins.int
    @property
    def Full(self) -> global___PsiData:
        """PSI data for all tasks in the cgroup."""

    @property
    def Some(self) -> global___PsiData:
        """PSI data for some tasks in the cgroup."""

    def __init__(
        self,
        *,
        Full: global___PsiData | None = ...,
        Some: global___PsiData | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["Full", b"Full", "Some", b"Some"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["Full", b"Full", "Some", b"Some"]
    ) -> None: ...

global___PsiStats = PsiStats

@typing.final
class PsiData(google.protobuf.message.Message):
    """PSI data for an individual resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOTAL_FIELD_NUMBER: builtins.int
    AVG10_FIELD_NUMBER: builtins.int
    AVG60_FIELD_NUMBER: builtins.int
    AVG300_FIELD_NUMBER: builtins.int
    Total: builtins.int
    """Total time duration for tasks in the cgroup have waited due to congestion.
    Unit: nanoseconds.
    """
    Avg10: builtins.float
    """The average (in %) tasks have waited due to congestion over a 10 second window."""
    Avg60: builtins.float
    """The average (in %) tasks have waited due to congestion over a 60 second window."""
    Avg300: builtins.float
    """The average (in %) tasks have waited due to congestion over a 300 second window."""
    def __init__(
        self,
        *,
        Total: builtins.int = ...,
        Avg10: builtins.float = ...,
        Avg60: builtins.float = ...,
        Avg300: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "Avg10", b"Avg10", "Avg300", b"Avg300", "Avg60", b"Avg60", "Total", b"Total"
        ],
    ) -> None: ...

global___PsiData = PsiData

@typing.final
class CpuUsage(google.protobuf.message.Message):
    """CpuUsage provides the CPU usage information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    USAGE_CORE_NANO_SECONDS_FIELD_NUMBER: builtins.int
    USAGE_NANO_CORES_FIELD_NUMBER: builtins.int
    PSI_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def usage_core_nano_seconds(self) -> global___UInt64Value:
        """Cumulative CPU usage (sum across all cores) since object creation."""

    @property
    def usage_nano_cores(self) -> global___UInt64Value:
        """Total CPU usage (sum of all cores) averaged over the sample window.
        The "core" unit can be interpreted as CPU core-nanoseconds per second.
        """

    @property
    def psi(self) -> global___PsiStats:
        """CPU PSI statistics."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        usage_core_nano_seconds: global___UInt64Value | None = ...,
        usage_nano_cores: global___UInt64Value | None = ...,
        psi: global___PsiStats | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "psi",
            b"psi",
            "usage_core_nano_seconds",
            b"usage_core_nano_seconds",
            "usage_nano_cores",
            b"usage_nano_cores",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "psi",
            b"psi",
            "timestamp",
            b"timestamp",
            "usage_core_nano_seconds",
            b"usage_core_nano_seconds",
            "usage_nano_cores",
            b"usage_nano_cores",
        ],
    ) -> None: ...

global___CpuUsage = CpuUsage

@typing.final
class WindowsCpuUsage(google.protobuf.message.Message):
    """WindowsCpuUsage provides the CPU usage information specific to Windows"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    USAGE_CORE_NANO_SECONDS_FIELD_NUMBER: builtins.int
    USAGE_NANO_CORES_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def usage_core_nano_seconds(self) -> global___UInt64Value:
        """Cumulative CPU usage (sum across all cores) since object creation."""

    @property
    def usage_nano_cores(self) -> global___UInt64Value:
        """Total CPU usage (sum of all cores) averaged over the sample window.
        The "core" unit can be interpreted as CPU core-nanoseconds per second.
        """

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        usage_core_nano_seconds: global___UInt64Value | None = ...,
        usage_nano_cores: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "usage_core_nano_seconds",
            b"usage_core_nano_seconds",
            "usage_nano_cores",
            b"usage_nano_cores",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "timestamp",
            b"timestamp",
            "usage_core_nano_seconds",
            b"usage_core_nano_seconds",
            "usage_nano_cores",
            b"usage_nano_cores",
        ],
    ) -> None: ...

global___WindowsCpuUsage = WindowsCpuUsage

@typing.final
class MemoryUsage(google.protobuf.message.Message):
    """MemoryUsage provides the memory usage information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    WORKING_SET_BYTES_FIELD_NUMBER: builtins.int
    AVAILABLE_BYTES_FIELD_NUMBER: builtins.int
    USAGE_BYTES_FIELD_NUMBER: builtins.int
    RSS_BYTES_FIELD_NUMBER: builtins.int
    PAGE_FAULTS_FIELD_NUMBER: builtins.int
    MAJOR_PAGE_FAULTS_FIELD_NUMBER: builtins.int
    PSI_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def working_set_bytes(self) -> global___UInt64Value:
        """The amount of working set memory in bytes."""

    @property
    def available_bytes(self) -> global___UInt64Value:
        """Available memory for use. This is defined as the memory limit - workingSetBytes."""

    @property
    def usage_bytes(self) -> global___UInt64Value:
        """Total memory in use. This includes all memory regardless of when it was accessed."""

    @property
    def rss_bytes(self) -> global___UInt64Value:
        """The amount of anonymous and swap cache memory (includes transparent hugepages)."""

    @property
    def page_faults(self) -> global___UInt64Value:
        """Cumulative number of minor page faults."""

    @property
    def major_page_faults(self) -> global___UInt64Value:
        """Cumulative number of major page faults."""

    @property
    def psi(self) -> global___PsiStats:
        """Memory PSI statistics."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        working_set_bytes: global___UInt64Value | None = ...,
        available_bytes: global___UInt64Value | None = ...,
        usage_bytes: global___UInt64Value | None = ...,
        rss_bytes: global___UInt64Value | None = ...,
        page_faults: global___UInt64Value | None = ...,
        major_page_faults: global___UInt64Value | None = ...,
        psi: global___PsiStats | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "available_bytes",
            b"available_bytes",
            "major_page_faults",
            b"major_page_faults",
            "page_faults",
            b"page_faults",
            "psi",
            b"psi",
            "rss_bytes",
            b"rss_bytes",
            "usage_bytes",
            b"usage_bytes",
            "working_set_bytes",
            b"working_set_bytes",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "available_bytes",
            b"available_bytes",
            "major_page_faults",
            b"major_page_faults",
            "page_faults",
            b"page_faults",
            "psi",
            b"psi",
            "rss_bytes",
            b"rss_bytes",
            "timestamp",
            b"timestamp",
            "usage_bytes",
            b"usage_bytes",
            "working_set_bytes",
            b"working_set_bytes",
        ],
    ) -> None: ...

global___MemoryUsage = MemoryUsage

@typing.final
class IoUsage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    PSI_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def psi(self) -> global___PsiStats:
        """IO PSI statistics."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        psi: global___PsiStats | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["psi", b"psi"]) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["psi", b"psi", "timestamp", b"timestamp"]
    ) -> None: ...

global___IoUsage = IoUsage

@typing.final
class SwapUsage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    SWAP_AVAILABLE_BYTES_FIELD_NUMBER: builtins.int
    SWAP_USAGE_BYTES_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def swap_available_bytes(self) -> global___UInt64Value:
        """Available swap for use. This is defined as the swap limit - swapUsageBytes."""

    @property
    def swap_usage_bytes(self) -> global___UInt64Value:
        """Total memory in use. This includes all memory regardless of when it was accessed."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        swap_available_bytes: global___UInt64Value | None = ...,
        swap_usage_bytes: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "swap_available_bytes",
            b"swap_available_bytes",
            "swap_usage_bytes",
            b"swap_usage_bytes",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "swap_available_bytes",
            b"swap_available_bytes",
            "swap_usage_bytes",
            b"swap_usage_bytes",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___SwapUsage = SwapUsage

@typing.final
class WindowsMemoryUsage(google.protobuf.message.Message):
    """WindowsMemoryUsage provides the memory usage information specific to Windows"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    WORKING_SET_BYTES_FIELD_NUMBER: builtins.int
    AVAILABLE_BYTES_FIELD_NUMBER: builtins.int
    PAGE_FAULTS_FIELD_NUMBER: builtins.int
    COMMIT_MEMORY_BYTES_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds at which the information were collected. Must be > 0."""
    @property
    def working_set_bytes(self) -> global___UInt64Value:
        """The amount of working set memory in bytes."""

    @property
    def available_bytes(self) -> global___UInt64Value:
        """Available memory for use. This is defined as the memory limit - commit_memory_bytes."""

    @property
    def page_faults(self) -> global___UInt64Value:
        """Cumulative number of page faults."""

    @property
    def commit_memory_bytes(self) -> global___UInt64Value:
        """Total commit memory in use. Commit memory is total of physical and virtual memory in use."""

    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        working_set_bytes: global___UInt64Value | None = ...,
        available_bytes: global___UInt64Value | None = ...,
        page_faults: global___UInt64Value | None = ...,
        commit_memory_bytes: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "available_bytes",
            b"available_bytes",
            "commit_memory_bytes",
            b"commit_memory_bytes",
            "page_faults",
            b"page_faults",
            "working_set_bytes",
            b"working_set_bytes",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "available_bytes",
            b"available_bytes",
            "commit_memory_bytes",
            b"commit_memory_bytes",
            "page_faults",
            b"page_faults",
            "timestamp",
            b"timestamp",
            "working_set_bytes",
            b"working_set_bytes",
        ],
    ) -> None: ...

global___WindowsMemoryUsage = WindowsMemoryUsage

@typing.final
class ReopenContainerLogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container for which to reopen the log."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["container_id", b"container_id"]
    ) -> None: ...

global___ReopenContainerLogRequest = ReopenContainerLogRequest

@typing.final
class ReopenContainerLogResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ReopenContainerLogResponse = ReopenContainerLogResponse

@typing.final
class CheckpointContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    LOCATION_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to be checkpointed."""
    location: builtins.str
    """Location of the checkpoint archive used for export"""
    timeout: builtins.int
    """Timeout in seconds for the checkpoint to complete.
    Timeout of zero means to use the CRI default.
    Timeout > 0 means to use the user specified timeout.
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        location: builtins.str = ...,
        timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_id",
            b"container_id",
            "location",
            b"location",
            "timeout",
            b"timeout",
        ],
    ) -> None: ...

global___CheckpointContainerRequest = CheckpointContainerRequest

@typing.final
class CheckpointContainerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CheckpointContainerResponse = CheckpointContainerResponse

@typing.final
class GetEventsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetEventsRequest = GetEventsRequest

@typing.final
class ContainerEventResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    CONTAINER_EVENT_TYPE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    POD_SANDBOX_STATUS_FIELD_NUMBER: builtins.int
    CONTAINERS_STATUSES_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container"""
    container_event_type: global___ContainerEventType.ValueType
    """Type of the container event"""
    created_at: builtins.int
    """Creation timestamp in nanoseconds of this event"""
    @property
    def pod_sandbox_status(self) -> global___PodSandboxStatus:
        """Sandbox status"""

    @property
    def containers_statuses(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ContainerStatus
    ]:
        """Container statuses"""

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        container_event_type: global___ContainerEventType.ValueType = ...,
        created_at: builtins.int = ...,
        pod_sandbox_status: global___PodSandboxStatus | None = ...,
        containers_statuses: (
            collections.abc.Iterable[global___ContainerStatus] | None
        ) = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["pod_sandbox_status", b"pod_sandbox_status"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_event_type",
            b"container_event_type",
            "container_id",
            b"container_id",
            "containers_statuses",
            b"containers_statuses",
            "created_at",
            b"created_at",
            "pod_sandbox_status",
            b"pod_sandbox_status",
        ],
    ) -> None: ...

global___ContainerEventResponse = ContainerEventResponse

@typing.final
class ListMetricDescriptorsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListMetricDescriptorsRequest = ListMetricDescriptorsRequest

@typing.final
class ListMetricDescriptorsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESCRIPTORS_FIELD_NUMBER: builtins.int
    @property
    def descriptors(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___MetricDescriptor
    ]: ...
    def __init__(
        self,
        *,
        descriptors: collections.abc.Iterable[global___MetricDescriptor] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["descriptors", b"descriptors"]
    ) -> None: ...

global___ListMetricDescriptorsResponse = ListMetricDescriptorsResponse

@typing.final
class MetricDescriptor(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    HELP_FIELD_NUMBER: builtins.int
    LABEL_KEYS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name field will be used as a unique identifier of this MetricDescriptor,
    and be used in conjunction with the Metric structure to populate the full Metric.
    """
    help: builtins.str
    @property
    def label_keys(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """When a metric uses this metric descriptor, it should only define
        labels that have previously been declared in label_keys.
        It is the responsibility of the runtime to correctly keep sorted the keys and values.
        If the two slices have different length, the behavior is undefined.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        help: builtins.str = ...,
        label_keys: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "help", b"help", "label_keys", b"label_keys", "name", b"name"
        ],
    ) -> None: ...

global___MetricDescriptor = MetricDescriptor

@typing.final
class ListPodSandboxMetricsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListPodSandboxMetricsRequest = ListPodSandboxMetricsRequest

@typing.final
class ListPodSandboxMetricsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_METRICS_FIELD_NUMBER: builtins.int
    @property
    def pod_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PodSandboxMetrics
    ]: ...
    def __init__(
        self,
        *,
        pod_metrics: collections.abc.Iterable[global___PodSandboxMetrics] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["pod_metrics", b"pod_metrics"]
    ) -> None: ...

global___ListPodSandboxMetricsResponse = ListPodSandboxMetricsResponse

@typing.final
class PodSandboxMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    CONTAINER_METRICS_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    @property
    def metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Metric
    ]: ...
    @property
    def container_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ContainerMetrics
    ]: ...
    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
        metrics: collections.abc.Iterable[global___Metric] | None = ...,
        container_metrics: (
            collections.abc.Iterable[global___ContainerMetrics] | None
        ) = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_metrics",
            b"container_metrics",
            "metrics",
            b"metrics",
            "pod_sandbox_id",
            b"pod_sandbox_id",
        ],
    ) -> None: ...

global___PodSandboxMetrics = PodSandboxMetrics

@typing.final
class ContainerMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    @property
    def metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Metric
    ]: ...
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        metrics: collections.abc.Iterable[global___Metric] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "container_id", b"container_id", "metrics", b"metrics"
        ],
    ) -> None: ...

global___ContainerMetrics = ContainerMetrics

@typing.final
class Metric(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    METRIC_TYPE_FIELD_NUMBER: builtins.int
    LABEL_VALUES_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name must match a name previously returned in a MetricDescriptors call,
    otherwise, it will be ignored.
    """
    timestamp: builtins.int
    """Timestamp should be 0 if the metric was gathered live.
    If it was cached, the Timestamp should reflect the time in nanoseconds it was collected.
    """
    metric_type: global___MetricType.ValueType
    @property
    def label_values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The corresponding LabelValues to the LabelKeys defined in the MetricDescriptor.
        It is the responsibility of the runtime to correctly keep sorted the keys and values.
        If the two slices have different length, the behavior is undefined.
        """

    @property
    def value(self) -> global___UInt64Value: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        timestamp: builtins.int = ...,
        metric_type: global___MetricType.ValueType = ...,
        label_values: collections.abc.Iterable[builtins.str] | None = ...,
        value: global___UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["value", b"value"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "label_values",
            b"label_values",
            "metric_type",
            b"metric_type",
            "name",
            b"name",
            "timestamp",
            b"timestamp",
            "value",
            b"value",
        ],
    ) -> None: ...

global___Metric = Metric

@typing.final
class RuntimeConfigRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RuntimeConfigRequest = RuntimeConfigRequest

@typing.final
class RuntimeConfigResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LINUX_FIELD_NUMBER: builtins.int
    @property
    def linux(self) -> global___LinuxRuntimeConfiguration:
        """Configuration information for Linux-based runtimes. This field contains
        global runtime configuration options that are not specific to runtime
        handlers.
        """

    def __init__(
        self,
        *,
        linux: global___LinuxRuntimeConfiguration | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["linux", b"linux"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["linux", b"linux"]) -> None: ...

global___RuntimeConfigResponse = RuntimeConfigResponse

@typing.final
class LinuxRuntimeConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CGROUP_DRIVER_FIELD_NUMBER: builtins.int
    cgroup_driver: global___CgroupDriver.ValueType
    """Cgroup driver to use
    Note: this field should not change for the lifecycle of the Kubelet,
    or while there are running containers.
    The Kubelet will not re-request this after startup, and will construct the cgroup
    hierarchy assuming it is static.
    If the runtime wishes to change this value, it must be accompanied by removal of
    all pods, and a restart of the Kubelet. The easiest way to do this is with a full node reboot.
    """
    def __init__(
        self,
        *,
        cgroup_driver: global___CgroupDriver.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["cgroup_driver", b"cgroup_driver"]
    ) -> None: ...

global___LinuxRuntimeConfiguration = LinuxRuntimeConfiguration

@typing.final
class UpdatePodSandboxResourcesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POD_SANDBOX_ID_FIELD_NUMBER: builtins.int
    OVERHEAD_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    pod_sandbox_id: builtins.str
    """ID of the PodSandbox to update."""
    @property
    def overhead(self) -> global___LinuxContainerResources:
        """Optional overhead represents the overheads associated with this sandbox"""

    @property
    def resources(self) -> global___LinuxContainerResources:
        """Optional resources represents the sum of container resources for this sandbox"""

    def __init__(
        self,
        *,
        pod_sandbox_id: builtins.str = ...,
        overhead: global___LinuxContainerResources | None = ...,
        resources: global___LinuxContainerResources | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal["overhead", b"overhead", "resources", b"resources"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "overhead",
            b"overhead",
            "pod_sandbox_id",
            b"pod_sandbox_id",
            "resources",
            b"resources",
        ],
    ) -> None: ...

global___UpdatePodSandboxResourcesRequest = UpdatePodSandboxResourcesRequest

@typing.final
class UpdatePodSandboxResourcesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdatePodSandboxResourcesResponse = UpdatePodSandboxResourcesResponse
