# -*- coding: utf-8 -*-
from contenttypes.basic import _
from contenttypes.basic.interfaces import IOSMapField
from contenttypes.basic.interfaces import IOSMapWidget
from datetime import datetime
from plone import api
from plone.api.exc import InvalidParameterError
from z3c.form.browser.text import TextWidget
from z3c.form.interfaces import IFieldWidget
from z3c.form.interfaces import IFormLayer
from z3c.form.widget import FieldWidget
from zope.component import adapter
from zope.interface import implementer


@implementer(IOSMapWidget)
class OSMapWidget(TextWidget):

    name = 'osmap-widget'
    label = _('OSMap Widget')
    timestamp = datetime.now().strftime('%s')

    @property
    def portal_url(self):
        return api.portal.get().absolute_url()

    @property
    def default_value(self):
        return self.field.default or '0|0'

    def default_value_map(self):
        try:
            return api.portal.get_registry_record(name='contenttypes.basic.map_center')
        except (InvalidParameterError):
            return '0|0'


@implementer(IFieldWidget)
@adapter(IOSMapField, IFormLayer)
def OSMapFieldWidget(field, request):
    return FieldWidget(field, OSMapWidget(request))
